/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.stats;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.ad.stats.ADStat;

public class ADStats {
    private Map<String, ADStat<?>> stats;

    public ADStats(Map<String, ADStat<?>> stats) {
        this.stats = stats;
    }

    public Map<String, ADStat<?>> getStats() {
        return this.stats;
    }

    public ADStat<?> getStat(String key) throws IllegalArgumentException {
        if (!this.stats.keySet().contains(key)) {
            throw new IllegalArgumentException("Stat=\"" + key + "\" does not exist");
        }
        return this.stats.get(key);
    }

    public Map<String, ADStat<?>> getNodeStats() {
        return this.getClusterOrNodeStats(false);
    }

    public Map<String, ADStat<?>> getClusterStats() {
        return this.getClusterOrNodeStats(true);
    }

    private Map<String, ADStat<?>> getClusterOrNodeStats(Boolean getClusterStats) {
        HashMap statsMap = new HashMap();
        for (Map.Entry<String, ADStat<?>> entry : this.stats.entrySet()) {
            if (entry.getValue().isClusterLevel() != getClusterStats) continue;
            statsMap.put(entry.getKey(), entry.getValue());
        }
        return statsMap;
    }
}

