/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.utils.network;

import cc.arduino.utils.FileHash;
import cc.arduino.utils.network.CacheControl;
import cc.arduino.utils.network.HttpConnectionManager;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.script.ScriptException;
import processing.app.BaseNoGui;
import processing.app.PreferencesData;
import processing.app.helpers.FileUtils;

public class FileDownloaderCache {
    private static final String CACHE_ENABLE_PREFERENCE_KEY = "cache.enable";
    private static final Map<String, FileCached> cachedFiles = Collections.synchronizedMap(new HashMap());
    private static final String cacheFolder;
    private static boolean enableCache;

    public static Optional<FileCached> getFileCached(URL remoteURL) throws URISyntaxException, NoSuchMethodException, ScriptException, IOException {
        return FileDownloaderCache.getFileCached(remoteURL, true);
    }

    public static Optional<FileCached> getFileCached(URL remoteURL, boolean enableCache) throws URISyntaxException, NoSuchMethodException, ScriptException, IOException {
        if (!enableCache || !FileDownloaderCache.enableCache) {
            return Optional.empty();
        }
        String[] splitPath = remoteURL.getPath().split("/");
        if (splitPath.length == 0) {
            return Optional.empty();
        }
        LinkedList<String> addFirstRemoteURL = new LinkedList<String>(Arrays.asList(splitPath));
        addFirstRemoteURL.addFirst(remoteURL.getHost());
        Path cacheFilePath = Paths.get(cacheFolder, addFirstRemoteURL.toArray(new String[0]));
        FileCached fileCached = Optional.ofNullable(cachedFiles.get(remoteURL.toString())).orElseGet(() -> new FileCached(remoteURL.toString(), cacheFilePath.toString()));
        if (fileCached.isExpire() || !fileCached.exists()) {
            Optional<FileCached> fileCachedInfoUpdated = FileDownloaderCache.updateCacheInfo(remoteURL, (remoteETagClean, cacheControl) -> {
                if (cacheControl.isNoCache() || cacheControl.isMustRevalidate() || cacheControl.isNoStore()) {
                    return Optional.empty();
                }
                FileCached fileCachedUpdateETag = new FileCached(remoteURL.toString(), cacheFilePath.toString(), fileCached.eTag, (String)remoteETagClean, fileCached.md5, (CacheControl)cacheControl);
                cachedFiles.put(remoteURL.toString(), fileCachedUpdateETag);
                return Optional.of(fileCachedUpdateETag);
            });
            FileDownloaderCache.updateCacheFilesInfo();
            return fileCachedInfoUpdated;
        }
        return Optional.of(fileCached);
    }

    private static Optional<FileCached> updateCacheInfo(URL remoteURL, BiFunction<String, CacheControl, Optional<FileCached>> getNewFile) throws URISyntaxException, NoSuchMethodException, ScriptException, IOException {
        HttpURLConnection headRequest = new HttpConnectionManager(remoteURL).makeConnection(connection -> {
            try {
                connection.setRequestMethod("HEAD");
            }
            catch (ProtocolException e) {
                System.err.println(e.getMessage());
            }
        });
        int responseCode = headRequest.getResponseCode();
        headRequest.disconnect();
        if (responseCode < 200 || responseCode >= 300) {
            return Optional.empty();
        }
        String remoteETag = headRequest.getHeaderField("ETag");
        String cacheControlHeader = headRequest.getHeaderField("Cache-Control");
        if (remoteETag != null && cacheControlHeader != null) {
            String remoteETagClean = remoteETag.trim().replace("\"", "");
            CacheControl cacheControl = CacheControl.valueOf(cacheControlHeader);
            return getNewFile.apply(remoteETagClean, cacheControl);
        }
        return Optional.empty();
    }

    private static synchronized void updateCacheFilesInfo() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        ObjectNode objectNode = mapper.createObjectNode();
        objectNode.putArray("files").addAll((Collection)cachedFiles.values().stream().map(v -> (JsonNode)mapper.convertValue(v, JsonNode.class)).collect(Collectors.toList()));
        Path cachedFileInfo = FileDownloaderCache.getCachedInfoPath();
        if (Files.notExists(cachedFileInfo, new LinkOption[0])) {
            Files.createDirectories(cachedFileInfo.getParent(), new FileAttribute[0]);
        }
        mapper.writeValue(cachedFileInfo.toFile(), (Object)objectNode);
    }

    private static Path getCachedInfoPath() {
        return Paths.get(cacheFolder, "cache.json");
    }

    static {
        enableCache = Boolean.valueOf(PreferencesData.get(CACHE_ENABLE_PREFERENCE_KEY, "true"));
        PreferencesData.set(CACHE_ENABLE_PREFERENCE_KEY, Boolean.toString(enableCache));
        File settingsFolder = BaseNoGui.getSettingsFolder();
        if (settingsFolder != null) {
            cacheFolder = Paths.get(settingsFolder.getPath(), "cache").toString();
        } else {
            enableCache = false;
            cacheFolder = null;
        }
        Path pathCacheInfo = FileDownloaderCache.getCachedInfoPath();
        try {
            if (Files.exists(pathCacheInfo, new LinkOption[0])) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonNode = mapper.readTree(pathCacheInfo.toFile());
                TypeReference<List<FileCached>> typeRef = new TypeReference<List<FileCached>>(){};
                List files = (List)mapper.readValue(mapper.treeAsTokens((TreeNode)jsonNode.get("files")), (TypeReference)typeRef);
                cachedFiles.putAll(Collections.synchronizedMap(files.stream().filter(FileCached::exists).collect(Collectors.toMap(FileCached::getRemoteURL, Function.identity()))));
            }
        }
        catch (Exception e) {
            System.err.println("Cannot initialized the cache: " + e.getMessage());
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class FileCached {
        private final String remoteURL;
        private final String localPath;
        private final String eTag;
        private final String lastETag;
        private final String md5;
        private final String createdAt;
        private final CacheControl cacheControl;

        FileCached() {
            this.remoteURL = null;
            this.localPath = null;
            this.lastETag = null;
            this.eTag = null;
            this.md5 = null;
            this.createdAt = null;
            this.cacheControl = null;
        }

        FileCached(String remoteURL, String localPath) {
            this.remoteURL = remoteURL;
            this.localPath = localPath;
            this.lastETag = null;
            this.eTag = null;
            this.md5 = null;
            this.createdAt = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
            this.cacheControl = null;
        }

        public FileCached(String remoteURL, String localPath, String eTag, String lastETag, String md5, CacheControl cacheControl) {
            this.remoteURL = remoteURL;
            this.localPath = localPath;
            this.eTag = eTag;
            this.lastETag = lastETag;
            this.md5 = md5;
            this.createdAt = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
            this.cacheControl = cacheControl;
        }

        @JsonIgnore
        public boolean isExpire() {
            LocalDateTime now = LocalDateTime.now();
            return this.getExpiresTime().isBefore(now) || this.getExpiresTime().isEqual(now);
        }

        @JsonIgnore
        public boolean isNotChange() {
            return !this.isChange();
        }

        @JsonIgnore
        public boolean isChange() {
            boolean isChanged = false;
            if (this.isExpire()) {
                isChanged = true;
            }
            if (this.lastETag != null && !this.lastETag.equals(this.eTag)) {
                isChanged = true;
            }
            return isChanged;
        }

        @JsonIgnore
        public boolean exists() {
            return this.localPath != null && Files.exists(Paths.get(this.localPath, new String[0]), new LinkOption[0]);
        }

        @JsonIgnore
        public Optional<File> getFileFromCache() {
            if (this.md5Check()) {
                return Optional.of(Paths.get(this.localPath, new String[0]).toFile());
            }
            return Optional.empty();
        }

        public synchronized void updateCacheFile(File fileToCache) throws Exception {
            Path cacheFilePath = Paths.get(this.localPath, new String[0]);
            if (!Files.exists(cacheFilePath.getParent(), new LinkOption[0])) {
                Files.createDirectories(cacheFilePath.getParent(), new FileAttribute[0]);
            }
            FileUtils.copyFile(fileToCache, cacheFilePath.toFile());
            String md5 = this.calculateMD5();
            String eTag = this.lastETag == null ? this.eTag : this.lastETag;
            FileCached newFileCached = new FileCached(this.remoteURL, this.localPath, eTag, eTag, md5, this.cacheControl);
            cachedFiles.put(this.remoteURL, newFileCached);
            FileDownloaderCache.updateCacheFilesInfo();
        }

        public synchronized void invalidateCache() throws IOException {
            cachedFiles.remove(this.remoteURL);
            Files.deleteIfExists(Paths.get(this.localPath, new String[0]));
        }

        private String calculateMD5() throws IOException, NoSuchAlgorithmException {
            if (this.exists()) {
                return FileHash.hash(Paths.get(this.localPath, new String[0]).toFile(), "MD5");
            }
            return null;
        }

        @JsonIgnore
        public boolean md5Check() {
            try {
                return !Objects.isNull(this.getMD5()) && Objects.equals(this.calculateMD5(), this.getMD5());
            }
            catch (Exception e) {
                return false;
            }
        }

        @JsonIgnore
        public LocalDateTime getExpiresTime() {
            int maxAge = this.cacheControl != null ? this.cacheControl.getMaxAge() : 0;
            if (this.createdAt != null) {
                return LocalDateTime.parse(this.createdAt, DateTimeFormatter.ISO_DATE_TIME).plusSeconds(maxAge);
            }
            return LocalDateTime.now();
        }

        public String getExpires() {
            return this.getExpiresTime().toString();
        }

        public String getMD5() {
            return this.md5;
        }

        public String geteTag() {
            return this.eTag;
        }

        public String getRemoteURL() {
            return this.remoteURL;
        }

        public String getLocalPath() {
            return this.localPath;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public CacheControl getCacheControl() {
            return this.cacheControl;
        }

        public String toString() {
            return "FileCached{eTag='" + this.eTag + '\'' + ", lastETag='" + this.lastETag + '\'' + ", remoteURL='" + this.remoteURL + '\'' + ", localPath='" + this.localPath + '\'' + ", md5='" + this.md5 + '\'' + ", createdAt='" + this.createdAt + '\'' + ", cacheControl=" + this.cacheControl + '}';
        }
    }
}

