### Copyright  (C) 2019 Intel Corporation. All rights reserved.
###
### The information and source code contained herein is the exclusive
### property of Intel Corporation and may not be disclosed, examined
### or reproduced in whole or in part without explicit written authorization
### from the company.
###
###  3/2019  Update Fortran-specific files

# Definition file for
#   host:    Mac
#   target:  Mac

include(def_util)
def_init_install_subsets()

#compiler header files common for 64/32 bit targets
if (DO_COPY_EFI2_TARGET_FILES OR DO_COPY_IA32_TARGET_FILES)
  set( compiler_header_files
        bfp754_conf.h
        bfp754_functionnames.h
        bfp754.h
        bfp754_macros.h
        bfp754_types.h
        complex
        complex.h
        dvec.h
        fenv.h
        float.h
        fvec.h
        istrconv.h
        ivec.h
        math_common_define.h
        math_common_undefine.h
        math.h
        mathimf.h
        omp.h
        omp_lib.h
        sse2mmx.h
        tbk_traceback.h
        xmm_func.h
        xmm_utils.h )

  if(BUILD_FORT)
    list(APPEND compiler_header_files
        ISO_Fortran_binding.h
        foriosdef.f90
        for_iosdef.for
        for_iosdef.h
        fordef.for
        fordef.h
        for_fpclass.for
        for_fpclass.h
        for_fpeflags.for
        for_fpeflags.h
        forreent.for
        forreent.h
        ieee_arithmetic.f90
        ieee_exceptions.f90
        ieee_features.f90
        ifcommonalloc.f90
        ifcore.f90
        ifestablish.f90
        iflport.f90
        iflposix.f90
        ifport.f90
        ifposix.f90
        iso_c_binding.f90
        iso_fortran_env.f90
        omp_lib.f90
        ## On MacOS (Intel64-only) the mod files are in top-level directory.
        foriosdef.mod
        ieee_arithmetic.modintr
        ieee_exceptions.modintr
        ieee_features.modintr
        ifcommonalloc.mod
        ifcore.mod
        ifestablish.mod
        iflport.mod
        iflposix.mod
        ifport.mod
        ifport_types.mod
        ifposix.mod
        iso_c_binding.modintr
        iso_fortran_env.modintr
        omp_lib_kinds.mod
        omp_lib.mod )
  endif ()

  def_add_install_subset( cmplr_headers INC
        SRCDIR "efi2/mac_test/include"
        INSTDIR "compiler/include"
        DESTDIR "opt/compiler/include"
        ${compiler_header_files} )

endif() # (DO_COPY_EFI2_TARGET_FILES OR DO_COPY_IA32_TARGET_FILES)

if (DO_COPY_EFI2_TARGET_FILES)
  set( lib64_files
        libbfp754.a
        libdecimal.a
        libimf.a
        libimf.dylib
        libintlc.dylib
        libiomp5.a
        libiomp5.dylib
        libiompstubs5.a
        libiompstubs5.dylib
        libipgo.a
        libirc.a
        libirc.dylib
        libirc_s.a
        libirng.a
        libirng.dylib
        libistrconv.a
        libistrconv.dylib
        libsvml.a
        libsvml.dylib )

  if(BUILD_FORT)
    list(APPEND lib64_files
      for_main.o
      libifcore.a
      libifcore.dylib
      libifcoremt.a
      libifcoremt.dylib
      libifport.a
      libifport.dylib
      libifportmt.dylib )
  endif()

  def_add_install_subset( lib_intel64 LIB
        SRCDIR "efi2/mac_test/lib"
        INSTDIR "compiler/lib"
        DESTDIR "lib"
        ${lib64_files} )

endif (DO_COPY_EFI2_TARGET_FILES)

# ia32 target no longer supported for Mac.
# if (DO_COPY_IA32_TARGET_FILES)
# endif(DO_COPY_IA32_TARGET_FILES)

def_add_install_targets()
