/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jruby.EvalType;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyRational;
import org.jruby.RubySymbol;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.ArrayPatternNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ComplexNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EncodingNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FileNode;
import org.jruby.ast.FindPatternNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.HashPatternNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2CaptureNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.NilRestArgNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnConstDeclNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PatternCaseNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RationalNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueModNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TwoValueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.compiler.NotCompilableException;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.ArrayDerefInstr;
import org.jruby.ir.instructions.AsFixnumInstr;
import org.jruby.ir.instructions.AsStringInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BIntInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BSwitchInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BUndefInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.BuildBackrefInstr;
import org.jruby.ir.instructions.BuildCompoundArrayInstr;
import org.jruby.ir.instructions.BuildCompoundStringInstr;
import org.jruby.ir.instructions.BuildDynRegExpInstr;
import org.jruby.ir.instructions.BuildLambdaInstr;
import org.jruby.ir.instructions.BuildRangeInstr;
import org.jruby.ir.instructions.BuildSplatInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CheckForLJEInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DebugOutputInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetEncodingInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.IntegerMathInstr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadBlockImplicitClosureInstr;
import org.jruby.ir.instructions.LoadFrameClosureInstr;
import org.jruby.ir.instructions.LoadImplicitClosureInstr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseRequiredKeywordArgumentError;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordsInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReceiveRubyExceptionInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.ReturnOrRethrowSavedExcInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SearchModuleForConstInstr;
import org.jruby.ir.instructions.SetCapturedVarInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.TraceInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.Complex;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DepthCloneable;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Filename;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Integer;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.MutableString;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Range;
import org.jruby.ir.operands.Rational;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.SymbolProc;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryCurrentModuleVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.ArgumentType;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Signature;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;
import org.jruby.util.DefinedMessage;
import org.jruby.util.KeyValuePair;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.cli.Options;

public class IRBuilder {
    static final UnexecutableNil U_NIL = UnexecutableNil.U_NIL;
    private final Deque<RescueBlockInfo> activeRescueBlockStack = new ArrayDeque<RescueBlockInfo>(4);
    private final Deque<EnsureBlockInfo> activeEnsureBlockStack = new ArrayDeque<EnsureBlockInfo>(4);
    private final Deque<EnsureBlockInfo> ensureBodyBuildStack = new ArrayDeque<EnsureBlockInfo>(4);
    private final Deque<Label> activeRescuers = new ArrayDeque<Label>(4);
    private final Deque<IRLoop> loopStack = new LinkedList<IRLoop>();
    private int lastProcessedLineNum = -1;
    private boolean needsLineNumInfo = false;
    public boolean underscoreVariableSeen = false;
    protected final IRBuilder parent;
    protected IRBuilder variableBuilder;
    protected final IRManager manager;
    protected final IRScope scope;
    protected final List<Instr> instructions;
    protected List<Object> argumentDescriptions;
    protected int coverageMode;
    protected boolean executesOnce = true;
    private int temporaryVariableIndex = -1;
    private boolean needsYieldBlock = false;
    public EvalType evalType = null;
    private RubySymbol methodName = null;
    protected int afterPrologueIndex = 0;
    private TemporaryVariable yieldClosureVariable = null;
    private Variable currentModuleVariable = null;
    private EnumSet<IRFlags> flags;

    public static Node buildAST(boolean isCommandLineScript, String arg2) {
        Ruby ruby = Ruby.getGlobalRuntime();
        if (isCommandLineScript) {
            return ruby.parse(ByteList.create(arg2), "-e", null, 0, false);
        }
        FileInputStream fis = null;
        try {
            File file2 = new File(arg2);
            fis = new FileInputStream(file2);
            long size2 = file2.length();
            byte[] bytes2 = new byte[(int)size2];
            fis.read(bytes2);
            System.out.println("-- processing " + arg2 + " --");
            Node node = ruby.parse(new ByteList(bytes2), arg2, null, 0, false);
            return node;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception2) {}
        }
    }

    private IRLoop getCurrentLoop() {
        return this.loopStack.peek();
    }

    public IRBuilder(IRManager manager, IRScope scope, IRBuilder parent, IRBuilder variableBuilder) {
        this.manager = manager;
        this.scope = scope;
        this.parent = parent;
        this.instructions = new ArrayList<Instr>(50);
        this.activeRescuers.push(Label.UNRESCUED_REGION_LABEL);
        int n = this.coverageMode = parent == null ? 0 : parent.coverageMode;
        if (parent != null) {
            this.executesOnce = parent.executesOnce;
        }
        this.variableBuilder = variableBuilder;
        this.flags = IRScope.allocateInitialFlags(scope);
    }

    public IRBuilder(IRManager manager, IRScope scope, IRBuilder parent) {
        this(manager, scope, parent, null);
    }

    private boolean needsCodeCoverage() {
        return this.coverageMode != 0 || this.parent != null && this.parent.needsCodeCoverage();
    }

    public void addArgumentDescription(ArgumentType type2, RubySymbol name2) {
        if (this.argumentDescriptions == null) {
            this.argumentDescriptions = new ArrayList<Object>();
        }
        this.argumentDescriptions.add((Object)type2);
        this.argumentDescriptions.add(name2);
    }

    public void addInstr(Instr instr) {
        if (this.needsLineNumInfo) {
            this.needsLineNumInfo = false;
            if (this.needsCodeCoverage()) {
                this.addInstr(new LineNumberInstr(this.lastProcessedLineNum, this.coverageMode));
            } else {
                this.addInstr(this.manager.newLineNumber(this.lastProcessedLineNum));
            }
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                this.addInstr(new TraceInstr(RubyEvent.LINE, this.getCurrentModuleVariable(), this.methodNameFor(), this.getFileName(), this.lastProcessedLineNum + 1));
            }
        }
        if (this.ensureBodyBuildStack.isEmpty()) {
            instr.computeScopeFlags(this.scope, this.flags);
            if (this.hasListener()) {
                this.manager.getIRScopeListener().addedInstr(this.scope, instr, this.instructions.size());
            }
            this.instructions.add(instr);
        } else {
            this.ensureBodyBuildStack.peek().addInstr(instr);
        }
    }

    public void addInstrAtBeginning(Instr instr) {
        if (this.ensureBodyBuildStack.isEmpty()) {
            instr.computeScopeFlags(this.scope, this.flags);
            if (this.hasListener()) {
                this.manager.getIRScopeListener().addedInstr(this.scope, instr, 0);
            }
            this.instructions.add(0, instr);
        } else {
            this.ensureBodyBuildStack.peek().addInstrAtBeginning(instr);
        }
    }

    private void emitEnsureBlocks(IRLoop loop2) {
        int n = this.activeEnsureBlockStack.size();
        EnsureBlockInfo[] ebArray = this.activeEnsureBlockStack.toArray(new EnsureBlockInfo[n]);
        for (int i2 = 0; i2 < n; ++i2) {
            EnsureBlockInfo ebi = ebArray[i2];
            if (loop2 != null && ebi.innermostLoop != loop2) break;
            ebi.cloneIntoHostScope(this);
        }
    }

    private void determineIfWeNeedLineNumber(Node node) {
        int currLineNum;
        if (node.isNewline() && (currLineNum = node.getLine()) != this.lastProcessedLineNum && !(node instanceof NilImplicitNode)) {
            this.needsLineNumInfo = true;
            this.lastProcessedLineNum = currLineNum;
        }
    }

    private NotCompilableException notCompilable(String message2, Node node) {
        int line = node != null ? node.getLine() : this.scope.getLine();
        String loc = this.scope.getFile() + ":" + line;
        String what = node != null ? node.getClass().getSimpleName() + " - " + loc : loc;
        return new NotCompilableException(message2 + " (" + what + ").");
    }

    private Operand buildOperand(Variable result2, Node node) throws NotCompilableException {
        this.determineIfWeNeedLineNumber(node);
        switch (node.getNodeType()) {
            case ALIASNODE: {
                return this.buildAlias((AliasNode)node);
            }
            case ANDNODE: {
                return this.buildAnd((AndNode)node);
            }
            case ARGSCATNODE: {
                return this.buildArgsCat((ArgsCatNode)node);
            }
            case ARGSPUSHNODE: {
                return this.buildArgsPush((ArgsPushNode)node);
            }
            case ARRAYNODE: {
                return this.buildArray((ArrayNode)node, false);
            }
            case ATTRASSIGNNODE: {
                return this.buildAttrAssign(result2, (AttrAssignNode)node);
            }
            case BACKREFNODE: {
                return this.buildBackref(result2, (BackRefNode)node);
            }
            case BEGINNODE: {
                return this.buildBegin((BeginNode)node);
            }
            case BIGNUMNODE: {
                return this.buildBignum((BignumNode)node);
            }
            case BLOCKNODE: {
                return this.buildBlock((BlockNode)node);
            }
            case BREAKNODE: {
                return this.buildBreak((BreakNode)node);
            }
            case CALLNODE: {
                return this.buildCall(result2, (CallNode)node, null, null);
            }
            case CASENODE: {
                return this.buildCase((CaseNode)node);
            }
            case CLASSNODE: {
                return this.buildClass((ClassNode)node);
            }
            case CLASSVARNODE: {
                return this.buildClassVar((ClassVarNode)node);
            }
            case CLASSVARASGNNODE: {
                return this.buildClassVarAsgn((ClassVarAsgnNode)node);
            }
            case COLON2NODE: {
                return this.buildColon2((Colon2Node)node);
            }
            case COLON3NODE: {
                return this.buildColon3((Colon3Node)node);
            }
            case COMPLEXNODE: {
                return this.buildComplex((ComplexNode)node);
            }
            case CONSTDECLNODE: {
                return this.buildConstDecl((ConstDeclNode)node);
            }
            case CONSTNODE: {
                return this.searchConst(((ConstNode)node).getName());
            }
            case DASGNNODE: {
                return this.buildDAsgn((DAsgnNode)node);
            }
            case DEFINEDNODE: {
                return this.buildGetDefinition(((DefinedNode)node).getExpressionNode());
            }
            case DEFNNODE: {
                return this.buildDefn((MethodDefNode)node);
            }
            case DEFSNODE: {
                return this.buildDefs((DefsNode)node);
            }
            case DOTNODE: {
                return this.buildDot((DotNode)node);
            }
            case DREGEXPNODE: {
                return this.buildDRegexp(result2, (DRegexpNode)node);
            }
            case DSTRNODE: {
                return this.buildDStr(result2, (DStrNode)node);
            }
            case DSYMBOLNODE: {
                return this.buildDSymbol(result2, (DSymbolNode)node);
            }
            case DVARNODE: {
                return this.buildDVar((DVarNode)node);
            }
            case DXSTRNODE: {
                return this.buildDXStr(result2, (DXStrNode)node);
            }
            case ENCODINGNODE: {
                return this.buildEncoding((EncodingNode)node);
            }
            case ENSURENODE: {
                return this.buildEnsureNode((EnsureNode)node);
            }
            case FALSENODE: {
                return this.buildFalse();
            }
            case FCALLNODE: {
                return this.buildFCall(result2, (FCallNode)node);
            }
            case FIXNUMNODE: {
                return this.buildFixnum((FixnumNode)node);
            }
            case FLIPNODE: {
                return this.buildFlip((FlipNode)node);
            }
            case FLOATNODE: {
                return this.buildFloat((FloatNode)node);
            }
            case FORNODE: {
                return this.buildFor((ForNode)node);
            }
            case GLOBALASGNNODE: {
                return this.buildGlobalAsgn((GlobalAsgnNode)node);
            }
            case GLOBALVARNODE: {
                return this.buildGlobalVar(result2, (GlobalVarNode)node);
            }
            case HASHNODE: {
                return this.buildHash((HashNode)node, false);
            }
            case IFNODE: {
                return this.buildIf(result2, (IfNode)node);
            }
            case INSTASGNNODE: {
                return this.buildInstAsgn((InstAsgnNode)node);
            }
            case INSTVARNODE: {
                return this.buildInstVar((InstVarNode)node);
            }
            case ITERNODE: {
                return this.buildIter((IterNode)node);
            }
            case LAMBDANODE: {
                return this.buildLambda((LambdaNode)node);
            }
            case LITERALNODE: {
                return this.buildLiteral((LiteralNode)node);
            }
            case LOCALASGNNODE: {
                return this.buildLocalAsgn((LocalAsgnNode)node);
            }
            case LOCALVARNODE: {
                return this.buildLocalVar((LocalVarNode)node);
            }
            case MATCH2NODE: {
                return this.buildMatch2(result2, (Match2Node)node);
            }
            case MATCH3NODE: {
                return this.buildMatch3(result2, (Match3Node)node);
            }
            case MATCHNODE: {
                return this.buildMatch(result2, (MatchNode)node);
            }
            case MODULENODE: {
                return this.buildModule((ModuleNode)node);
            }
            case MULTIPLEASGNNODE: {
                return this.buildMultipleAsgn19((MultipleAsgnNode)node);
            }
            case NEXTNODE: {
                return this.buildNext((NextNode)node);
            }
            case NTHREFNODE: {
                return this.buildNthRef((NthRefNode)node);
            }
            case NILNODE: {
                return this.buildNil();
            }
            case OPASGNANDNODE: {
                return this.buildOpAsgnAnd((OpAsgnAndNode)node);
            }
            case OPASGNCONSTDECLNODE: {
                return this.buildOpAsgnConstDeclNode((OpAsgnConstDeclNode)node);
            }
            case OPASGNNODE: {
                return this.buildOpAsgn((OpAsgnNode)node);
            }
            case OPASGNORNODE: {
                return this.buildOpAsgnOr((OpAsgnOrNode)node);
            }
            case OPELEMENTASGNNODE: {
                return this.buildOpElementAsgn((OpElementAsgnNode)node);
            }
            case ORNODE: {
                return this.buildOr((OrNode)node);
            }
            case PATTERNCASENODE: {
                return this.buildPatternCase((PatternCaseNode)node);
            }
            case PREEXENODE: {
                return this.buildPreExe((PreExeNode)node);
            }
            case POSTEXENODE: {
                return this.buildPostExe((PostExeNode)node);
            }
            case RATIONALNODE: {
                return this.buildRational((RationalNode)node);
            }
            case REDONODE: {
                return this.buildRedo((RedoNode)node);
            }
            case REGEXPNODE: {
                return this.buildRegexp((RegexpNode)node);
            }
            case RESCUEBODYNODE: {
                throw this.notCompilable("handled by rescue compilation", node);
            }
            case RESCUENODE: {
                return this.buildRescue((RescueNode)node);
            }
            case RETRYNODE: {
                return this.buildRetry((RetryNode)node);
            }
            case RETURNNODE: {
                return this.buildReturn((ReturnNode)node);
            }
            case ROOTNODE: {
                throw this.notCompilable("Use buildRoot()", node);
            }
            case SCLASSNODE: {
                return this.buildSClass((SClassNode)node);
            }
            case SELFNODE: {
                return this.buildSelf();
            }
            case SPLATNODE: {
                return this.buildSplat((SplatNode)node);
            }
            case STRNODE: {
                return this.buildStr((StrNode)node);
            }
            case SUPERNODE: {
                return this.buildSuper((SuperNode)node);
            }
            case SVALUENODE: {
                return this.buildSValue((SValueNode)node);
            }
            case SYMBOLNODE: {
                return this.buildSymbol((SymbolNode)node);
            }
            case TRUENODE: {
                return this.buildTrue();
            }
            case UNDEFNODE: {
                return this.buildUndef(node);
            }
            case UNTILNODE: {
                return this.buildUntil((UntilNode)node);
            }
            case VALIASNODE: {
                return this.buildVAlias((VAliasNode)node);
            }
            case VCALLNODE: {
                return this.buildVCall(result2, (VCallNode)node);
            }
            case WHILENODE: {
                return this.buildWhile((WhileNode)node);
            }
            case WHENNODE: {
                assert (false) : "When nodes are handled by case node compilation.";
                return null;
            }
            case XSTRNODE: {
                return this.buildXStr((XStrNode)node);
            }
            case YIELDNODE: {
                return this.buildYield((YieldNode)node, result2);
            }
            case ZARRAYNODE: {
                return this.buildZArray(result2);
            }
            case ZSUPERNODE: {
                return this.buildZSuper((ZSuperNode)node);
            }
        }
        throw this.notCompilable("Unknown node encountered in builder", node);
    }

    private boolean hasListener() {
        return this.manager.getIRScopeListener() != null;
    }

    public IRBuilder newIRBuilder(IRManager manager, IRScope newScope) {
        return new IRBuilder(manager, newScope, this);
    }

    public static IRBuilder topIRBuilder(IRManager manager, IRScope newScope) {
        return new IRBuilder(manager, newScope, null);
    }

    public Operand build(Node node) {
        return this.build(null, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operand build(Variable result2, Node node) {
        if (node == null) {
            return null;
        }
        boolean savedExecuteOnce = this.executesOnce;
        try {
            if (this.executesOnce) {
                this.executesOnce = node.executesOnce();
            }
            if (this.hasListener()) {
                this.manager.getIRScopeListener().startBuildOperand(node, this.scope);
            }
            Operand operand = this.buildOperand(result2, node);
            if (this.hasListener()) {
                this.manager.getIRScopeListener().endBuildOperand(node, this.scope, operand);
            }
            Operand operand2 = operand;
            return operand2;
        }
        finally {
            this.executesOnce = savedExecuteOnce;
        }
    }

    private InterpreterContext buildLambdaInner(LambdaNode node) {
        Operand closureRetVal;
        this.prepareClosureImplicitState();
        this.addCurrentModule();
        this.receiveBlockArgs(node);
        Operand operand = closureRetVal = node.getBody() == null ? this.manager.getNil() : this.build(node.getBody());
        if (closureRetVal != U_NIL) {
            this.addInstr(new ReturnInstr(closureRetVal));
        }
        this.preloadBlockImplicitClosure();
        this.handleBreakAndReturnsInLambdas();
        this.computeScopeFlagsFrom(this.instructions);
        return this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
    }

    private void preloadBlockImplicitClosure() {
        if (this.needsYieldBlock) {
            this.addInstrAtBeginning(new LoadBlockImplicitClosureInstr(this.getYieldClosureVariable()));
        }
    }

    public Operand buildLambda(LambdaNode node) {
        IRClosure closure = new IRClosure(this.manager, this.scope, node.getLine(), node.getScope(), Signature.from(node), this.coverageMode);
        this.newIRBuilder(this.manager, closure).buildLambdaInner(node);
        TemporaryVariable lambda2 = this.createTemporaryVariable();
        WrappedIRClosure lambdaBody = new WrappedIRClosure(closure.getSelf(), closure);
        this.addInstr(new BuildLambdaInstr(lambda2, lambdaBody));
        return lambda2;
    }

    public Operand buildEncoding(EncodingNode node) {
        TemporaryVariable ret = this.createTemporaryVariable();
        this.addInstr(new GetEncodingInstr(ret, node.getEncoding()));
        return ret;
    }

    public Operand buildMultipleAsgn19(MultipleAsgnNode multipleAsgnNode) {
        Node valueNode = multipleAsgnNode.getValueNode();
        Operand values2 = this.build(valueNode);
        Variable ret = this.getValueInTemporaryVariable(values2);
        if (valueNode instanceof ArrayNode || valueNode instanceof ZArrayNode) {
            this.buildMultipleAsgn19Assignment(multipleAsgnNode, null, ret);
        } else if (valueNode instanceof ILiteralNode) {
            this.buildMultipleAsgn19Assignment(multipleAsgnNode, null, new Array(new Operand[]{ret}));
        } else {
            TemporaryVariable tmp = this.createTemporaryVariable();
            this.addInstr(new ToAryInstr(tmp, (Operand)ret));
            this.buildMultipleAsgn19Assignment(multipleAsgnNode, null, tmp);
        }
        return ret;
    }

    protected Operand buildWithOrder(Node node, boolean preserveOrder) {
        Operand value2 = this.build(node);
        return preserveOrder && !(value2 instanceof ImmutableLiteral) ? this.copy(value2) : value2;
    }

    protected Operand buildLazyWithOrder(CallNode node, Label lazyLabel, Label endLabel, boolean preserveOrder) {
        Operand value2 = this.buildCall(null, node, lazyLabel, endLabel);
        return preserveOrder && !(value2 instanceof ImmutableLiteral) ? this.copy(value2) : value2;
    }

    protected Variable getValueInTemporaryVariable(Operand val) {
        if (val != null && val instanceof TemporaryVariable) {
            return (Variable)val;
        }
        return this.copy(val);
    }

    protected Operand buildAttrAssignCallArgs(List<Operand> argsList, Node args2, boolean containsAssignment) {
        if (args2 == null) {
            return this.manager.getNil();
        }
        switch (args2.getNodeType()) {
            case ARRAYNODE: {
                Operand last2 = this.manager.getNil();
                for (Node n : ((ListNode)args2).children()) {
                    last2 = this.buildWithOrder(n, containsAssignment);
                    argsList.add(last2);
                }
                return last2;
            }
            case ARGSCATNODE: {
                ArgsCatNode argsCatNode = (ArgsCatNode)args2;
                Operand lhs = this.build(argsCatNode.getFirstNode());
                Operand rhs = this.build(argsCatNode.getSecondNode());
                TemporaryVariable res = this.createTemporaryVariable();
                this.addInstr(new BuildCompoundArrayInstr(res, lhs, rhs, false, false));
                argsList.add(new Splat(res));
                return rhs;
            }
            case ARGSPUSHNODE: {
                ArgsPushNode argsPushNode = (ArgsPushNode)args2;
                Operand lhs = this.build(argsPushNode.getFirstNode());
                Operand rhs = this.build(argsPushNode.getSecondNode());
                TemporaryVariable res = this.createTemporaryVariable();
                this.addInstr(new BuildCompoundArrayInstr(res, lhs, rhs, true, false));
                argsList.add(new Splat(res));
                return rhs;
            }
            case SPLATNODE: {
                Splat rhs = new Splat(this.buildSplat((SplatNode)args2));
                argsList.add(rhs);
                return rhs;
            }
        }
        throw this.notCompilable("Invalid node for attrassign call args", args2);
    }

    private Operand buildRestKeywordArgs(HashNode keywordArgs, int[] flags2) {
        flags2[0] = flags2[0] | 4;
        List<KeyValuePair<Node, Node>> pairs = keywordArgs.getPairs();
        if (pairs.size() == 1) {
            Operand splat = this.buildWithOrder(pairs.get(0).getValue(), keywordArgs.containsVariableAssignment());
            return this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.HASH_CHECK, new Operand[]{splat}));
        }
        Variable splatValue = this.copy(new Hash(new ArrayList<KeyValuePair<Operand, Operand>>()));
        for (KeyValuePair<Node, Node> pair : pairs) {
            Operand splat = this.buildWithOrder(pair.getValue(), keywordArgs.containsVariableAssignment());
            this.addInstr(new RuntimeHelperCall(splatValue, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{splatValue, splat, this.fals()}));
        }
        return splatValue;
    }

    protected Operand buildCallKeywordArguments(HashNode keywords, int[] flags2) {
        flags2[0] = flags2[0] | 2;
        if (keywords.hasOnlyRestKwargs()) {
            return this.buildRestKeywordArgs(keywords, flags2);
        }
        return this.buildHash(keywords, true);
    }

    protected Operand buildCallArgsArrayForSplat(ListNode args2, int[] flags2) {
        Node[] nodes = args2.children();
        Operand[] elts = new Operand[nodes.length];
        boolean containsAssignments = args2.containsVariableAssignment();
        Operand keywordRestSplat = null;
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            elts[i2] = this.buildWithOrder(nodes[i2], containsAssignments);
            if (i2 != nodes.length - 1 || !(nodes[i2] instanceof HashNode) || ((HashNode)nodes[i2]).isLiteral()) continue;
            flags2[0] = flags2[0] | 2;
            if (!((HashNode)nodes[i2]).hasOnlyRestKwargs()) continue;
            keywordRestSplat = elts[i2];
        }
        if (keywordRestSplat != null) {
            Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{keywordRestSplat}));
            Variable result2 = this.temp();
            this.if_else(test2, this.manager.getTrue(), () -> this.copy(result2, new Array(IRBuilder.removeArg(elts))), () -> this.copy(result2, new Array(elts)));
            return result2;
        }
        return new Array(elts);
    }

    protected Operand[] buildCallArgsArray(ListNode args2, int[] flags2) {
        Node[] children2 = args2.children();
        int numberOfArgs = children2.length;
        Operand[] builtArgs = new Operand[numberOfArgs];
        boolean hasAssignments = args2.containsVariableAssignment();
        for (int i2 = 0; i2 < numberOfArgs; ++i2) {
            if (i2 == numberOfArgs - 1 && children2[i2] instanceof HashNode && !((HashNode)children2[i2]).isLiteral()) {
                HashNode hash2 = (HashNode)children2[i2];
                builtArgs[i2] = this.buildCallKeywordArguments(hash2, flags2);
                continue;
            }
            builtArgs[i2] = this.buildWithOrder(children2[i2], hasAssignments);
        }
        return builtArgs;
    }

    protected Operand[] buildCallArgs(Node args2, int[] flags2) {
        switch (args2.getNodeType()) {
            case ARGSCATNODE: 
            case ARGSPUSHNODE: {
                Operand lhs = this.build(((TwoValueNode)((Object)args2)).getFirstNode());
                Node secondNode = ((TwoValueNode)((Object)args2)).getSecondNode();
                flags2[0] = flags2[0] | 1;
                Operand valueToSplat = secondNode instanceof ListNode && !(secondNode instanceof DNode) ? this.buildCallArgsArrayForSplat((ListNode)secondNode, flags2) : (secondNode instanceof HashNode && !((HashNode)secondNode).isLiteral() ? this.buildCallKeywordArguments((HashNode)secondNode, flags2) : this.build(secondNode));
                Variable array2 = this.addResultInstr(new BuildCompoundArrayInstr(this.createTemporaryVariable(), lhs, valueToSplat, args2.getNodeType() == NodeType.ARGSPUSHNODE, (flags2[0] & 4) != 0));
                return new Operand[]{new Splat(this.addResultInstr(new BuildSplatInstr(this.createTemporaryVariable(), (Operand)array2, false)))};
            }
            case ARRAYNODE: {
                return this.buildCallArgsArray((ListNode)args2, flags2);
            }
            case SPLATNODE: {
                flags2[0] = flags2[0] | 1;
                return new Operand[]{new Splat(this.addResultInstr(new BuildSplatInstr(this.createTemporaryVariable(), this.build(args2), false)))};
            }
        }
        throw this.notCompilable("Invalid node for call args: ", args2);
    }

    protected Operand buildYieldArgs(Node args2, int[] flags2) {
        if (args2 == null) {
            return UndefinedValue.UNDEFINED;
        }
        switch (args2.getNodeType()) {
            case ARGSCATNODE: 
            case ARGSPUSHNODE: {
                Operand lhs = this.build(((TwoValueNode)((Object)args2)).getFirstNode());
                Node secondNode = ((TwoValueNode)((Object)args2)).getSecondNode();
                flags2[0] = flags2[0] | 1;
                Operand valueToSplat = secondNode instanceof ListNode ? this.buildCallArgsArrayForSplat((ListNode)secondNode, flags2) : (secondNode instanceof HashNode && !((HashNode)secondNode).isLiteral() ? this.buildCallKeywordArguments((HashNode)secondNode, flags2) : this.build(secondNode));
                Variable array2 = this.addResultInstr(new BuildCompoundArrayInstr(this.createTemporaryVariable(), lhs, valueToSplat, args2.getNodeType() == NodeType.ARGSPUSHNODE, (flags2[0] & 4) != 0));
                return new Splat(this.addResultInstr(new BuildSplatInstr(this.createTemporaryVariable(), (Operand)array2, false)));
            }
            case ARRAYNODE: {
                return new Array(this.buildCallArgsArray((ListNode)args2, flags2));
            }
            case SPLATNODE: {
                flags2[0] = flags2[0] | 1;
                return new Splat(this.addResultInstr(new BuildSplatInstr(this.createTemporaryVariable(), this.build(args2), false)));
            }
        }
        return this.build(args2);
    }

    public Operand[] setupCallArgs(Node args2, int[] flags2) {
        return args2 == null ? Operand.EMPTY_ARRAY : this.buildCallArgs(args2, flags2);
    }

    public static Operand[] addArg(Operand[] args2, Operand extraArg) {
        Operand[] newArgs = new Operand[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = extraArg;
        return newArgs;
    }

    public static Operand[] removeArg(Operand[] args2) {
        Operand[] newArgs = new Operand[args2.length - 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length - 1);
        return newArgs;
    }

    public void buildAssignment(Node node, Variable rhsVal) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                this.buildAttrAssignAssignment(node, rhsVal);
                break;
            }
            case CLASSVARASGNNODE: {
                this.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(), ((ClassVarAsgnNode)node).getName(), (Operand)rhsVal));
                break;
            }
            case CONSTDECLNODE: {
                this.buildConstDeclAssignment((ConstDeclNode)node, rhsVal);
                break;
            }
            case DASGNNODE: {
                DAsgnNode variable = (DAsgnNode)node;
                int depth = variable.getDepth();
                this.addInstr(new CopyInstr(this.getLocalVariable(variable.getName(), depth), (Operand)rhsVal));
                break;
            }
            case GLOBALASGNNODE: {
                this.addInstr(new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), (Operand)rhsVal));
                break;
            }
            case INSTASGNNODE: {
                this.addInstr(new PutFieldInstr(this.buildSelf(), ((InstAsgnNode)node).getName(), (Operand)rhsVal));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                int depth = localVariable.getDepth();
                this.addInstr(new CopyInstr(this.getLocalVariable(localVariable.getName(), depth), (Operand)rhsVal));
                break;
            }
            case ZEROARGNODE: {
                throw this.notCompilable("Shouldn't get here; zeroarg does not do assignment", node);
            }
            case MULTIPLEASGNNODE: {
                TemporaryVariable tmp = this.createTemporaryVariable();
                this.addInstr(new ToAryInstr(tmp, (Operand)rhsVal));
                this.buildMultipleAsgn19Assignment((MultipleAsgnNode)node, null, tmp);
                break;
            }
            default: {
                throw this.notCompilable("Can't build assignment node", node);
            }
        }
    }

    protected LocalVariable getBlockArgVariable(RubySymbol name2, int depth) {
        if (!(this.scope instanceof IRFor)) {
            throw this.notCompilable("Cannot ask for block-arg variable in 1.9 mode", null);
        }
        return this.getLocalVariable(name2, depth);
    }

    protected void receiveBlockArg(Variable v, Operand argsArray, int argIndex, boolean isSplat) {
        if (argsArray != null) {
            if (isSplat) {
                this.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, argIndex));
            } else {
                this.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, argIndex));
            }
        } else {
            Variable keywords = this.copy(UndefinedValue.UNDEFINED);
            this.addInstr(isSplat ? new ReceiveRestArgInstr(v, keywords, argIndex, argIndex) : new ReceivePreReqdArgInstr(v, keywords, argIndex));
        }
    }

    public void buildVersionSpecificBlockArgsAssignment(Node node) {
        if (!(this.scope instanceof IRFor)) {
            throw this.notCompilable("Should not have come here for block args assignment", node);
        }
        switch (node.getNodeType()) {
            case MULTIPLEASGNNODE: {
                ListNode sourceArray = ((MultipleAsgnNode)node).getPre();
                int i2 = 0;
                for (Node an : sourceArray.children()) {
                    this.buildBlockArgsAssignment(an, null, i2, false);
                    ++i2;
                }
                break;
            }
            default: {
                throw this.notCompilable("Can't build assignment node", node);
            }
        }
    }

    public void buildBlockArgsAssignment(Node node, Operand argsArray, int argIndex, boolean isSplat) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                TemporaryVariable v = this.createTemporaryVariable();
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                this.buildAttrAssignAssignment(node, v);
                break;
            }
            case DASGNNODE: {
                DAsgnNode dynamicAsgn = (DAsgnNode)node;
                LocalVariable v = this.getBlockArgVariable(dynamicAsgn.getName(), dynamicAsgn.getDepth());
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                break;
            }
            case CLASSVARASGNNODE: {
                TemporaryVariable v = this.createTemporaryVariable();
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                this.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(), ((ClassVarAsgnNode)node).getName(), (Operand)v));
                break;
            }
            case CONSTDECLNODE: {
                TemporaryVariable v = this.createTemporaryVariable();
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                this.buildConstDeclAssignment((ConstDeclNode)node, v);
                break;
            }
            case GLOBALASGNNODE: {
                TemporaryVariable v = this.createTemporaryVariable();
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                this.addInstr(new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), (Operand)v));
                break;
            }
            case INSTASGNNODE: {
                TemporaryVariable v = this.createTemporaryVariable();
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                this.addInstr(new PutFieldInstr(this.buildSelf(), ((InstAsgnNode)node).getName(), (Operand)v));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                LocalVariable v = this.getBlockArgVariable(localVariable.getName(), localVariable.getDepth());
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                break;
            }
            case ZEROARGNODE: {
                throw this.notCompilable("Shouldn't get here; zeroarg does not do assignment", node);
            }
            default: {
                this.buildVersionSpecificBlockArgsAssignment(node);
            }
        }
    }

    public Operand buildAlias(AliasNode alias) {
        Operand newName = this.build(alias.getNewName());
        Operand oldName = this.build(alias.getOldName());
        this.addInstr(new AliasInstr(newName, oldName));
        return this.manager.getNil();
    }

    public Operand buildAnd(AndNode andNode) {
        if (andNode.getFirstNode().getNodeType().alwaysTrue()) {
            this.build(andNode.getFirstNode());
            return this.build(andNode.getSecondNode());
        }
        if (andNode.getFirstNode().getNodeType().alwaysFalse()) {
            return this.build(andNode.getFirstNode());
        }
        Label l = this.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode());
        Variable ret = this.getValueInTemporaryVariable(v1);
        this.addInstr(IRBuilder.createBranch(v1, this.manager.getFalse(), l));
        Operand v2 = this.build(andNode.getSecondNode());
        this.addInstr(new CopyInstr(ret, v2));
        this.addInstr(new LabelInstr(l));
        return ret;
    }

    public Operand buildArray(ArrayNode node, boolean operandOnly) {
        Node[] nodes = node.children();
        Operand[] elts = new Operand[nodes.length];
        boolean containsAssignments = node.containsVariableAssignment();
        Operand keywordRestSplat = null;
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            elts[i2] = this.buildWithOrder(nodes[i2], containsAssignments);
            if (!(nodes[i2] instanceof HashNode) || !((HashNode)nodes[i2]).hasOnlyRestKwargs()) continue;
            keywordRestSplat = elts[i2];
        }
        if (keywordRestSplat != null) {
            Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{keywordRestSplat}));
            Variable result2 = this.temp();
            this.if_else(test2, this.manager.getTrue(), () -> this.copy(result2, new Array(IRBuilder.removeArg(elts))), () -> this.copy(result2, new Array(elts)));
            return result2;
        }
        Array array2 = new Array(elts);
        return operandOnly ? array2 : this.copy(array2);
    }

    public Operand buildArgsCat(ArgsCatNode argsCatNode) {
        Operand lhs = this.build(argsCatNode.getFirstNode());
        Operand rhs = this.build(argsCatNode.getSecondNode());
        return this.addResultInstr(new BuildCompoundArrayInstr(this.createTemporaryVariable(), lhs, rhs, false, false));
    }

    public Operand buildArgsPush(ArgsPushNode node) {
        Operand lhs = this.build(node.getFirstNode());
        Operand rhs = this.build(node.getSecondNode());
        return this.addResultInstr(new BuildCompoundArrayInstr(this.createTemporaryVariable(), lhs, rhs, true, false));
    }

    private Operand buildAttrAssign(Variable result2, AttrAssignNode attrAssignNode) {
        boolean containsAssignment = attrAssignNode.containsVariableAssignment();
        Operand obj = this.buildWithOrder(attrAssignNode.getReceiverNode(), containsAssignment);
        Label lazyLabel = null;
        Label endLabel = null;
        if (result2 == null) {
            result2 = this.createTemporaryVariable();
        }
        if (attrAssignNode.isLazy()) {
            lazyLabel = this.getNewLabel();
            endLabel = this.getNewLabel();
            this.addInstr(new BNilInstr(lazyLabel, obj));
        }
        ArrayList<Operand> args2 = new ArrayList<Operand>();
        Node argsNode = attrAssignNode.getArgsNode();
        int[] flags2 = new int[]{0};
        Operand lastArg = this.buildAttrAssignCallArgs(args2, argsNode, containsAssignment);
        Operand block = this.setupCallClosure(attrAssignNode.getBlockNode());
        this.addInstr(AttrAssignInstr.create(this.scope, obj, attrAssignNode.getName(), args2.toArray(new Operand[args2.size()]), block, flags2[0], this.scope.maybeUsingRefinements()));
        this.addInstr(new CopyInstr(result2, lastArg));
        if (attrAssignNode.isLazy()) {
            this.addInstr(new JumpInstr(endLabel));
            this.addInstr(new LabelInstr(lazyLabel));
            this.addInstr(new CopyInstr(result2, this.manager.getNil()));
            this.addInstr(new LabelInstr(endLabel));
        }
        return result2;
    }

    public Operand buildAttrAssignAssignment(Node node, Operand value2) {
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        Operand obj = this.build(attrAssignNode.getReceiverNode());
        int[] flags2 = new int[]{0};
        Operand[] args2 = this.setupCallArgs(attrAssignNode.getArgsNode(), flags2);
        args2 = IRBuilder.addArg(args2, value2);
        this.addInstr(AttrAssignInstr.create(this.scope, obj, attrAssignNode.getName(), args2, flags2[0], this.scope.maybeUsingRefinements()));
        return value2;
    }

    public Operand buildBackref(Variable result2, BackRefNode node) {
        if (result2 == null) {
            result2 = this.createTemporaryVariable();
        }
        return this.addResultInstr(new BuildBackrefInstr(result2, node.getType()));
    }

    public Operand buildBegin(BeginNode beginNode) {
        return this.build(beginNode.getBodyNode());
    }

    public Operand buildBignum(BignumNode node) {
        return new Bignum(node.getValue());
    }

    public Operand buildBlock(BlockNode node) {
        Operand retVal = null;
        for (Node child : node.children()) {
            retVal = this.build(child);
        }
        return retVal;
    }

    public Operand buildBreak(BreakNode breakNode) {
        IRLoop currLoop = this.getCurrentLoop();
        if (currLoop != null) {
            if (!this.activeEnsureBlockStack.isEmpty()) {
                this.emitEnsureBlocks(currLoop);
            }
            this.addInstr(new CopyInstr(currLoop.loopResult, this.build(breakNode.getValueNode())));
            this.addInstr(new JumpInstr(currLoop.loopEndLabel));
        } else if (this.scope instanceof IRClosure) {
            IRScope returnScope = this.scope.getLexicalParent();
            if (this.scope instanceof IREvalScript || returnScope == null) {
                this.throwSyntaxError(breakNode, "Can't escape from eval with redo");
            } else {
                this.addInstr(new BreakInstr(this.build(breakNode.getValueNode()), returnScope.getId()));
            }
        } else {
            this.throwSyntaxError(breakNode, "Invalid break");
        }
        return U_NIL;
    }

    private void throwSyntaxError(Node node, String message2) {
        String errorMessage = this.getFileName() + ":" + (node.getLine() + 1) + ": " + message2;
        throw this.scope.getManager().getRuntime().newSyntaxError(errorMessage);
    }

    private void handleNonlocalReturnInMethod() {
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = this.getNewLabel();
        Label gebLabel = this.getNewLabel();
        this.addInstrAtBeginning(new ExceptionRegionStartMarkerInstr(gebLabel));
        this.addInstrAtBeginning(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.addInstr(new LabelInstr(gebLabel));
        TemporaryVariable exc = this.createTemporaryVariable();
        this.addInstr(new ReceiveJRubyExceptionInstr(exc));
        TemporaryVariable ret = this.createTemporaryVariable();
        this.addInstr(new RuntimeHelperCall(ret, RuntimeHelperCall.Methods.HANDLE_NONLOCAL_RETURN, new Operand[]{exc}));
        this.addInstr(new ReturnInstr(ret));
        this.addInstr(new LabelInstr(rEndLabel));
    }

    private Operand receiveBreakException(Operand block, CodeBlock codeBlock) {
        if (block == null || !(block instanceof WrappedIRClosure) || !((WrappedIRClosure)block).getClosure().hasBreakInstructions()) {
            return codeBlock.run();
        }
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = this.getNewLabel();
        Label rescueLabel = this.getNewLabel();
        this.addInstr(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionStartMarkerInstr(rescueLabel));
        Variable callResult = (Variable)codeBlock.run();
        this.addInstr(new JumpInstr(rEndLabel));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.addInstr(new LabelInstr(rescueLabel));
        TemporaryVariable exc = this.createTemporaryVariable();
        this.addInstr(new ReceiveJRubyExceptionInstr(exc));
        this.addInstr(new RuntimeHelperCall(callResult, RuntimeHelperCall.Methods.HANDLE_PROPAGATED_BREAK, new Operand[]{exc}));
        this.addInstr(new LabelInstr(rEndLabel));
        return callResult;
    }

    private void receiveBreakException(Operand block, CallInstr callInstr) {
        this.receiveBreakException(block, () -> this.addResultInstr(callInstr));
    }

    public Operand buildCall(Variable aResult, CallNode callNode, Label lazyLabel, Label endLabel) {
        Node arg0;
        ArrayNode argsAry;
        Variable result2;
        RubySymbol name2 = this.methodName = callNode.getName();
        Node receiverNode = callNode.getReceiverNode();
        if (receiverNode instanceof SelfNode) {
            FCallNode fcall = new FCallNode(callNode.getLine(), callNode.getName(), callNode.getArgsNode(), callNode.getIterNode());
            return this.buildFCall(aResult, fcall);
        }
        String id2 = name2.idString();
        if (Options.IR_STRING_FREEZE.load().booleanValue() && receiverNode instanceof StrNode && (id2.equals("freeze") || id2.equals("-@"))) {
            StrNode asString = (StrNode)receiverNode;
            return new FrozenString(asString.getValue(), asString.getCodeRange(), this.scope.getFile(), asString.getLine());
        }
        boolean compileLazyLabel = false;
        if (callNode.isLazy() && lazyLabel == null) {
            compileLazyLabel = true;
            lazyLabel = this.getNewLabel();
            endLabel = this.getNewLabel();
        }
        Operand receiver2 = receiverNode instanceof CallNode && ((CallNode)receiverNode).isLazy() ? this.buildLazyWithOrder((CallNode)receiverNode, lazyLabel, endLabel, callNode.containsVariableAssignment()) : this.buildWithOrder(receiverNode, callNode.containsVariableAssignment());
        Variable variable = result2 = aResult == null ? this.createTemporaryVariable() : aResult;
        if (!callNode.isLazy() && id2.equals("[]") && callNode.getArgsNode() instanceof ArrayNode && (argsAry = (ArrayNode)callNode.getArgsNode()).size() == 1 && (arg0 = argsAry.get(0)) instanceof StrNode && !((StrNode)arg0).isFrozen() && !this.scope.maybeUsingRefinements() && callNode.getIterNode() == null) {
            StrNode keyNode = (StrNode)argsAry.get(0);
            FrozenString key2 = new FrozenString(keyNode.getValue(), keyNode.getCodeRange(), this.scope.getFile(), keyNode.getLine());
            this.addInstr(ArrayDerefInstr.create(this.scope, result2, receiver2, key2, 0));
            return result2;
        }
        if (callNode.isLazy()) {
            this.addInstr(new BNilInstr(lazyLabel, receiver2));
        }
        int[] flags2 = new int[]{0};
        Operand[] args2 = this.setupCallArgs(callNode.getArgsNode(), flags2);
        Operand block = this.setupCallClosure(callNode.getIterNode());
        if ((flags2[0] & 4) != 0) {
            Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{args2[args2.length - 1]}));
            this.if_else(test2, this.manager.getTrue(), () -> this.receiveBreakException(block, this.determineIfProcNew(receiverNode, CallInstr.create(this.scope, CallType.NORMAL, result2, name2, receiver2, IRBuilder.removeArg(args2), block, flags2[0]))), () -> this.receiveBreakException(block, this.determineIfProcNew(receiverNode, CallInstr.create(this.scope, CallType.NORMAL, result2, name2, receiver2, args2, block, flags2[0]))));
        } else {
            this.determineIfWeNeedLineNumber(callNode);
            this.receiveBreakException(block, this.determineIfProcNew(receiverNode, CallInstr.create(this.scope, CallType.NORMAL, result2, name2, receiver2, args2, block, flags2[0])));
        }
        if (compileLazyLabel) {
            this.addInstr(new JumpInstr(endLabel));
            this.addInstr(new LabelInstr(lazyLabel));
            this.addInstr(new CopyInstr(result2, this.manager.getNil()));
            this.addInstr(new LabelInstr(endLabel));
        }
        return result2;
    }

    private List<KeyValuePair<Operand, Operand>> buildKeywordArguments(HashNode keywordArgs) {
        ArrayList<KeyValuePair<Operand, Operand>> kwargs = new ArrayList<KeyValuePair<Operand, Operand>>();
        for (KeyValuePair<Node, Node> pair : keywordArgs.getPairs()) {
            kwargs.add(new KeyValuePair<Operand, Operand>(this.build(pair.getKey()), this.build(pair.getValue())));
        }
        return kwargs;
    }

    private CallInstr determineIfProcNew(Node receiverNode, CallInstr callInstr) {
        if (CommonByteLists.NEW_METHOD.equals(callInstr.getName().getBytes()) && receiverNode instanceof ConstNode && ((ConstNode)receiverNode).getName().idString().equals("Proc")) {
            callInstr.setProcNew(true);
        }
        return callInstr;
    }

    private void buildFindPattern(Label testEnd, Variable result2, Variable deconstructed, FindPatternNode pattern, Operand obj, boolean inAlteration, boolean isSinglePattern, Variable errorString) {
        if (pattern.hasConstant()) {
            Operand constant = this.build(pattern.getConstant());
            this.addInstr(new EQQInstr(this.scope, result2, constant, obj, false, true));
            this.cond_ne(testEnd, result2, this.tru());
        }
        this.label("deconstruct_end", deconstructCheck -> this.cond_ne((Label)deconstructCheck, deconstructed, this.buildNil(), () -> {
            this.call(result2, obj, "respond_to?", new Symbol(this.symbol("deconstruct")));
            this.cond_ne(testEnd, result2, this.tru());
            this.call(deconstructed, obj, "deconstruct", new Operand[0]);
            this.label("array_check_end", arrayCheck -> {
                this.addInstr(new EQQInstr(this.scope, result2, this.manager.getArrayClass(), deconstructed, false, false));
                this.cond((Label)arrayCheck, result2, this.tru(), () -> this.type_error("deconstruct must return Array"));
            });
        }));
        Variable length2 = this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.ARRAY_LENGTH, new Operand[]{deconstructed}));
        int fixedArgsLength = pattern.getArgs().size();
        Integer argsNum = new Integer(fixedArgsLength);
        this.label("size_check_end", sizeCheckEnd -> {
            this.addInstr(new BIntInstr((Label)sizeCheckEnd, BIntInstr.Op.LTE, (Operand)argsNum, (Operand)length2));
            this.copy(result2, this.fals());
            this.jump(testEnd);
        });
        Variable limit2 = this.addResultInstr(new IntegerMathInstr(IntegerMathInstr.Op.SUBTRACT, this.temp(), (Operand)length2, (Operand)argsNum));
        Variable i2 = this.copy(new Integer(0));
        this.for_loop(after -> this.addInstr(new BIntInstr((Label)after, BIntInstr.Op.GT, (Operand)i2, (Operand)limit2)), after -> this.addInstr(new IntegerMathInstr(IntegerMathInstr.Op.ADD, i2, (Operand)i2, (Operand)new Integer(1))), (after, bottom) -> {
            Node post;
            this.times(fixedArgsLength, (end_times, j) -> {
                Node pat = pattern.getArgs().get(j.value);
                Variable deconstructIndex = this.addResultInstr(new IntegerMathInstr(IntegerMathInstr.Op.ADD, this.temp(), (Operand)i2, (Operand)new Integer(j.value)));
                Variable deconstructFixnum = this.as_fixnum(deconstructIndex);
                Variable test2 = this.call(this.temp(), (Operand)deconstructed, "[]", deconstructFixnum);
                this.buildPatternMatch(result2, this.copy(this.buildNil()), pat, test2, false, isSinglePattern, errorString);
                this.cond_ne((Label)bottom, result2, this.tru());
            });
            Node pre = pattern.getPreRestArg();
            if (pre != null && !(pre instanceof StarNode)) {
                Variable iFixnum = this.as_fixnum(i2);
                Variable test2 = this.call(this.temp(), (Operand)deconstructed, "[]", this.manager.newFixnum(0L), iFixnum);
                this.buildPatternMatch(result2, this.copy(this.buildNil()), pre, test2, false, isSinglePattern, errorString);
                this.cond_ne((Label)bottom, result2, this.tru());
            }
            if ((post = pattern.getPostRestArg()) != null && !(post instanceof StarNode)) {
                Variable deconstructIndex = this.addResultInstr(new IntegerMathInstr(IntegerMathInstr.Op.ADD, (Variable)this.createTemporaryVariable(), (Operand)i2, argsNum));
                Variable deconstructFixnum = this.as_fixnum(deconstructIndex);
                Variable lengthFixnum = this.as_fixnum(length2);
                Variable test3 = this.call(this.temp(), (Operand)deconstructed, "[]", deconstructFixnum, lengthFixnum);
                this.buildPatternMatch(result2, this.copy(this.buildNil()), post, test3, false, isSinglePattern, errorString);
                this.cond_ne((Label)bottom, result2, this.tru());
            }
            this.jump((Label)after);
        });
    }

    private void buildArrayPattern(Label testEnd, Variable result2, Variable deconstructed, ArrayPatternNode pattern, Operand obj, boolean inAlteration, boolean isSinglePattern, Variable errorString) {
        ListNode postArgs;
        int preArgsSize;
        Variable restNum = this.addResultInstr(new CopyInstr(this.temp(), new Integer(0)));
        if (pattern.hasConstant()) {
            Operand constant = this.build(pattern.getConstant());
            this.addInstr(new EQQInstr(this.scope, result2, constant, obj, false, true));
            this.cond_ne(testEnd, result2, this.tru());
        }
        this.call(result2, obj, "respond_to?", new Symbol(this.symbol("deconstruct")));
        this.cond_ne(testEnd, result2, this.tru());
        this.label("deconstruct_cache_end", deconstruct_cache_end -> this.cond_ne((Label)deconstruct_cache_end, deconstructed, this.buildNil(), () -> {
            this.call(deconstructed, obj, "deconstruct", new Operand[0]);
            this.label("array_check_end", arrayCheck -> {
                this.addInstr(new EQQInstr(this.scope, result2, this.manager.getArrayClass(), deconstructed, false, false));
                this.cond((Label)arrayCheck, result2, this.tru(), () -> this.type_error("deconstruct must return Array"));
            });
        }));
        Integer minArgsCount = new Integer(pattern.minimumArgsNum());
        Variable length2 = this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.ARRAY_LENGTH, new Operand[]{deconstructed}));
        this.label("min_args_check_end", minArgsCheck -> {
            BIntInstr.Op compareOp = pattern.hasRestArg() ? BIntInstr.Op.GTE : BIntInstr.Op.EQ;
            this.addInstr(new BIntInstr((Label)minArgsCheck, compareOp, (Operand)length2, (Operand)minArgsCount));
            this.fcall(errorString, (Operand)this.buildSelf(), "sprintf", new FrozenString("%s: %s length mismatch (given %d, expected %d)"), deconstructed, deconstructed, this.as_fixnum(length2), this.as_fixnum(minArgsCount));
            this.addInstr(new CopyInstr(result2, this.fals()));
            this.jump(testEnd);
        });
        ListNode preArgs = pattern.getPreArgs();
        int n = preArgsSize = preArgs == null ? 0 : preArgs.size();
        if (preArgsSize > 0) {
            for (int i2 = 0; i2 < preArgsSize; ++i2) {
                Variable elt = this.call(this.temp(), (Operand)deconstructed, "[]", this.fix(i2));
                Node arg2 = preArgs.get(i2);
                this.buildPatternEach(testEnd, result2, this.copy(this.buildNil()), elt, arg2, inAlteration, isSinglePattern, errorString);
                this.cond_ne(testEnd, result2, this.tru());
            }
        }
        if (pattern.hasRestArg()) {
            this.addInstr(new IntegerMathInstr(IntegerMathInstr.Op.SUBTRACT, restNum, (Operand)length2, (Operand)minArgsCount));
            if (pattern.isNamedRestArg()) {
                Variable min2 = this.copy(this.fix(preArgsSize));
                Variable max2 = this.as_fixnum(restNum);
                Variable elt = this.call(this.temp(), (Operand)deconstructed, "[]", min2, max2);
                this.buildPatternMatch(result2, this.copy(this.buildNil()), pattern.getRestArg(), elt, inAlteration, isSinglePattern, errorString);
                this.cond_ne(testEnd, result2, this.tru());
            }
        }
        if ((postArgs = pattern.getPostArgs()) != null) {
            for (int i3 = 0; i3 < postArgs.size(); ++i3) {
                Label matchElementCheck = this.getNewLabel("match_post_args_element(i)_end");
                Variable j = this.addResultInstr(new IntegerMathInstr(IntegerMathInstr.Op.ADD, this.temp(), (Operand)new Integer(i3 + preArgsSize), (Operand)restNum));
                Variable k = this.as_fixnum(j);
                Variable elt = this.call(this.temp(), (Operand)deconstructed, "[]", k);
                this.buildPatternEach(testEnd, result2, this.copy(this.buildNil()), elt, postArgs.get(i3), inAlteration, isSinglePattern, errorString);
                this.addInstr(BNEInstr.create(matchElementCheck, result2, this.buildFalse()));
                this.addInstr(new JumpInstr(testEnd));
                this.addInstr(new LabelInstr(matchElementCheck));
            }
        }
    }

    private Variable deconstructHashPatternKeys(Label testEnd, HashPatternNode pattern, Variable result2, Operand obj) {
        Operand keys2;
        if (pattern.hasKeywordArgs() && !pattern.hashNamedKeywordRestArg()) {
            List keyNodes = pattern.getKeys();
            int length2 = keyNodes.size();
            Operand[] builtKeys = new Operand[length2];
            for (int i2 = 0; i2 < length2; ++i2) {
                builtKeys[i2] = this.build((Node)keyNodes.get(i2));
            }
            keys2 = new Array(builtKeys);
        } else {
            keys2 = this.manager.getNil();
        }
        if (pattern.getConstant() != null) {
            Operand constant = this.build(pattern.getConstant());
            this.addInstr(new EQQInstr(this.scope, result2, constant, obj, false, true));
            this.cond_ne(testEnd, result2, this.tru());
        }
        this.call(result2, obj, "respond_to?", new Symbol(this.symbol("deconstruct_keys")));
        this.cond_ne(testEnd, result2, this.tru());
        return this.call((Variable)this.createTemporaryVariable(), obj, "deconstruct_keys", keys2);
    }

    private void buildHashPattern(Label testEnd, Variable result2, Variable deconstructed, HashPatternNode pattern, Operand obj, boolean inAlteration, boolean isSinglePattern, Variable errorString) {
        Variable d = this.deconstructHashPatternKeys(testEnd, pattern, result2, obj);
        this.label("hash_check_end", endHashCheck -> {
            this.addInstr(new EQQInstr(this.scope, result2, this.manager.getHashClass(), d, false, true));
            this.cond((Label)endHashCheck, result2, this.tru(), () -> this.type_error("deconstruct_keys must return Hash"));
        });
        if (pattern.hasRestArg()) {
            this.call(d, (Operand)d, "dup", new Operand[0]);
        }
        if (pattern.hasKeywordArgs()) {
            List<KeyValuePair<Node, Node>> kwargs = pattern.getKeywordArgs().getPairs();
            for (KeyValuePair<Node, Node> pair : kwargs) {
                Operand key2 = this.build(pair.getKey());
                this.call(result2, (Operand)d, "key?", key2);
                this.cond_ne(testEnd, result2, this.tru());
                String method2 = pattern.hasRestArg() ? "delete" : "[]";
                Variable value2 = this.call(this.temp(), (Operand)d, method2, key2);
                this.buildPatternEach(testEnd, result2, this.copy(this.buildNil()), value2, pair.getValue(), inAlteration, isSinglePattern, errorString);
                this.cond_ne(testEnd, result2, this.tru());
            }
        } else {
            this.call(result2, (Operand)d, "empty?", new Operand[0]);
            this.cond_ne(testEnd, result2, this.tru());
        }
        if (pattern.hasRestArg()) {
            if (pattern.getRestArg() instanceof NilRestArgNode) {
                this.call(result2, (Operand)d, "empty?", new Operand[0]);
                this.cond_ne(testEnd, result2, this.tru());
            } else if (pattern.isNamedRestArg()) {
                this.buildPatternEach(testEnd, result2, this.copy(this.buildNil()), d, pattern.getRestArg(), inAlteration, isSinglePattern, errorString);
                this.cond_ne(testEnd, result2, this.tru());
            }
        }
    }

    private void type_error(String message2) {
        this.addRaiseError("TypeError", message2);
    }

    private Variable temp() {
        return this.createTemporaryVariable();
    }

    private Operand fals() {
        return this.manager.getFalse();
    }

    private Fixnum fix(long value2) {
        return this.manager.newFixnum(value2);
    }

    private Operand tru() {
        return this.manager.getTrue();
    }

    private void cond(Label label2, Operand value2, Operand test2) {
        this.addInstr(IRBuilder.createBranch(value2, test2, label2));
    }

    private void cond(Label endLabel, Operand value2, Operand test2, RunIt body) {
        this.addInstr(IRBuilder.createBranch(value2, test2, endLabel));
        body.apply();
    }

    private void cond_ne(Label label2, Operand value2, Operand test2) {
        this.addInstr(BNEInstr.create(label2, value2, test2));
    }

    private void cond_ne(Label endLabel, Operand value2, Operand test2, RunIt body) {
        this.addInstr(BNEInstr.create(endLabel, value2, test2));
        body.apply();
    }

    private void jump(Label label2) {
        this.addInstr(new JumpInstr(label2));
    }

    private Variable call(Variable result2, Operand object, String name2, Operand ... args2) {
        return this.call(result2, object, this.symbol(name2), args2);
    }

    private Variable call(Variable result2, Operand object, RubySymbol name2, Operand ... args2) {
        return this._call(result2, CallType.NORMAL, object, name2, args2);
    }

    private Variable _call(Variable result2, CallType type2, Operand object, RubySymbol name2, Operand ... args2) {
        this.addInstr(CallInstr.create(this.scope, type2, result2, name2, object, args2, NullBlock.INSTANCE, 0));
        return result2;
    }

    private Variable fcall(Variable result2, Operand object, String name2, Operand ... args2) {
        return this.fcall(result2, object, this.symbol(name2), args2);
    }

    private Variable fcall(Variable result2, Operand object, RubySymbol name2, Operand ... args2) {
        return this._call(result2, CallType.FUNCTIONAL, object, name2, args2);
    }

    private void for_loop(Consumer<Label> test2, Consumer<Label> increment, Consume2<Label, Label> body) {
        Label top = this.getNewLabel("for_top");
        Label bottom = this.getNewLabel("for_bottom");
        this.label("for_end", after -> {
            this.addInstr(new LabelInstr(top));
            test2.accept((Label)after);
            body.apply((Label)after, bottom);
            this.addInstr(new LabelInstr(bottom));
            increment.accept((Label)after);
            this.jump(top);
        });
    }

    private void times(int times2, Consume2<Label, Integer> body) {
        this.label("times_end", end2 -> {
            for (int i2 = 0; i2 < times2; ++i2) {
                body.apply((Label)end2, new Integer(i2));
            }
        });
    }

    private void label(String labelName, Consumer<Label> block) {
        Label label2 = this.getNewLabel(labelName);
        block.accept(label2);
        this.addInstr(new LabelInstr(label2));
    }

    private void buildPatternMatch(Variable result2, Variable deconstructed, Node arg2, Operand obj, boolean inAlternation, boolean isSinglePattern, Variable errorString) {
        this.label("pattern_end", testEnd -> this.buildPatternEach((Label)testEnd, result2, deconstructed, obj, arg2, inAlternation, isSinglePattern, errorString));
    }

    private Variable buildPatternEach(Label testEnd, Variable result2, Variable deconstructed, Operand value2, Node exprNodes, boolean inAlternation, boolean isSinglePattern, Variable errorString) {
        if (exprNodes instanceof ArrayPatternNode) {
            this.buildArrayPattern(testEnd, result2, deconstructed, (ArrayPatternNode)exprNodes, value2, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof HashPatternNode) {
            this.buildHashPattern(testEnd, result2, deconstructed, (HashPatternNode)exprNodes, value2, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof FindPatternNode) {
            this.buildFindPattern(testEnd, result2, deconstructed, (FindPatternNode)exprNodes, value2, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof HashNode) {
            HashNode hash2 = (HashNode)exprNodes;
            if (hash2.getPairs().size() != 1) {
                this.throwSyntaxError(hash2, "unexpected node");
            }
            KeyValuePair<Node, Node> pair = hash2.getPairs().get(0);
            this.buildPatternMatch(result2, deconstructed, pair.getKey(), value2, inAlternation, isSinglePattern, errorString);
            this.buildPatternEach(testEnd, result2, deconstructed, value2, pair.getValue(), inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof IfNode) {
            boolean unless;
            IfNode ifNode = (IfNode)exprNodes;
            if (ifNode.getThenBody() != null) {
                unless = false;
                this.buildPatternMatch(result2, deconstructed, ifNode.getThenBody(), value2, inAlternation, isSinglePattern, errorString);
            } else {
                unless = true;
                this.buildPatternMatch(result2, deconstructed, ifNode.getElseBody(), value2, inAlternation, isSinglePattern, errorString);
            }
            this.label("if_else_end", conditionalEnd -> {
                this.cond_ne((Label)conditionalEnd, result2, this.tru());
                Operand ifResult = this.build(ifNode.getCondition());
                if (unless) {
                    this.call(result2, ifResult, "!", new Operand[0]);
                } else {
                    this.addInstr(new CopyInstr(result2, ifResult));
                }
            });
        } else if (exprNodes instanceof LocalAsgnNode) {
            LocalAsgnNode localAsgnNode = (LocalAsgnNode)exprNodes;
            RubySymbol name2 = localAsgnNode.getName();
            if (inAlternation && name2.idString().charAt(0) != '_') {
                this.throwSyntaxError(localAsgnNode, RubyStringBuilder.str(this.manager.getRuntime(), "illegal variable in alternative pattern (", name2, ")"));
            }
            LocalVariable variable = this.getLocalVariable(name2, localAsgnNode.getDepth());
            this.addInstr(new CopyInstr(variable, value2));
        } else if (!(exprNodes instanceof StarNode)) {
            if (exprNodes instanceof DAsgnNode) {
                DAsgnNode localAsgnNode = (DAsgnNode)exprNodes;
                RubySymbol name3 = localAsgnNode.getName();
                if (inAlternation && name3.idString().charAt(0) != '_') {
                    this.throwSyntaxError(localAsgnNode, RubyStringBuilder.str(this.manager.getRuntime(), "illegal variable in alternative pattern (", name3, ")"));
                }
                LocalVariable variable = this.getLocalVariable(name3, localAsgnNode.getDepth());
                this.addInstr(new CopyInstr(variable, value2));
            } else if (exprNodes instanceof OrNode) {
                OrNode orNode = (OrNode)exprNodes;
                this.label("or_lhs_end", firstCase -> this.buildPatternEach((Label)firstCase, result2, deconstructed, value2, orNode.getFirstNode(), true, isSinglePattern, errorString));
                this.label("or_rhs_end", secondCase -> this.cond((Label)secondCase, result2, this.tru(), () -> this.buildPatternEach(testEnd, result2, deconstructed, value2, orNode.getSecondNode(), true, isSinglePattern, errorString)));
            } else {
                Operand expression = this.build(exprNodes);
                boolean needsSplat = exprNodes instanceof ArgsPushNode || exprNodes instanceof SplatNode || exprNodes instanceof ArgsCatNode;
                this.addInstr(new EQQInstr(this.scope, result2, expression, value2, needsSplat, this.scope.maybeUsingRefinements()));
            }
        }
        return result2;
    }

    public Operand buildPatternCase(PatternCaseNode patternCase) {
        Variable result2 = this.temp();
        Operand value2 = this.build(patternCase.getCaseNode());
        Variable errorString = this.copy(this.buildNil());
        this.label("pattern_case_end", end2 -> {
            boolean hasElse;
            ArrayList<Label> labels = new ArrayList<Label>();
            HashMap<Label, Node> bodies = new HashMap<Label, Node>();
            Variable deconstructed = this.copy(this.buildNil());
            for (Node aCase : patternCase.getCases().children()) {
                InNode inNode = (InNode)aCase;
                Label bodyLabel = this.getNewLabel();
                boolean isSinglePattern = inNode.isSinglePattern();
                Variable eqqResult = this.copy(this.tru());
                labels.add(bodyLabel);
                this.buildPatternMatch(eqqResult, deconstructed, inNode.getExpression(), value2, false, isSinglePattern, errorString);
                this.addInstr(IRBuilder.createBranch(eqqResult, this.tru(), bodyLabel));
                bodies.put(bodyLabel, inNode.getBody());
            }
            Label elseLabel = this.getNewLabel();
            this.addInstr(new JumpInstr(elseLabel));
            boolean bl = hasElse = patternCase.getElseNode() != null;
            if (hasElse) {
                labels.add(elseLabel);
                bodies.put(elseLabel, patternCase.getElseNode());
            }
            for (Label label2 : labels) {
                this.addInstr(new LabelInstr(label2));
                Operand bodyValue = this.build((Node)bodies.get(label2));
                if (bodyValue != null) {
                    this.copy(result2, bodyValue);
                }
                this.jump((Label)end2);
            }
            if (!hasElse) {
                this.addInstr(new LabelInstr(elseLabel));
                Variable inspect2 = this.temp();
                this.if_else(errorString, this.buildNil(), () -> this.call(inspect2, value2, "inspect", new Operand[0]), () -> this.copy(inspect2, errorString));
                this.addRaiseError("NoMatchingPatternError", inspect2);
                this.jump((Label)end2);
            }
        });
        return result2;
    }

    public Operand buildCase(CaseNode caseNode) {
        if (caseNode.getCaseNode() != null && !this.scope.maybeUsingRefinements()) {
            Enum seenType = null;
            for (Node aCase : caseNode.getCases().children()) {
                WhenNode whenNode = (WhenNode)aCase;
                NodeType exprNodeType = whenNode.getExpressionNodes().getNodeType();
                if (seenType == null) {
                    seenType = exprNodeType;
                    continue;
                }
                if (seenType == exprNodeType) continue;
                seenType = null;
                break;
            }
            if (seenType != null) {
                switch (7.$SwitchMap$org$jruby$ast$NodeType[seenType.ordinal()]) {
                    case 36: {
                        return this.buildOptimizedCaseWhen(caseNode, RubyFixnum.class, n -> ((FixnumNode)n).getValue());
                    }
                    case 82: {
                        return this.buildOptimizedCaseWhen(caseNode, RubySymbol.class, n -> ((SymbolNode)n).getName().getId());
                    }
                }
            }
        }
        Operand testValue = this.buildCaseTestValue(caseNode);
        Label elseLabel = this.getNewLabel();
        Label endLabel = this.getNewLabel();
        boolean hasExplicitElse = caseNode.getElseNode() != null;
        TemporaryVariable result2 = this.createTemporaryVariable();
        HashMap<Label, Node> bodies = new HashMap<Label, Node>();
        HashSet<IRubyObject> seenLiterals = new HashSet<IRubyObject>();
        for (Node aCase : caseNode.getCases().children()) {
            WhenNode when = (WhenNode)aCase;
            Label bodyLabel = this.getNewLabel();
            this.buildWhenArgs(when, testValue, bodyLabel, seenLiterals);
            bodies.put(bodyLabel, when.getBodyNode());
        }
        this.addInstr(new JumpInstr(elseLabel));
        if (hasExplicitElse) {
            bodies.put(elseLabel, caseNode.getElseNode());
        }
        int numberOfBodies = bodies.size();
        int i2 = 1;
        for (Map.Entry entry : bodies.entrySet()) {
            this.addInstr(new LabelInstr((Label)entry.getKey()));
            Operand bodyValue = this.build((Node)entry.getValue());
            if (bodyValue != null) {
                this.addInstr(new CopyInstr(result2, bodyValue));
                if (i2 != numberOfBodies) {
                    this.addInstr(new JumpInstr(endLabel));
                } else if (!hasExplicitElse) {
                    this.addInstr(new JumpInstr(endLabel));
                }
            }
            ++i2;
        }
        if (!hasExplicitElse) {
            this.addInstr(new LabelInstr(elseLabel));
            this.addInstr(new CopyInstr(result2, this.manager.getNil()));
        }
        this.addInstr(new LabelInstr(endLabel));
        return result2;
    }

    private Operand buildCaseTestValue(CaseNode caseNode) {
        Operand testValue;
        Node caseTestValue = caseNode.getCaseNode();
        if (caseTestValue instanceof StrNode) {
            ((StrNode)caseTestValue).setFrozen(true);
        }
        return (testValue = this.build(caseTestValue)) == null ? UndefinedValue.UNDEFINED : testValue;
    }

    private boolean literalWhenCheck(Node value2, Set<IRubyObject> seenLiterals) {
        IRubyObject literal = this.getWhenLiteral(value2);
        if (literal != null) {
            if (seenLiterals.contains(literal)) {
                this.scope.getManager().getRuntime().getWarnings().warning(IRubyWarnings.ID.MISCELLANEOUS, this.getFileName(), value2.getLine(), "duplicated when clause is ignored");
                return false;
            }
            seenLiterals.add(literal);
            return true;
        }
        return true;
    }

    private void buildWhenValues(Variable eqqResult, ListNode exprValues, Operand testValue, Label bodyLabel, Set<IRubyObject> seenLiterals) {
        for (Node value2 : exprValues.children()) {
            this.buildWhenValue(eqqResult, testValue, bodyLabel, value2, seenLiterals, false);
        }
    }

    private void buildWhenValue(Variable eqqResult, Operand testValue, Label bodyLabel, Node node, Set<IRubyObject> seenLiterals, boolean needsSplat) {
        if (this.literalWhenCheck(node, seenLiterals)) {
            if (node instanceof StrNode) {
                ((StrNode)node).setFrozen(true);
            }
            Operand expression = this.buildWithOrder(node, node.containsVariableAssignment());
            this.addInstr(new EQQInstr(this.scope, eqqResult, expression, testValue, needsSplat, this.scope.maybeUsingRefinements()));
            this.addInstr(IRBuilder.createBranch(eqqResult, this.manager.getTrue(), bodyLabel));
        }
    }

    private void buildWhenSplatValues(Variable eqqResult, Node node, Operand testValue, Label bodyLabel, Set<IRubyObject> seenLiterals) {
        if (node instanceof ListNode && !(node instanceof DNode) && !(node instanceof ArrayNode)) {
            this.buildWhenValues(eqqResult, (ListNode)node, testValue, bodyLabel, seenLiterals);
        } else if (node instanceof SplatNode) {
            this.buildWhenValue(eqqResult, testValue, bodyLabel, node, seenLiterals, true);
        } else if (node instanceof ArgsCatNode) {
            ArgsCatNode catNode = (ArgsCatNode)node;
            this.buildWhenSplatValues(eqqResult, catNode.getFirstNode(), testValue, bodyLabel, seenLiterals);
            this.buildWhenSplatValues(eqqResult, catNode.getSecondNode(), testValue, bodyLabel, seenLiterals);
        } else if (node instanceof ArgsPushNode) {
            ArgsPushNode pushNode = (ArgsPushNode)node;
            this.buildWhenSplatValues(eqqResult, pushNode.getFirstNode(), testValue, bodyLabel, seenLiterals);
            this.buildWhenValue(eqqResult, testValue, bodyLabel, pushNode.getSecondNode(), seenLiterals, false);
        } else {
            this.buildWhenValue(eqqResult, testValue, bodyLabel, node, seenLiterals, true);
        }
    }

    private void buildWhenArgs(WhenNode whenNode, Operand testValue, Label bodyLabel, Set<IRubyObject> seenLiterals) {
        TemporaryVariable eqqResult = this.createTemporaryVariable();
        Node exprNodes = whenNode.getExpressionNodes();
        if (exprNodes instanceof ListNode && !(exprNodes instanceof DNode) && !(exprNodes instanceof ArrayNode) && !(exprNodes instanceof ZArrayNode)) {
            this.buildWhenValues(eqqResult, (ListNode)exprNodes, testValue, bodyLabel, seenLiterals);
        } else if (exprNodes instanceof ArgsPushNode || exprNodes instanceof SplatNode || exprNodes instanceof ArgsCatNode) {
            this.buildWhenSplatValues(eqqResult, exprNodes, testValue, bodyLabel, seenLiterals);
        } else {
            this.buildWhenValue(eqqResult, testValue, bodyLabel, exprNodes, seenLiterals, false);
        }
    }

    private IRubyObject getWhenLiteral(Node node) {
        Ruby runtime2 = this.scope.getManager().getRuntime();
        switch (node.getNodeType()) {
            case FIXNUMNODE: {
                return runtime2.newFixnum(((FixnumNode)node).getValue());
            }
            case FLOATNODE: {
                return runtime2.newFloat(((FloatNode)node).getValue());
            }
            case BIGNUMNODE: {
                return new RubyBignum(runtime2, ((BignumNode)node).getValue());
            }
            case COMPLEXNODE: {
                return RubyComplex.newComplexRaw(runtime2, this.getWhenLiteral(((ComplexNode)node).getNumber()));
            }
            case RATIONALNODE: {
                return RubyRational.newRationalRaw(runtime2, this.getWhenLiteral(((RationalNode)node).getDenominator()), this.getWhenLiteral(((RationalNode)node).getNumerator()));
            }
            case NILNODE: {
                return runtime2.getNil();
            }
            case TRUENODE: {
                return runtime2.getTrue();
            }
            case FALSENODE: {
                return runtime2.getFalse();
            }
            case SYMBOLNODE: {
                return ((SymbolNode)node).getName();
            }
            case STRNODE: {
                return runtime2.newString(((StrNode)node).getValue());
            }
        }
        return null;
    }

    private <T extends Node> Variable buildOptimizedCaseWhen(CaseNode caseNode, Class caseClass, Function<T, Long> caseFunction) {
        Operand value2 = this.build(caseNode.getCaseNode());
        HashMap<Node, Label> nodeBodies = new HashMap<Node, Label>();
        Map<java.lang.Integer, Label> jumpTable = this.gatherLiteralWhenBodies(caseNode, nodeBodies, caseFunction);
        Map.Entry<java.lang.Integer, Label>[] jumpEntries = IRBuilder.sortJumpEntries(jumpTable);
        Label endLabel = this.getNewLabel();
        boolean hasElse = caseNode.getElseNode() != null;
        Label elseLabel = this.getNewLabel();
        TemporaryVariable result2 = this.createTemporaryVariable();
        this.buildOptimizedSwitch(jumpTable, jumpEntries, elseLabel, value2, caseClass);
        return this.buildStandardCaseWhen(caseNode, nodeBodies, endLabel, hasElse, elseLabel, value2, result2);
    }

    private <T extends Node> Map<java.lang.Integer, Label> gatherLiteralWhenBodies(CaseNode caseNode, Map<Node, Label> nodeBodies, Function<T, Long> caseFunction) {
        HashMap<java.lang.Integer, Label> jumpTable = new HashMap<java.lang.Integer, Label>();
        for (Node aCase : caseNode.getCases().children()) {
            WhenNode whenNode = (WhenNode)aCase;
            Label bodyLabel = this.getNewLabel();
            Node expr = whenNode.getExpressionNodes();
            long exprLong = caseFunction.apply(expr);
            if (exprLong > java.lang.Integer.MAX_VALUE) {
                throw this.notCompilable("optimized case has long-ranged value", caseNode);
            }
            if (jumpTable.get((int)exprLong) == null) {
                jumpTable.put((int)exprLong, bodyLabel);
                nodeBodies.put(whenNode, bodyLabel);
                continue;
            }
            this.scope.getManager().getRuntime().getWarnings().warning(IRubyWarnings.ID.MISCELLANEOUS, this.getFileName(), expr.getLine(), "duplicated when clause is ignored");
        }
        return jumpTable;
    }

    private static Map.Entry<java.lang.Integer, Label>[] sortJumpEntries(Map<java.lang.Integer, Label> jumpTable) {
        Map.Entry[] jumpEntries = jumpTable.entrySet().toArray(new Map.Entry[jumpTable.size()]);
        Arrays.sort(jumpEntries, Comparator.comparingInt(Map.Entry::getKey));
        return jumpEntries;
    }

    private void buildOptimizedSwitch(Map<java.lang.Integer, Label> jumpTable, Map.Entry<java.lang.Integer, Label>[] jumpEntries, Label elseLabel, Operand value2, Class valueClass) {
        Label eqqPath = this.getNewLabel();
        int[] jumps = new int[jumpTable.size()];
        Label[] targets = new Label[jumps.length];
        int i2 = 0;
        for (Map.Entry<java.lang.Integer, Label> jumpEntry : jumpEntries) {
            jumps[i2] = jumpEntry.getKey();
            targets[i2] = jumpEntry.getValue();
            ++i2;
        }
        this.addInstr(new BSwitchInstr(jumps, value2, eqqPath, targets, elseLabel, valueClass));
        this.addInstr(new LabelInstr(eqqPath));
    }

    private Variable buildStandardCaseWhen(CaseNode caseNode, Map<Node, Label> nodeBodies, Label endLabel, boolean hasElse, Label elseLabel, Operand value2, Variable result2) {
        ArrayList<Label> labels = new ArrayList<Label>();
        HashMap<Label, Node> bodies = new HashMap<Label, Node>();
        for (Node aCase : caseNode.getCases().children()) {
            WhenNode whenNode = (WhenNode)aCase;
            Label bodyLabel = nodeBodies.get(whenNode);
            if (bodyLabel == null) {
                bodyLabel = this.getNewLabel();
            }
            TemporaryVariable eqqResult = this.createTemporaryVariable();
            labels.add(bodyLabel);
            Operand expression = this.build(whenNode.getExpressionNodes());
            if (expression instanceof MutableString) {
                expression = ((MutableString)expression).frozenString;
            }
            this.addInstr(new EQQInstr(this.scope, eqqResult, expression, value2, false, this.scope.maybeUsingRefinements()));
            this.addInstr(IRBuilder.createBranch(eqqResult, this.manager.getTrue(), bodyLabel));
            bodies.put(bodyLabel, whenNode.getBodyNode());
        }
        this.addInstr(new JumpInstr(elseLabel));
        if (hasElse) {
            labels.add(elseLabel);
            bodies.put(elseLabel, caseNode.getElseNode());
        }
        for (Label whenLabel : labels) {
            this.addInstr(new LabelInstr(whenLabel));
            Operand bodyValue = this.build((Node)bodies.get(whenLabel));
            if (bodyValue == null) continue;
            this.addInstr(new CopyInstr(result2, bodyValue));
            this.addInstr(new JumpInstr(endLabel));
        }
        if (!hasElse) {
            this.addInstr(new LabelInstr(elseLabel));
            this.addInstr(new CopyInstr(result2, this.manager.getNil()));
            this.addInstr(new JumpInstr(endLabel));
        }
        this.addInstr(new LabelInstr(endLabel));
        return result2;
    }

    public Operand buildClass(ClassNode classNode) {
        boolean executesOnce = this.executesOnce;
        Node superNode = classNode.getSuperNode();
        Colon3Node cpath = classNode.getCPath();
        Operand superClass = superNode == null ? null : this.build(superNode);
        ByteList className = cpath.getName().getBytes();
        Operand container = this.getContainerFromCPath(cpath);
        IRClassBody body = new IRClassBody(this.manager, this.scope, className, classNode.getLine(), classNode.getScope(), executesOnce);
        Variable bodyResult = this.addResultInstr(new DefineClassInstr(this.createTemporaryVariable(), body, container, superClass));
        this.newIRBuilder(this.manager, body).buildModuleOrClassBody(classNode.getBodyNode(), classNode.getLine(), classNode.getEndLine());
        return bodyResult;
    }

    public Operand buildSClass(SClassNode sclassNode) {
        Operand receiver2 = this.build(sclassNode.getReceiverNode());
        IRMetaClassBody body = new IRMetaClassBody(this.manager, this.scope, this.manager.getMetaClassName().getBytes(), sclassNode.getLine(), sclassNode.getScope());
        Variable sClassVar = this.addResultInstr(new DefineMetaClassInstr(this.createTemporaryVariable(), receiver2, body));
        Variable processBodyResult = this.addResultInstr(new ProcessModuleBodyInstr(this.createTemporaryVariable(), sClassVar, this.getYieldClosureVariable()));
        this.newIRBuilder(this.manager, body).buildModuleOrClassBody(sclassNode.getBodyNode(), sclassNode.getLine(), sclassNode.getEndLine());
        return processBodyResult;
    }

    private boolean isTopScope() {
        IRScope s2;
        boolean isTopScope;
        IRScope topScope = this.scope.getNearestNonClosurelikeScope();
        boolean bl = isTopScope = topScope instanceof IRScriptBody || this.evalType != null && this.evalType != EvalType.MODULE_EVAL && this.evalType != EvalType.BINDING_EVAL;
        if (!isTopScope) {
            return false;
        }
        for (s2 = topScope; s2 != null && !(s2 instanceof IRModuleBody); s2 = s2.getLexicalParent()) {
        }
        return s2 == null;
    }

    public Operand buildClassVar(ClassVarNode node) {
        if (this.isTopScope()) {
            return this.addRaiseError("RuntimeError", "class variable access from toplevel");
        }
        return this.addResultInstr(new GetClassVariableInstr(this.temp(), this.classVarDefinitionContainer(), node.getName()));
    }

    private Variable addResultInstr(ResultInstr instr) {
        this.addInstr((Instr)((Object)instr));
        return instr.getResult();
    }

    public Operand buildClassVarAsgn(ClassVarAsgnNode classVarAsgnNode) {
        if (this.isTopScope()) {
            return this.addRaiseError("RuntimeError", "class variable access from toplevel");
        }
        Operand val = this.build(classVarAsgnNode.getValueNode());
        this.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(), classVarAsgnNode.getName(), val));
        return val;
    }

    @Deprecated
    public Operand classVarDeclarationContainer() {
        return this.classVarContainer(true);
    }

    public Operand classVarDefinitionContainer() {
        return this.classVarContainer(false);
    }

    public Operand classVarContainer(boolean declContext) {
        IRScope cvarScope;
        int n = 0;
        for (cvarScope = this.scope; cvarScope != null && !(cvarScope instanceof IREvalScript) && !cvarScope.isNonSingletonClassBody(); cvarScope = cvarScope.getLexicalParent()) {
            if (cvarScope instanceof IRFor) continue;
            ++n;
        }
        if (cvarScope != null && cvarScope.isNonSingletonClassBody()) {
            return ScopeModule.ModuleFor(n);
        }
        return this.addResultInstr(new GetClassVarContainerModuleInstr(this.createTemporaryVariable(), CurrentScope.INSTANCE, declContext ? null : this.buildSelf()));
    }

    public Operand buildConstDecl(ConstDeclNode node) {
        return this.buildConstDeclAssignment(node, this.build(node.getValueNode()));
    }

    private Operand findContainerModule() {
        int nearestModuleBodyDepth = this.scope.getNearestModuleReferencingScopeDepth();
        return nearestModuleBodyDepth == -1 ? this.getCurrentModuleVariable() : ScopeModule.ModuleFor(nearestModuleBodyDepth);
    }

    public Operand buildConstDeclAssignment(ConstDeclNode constDeclNode, Operand value2) {
        Node constNode = constDeclNode.getConstNode();
        if (constNode == null) {
            return this.putConstant(constDeclNode.getName(), value2);
        }
        if (constNode.getNodeType() == NodeType.COLON2NODE) {
            return this.putConstant((Colon2Node)constNode, value2);
        }
        return this.putConstant((Colon3Node)constNode, value2);
    }

    private Operand putConstant(RubySymbol name2, Operand value2) {
        this.addInstr(new PutConstInstr(this.findContainerModule(), name2, value2));
        return value2;
    }

    private Operand putConstant(Colon3Node node, Operand value2) {
        this.addInstr(new PutConstInstr(this.manager.getObjectClass(), node.getName(), value2));
        return value2;
    }

    private Operand putConstant(Colon2Node node, Operand value2) {
        this.addInstr(new PutConstInstr(this.build(node.getLeftNode()), node.getName(), value2));
        return value2;
    }

    private Operand putConstantAssignment(OpAsgnConstDeclNode node, Operand value2) {
        Node constNode = node.getFirstNode();
        if (constNode instanceof Colon2Node) {
            return this.putConstant((Colon2Node)constNode, value2);
        }
        return this.putConstant((Colon3Node)constNode, value2);
    }

    private Operand searchModuleForConst(Operand startingModule, RubySymbol name2) {
        return this.addResultInstr(new SearchModuleForConstInstr(this.createTemporaryVariable(), startingModule, name2, true));
    }

    private Operand searchConst(RubySymbol name2) {
        return this.addResultInstr(new SearchConstInstr(this.createTemporaryVariable(), CurrentScope.INSTANCE, name2, false));
    }

    public Operand buildColon2(Colon2Node colon2) {
        Node lhs = colon2.getLeftNode();
        if (lhs == null) {
            return this.searchConst(colon2.getName());
        }
        return this.searchModuleForConst(this.build(lhs), colon2.getName());
    }

    public Operand buildColon3(Colon3Node node) {
        return this.searchModuleForConst(this.manager.getObjectClass(), node.getName());
    }

    public Operand buildComplex(ComplexNode node) {
        return new Complex((ImmutableLiteral)this.build(node.getNumber()));
    }

    private Operand protectCodeWithRescue(CodeBlock protectedCode, CodeBlock rescueBlock) {
        TemporaryVariable rv = this.createTemporaryVariable();
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = this.getNewLabel();
        Label rescueLabel = this.getNewLabel();
        this.addInstr(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionStartMarkerInstr(rescueLabel));
        Operand v1 = protectedCode.run();
        this.addInstr(new CopyInstr(rv, v1));
        this.addInstr(new JumpInstr(rEndLabel));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        Label caughtLabel = this.getNewLabel();
        TemporaryVariable exc = this.createTemporaryVariable();
        TemporaryVariable excType = this.createTemporaryVariable();
        this.addInstr(new LabelInstr(rescueLabel));
        this.addInstr(new ReceiveRubyExceptionInstr(exc));
        this.addInstr(new InheritanceSearchConstInstr(excType, this.manager.getObjectClass(), this.manager.runtime.newSymbol(CommonByteLists.EXCEPTION)));
        this.outputExceptionCheck(excType, exc, caughtLabel);
        this.addInstr(new ThrowExceptionInstr(exc));
        this.addInstr(new LabelInstr(caughtLabel));
        Operand v2 = rescueBlock.run();
        if (v2 != null) {
            this.addInstr(new CopyInstr(rv, this.manager.getNil()));
        }
        this.addInstr(new LabelInstr(rEndLabel));
        return rv;
    }

    public Operand buildGetDefinition(Node node) {
        if (node == null) {
            return new FrozenString("expression");
        }
        switch (node.getNodeType()) {
            case CLASSVARASGNNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case INSTASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNANDNODE: 
            case OPASGNNODE: 
            case OPASGNORNODE: 
            case OPELEMENTASGNNODE: 
            case CLASSVARDECLNODE: {
                return new FrozenString(DefinedMessage.ASSIGNMENT.getText());
            }
            case ANDNODE: 
            case DREGEXPNODE: 
            case DSTRNODE: 
            case ORNODE: {
                return new FrozenString(DefinedMessage.EXPRESSION.getText());
            }
            case FALSENODE: {
                return new FrozenString(DefinedMessage.FALSE.getText());
            }
            case DVARNODE: 
            case LOCALVARNODE: {
                return new FrozenString(DefinedMessage.LOCAL_VARIABLE.getText());
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                return new FrozenString(DefinedMessage.METHOD.getText());
            }
            case NILNODE: {
                return new FrozenString(DefinedMessage.NIL.getText());
            }
            case SELFNODE: {
                return new FrozenString(DefinedMessage.SELF.getText());
            }
            case TRUENODE: {
                return new FrozenString(DefinedMessage.TRUE.getText());
            }
            case ARRAYNODE: {
                ArrayNode array2 = (ArrayNode)node;
                Label undefLabel = this.getNewLabel();
                Label doneLabel = this.getNewLabel();
                TemporaryVariable tmpVar = this.createTemporaryVariable();
                for (Node elt : array2.children()) {
                    Operand result2 = this.buildGetDefinition(elt);
                    this.addInstr(IRBuilder.createBranch(result2, this.manager.getNil(), undefLabel));
                }
                this.addInstr(new CopyInstr(tmpVar, new FrozenString(DefinedMessage.EXPRESSION.getText())));
                this.addInstr(new JumpInstr(doneLabel));
                this.addInstr(new LabelInstr(undefLabel));
                this.addInstr(new CopyInstr(tmpVar, this.manager.getNil()));
                this.addInstr(new LabelInstr(doneLabel));
                return tmpVar;
            }
            case BACKREFNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_BACKREF, new Operand[]{new FrozenString(DefinedMessage.GLOBAL_VARIABLE.getText())}));
            }
            case GLOBALVARNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_GLOBAL, new Operand[]{new FrozenString(((GlobalVarNode)node).getName()), new FrozenString(DefinedMessage.GLOBAL_VARIABLE.getText())}));
            }
            case NTHREFNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_NTH_REF, new Operand[]{this.manager.newFixnum(((NthRefNode)node).getMatchNumber()), new FrozenString(DefinedMessage.GLOBAL_VARIABLE.getText())}));
            }
            case INSTVARNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_INSTANCE_VAR, new Operand[]{this.buildSelf(), new FrozenString(((InstVarNode)node).getName()), new FrozenString(DefinedMessage.INSTANCE_VARIABLE.getText())}));
            }
            case CLASSVARNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_CLASS_VAR, new Operand[]{this.classVarDefinitionContainer(), new FrozenString(((ClassVarNode)node).getName()), new FrozenString(DefinedMessage.CLASS_VARIABLE.getText())}));
            }
            case SUPERNODE: {
                Label undefLabel = this.getNewLabel();
                Variable tmpVar = this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_SUPER, new Operand[]{this.buildSelf(), new FrozenString(DefinedMessage.SUPER.getText())}));
                this.addInstr(IRBuilder.createBranch(tmpVar, this.manager.getNil(), undefLabel));
                Operand superDefnVal = this.buildGetArgumentDefinition(((SuperNode)node).getArgsNode(), DefinedMessage.SUPER.getText());
                return this.buildDefnCheckIfThenPaths(undefLabel, superDefnVal);
            }
            case VCALLNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{this.buildSelf(), new FrozenString(((VCallNode)node).getName()), this.manager.getFalse(), new FrozenString(DefinedMessage.METHOD.getText())}));
            }
            case YIELDNODE: {
                return this.buildDefinitionCheck(new BlockGivenInstr(this.createTemporaryVariable(), (Operand)this.getYieldClosureVariable()), DefinedMessage.YIELD.getText());
            }
            case ZSUPERNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_SUPER, new Operand[]{this.buildSelf(), new FrozenString(DefinedMessage.SUPER.getText())}));
            }
            case CONSTNODE: {
                Label defLabel = this.getNewLabel();
                Label doneLabel = this.getNewLabel();
                TemporaryVariable tmpVar = this.createTemporaryVariable();
                RubySymbol constName = ((ConstNode)node).getName();
                this.addInstr(new LexicalSearchConstInstr(tmpVar, CurrentScope.INSTANCE, constName));
                this.addInstr(BNEInstr.create(defLabel, tmpVar, UndefinedValue.UNDEFINED));
                this.addInstr(new InheritanceSearchConstInstr(tmpVar, this.findContainerModule(), constName));
                this.addInstr(BNEInstr.create(defLabel, tmpVar, UndefinedValue.UNDEFINED));
                this.addInstr(new CopyInstr(tmpVar, this.manager.getNil()));
                this.addInstr(new JumpInstr(doneLabel));
                this.addInstr(new LabelInstr(defLabel));
                this.addInstr(new CopyInstr(tmpVar, new FrozenString(DefinedMessage.CONSTANT.getText())));
                this.addInstr(new LabelInstr(doneLabel));
                return tmpVar;
            }
            case COLON2NODE: 
            case COLON3NODE: {
                final Colon3Node colon = (Colon3Node)node;
                final RubySymbol name2 = colon.getName();
                final TemporaryVariable errInfo = this.createTemporaryVariable();
                this.addInstr(new GetErrorInfoInstr(errInfo));
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run() {
                        if (!(colon instanceof Colon2Node)) {
                            return IRBuilder.this.addResultInstr(new RuntimeHelperCall(IRBuilder.this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_CONSTANT_OR_METHOD, new Operand[]{IRBuilder.this.manager.getObjectClass(), new FrozenString(name2), new FrozenString(DefinedMessage.CONSTANT.getText()), new FrozenString(DefinedMessage.METHOD.getText())}));
                        }
                        Label bad = IRBuilder.this.getNewLabel();
                        Label done = IRBuilder.this.getNewLabel();
                        TemporaryVariable result2 = IRBuilder.this.createTemporaryVariable();
                        Operand test2 = IRBuilder.this.buildGetDefinition(((Colon2Node)colon).getLeftNode());
                        IRBuilder.this.addInstr(IRBuilder.createBranch(test2, IRBuilder.this.manager.getNil(), bad));
                        Operand lhs = IRBuilder.this.build(((Colon2Node)colon).getLeftNode());
                        IRBuilder.this.addInstr(new RuntimeHelperCall(result2, RuntimeHelperCall.Methods.IS_DEFINED_CONSTANT_OR_METHOD, new Operand[]{lhs, new FrozenString(name2), new FrozenString(DefinedMessage.CONSTANT.getText()), new FrozenString(DefinedMessage.METHOD.getText())}));
                        IRBuilder.this.addInstr(new JumpInstr(done));
                        IRBuilder.this.addInstr(new LabelInstr(bad));
                        IRBuilder.this.addInstr(new CopyInstr(result2, IRBuilder.this.manager.getNil()));
                        IRBuilder.this.addInstr(new LabelInstr(done));
                        return result2;
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run() {
                        IRBuilder.this.addInstr(new RestoreErrorInfoInstr(errInfo));
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(protectedCode, rescueBlock);
            }
            case FCALLNODE: {
                Label undefLabel = this.getNewLabel();
                Variable tmpVar = this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{this.buildSelf(), new Symbol(((FCallNode)node).getName()), this.manager.getFalse(), new FrozenString(DefinedMessage.METHOD.getText())}));
                this.addInstr(IRBuilder.createBranch(tmpVar, this.manager.getNil(), undefLabel));
                Operand argsCheckDefn = this.buildGetArgumentDefinition(((FCallNode)node).getArgsNode(), "method");
                return this.buildDefnCheckIfThenPaths(undefLabel, argsCheckDefn);
            }
            case CALLNODE: {
                final CallNode callNode = (CallNode)node;
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run() {
                        Label undefLabel = IRBuilder.this.getNewLabel();
                        Operand receiverDefn = IRBuilder.this.buildGetDefinition(callNode.getReceiverNode());
                        IRBuilder.this.addInstr(IRBuilder.createBranch(receiverDefn, IRBuilder.this.manager.getNil(), undefLabel));
                        TemporaryVariable tmpVar = IRBuilder.this.createTemporaryVariable();
                        IRBuilder.this.addInstr(new RuntimeHelperCall(tmpVar, RuntimeHelperCall.Methods.IS_DEFINED_CALL, new Operand[]{IRBuilder.this.build(callNode.getReceiverNode()), new Symbol(callNode.getName()), new FrozenString(DefinedMessage.METHOD.getText())}));
                        return IRBuilder.this.buildDefnCheckIfThenPaths(undefLabel, tmpVar);
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run() {
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(protectedCode, rescueBlock);
            }
            case ATTRASSIGNNODE: {
                final AttrAssignNode attrAssign = (AttrAssignNode)node;
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run() {
                        Label undefLabel = IRBuilder.this.getNewLabel();
                        Operand receiverDefn = IRBuilder.this.buildGetDefinition(attrAssign.getReceiverNode());
                        IRBuilder.this.addInstr(IRBuilder.createBranch(receiverDefn, IRBuilder.this.manager.getNil(), undefLabel));
                        TemporaryVariable tmpVar = IRBuilder.this.createTemporaryVariable();
                        Operand receiver2 = IRBuilder.this.build(attrAssign.getReceiverNode());
                        IRBuilder.this.addInstr(new RuntimeHelperCall(tmpVar, RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{receiver2, new Symbol(attrAssign.getName()), IRBuilder.this.manager.getTrue(), new FrozenString(DefinedMessage.METHOD.getText())}));
                        IRBuilder.this.addInstr(IRBuilder.createBranch(tmpVar, IRBuilder.this.manager.getNil(), undefLabel));
                        Operand argsCheckDefn = IRBuilder.this.buildGetArgumentDefinition(attrAssign.getArgsNode(), "assignment");
                        return IRBuilder.this.buildDefnCheckIfThenPaths(undefLabel, argsCheckDefn);
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run() {
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(protectedCode, rescueBlock);
            }
        }
        return new FrozenString("expression");
    }

    protected Variable buildDefnCheckIfThenPaths(Label undefLabel, Operand defVal) {
        Label defLabel = this.getNewLabel();
        Variable tmpVar = this.getValueInTemporaryVariable(defVal);
        this.addInstr(new JumpInstr(defLabel));
        this.addInstr(new LabelInstr(undefLabel));
        this.addInstr(new CopyInstr(tmpVar, this.manager.getNil()));
        this.addInstr(new LabelInstr(defLabel));
        return tmpVar;
    }

    protected Variable buildDefinitionCheck(ResultInstr definedInstr, String definedReturnValue) {
        Label undefLabel = this.getNewLabel();
        this.addInstr((Instr)((Object)definedInstr));
        this.addInstr(IRBuilder.createBranch(definedInstr.getResult(), this.manager.getFalse(), undefLabel));
        return this.buildDefnCheckIfThenPaths(undefLabel, new FrozenString(definedReturnValue));
    }

    public Operand buildGetArgumentDefinition(Node node, String type2) {
        if (node == null) {
            return new MutableString(type2);
        }
        ImmutableLiteral rv = new FrozenString(type2);
        boolean failPathReqd = false;
        Label failLabel = this.getNewLabel();
        if (node instanceof ArrayNode) {
            for (int i2 = 0; i2 < ((ArrayNode)node).size(); ++i2) {
                Node iterNode = ((ArrayNode)node).get(i2);
                Operand def = this.buildGetDefinition(iterNode);
                if (def == this.manager.getNil()) {
                    rv = this.manager.getNil();
                    break;
                }
                if (def.hasKnownValue()) continue;
                failPathReqd = true;
                this.addInstr(IRBuilder.createBranch(def, this.manager.getNil(), failLabel));
            }
        } else {
            Operand def = this.buildGetDefinition(node);
            if (def == this.manager.getNil()) {
                rv = this.manager.getNil();
            } else if (!def.hasKnownValue()) {
                failPathReqd = true;
                this.addInstr(IRBuilder.createBranch(def, this.manager.getNil(), failLabel));
            }
        }
        return failPathReqd ? this.buildDefnCheckIfThenPaths(failLabel, rv) : rv;
    }

    public Operand buildDAsgn(DAsgnNode dasgnNode) {
        Operand value2;
        int depth = dasgnNode.getDepth();
        LocalVariable arg2 = this.getLocalVariable(dasgnNode.getName(), depth);
        if (arg2 == (value2 = this.build(dasgnNode.getValueNode()))) {
            return value2;
        }
        this.addInstr(new CopyInstr(arg2, value2));
        return value2;
    }

    protected InterpreterContext defineMethodInner(DefNode defNode, IRScope parent, int coverageMode) {
        ArgumentDescriptor[] argDesc;
        this.coverageMode = coverageMode;
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(this.manager.newLineNumber(this.scope.getLine() + 1));
            this.addInstr(new TraceInstr(RubyEvent.CALL, this.getCurrentModuleVariable(), this.getName(), this.getFileName(), this.scope.getLine() + 1));
        }
        this.prepareImplicitState();
        int nearestScopeDepth = parent.getNearestModuleReferencingScopeDepth();
        this.addInstr(new CopyInstr(this.getCurrentModuleVariable(), ScopeModule.ModuleFor(nearestScopeDepth == -1 ? 1 : nearestScopeDepth)));
        this.receiveMethodArgs(defNode.getArgsNode());
        Operand rv = this.build(defNode.getBodyNode());
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(new LineNumberInstr(defNode.getEndLine() + 1));
            this.addInstr(new TraceInstr(RubyEvent.RETURN, this.getCurrentModuleVariable(), this.getName(), this.getFileName(), defNode.getEndLine() + 1));
        }
        if (rv != null) {
            this.addInstr(new ReturnInstr(rv));
        }
        this.computeScopeFlagsFrom(this.instructions);
        if (this.scope.canReceiveNonlocalReturns()) {
            this.handleNonlocalReturnInMethod();
        }
        if (this.argumentDescriptions == null) {
            argDesc = ArgumentDescriptor.EMPTY_ARRAY;
        } else {
            argDesc = new ArgumentDescriptor[this.argumentDescriptions.size() / 2];
            for (int i2 = 0; i2 < this.argumentDescriptions.size(); i2 += 2) {
                ArgumentType type2 = (ArgumentType)((Object)this.argumentDescriptions.get(i2));
                RubySymbol symbol = (RubySymbol)this.argumentDescriptions.get(i2 + 1);
                argDesc[i2 / 2] = new ArgumentDescriptor(type2, symbol);
            }
        }
        ((IRMethod)this.scope).setArgumentDescriptors(argDesc);
        this.computeScopeFlagsFrom(this.instructions);
        return this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
    }

    private IRMethod defineNewMethod(MethodDefNode defNode, boolean isInstanceMethod) {
        IRMethod method2 = new IRMethod(this.manager, this.scope, defNode, defNode.getName().getBytes(), isInstanceMethod, defNode.getLine(), defNode.getScope(), this.coverageMode);
        if (defNode.containsBreakNext()) {
            method2.lazilyAcquireInterpreterContext();
        }
        return method2;
    }

    public Operand buildDefn(MethodDefNode node) {
        IRMethod method2 = this.defineNewMethod(node, true);
        this.addInstr(new DefineInstanceMethodInstr(method2));
        return new Symbol(node.getName());
    }

    public Operand buildDefs(DefsNode node) {
        Operand container = this.build(node.getReceiverNode());
        IRMethod method2 = this.defineNewMethod(node, false);
        this.addInstr(new DefineClassMethodInstr(container, method2));
        return new Symbol(node.getName());
    }

    protected LocalVariable getArgVariable(RubySymbol name2, int depth) {
        return this.scope instanceof IRFor ? this.getLocalVariable(name2, depth) : this.getNewLocalVariable(name2, 0);
    }

    private void addArgReceiveInstr(Variable v, Variable keywords, int argIndex, Signature signature) {
        boolean post;
        boolean bl = post = signature != null;
        if (post) {
            this.addInstr(new ReceivePostReqdArgInstr(v, keywords, argIndex, signature.pre(), signature.opt(), signature.hasRest(), signature.post()));
        } else {
            this.addInstr(new ReceivePreReqdArgInstr(v, keywords, argIndex));
        }
    }

    private Variable argumentResult(RubySymbol name2) {
        boolean isUnderscore;
        boolean bl = isUnderscore = name2.getBytes().realSize() == 1 && name2.getBytes().charAt(0) == '_';
        if (isUnderscore && this.underscoreVariableSeen) {
            return this.createTemporaryVariable();
        }
        if (isUnderscore) {
            this.underscoreVariableSeen = true;
        }
        return this.getNewLocalVariable(name2, 0);
    }

    public void receiveRequiredArg(Node node, Variable keywords, int argIndex, Signature signature) {
        switch (node.getNodeType()) {
            case ARGUMENTNODE: {
                RubySymbol argName = ((ArgumentNode)node).getName();
                if (this.scope instanceof IRMethod) {
                    this.addArgumentDescription(ArgumentType.req, argName);
                }
                this.addArgReceiveInstr(this.argumentResult(argName), keywords, argIndex, signature);
                break;
            }
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode childNode = (MultipleAsgnNode)node;
                TemporaryVariable v = this.createTemporaryVariable();
                this.addArgReceiveInstr(v, keywords, argIndex, signature);
                if (this.scope instanceof IRMethod) {
                    this.addArgumentDescription(ArgumentType.anonreq, null);
                }
                TemporaryVariable tmp = this.createTemporaryVariable();
                this.addInstr(new ToAryInstr(tmp, (Operand)v));
                this.buildMultipleAsgn19Assignment(childNode, tmp, null);
                break;
            }
            default: {
                throw this.notCompilable("Can't build assignment node", node);
            }
        }
    }

    protected void receiveNonBlockArgs(ArgsNode argsNode, Variable keywords) {
        int opt;
        Signature signature = this.scope.getStaticScope().getSignature();
        if (this.scope instanceof IRMethod) {
            this.addInstr(new CheckArityInstr(signature.required(), signature.opt(), signature.hasRest(), signature.keyRest(), keywords));
        } else if (this.scope instanceof IRClosure && argsNode.hasKwargs()) {
            this.addInstr(new CheckArityInstr(signature.required(), signature.opt(), signature.hasRest(), signature.keyRest(), keywords));
        }
        int argIndex = 0;
        Node[] args2 = argsNode.getArgs();
        int preCount = signature.pre();
        int i2 = 0;
        while (i2 < preCount) {
            this.receiveRequiredArg(args2[i2], keywords, argIndex, null);
            ++i2;
            ++argIndex;
        }
        int n = opt = signature.opt() > 0 ? signature.opt() : 0;
        if (opt > 0) {
            int optIndex = argsNode.getOptArgIndex();
            int j = 0;
            while (j < opt) {
                Label variableAssigned = this.getNewLabel();
                OptArgNode optArg = (OptArgNode)args2[optIndex + j];
                RubySymbol argName = optArg.getName();
                Variable argVar = this.argumentResult(argName);
                if (this.scope instanceof IRMethod) {
                    this.addArgumentDescription(ArgumentType.opt, argName);
                }
                this.addInstr(new ReceiveOptArgInstr(argVar, keywords, j, signature.required(), signature.pre()));
                this.addInstr(BNEInstr.create(variableAssigned, argVar, UndefinedValue.UNDEFINED));
                this.addInstr(new CopyInstr(argVar, this.manager.getNil()));
                this.build(optArg.getValue());
                this.addInstr(new LabelInstr(variableAssigned));
                ++j;
                ++argIndex;
            }
        }
        if (signature.hasRest()) {
            RestArgNode restArgNode = argsNode.getRestArgNode();
            if (this.scope instanceof IRMethod) {
                this.addArgumentDescription(restArgNode.isAnonymous() ? ArgumentType.anonrest : ArgumentType.rest, restArgNode.getName());
            }
            RubySymbol argName = restArgNode.isAnonymous() ? this.scope.getManager().getRuntime().newSymbol(CommonByteLists.STAR) : restArgNode.getName();
            this.addInstr(new ReceiveRestArgInstr(this.argumentResult(argName), keywords, argIndex, signature.required() + opt));
        }
        int postCount = argsNode.getPostCount();
        int postIndex = argsNode.getPostIndex();
        for (int i3 = 0; i3 < postCount; ++i3) {
            this.receiveRequiredArg(args2[postIndex + i3], keywords, i3, signature);
        }
    }

    protected void receiveBlockArg(ArgsNode argsNode) {
        BlockArgNode blockArg = argsNode.getBlock();
        if (blockArg != null) {
            RubySymbol argName = blockArg.getName();
            Variable blockVar = this.argumentResult(argName);
            if (this.scope instanceof IRMethod) {
                this.addArgumentDescription(ArgumentType.block, argName);
            }
            TemporaryVariable tmp = this.createTemporaryVariable();
            this.addInstr(new LoadImplicitClosureInstr(tmp));
            this.addInstr(new ReifyClosureInstr(blockVar, (Variable)tmp));
        }
    }

    private void prepareImplicitState() {
        this.addInstr(this.manager.getReceiveSelfInstr());
        if (this.scope instanceof IRMethod || this.scope instanceof IRMetaClassBody) {
            this.addInstr(new LoadImplicitClosureInstr(this.getYieldClosureVariable()));
        } else {
            this.addInstr(new LoadFrameClosureInstr(this.getYieldClosureVariable()));
        }
    }

    private void prepareClosureImplicitState() {
        this.addInstr(this.manager.getReceiveSelfInstr());
    }

    public void receiveArgs(ArgsNode argsNode) {
        KeywordRestArgNode keyRest;
        Signature signature = this.scope.getStaticScope().getSignature();
        Variable keywords = this.addResultInstr(new ReceiveKeywordsInstr(this.temp(), signature.hasRest(), argsNode.hasKwargs()));
        this.receiveNonBlockArgs(argsNode, keywords);
        Node[] args2 = argsNode.getArgs();
        int required = argsNode.getRequiredArgsCount();
        if (argsNode.hasKwargs()) {
            int keywordIndex = argsNode.getKeywordsIndex();
            int keywordsCount = argsNode.getKeywordCount();
            for (int i2 = 0; i2 < keywordsCount; ++i2) {
                KeywordArgNode kwarg = (KeywordArgNode)args2[keywordIndex + i2];
                AssignableNode kasgn = kwarg.getAssignable();
                RubySymbol key2 = ((INameNode)((Object)kasgn)).getName();
                LocalVariable av = this.getNewLocalVariable(key2, 0);
                Label l = this.getNewLabel();
                if (this.scope instanceof IRMethod) {
                    this.addKeyArgDesc(kasgn, key2);
                }
                this.addInstr(new ReceiveKeywordArgInstr(av, keywords, key2, required));
                this.addInstr(BNEInstr.create(l, av, UndefinedValue.UNDEFINED));
                if (!this.isRequiredKeywordArgumentValue(kasgn)) {
                    this.addInstr(new CopyInstr(av, this.buildNil()));
                    this.build(kasgn);
                } else {
                    this.addInstr(new RaiseRequiredKeywordArgumentError(key2));
                }
                this.addInstr(new LabelInstr(l));
            }
        }
        if ((keyRest = argsNode.getKeyRest()) != null) {
            RubySymbol key3 = keyRest.getName();
            ArgumentType type2 = ArgumentType.keyrest;
            if (key3 == null || key3.getBytes().realSize() == 0) {
                type2 = ArgumentType.anonkeyrest;
            }
            LocalVariable av = this.getNewLocalVariable(key3, 0);
            if (this.scope instanceof IRMethod) {
                this.addArgumentDescription(type2, key3);
            }
            if (key3 != null && "nil".equals(key3.idString())) {
                this.if_not(keywords, UndefinedValue.UNDEFINED, () -> this.addRaiseError("ArgumentError", "no keywords accepted"));
            } else {
                this.addInstr(new ReceiveKeywordRestArgInstr(av, keywords));
            }
        }
        this.receiveBlockArg(argsNode);
    }

    private void addKeyArgDesc(AssignableNode kasgn, RubySymbol key2) {
        if (this.isRequiredKeywordArgumentValue(kasgn)) {
            this.addArgumentDescription(ArgumentType.keyreq, key2);
        } else {
            this.addArgumentDescription(ArgumentType.key, key2);
        }
    }

    private boolean isRequiredKeywordArgumentValue(AssignableNode kasgn) {
        return kasgn.getValueNode().getNodeType() == NodeType.REQUIRED_KEYWORD_ARGUMENT_VALUE;
    }

    public void buildArgsMasgn(Node node, Operand argsArray, boolean isMasgnRoot, int preArgsCount, int postArgsCount, int index2, boolean isSplat) {
        switch (node.getNodeType()) {
            case DASGNNODE: {
                DAsgnNode dynamicAsgn = (DAsgnNode)node;
                LocalVariable v = this.getArgVariable(dynamicAsgn.getName(), dynamicAsgn.getDepth());
                if (isSplat) {
                    this.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, index2, preArgsCount, postArgsCount));
                    break;
                }
                this.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, index2, preArgsCount, postArgsCount));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                LocalVariable v = this.getArgVariable(localVariable.getName(), localVariable.getDepth());
                if (isSplat) {
                    this.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, index2, preArgsCount, postArgsCount));
                    break;
                }
                this.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, index2, preArgsCount, postArgsCount));
                break;
            }
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode childNode = (MultipleAsgnNode)node;
                if (!isMasgnRoot) {
                    TemporaryVariable v = this.createTemporaryVariable();
                    if (isSplat) {
                        this.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, index2, preArgsCount, postArgsCount));
                    } else {
                        this.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, index2, preArgsCount, postArgsCount));
                    }
                    TemporaryVariable tmp = this.createTemporaryVariable();
                    this.addInstr(new ToAryInstr(tmp, (Operand)v));
                    argsArray = tmp;
                }
                this.buildMultipleAsgn19Assignment(childNode, argsArray, null);
                break;
            }
            default: {
                throw this.notCompilable("Shouldn't get here", node);
            }
        }
    }

    public void buildMultipleAsgn19Assignment(MultipleAsgnNode multipleAsgnNode, Operand argsArray, Operand values2) {
        ListNode masgnPost;
        ListNode masgnPre = multipleAsgnNode.getPre();
        ArrayList<Tuple<Node, TemporaryVariable>> assigns = new ArrayList<Tuple<Node, TemporaryVariable>>();
        int i2 = 0;
        if (masgnPre != null) {
            for (Node an : masgnPre.children()) {
                if (values2 == null) {
                    this.buildArgsMasgn(an, argsArray, false, -1, -1, i2, false);
                } else {
                    TemporaryVariable temporaryVariable = this.createTemporaryVariable();
                    this.addInstr(new ReqdArgMultipleAsgnInstr(temporaryVariable, values2, i2));
                    assigns.add(new Tuple<Node, TemporaryVariable>(an, temporaryVariable));
                }
                ++i2;
            }
        }
        Node restNode = multipleAsgnNode.getRest();
        int postArgsCount = multipleAsgnNode.getPostCount();
        if (restNode != null && !(restNode instanceof StarNode)) {
            if (values2 == null) {
                this.buildArgsMasgn(restNode, argsArray, false, i2, postArgsCount, 0, true);
            } else {
                TemporaryVariable rhsVal = this.createTemporaryVariable();
                this.addInstr(new RestArgMultipleAsgnInstr(rhsVal, values2, 0, i2, postArgsCount));
                assigns.add(new Tuple<Node, TemporaryVariable>(restNode, rhsVal));
            }
        }
        if ((masgnPost = multipleAsgnNode.getPost()) != null) {
            int j = 0;
            for (Node an : masgnPost.children()) {
                if (values2 == null) {
                    this.buildArgsMasgn(an, argsArray, false, i2, postArgsCount, j, false);
                } else {
                    TemporaryVariable rhsVal = this.createTemporaryVariable();
                    this.addInstr(new ReqdArgMultipleAsgnInstr(rhsVal, values2, j, i2, postArgsCount));
                    assigns.add(new Tuple<Node, TemporaryVariable>(an, rhsVal));
                }
                ++j;
            }
        }
        for (Tuple tuple : assigns) {
            this.buildAssignment((Node)tuple.a, (Variable)tuple.b);
        }
    }

    private void handleBreakAndReturnsInLambdas() {
        Label rEndLabel = this.getNewLabel();
        Label rescueLabel = Label.getGlobalEnsureBlockLabel();
        this.addInstrAtBeginning(new ExceptionRegionStartMarkerInstr(rescueLabel));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.addInstr(new LabelInstr(rescueLabel));
        TemporaryVariable exc = this.createTemporaryVariable();
        this.addInstr(new ReceiveJRubyExceptionInstr(exc));
        TemporaryVariable ret = this.createTemporaryVariable();
        this.addInstr(new RuntimeHelperCall(ret, RuntimeHelperCall.Methods.HANDLE_BREAK_AND_RETURNS_IN_LAMBDA, new Operand[]{exc}));
        this.addInstr(new ReturnOrRethrowSavedExcInstr(ret));
        this.addInstr(new LabelInstr(rEndLabel));
    }

    public void receiveMethodArgs(ArgsNode argsNode) {
        this.receiveArgs(argsNode);
    }

    public void receiveBlockArgs(IterNode node) {
        Node args2 = node.getVarNode();
        if (args2 instanceof ArgsNode) {
            ((IRClosure)this.scope).setArgumentDescriptors(Helpers.argsNodeToArgumentDescriptors((ArgsNode)args2));
            this.receiveArgs((ArgsNode)args2);
        } else {
            this.buildBlockArgsAssignment(args2, null, 0, false);
        }
    }

    public Operand buildDot(DotNode dotNode) {
        Operand begin2 = this.build(dotNode.getBeginNode());
        Operand end2 = this.build(dotNode.getEndNode());
        if (begin2 instanceof ImmutableLiteral && end2 instanceof ImmutableLiteral) {
            return new Range((ImmutableLiteral)begin2, (ImmutableLiteral)end2, dotNode.isExclusive());
        }
        return this.addResultInstr(new BuildRangeInstr(this.createTemporaryVariable(), begin2, end2, dotNode.isExclusive()));
    }

    private int dynamicPiece(Operand[] pieces, int i2, Node pieceNode) {
        Operand piece;
        int estimatedSize;
        block4: {
            estimatedSize = 4;
            while (true) {
                if (pieceNode instanceof StrNode) {
                    piece = this.buildStrRaw((StrNode)pieceNode);
                    estimatedSize = ((StrNode)pieceNode).getValue().realSize();
                    break block4;
                }
                if (!(pieceNode instanceof EvStrNode)) break;
                if (this.scope.maybeUsingRefinements()) {
                    TemporaryVariable result2 = this.createTemporaryVariable();
                    this.addInstr(new AsStringInstr(this.scope, result2, this.build(((EvStrNode)pieceNode).getBody()), this.scope.maybeUsingRefinements()));
                    piece = result2;
                    break block4;
                }
                pieceNode = ((EvStrNode)pieceNode).getBody();
            }
            piece = this.build(pieceNode);
        }
        if (piece instanceof MutableString) {
            piece = ((MutableString)piece).frozenString;
        }
        pieces[i2] = piece == null ? this.manager.getNil() : piece;
        return estimatedSize;
    }

    public Operand buildDRegexp(Variable result2, DRegexpNode node) {
        Node[] nodePieces = node.children();
        Operand[] pieces = new Operand[nodePieces.length];
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            this.dynamicPiece(pieces, i2, nodePieces[i2]);
        }
        if (result2 == null) {
            result2 = this.createTemporaryVariable();
        }
        this.addInstr(new BuildDynRegExpInstr(result2, pieces, node.getOptions()));
        return result2;
    }

    public Operand buildDStr(Variable result2, DStrNode node) {
        Node[] nodePieces = node.children();
        Operand[] pieces = new Operand[nodePieces.length];
        int estimatedSize = 0;
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            estimatedSize += this.dynamicPiece(pieces, i2, nodePieces[i2]);
        }
        if (result2 == null) {
            result2 = this.createTemporaryVariable();
        }
        boolean debuggingFrozenStringLiteral = this.manager.getInstanceConfig().isDebuggingFrozenStringLiteral();
        this.addInstr(new BuildCompoundStringInstr(result2, pieces, node.getEncoding(), estimatedSize, node.isFrozen(), debuggingFrozenStringLiteral, this.getFileName(), node.getLine()));
        return result2;
    }

    public Operand buildDSymbol(Variable result2, DSymbolNode node) {
        Node[] nodePieces = node.children();
        Operand[] pieces = new Operand[nodePieces.length];
        int estimatedSize = 0;
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            estimatedSize += this.dynamicPiece(pieces, i2, nodePieces[i2]);
        }
        if (result2 == null) {
            result2 = this.createTemporaryVariable();
        }
        boolean debuggingFrozenStringLiteral = this.manager.getInstanceConfig().isDebuggingFrozenStringLiteral();
        this.addInstr(new BuildCompoundStringInstr(result2, pieces, node.getEncoding(), estimatedSize, false, debuggingFrozenStringLiteral, this.getFileName(), node.getLine()));
        return this.copy(new DynamicSymbol(result2));
    }

    public Operand buildDVar(DVarNode node) {
        return this.getLocalVariable(node.getName(), node.getDepth());
    }

    public Operand buildDXStr(Variable result2, DXStrNode node) {
        Node[] nodePieces = node.children();
        Operand[] pieces = new Operand[nodePieces.length];
        int estimatedSize = 0;
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            estimatedSize += this.dynamicPiece(pieces, i2, nodePieces[i2]);
        }
        TemporaryVariable stringResult = this.createTemporaryVariable();
        if (result2 == null) {
            result2 = this.createTemporaryVariable();
        }
        boolean debuggingFrozenStringLiteral = this.manager.getInstanceConfig().isDebuggingFrozenStringLiteral();
        this.addInstr(new BuildCompoundStringInstr(stringResult, pieces, node.getEncoding(), estimatedSize, false, debuggingFrozenStringLiteral, this.getFileName(), node.getLine()));
        return this.fcall(result2, (Operand)Self.SELF, "`", stringResult);
    }

    public Operand buildEnsureNode(EnsureNode ensureNode) {
        return this.buildEnsureInternal(ensureNode.getBodyNode(), ensureNode.getEnsureNode());
    }

    public Operand buildEnsureInternal(Node ensureBodyNode, Node ensureNode) {
        boolean isEnsureExpr;
        TemporaryVariable savedGlobalException = this.createTemporaryVariable();
        this.addInstr(new GetGlobalVariableInstr((Variable)savedGlobalException, this.symbol("$!")));
        EnsureBlockInfo ebi = new EnsureBlockInfo(this.scope, ensureBodyNode instanceof RescueNode ? (RescueNode)ensureBodyNode : null, this.getCurrentLoop(), this.activeRescuers.peek());
        if (ensureBodyNode instanceof RescueNode) {
            ebi.savedGlobalException = savedGlobalException;
        }
        this.ensureBodyBuildStack.push(ebi);
        Operand ensureRetVal = ensureNode == null ? this.manager.getNil() : this.build(ensureNode);
        this.ensureBodyBuildStack.pop();
        this.activeEnsureBlockStack.push(ebi);
        this.addInstr(new LabelInstr(ebi.regionStart));
        this.addInstr(new ExceptionRegionStartMarkerInstr(ebi.dummyRescueBlockLabel));
        this.activeRescuers.push(ebi.dummyRescueBlockLabel);
        TemporaryVariable ensureExprValue = this.createTemporaryVariable();
        Operand rv = ensureBodyNode instanceof RescueNode ? this.buildRescueInternal((RescueNode)ensureBodyNode, ebi) : this.build(ensureBodyNode);
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.activeRescuers.pop();
        boolean bl = isEnsureExpr = ensureNode != null && rv != U_NIL && !(ensureBodyNode instanceof RescueNode);
        if (isEnsureExpr) {
            this.addInstr(new CopyInstr(ensureExprValue, rv));
            ebi.cloneIntoHostScope(this);
            this.addInstr(new JumpInstr(ebi.end));
        }
        this.activeEnsureBlockStack.pop();
        TemporaryVariable exc = this.createTemporaryVariable();
        this.addInstr(new LabelInstr(ebi.dummyRescueBlockLabel));
        this.addInstr(new ReceiveJRubyExceptionInstr(exc));
        if (ensureNode != null) {
            ebi.emitBody(this);
        }
        if (ensureRetVal == U_NIL) {
            rv = U_NIL;
        }
        this.addInstr(new ThrowExceptionInstr(exc));
        this.addInstr(new LabelInstr(ebi.end));
        return isEnsureExpr ? ensureExprValue : rv;
    }

    public Operand buildFalse() {
        return this.manager.getFalse();
    }

    private void if_else(Operand testVariable, Operand testValue, VoidCodeBlock ifBlock, VoidCodeBlock elseBlock) {
        Label elseLabel = this.getNewLabel();
        Label endLabel = this.getNewLabel();
        this.addInstr(BNEInstr.create(elseLabel, testVariable, testValue));
        ifBlock.run();
        this.addInstr(new JumpInstr(endLabel));
        this.addInstr(new LabelInstr(elseLabel));
        elseBlock.run();
        this.addInstr(new LabelInstr(endLabel));
    }

    private void if_not(Operand testVariable, Operand testValue, VoidCodeBlock ifBlock) {
        this.label("if_not_end", endLabel -> {
            this.addInstr(IRBuilder.createBranch(testVariable, testValue, endLabel));
            ifBlock.run();
        });
    }

    public Operand buildFCall(Variable aResult, FCallNode fcallNode) {
        RubySymbol name2 = this.methodName = fcallNode.getName();
        Node callArgsNode = fcallNode.getArgsNode();
        Variable result2 = aResult == null ? this.createTemporaryVariable() : aResult;
        int[] flags2 = new int[]{0};
        Operand[] args2 = this.setupCallArgs(callArgsNode, flags2);
        this.determineIfMaybeRefined(fcallNode.getName(), args2);
        Operand block = this.setupCallClosure(fcallNode.getIterNode());
        if ((flags2[0] & 4) != 0) {
            Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{args2[args2.length - 1]}));
            this.if_else(test2, this.manager.getTrue(), () -> this.receiveBreakException(block, CallInstr.create(this.scope, CallType.FUNCTIONAL, result2, name2, this.buildSelf(), IRBuilder.removeArg(args2), block, flags2[0])), () -> this.receiveBreakException(block, CallInstr.create(this.scope, CallType.FUNCTIONAL, result2, name2, this.buildSelf(), args2, block, flags2[0])));
        } else {
            IRClosure closure;
            if (CommonByteLists.DEFINE_METHOD_METHOD.equals(fcallNode.getName().getBytes()) && block instanceof WrappedIRClosure && !(closure = ((WrappedIRClosure)block).getClosure()).accessesParentsLocalVariables() && fcallNode.getIterNode() instanceof IterNode) {
                closure.setSource((IterNode)fcallNode.getIterNode());
            }
            this.determineIfWeNeedLineNumber(fcallNode);
            this.receiveBreakException(block, CallInstr.create(this.scope, CallType.FUNCTIONAL, result2, name2, this.buildSelf(), args2, block, flags2[0]));
        }
        return result2;
    }

    private Operand setupCallClosure(Node node) {
        if (node == null) {
            return NullBlock.INSTANCE;
        }
        switch (node.getNodeType()) {
            case ITERNODE: {
                return this.build(node);
            }
            case BLOCKPASSNODE: {
                Node bodyNode = ((BlockPassNode)node).getBodyNode();
                if (bodyNode instanceof SymbolNode && !this.scope.maybeUsingRefinements()) {
                    return new SymbolProc(((SymbolNode)bodyNode).getName());
                }
                if (bodyNode instanceof ArgumentNode && ((ArgumentNode)bodyNode).getName().idString().equals("&")) {
                    return this.getYieldClosureVariable();
                }
                return this.build(bodyNode);
            }
        }
        throw this.notCompilable("ERROR: Encountered a method with a non-block, non-blockpass iter node", node);
    }

    private void determineIfMaybeRefined(RubySymbol methodName, Operand[] args2) {
        IRScope outerScope = this.scope.getNearestTopLocalVariableScope();
        boolean refinement = false;
        if (!(outerScope instanceof IRMethod)) {
            ByteList methodBytes = methodName.getBytes();
            if (args2.length == 1) {
                refinement = IRBuilder.isRefinementCall(methodBytes);
            } else if (args2.length == 2 && CommonByteLists.SEND.equal(methodBytes) && args2[0] instanceof Symbol) {
                Symbol sendName = (Symbol)args2[0];
                methodBytes = sendName.getBytes();
                refinement = IRBuilder.isRefinementCall(methodBytes);
            }
        }
        if (refinement) {
            this.scope.setIsMaybeUsingRefinements();
        }
    }

    private static boolean isRefinementCall(ByteList methodBytes) {
        return CommonByteLists.USING_METHOD.equals(methodBytes) || CommonByteLists.REFINE_METHOD.equals(methodBytes);
    }

    public Operand buildFixnum(FixnumNode node) {
        return this.manager.newFixnum(node.getValue());
    }

    public Operand buildFlip(FlipNode flipNode) {
        this.addRaiseError("NotImplementedError", "flip-flop is no longer supported in JRuby");
        return this.manager.getNil();
    }

    public Operand buildFloat(FloatNode node) {
        return new Float(node.getValue());
    }

    public Operand buildFor(ForNode forNode) {
        TemporaryVariable result2 = this.createTemporaryVariable();
        Operand receiver2 = this.build(forNode.getIterNode());
        Operand forBlock = this.buildForIter(forNode);
        CallInstr callInstr = new CallInstr(this.scope, CallType.NORMAL, result2, this.manager.runtime.newSymbol(CommonByteLists.EACH), receiver2, Instr.EMPTY_OPERANDS, forBlock, 0, this.scope.maybeUsingRefinements());
        this.receiveBreakException(forBlock, callInstr);
        return result2;
    }

    public Operand buildForIter(ForNode forNode) {
        IRFor closure = new IRFor(this.manager, this.scope, forNode.getLine(), forNode.getScope(), Signature.from(forNode));
        this.newIRBuilder(this.manager, closure).buildIterInner(null, forNode);
        return new WrappedIRClosure(this.buildSelf(), closure);
    }

    public Operand buildGlobalAsgn(GlobalAsgnNode globalAsgnNode) {
        Operand value2 = this.build(globalAsgnNode.getValueNode());
        this.addInstr(new PutGlobalVarInstr(globalAsgnNode.getName(), value2));
        return value2;
    }

    public Operand buildGlobalVar(Variable result2, GlobalVarNode node) {
        if (result2 == null) {
            result2 = this.createTemporaryVariable();
        }
        return this.addResultInstr(new GetGlobalVariableInstr(result2, node.getName()));
    }

    public Operand buildHash(HashNode hashNode, boolean keywordArgsCall) {
        ArrayList<KeyValuePair<Operand, Operand>> args2 = new ArrayList<KeyValuePair<Operand, Operand>>();
        boolean hasAssignments = hashNode.containsVariableAssignment();
        Variable hash2 = null;
        Operand duplicateCheck = this.fals();
        for (KeyValuePair<Node, Node> pair : hashNode.getPairs()) {
            Node key2 = pair.getKey();
            if (key2 == null) {
                Node value2 = pair.getValue();
                Operand operand = duplicateCheck = value2 instanceof HashNode && ((HashNode)value2).isLiteral() ? this.tru() : this.fals();
                if (hash2 == null) {
                    hash2 = this.copy(new Hash(args2));
                    args2 = new ArrayList();
                } else if (!args2.isEmpty()) {
                    this.addInstr(new RuntimeHelperCall(hash2, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash2, new Hash(args2), duplicateCheck}));
                    args2 = new ArrayList();
                }
                Operand splat = this.buildWithOrder(value2, hasAssignments);
                this.addInstr(new RuntimeHelperCall(hash2, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash2, splat, duplicateCheck}));
                continue;
            }
            Operand keyOperand = this.buildWithOrder(key2, hasAssignments);
            args2.add(new KeyValuePair<Operand, Operand>(keyOperand, this.buildWithOrder(pair.getValue(), hasAssignments)));
        }
        if (hash2 == null) {
            hash2 = this.copy(new Hash(args2));
        } else if (!args2.isEmpty()) {
            this.addInstr(new RuntimeHelperCall(hash2, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash2, new Hash(args2), duplicateCheck}));
        }
        return hash2;
    }

    public Operand buildIf(Variable result2, IfNode ifNode) {
        Node actualCondition = ifNode.getCondition();
        Label falseLabel = this.getNewLabel();
        Label doneLabel = this.getNewLabel();
        this.addInstr(IRBuilder.createBranch(this.build(actualCondition), this.manager.getFalse(), falseLabel));
        boolean thenNull = false;
        boolean elseNull = false;
        boolean thenUnil = false;
        boolean elseUnil = false;
        if (ifNode.getThenBody() != null) {
            Operand thenResult = this.build(result2, ifNode.getThenBody());
            if (thenResult != U_NIL) {
                result2 = this.getValueInTemporaryVariable(thenResult);
                this.addInstr(new JumpInstr(doneLabel));
            } else {
                if (result2 == null) {
                    result2 = this.createTemporaryVariable();
                }
                thenUnil = true;
            }
        } else {
            thenNull = true;
            if (result2 == null) {
                result2 = this.createTemporaryVariable();
            }
            this.addInstr(new CopyInstr(result2, this.manager.getNil()));
            this.addInstr(new JumpInstr(doneLabel));
        }
        this.addInstr(new LabelInstr(falseLabel));
        if (ifNode.getElseBody() != null) {
            Operand elseResult = this.build(ifNode.getElseBody());
            if (elseResult != U_NIL) {
                this.addInstr(new CopyInstr(result2, elseResult));
            } else {
                elseUnil = true;
            }
        } else {
            elseNull = true;
            this.addInstr(new CopyInstr(result2, this.manager.getNil()));
        }
        if (thenNull && elseNull) {
            this.addInstr(new LabelInstr(doneLabel));
            return this.manager.getNil();
        }
        if (thenUnil && elseUnil) {
            return U_NIL;
        }
        this.addInstr(new LabelInstr(doneLabel));
        return result2;
    }

    public Operand buildInstAsgn(InstAsgnNode instAsgnNode) {
        Operand val = this.build(instAsgnNode.getValueNode());
        this.addInstr(new PutFieldInstr(this.buildSelf(), instAsgnNode.getName(), val));
        return val;
    }

    public Operand buildInstVar(InstVarNode node) {
        return this.addResultInstr(new GetFieldInstr(this.createTemporaryVariable(), (Operand)this.buildSelf(), node.getName()));
    }

    private InterpreterContext buildIterInner(RubySymbol methodName, IterNode iterNode) {
        Operand closureRetVal;
        this.methodName = methodName;
        boolean forNode = iterNode instanceof ForNode;
        this.prepareClosureImplicitState();
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(new TraceInstr(RubyEvent.B_CALL, this.getCurrentModuleVariable(), this.getName(), this.getFileName(), this.scope.getLine() + 1));
        }
        if (!forNode) {
            this.addCurrentModule();
        }
        this.receiveBlockArgs(iterNode);
        if (forNode) {
            this.addCurrentModule();
        }
        this.afterPrologueIndex = this.instructions.size() - 1;
        Operand operand = closureRetVal = iterNode.getBodyNode() == null ? this.manager.getNil() : this.build(iterNode.getBodyNode());
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(new TraceInstr(RubyEvent.B_RETURN, this.getCurrentModuleVariable(), this.getName(), this.getFileName(), iterNode.getEndLine() + 1));
        }
        if (closureRetVal != U_NIL) {
            this.addInstr(new ReturnInstr(closureRetVal));
        }
        this.preloadBlockImplicitClosure();
        if (!forNode) {
            this.handleBreakAndReturnsInLambdas();
        }
        this.computeScopeFlagsFrom(this.instructions);
        return this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
    }

    public Operand buildIter(IterNode iterNode) {
        IRClosure closure = new IRClosure(this.manager, this.scope, iterNode.getLine(), iterNode.getScope(), Signature.from(iterNode), this.coverageMode);
        this.newIRBuilder(this.manager, closure).buildIterInner(this.methodName, iterNode);
        this.methodName = null;
        return new WrappedIRClosure(this.buildSelf(), closure);
    }

    public Operand buildLiteral(LiteralNode literalNode) {
        return new MutableString(literalNode.getSymbolName());
    }

    public Operand buildLocalAsgn(LocalAsgnNode localAsgnNode) {
        Operand value2;
        LocalVariable variable = this.getLocalVariable(localAsgnNode.getName(), localAsgnNode.getDepth());
        if (variable == (value2 = this.build(variable, localAsgnNode.getValueNode()))) {
            return value2;
        }
        this.addInstr(new CopyInstr(variable, value2));
        return value2;
    }

    public Operand buildLocalVar(LocalVarNode node) {
        return this.getLocalVariable(node.getName(), node.getDepth());
    }

    public Operand buildMatch(Variable result2, MatchNode matchNode) {
        Operand regexp2 = this.build(matchNode.getRegexpNode());
        TemporaryVariable tempLastLine = this.createTemporaryVariable();
        this.addResultInstr(new GetGlobalVariableInstr((Variable)tempLastLine, this.symbol("$_")));
        if (result2 == null) {
            result2 = this.createTemporaryVariable();
        }
        return this.addResultInstr(new MatchInstr(this.scope, result2, regexp2, tempLastLine));
    }

    public Operand buildMatch2(Variable result2, Match2Node matchNode) {
        Operand receiver2 = this.build(matchNode.getReceiverNode());
        Operand value2 = this.build(matchNode.getValueNode());
        if (result2 == null) {
            result2 = this.createTemporaryVariable();
        }
        this.addInstr(new MatchInstr(this.scope, result2, receiver2, value2));
        if (matchNode instanceof Match2CaptureNode) {
            Match2CaptureNode m2c = (Match2CaptureNode)matchNode;
            for (int slot : m2c.getScopeOffsets()) {
                int depth = slot >> 16;
                int offset2 = slot & 0xFFFF;
                RubySymbol var = this.manager.runtime.newSymbol(this.getVarNameFromScopeTree(this.scope, depth, offset2));
                this.addInstr(new SetCapturedVarInstr(this.getLocalVariable(var, depth), (Operand)result2, var));
            }
        }
        return result2;
    }

    private String getVarNameFromScopeTree(IRScope scope, int depth, int offset2) {
        if (depth == 0) {
            return scope.getStaticScope().getVariables()[offset2];
        }
        return this.getVarNameFromScopeTree(scope.getLexicalParent(), depth - 1, offset2);
    }

    public Operand buildMatch3(Variable result2, Match3Node matchNode) {
        Operand receiver2 = this.build(matchNode.getReceiverNode());
        Operand value2 = this.build(matchNode.getValueNode());
        if (result2 == null) {
            result2 = this.createTemporaryVariable();
        }
        return this.addResultInstr(new MatchInstr(this.scope, result2, receiver2, value2));
    }

    private Operand getContainerFromCPath(Colon3Node cpath) {
        Node leftNode;
        Operand container = cpath instanceof Colon2Node ? ((leftNode = ((Colon2Node)cpath).getLeftNode()) != null ? this.build(leftNode) : this.findContainerModule()) : this.manager.getObjectClass();
        return container;
    }

    public Operand buildModule(ModuleNode moduleNode) {
        boolean executesOnce = this.executesOnce;
        Colon3Node cpath = moduleNode.getCPath();
        ByteList moduleName = cpath.getName().getBytes();
        Operand container = this.getContainerFromCPath(cpath);
        IRModuleBody body = new IRModuleBody(this.manager, this.scope, moduleName, moduleNode.getLine(), moduleNode.getScope(), executesOnce);
        Variable bodyResult = this.addResultInstr(new DefineModuleInstr(this.createTemporaryVariable(), container, body));
        this.newIRBuilder(this.manager, body).buildModuleOrClassBody(moduleNode.getBodyNode(), moduleNode.getLine(), moduleNode.getEndLine());
        return bodyResult;
    }

    public Operand buildNext(NextNode nextNode) {
        IRLoop currLoop = this.getCurrentLoop();
        Operand rv = this.build(nextNode.getValueNode());
        if (!this.activeEnsureBlockStack.isEmpty()) {
            this.emitEnsureBlocks(currLoop);
        }
        if (currLoop != null) {
            this.addInstr(new JumpInstr(currLoop.iterEndLabel));
        } else {
            this.addInstr(new ThreadPollInstr(true));
            if (this.scope instanceof IRClosure) {
                if (this.scope instanceof IREvalScript) {
                    this.throwSyntaxError(nextNode, "Can't escape from eval with next");
                } else {
                    this.addInstr(new ReturnInstr(rv));
                }
            } else {
                this.throwSyntaxError(nextNode, "Invalid next");
            }
        }
        return U_NIL;
    }

    public Operand buildNthRef(NthRefNode nthRefNode) {
        return this.copy(new NthRef(this.scope, nthRefNode.getMatchNumber()));
    }

    public Operand buildNil() {
        return this.manager.getNil();
    }

    public Operand buildOpAsgn(OpAsgnNode opAsgnNode) {
        TemporaryVariable writerValue = this.createTemporaryVariable();
        Node receiver2 = opAsgnNode.getReceiverNode();
        CallType callType = receiver2 instanceof SelfNode ? CallType.FUNCTIONAL : CallType.NORMAL;
        Operand v1 = this.build(opAsgnNode.getReceiverNode());
        Label lazyLabel = null;
        Label endLabel = null;
        TemporaryVariable result2 = this.createTemporaryVariable();
        if (opAsgnNode.isLazy()) {
            lazyLabel = this.getNewLabel();
            endLabel = this.getNewLabel();
            this.addInstr(new BNilInstr(lazyLabel, v1));
        }
        Variable readerValue = this._call(this.temp(), callType, v1, opAsgnNode.getVariableSymbolName(), new Operand[0]);
        boolean isOrOr = opAsgnNode.isOr();
        if (isOrOr || opAsgnNode.isAnd()) {
            Label l = this.getNewLabel();
            this.addInstr(IRBuilder.createBranch(readerValue, isOrOr ? this.manager.getTrue() : this.manager.getFalse(), l));
            Operand v2 = this.build(opAsgnNode.getValueNode());
            this._call(writerValue, callType, v1, opAsgnNode.getVariableSymbolNameAsgn(), v2);
            this.addInstr(new CopyInstr(readerValue, v2));
            this.addInstr(new LabelInstr(l));
            if (!opAsgnNode.isLazy()) {
                return readerValue;
            }
            this.addInstr(new CopyInstr(result2, (Operand)readerValue));
        } else {
            Operand v2 = this.build(opAsgnNode.getValueNode());
            Variable setValue2 = this.call(this.temp(), (Operand)readerValue, opAsgnNode.getOperatorSymbolName(), v2);
            this._call(writerValue, callType, v1, opAsgnNode.getVariableSymbolNameAsgn(), setValue2);
            if (!opAsgnNode.isLazy()) {
                return setValue2;
            }
            this.addInstr(new CopyInstr(result2, (Operand)setValue2));
        }
        this.addInstr(new JumpInstr(endLabel));
        this.addInstr(new LabelInstr(lazyLabel));
        this.addInstr(new CopyInstr(result2, this.manager.getNil()));
        this.addInstr(new LabelInstr(endLabel));
        return result2;
    }

    private Operand buildColon2ForConstAsgnDeclNode(Node lhs, Variable valueResult, boolean constMissing) {
        RubySymbol name2;
        TemporaryVariable leftModule = this.createTemporaryVariable();
        if (lhs instanceof Colon2Node) {
            Colon2Node colon2Node = (Colon2Node)lhs;
            name2 = colon2Node.getName();
            Operand leftValue = this.build(colon2Node.getLeftNode());
            this.copy(leftModule, leftValue);
        } else {
            this.copy(leftModule, this.manager.getObjectClass());
            name2 = ((Colon3Node)lhs).getName();
        }
        this.addInstr(new SearchModuleForConstInstr(valueResult, leftModule, name2, false, constMissing));
        return leftModule;
    }

    public Operand buildOpAsgnConstDeclNode(OpAsgnConstDeclNode node) {
        if (node.isOr()) {
            TemporaryVariable result2 = this.createTemporaryVariable();
            Label falseCheck = this.getNewLabel();
            Label done = this.getNewLabel();
            Label assign = this.getNewLabel();
            Operand module = this.buildColon2ForConstAsgnDeclNode(node.getFirstNode(), result2, false);
            this.addInstr(BNEInstr.create(falseCheck, result2, UndefinedValue.UNDEFINED));
            this.addInstr(new JumpInstr(assign));
            this.addInstr(new LabelInstr(falseCheck));
            this.addInstr(BNEInstr.create(done, result2, this.manager.getFalse()));
            this.addInstr(new LabelInstr(assign));
            Operand rhsValue = this.build(node.getSecondNode());
            this.copy(result2, rhsValue);
            this.addInstr(new PutConstInstr(module, ((Colon3Node)node.getFirstNode()).getName(), rhsValue));
            this.addInstr(new LabelInstr(done));
            return result2;
        }
        if (node.isAnd()) {
            TemporaryVariable result3 = this.createTemporaryVariable();
            Label done = this.getNewLabel();
            Operand module = this.buildColon2ForConstAsgnDeclNode(node.getFirstNode(), result3, true);
            this.addInstr(new BFalseInstr(done, result3));
            Operand rhsValue = this.build(node.getSecondNode());
            this.copy(result3, rhsValue);
            this.addInstr(new PutConstInstr(module, ((Colon3Node)node.getFirstNode()).getName(), rhsValue));
            this.addInstr(new LabelInstr(done));
            return result3;
        }
        Operand lhs = this.build(node.getFirstNode());
        Operand rhs = this.build(node.getSecondNode());
        Variable result4 = this.call(this.temp(), lhs, node.getSymbolOperator(), rhs);
        return this.addResultInstr(new CopyInstr(this.createTemporaryVariable(), this.putConstantAssignment(node, result4)));
    }

    public Operand buildOpAsgnAnd(OpAsgnAndNode andNode) {
        Label l = this.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode());
        Variable result2 = this.getValueInTemporaryVariable(v1);
        this.addInstr(IRBuilder.createBranch(v1, this.manager.getFalse(), l));
        Operand v2 = this.build(andNode.getSecondNode());
        this.addInstr(new CopyInstr(result2, v2));
        this.addInstr(new LabelInstr(l));
        return result2;
    }

    public Operand buildOpAsgnOr(OpAsgnOrNode orNode) {
        Operand v1;
        Label l1 = this.getNewLabel();
        Label l2 = null;
        TemporaryVariable flag = this.createTemporaryVariable();
        boolean needsDefnCheck = orNode.getFirstNode().needsDefinitionCheck();
        if (needsDefnCheck) {
            l2 = this.getNewLabel();
            v1 = this.buildGetDefinition(orNode.getFirstNode());
            this.addInstr(new CopyInstr(flag, v1));
            this.addInstr(IRBuilder.createBranch(flag, this.manager.getNil(), l2));
        }
        v1 = this.build(orNode.getFirstNode());
        this.addInstr(new CopyInstr(flag, v1));
        Variable result2 = this.getValueInTemporaryVariable(v1);
        if (needsDefnCheck) {
            this.addInstr(new LabelInstr(l2));
        }
        this.addInstr(IRBuilder.createBranch(flag, this.manager.getTrue(), l1));
        Operand v2 = this.build(orNode.getSecondNode());
        this.addInstr(new CopyInstr(result2, v2));
        this.addInstr(new LabelInstr(l1));
        return result2;
    }

    public Operand buildOpElementAsgn(OpElementAsgnNode node) {
        if (node.isOr()) {
            return this.buildOpElementAsgnWith(node, this.manager.getTrue());
        }
        if (node.isAnd()) {
            return this.buildOpElementAsgnWith(node, this.manager.getFalse());
        }
        return this.buildOpElementAsgnWithMethod(node);
    }

    private Operand buildOpElementAsgnWith(OpElementAsgnNode opElementAsgnNode, Boolean truthy) {
        Node receiver2 = opElementAsgnNode.getReceiverNode();
        CallType callType = receiver2 instanceof SelfNode ? CallType.FUNCTIONAL : CallType.NORMAL;
        Operand array2 = this.buildWithOrder(receiver2, opElementAsgnNode.containsVariableAssignment());
        Label endLabel = this.getNewLabel();
        TemporaryVariable elt = this.createTemporaryVariable();
        int[] flags2 = new int[]{0};
        Operand[] argList = this.setupCallArgs(opElementAsgnNode.getArgsNode(), flags2);
        Operand block = this.setupCallClosure(opElementAsgnNode.getBlockNode());
        this.addInstr(CallInstr.create(this.scope, callType, elt, this.symbol(ArrayDerefInstr.AREF), array2, argList, block, flags2[0]));
        this.addInstr(IRBuilder.createBranch(elt, truthy, endLabel));
        Operand value2 = this.build(opElementAsgnNode.getValueNode());
        argList = IRBuilder.addArg(argList, value2);
        this.addInstr(CallInstr.create(this.scope, callType, elt, this.symbol(ArrayDerefInstr.ASET), array2, argList, block, flags2[0]));
        this.addInstr(new CopyInstr(elt, value2));
        this.addInstr(new LabelInstr(endLabel));
        return elt;
    }

    public Operand buildOpElementAsgnWithMethod(OpElementAsgnNode opElementAsgnNode) {
        Node receiver2 = opElementAsgnNode.getReceiverNode();
        CallType callType = receiver2 instanceof SelfNode ? CallType.FUNCTIONAL : CallType.NORMAL;
        Operand array2 = this.buildWithOrder(receiver2, opElementAsgnNode.containsVariableAssignment());
        int[] flags2 = new int[]{0};
        Operand[] argList = this.setupCallArgs(opElementAsgnNode.getArgsNode(), flags2);
        Operand block = this.setupCallClosure(opElementAsgnNode.getBlockNode());
        TemporaryVariable elt = this.createTemporaryVariable();
        this.addInstr(CallInstr.create(this.scope, callType, elt, this.symbol(ArrayDerefInstr.AREF), array2, argList, block, flags2[0]));
        Operand value2 = this.build(opElementAsgnNode.getValueNode());
        this._call(elt, callType, elt, opElementAsgnNode.getOperatorSymbolName(), value2);
        argList = IRBuilder.addArg(argList, elt);
        this.addInstr(CallInstr.create(this.scope, callType, this.temp(), this.symbol(ArrayDerefInstr.ASET), array2, argList, block, flags2[0]));
        return elt;
    }

    public Operand buildOr(OrNode orNode) {
        if (orNode.getFirstNode().getNodeType().alwaysTrue()) {
            return this.build(orNode.getFirstNode());
        }
        if (orNode.getFirstNode().getNodeType().alwaysFalse()) {
            this.build(orNode.getFirstNode());
            return this.build(orNode.getSecondNode());
        }
        Label endOfExprLabel = this.getNewLabel();
        Operand left2 = this.build(orNode.getFirstNode());
        Variable result2 = this.getValueInTemporaryVariable(left2);
        this.addInstr(IRBuilder.createBranch(left2, this.manager.getTrue(), endOfExprLabel));
        Operand right = this.build(orNode.getSecondNode());
        this.addInstr(new CopyInstr(result2, right));
        this.addInstr(new LabelInstr(endOfExprLabel));
        return result2;
    }

    private InterpreterContext buildPrePostExeInner(Node body) {
        this.addInstr(new CopyInstr(this.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        this.build(body);
        this.addInstr(new ReturnInstr(new Nil()));
        this.computeScopeFlagsFrom(this.instructions);
        return this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
    }

    private List<Instr> buildPreExeInner(Node body) {
        this.build(body);
        return this.instructions;
    }

    public Operand buildPostExe(PostExeNode postExeNode) {
        IRScope topLevel = this.scope.getRootLexicalScope();
        IRScope nearestLVarScope = this.scope.getNearestTopLocalVariableScope();
        StaticScope parentScope = nearestLVarScope.getStaticScope();
        StaticScope staticScope = parentScope.duplicate();
        staticScope.setEnclosingScope(parentScope);
        IRClosure endClosure = new IRClosure(this.manager, this.scope, postExeNode.getLine(), staticScope, Signature.from(postExeNode), CommonByteLists._END_, true);
        staticScope.setIRScope(endClosure);
        endClosure.setIsEND();
        this.newIRBuilder(this.manager, endClosure).buildPrePostExeInner(postExeNode.getBodyNode());
        this.addInstr(new RecordEndBlockInstr(topLevel, new WrappedIRClosure(this.buildSelf(), endClosure)));
        return this.manager.getNil();
    }

    public Operand buildPreExe(PreExeNode preExeNode) {
        IRBuilder builder = new IRBuilder(this.manager, this.scope, this, this);
        List<Instr> beginInstrs = builder.buildPreExeInner(preExeNode.getBodyNode());
        this.instructions.addAll(this.afterPrologueIndex, beginInstrs);
        this.afterPrologueIndex += beginInstrs.size();
        return this.manager.getNil();
    }

    public Operand buildRational(RationalNode rationalNode) {
        return new Rational((ImmutableLiteral)this.build(rationalNode.getNumerator()), (ImmutableLiteral)this.build(rationalNode.getDenominator()));
    }

    public Operand buildRedo(RedoNode redoNode) {
        IRLoop currLoop;
        if (!this.activeEnsureBlockStack.isEmpty()) {
            this.emitEnsureBlocks(this.getCurrentLoop());
        }
        if ((currLoop = this.getCurrentLoop()) != null) {
            this.addInstr(new JumpInstr(currLoop.iterStartLabel));
        } else if (this.scope instanceof IRClosure) {
            if (this.scope instanceof IREvalScript) {
                this.throwSyntaxError(redoNode, "Can't escape from eval with redo");
            } else {
                this.addInstr(new ThreadPollInstr(true));
                Label startLabel = new Label(this.scope.getId() + "_START", 0);
                this.instructions.add(this.afterPrologueIndex, new LabelInstr(startLabel));
                this.addInstr(new JumpInstr(startLabel));
            }
        } else {
            this.throwSyntaxError(redoNode, "Invalid redo");
        }
        return this.manager.getNil();
    }

    public Operand buildRegexp(RegexpNode reNode) {
        return this.copy(new Regexp(reNode.getValue(), reNode.getOptions()));
    }

    public Operand buildRescue(RescueNode node) {
        return this.buildEnsureInternal(node, null);
    }

    private boolean canBacktraceBeRemoved(RescueNode rescueNode) {
        if (RubyInstanceConfig.FULL_TRACE_ENABLED || !(rescueNode instanceof RescueModNode) && rescueNode.getElseNode() != null) {
            return false;
        }
        RescueBodyNode rescueClause = rescueNode.getRescueNode();
        if (rescueClause.getOptRescueNode() != null) {
            return false;
        }
        if (rescueClause.getExceptionNodes() != null) {
            return false;
        }
        Node body = rescueClause.getBodyNode();
        if (body instanceof GlobalVarNode && IRBuilder.isErrorInfoGlobal(((GlobalVarNode)body).getName().idString())) {
            return false;
        }
        return body instanceof SideEffectFree;
    }

    private static boolean isErrorInfoGlobal(String name2) {
        switch (name2) {
            case "$!": 
            case "$ERROR_INFO": 
            case "$@": 
            case "$ERROR_POSITION": {
                return true;
            }
        }
        return false;
    }

    private Operand buildRescueInternal(RescueNode rescueNode, EnsureBlockInfo ensure) {
        boolean needsBacktrace = !this.canBacktraceBeRemoved(rescueNode);
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = ensure.end;
        Label rescueLabel = this.getNewLabel();
        ensure.needsBacktrace = needsBacktrace;
        this.addInstr(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionStartMarkerInstr(rescueLabel));
        this.activeRescuers.push(rescueLabel);
        this.addInstr(this.manager.needsBacktrace(needsBacktrace));
        Operand tmp = this.manager.getNil();
        TemporaryVariable rv = this.createTemporaryVariable();
        if (rescueNode.getBodyNode() != null) {
            tmp = this.build(rescueNode.getBodyNode());
        }
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.activeRescuers.pop();
        if (rescueNode.getElseNode() != null) {
            this.addInstr(new LabelInstr(this.getNewLabel()));
            tmp = this.build(rescueNode.getElseNode());
        }
        RescueBlockInfo rbi = new RescueBlockInfo(rBeginLabel, ensure.savedGlobalException);
        this.activeRescueBlockStack.push(rbi);
        if (tmp != U_NIL) {
            this.addInstr(new CopyInstr(rv, tmp));
            ensure.cloneIntoHostScope(this);
            this.addInstr(new JumpInstr(rEndLabel));
        }
        this.addInstr(new LabelInstr(rescueLabel));
        if (!needsBacktrace) {
            this.addInstr(this.manager.needsBacktrace(true));
        }
        Variable exc = this.addResultInstr(new ReceiveRubyExceptionInstr(this.createTemporaryVariable()));
        this.buildRescueBodyInternal(rescueNode.getRescueNode(), rv, exc, rEndLabel);
        this.activeRescueBlockStack.pop();
        return rv;
    }

    private void outputExceptionCheck(Operand excType, Operand excObj, Label caughtLabel) {
        Variable eqqResult = this.addResultInstr(new RescueEQQInstr(this.createTemporaryVariable(), excType, excObj));
        this.addInstr(IRBuilder.createBranch(eqqResult, this.manager.getTrue(), caughtLabel));
    }

    private void buildRescueBodyInternal(RescueBodyNode rescueBodyNode, Variable rv, Variable exc, Label endLabel) {
        Node exceptionList = rescueBodyNode.getExceptionNodes();
        Label uncaughtLabel = this.getNewLabel();
        Label caughtLabel = this.getNewLabel();
        if (exceptionList != null) {
            if (exceptionList instanceof ListNode) {
                Node[] exceptionNodes = ((ListNode)exceptionList).children();
                for (int i2 = 0; i2 < exceptionNodes.length; ++i2) {
                    this.outputExceptionCheck(this.build(exceptionNodes[i2]), exc, caughtLabel);
                }
            } else {
                this.outputExceptionCheck(this.build(exceptionList), exc, caughtLabel);
            }
        } else {
            this.outputExceptionCheck(this.manager.getStandardError(), exc, caughtLabel);
        }
        this.addInstr(new LabelInstr(uncaughtLabel));
        if (rescueBodyNode.getOptRescueNode() != null) {
            this.buildRescueBodyInternal(rescueBodyNode.getOptRescueNode(), rv, exc, endLabel);
        } else {
            this.addInstr(new ThrowExceptionInstr(exc));
        }
        this.addInstr(new LabelInstr(caughtLabel));
        Node realBody = rescueBodyNode.getBodyNode();
        Operand x = this.build(realBody);
        if (x != U_NIL) {
            this.addInstr(new CopyInstr(rv, x));
            this.activeEnsureBlockStack.peek().cloneIntoHostScope(this);
            this.addInstr(new JumpInstr(endLabel));
        }
    }

    public Operand buildRetry(RetryNode retryNode) {
        if (this.activeRescueBlockStack.isEmpty()) {
            this.throwSyntaxError(retryNode, "Invalid retry");
        } else {
            this.addInstr(new ThreadPollInstr(true));
            RescueBlockInfo rbi = this.activeRescueBlockStack.peek();
            this.addInstr(new PutGlobalVarInstr(this.symbol("$!"), (Operand)rbi.savedExceptionVariable));
            this.addInstr(new JumpInstr(rbi.entryLabel));
            this.scope.setHasLoops();
        }
        return this.manager.getNil();
    }

    private Operand processEnsureRescueBlocks(Operand retVal) {
        if (!this.activeEnsureBlockStack.isEmpty()) {
            retVal = this.addResultInstr(new CopyInstr(this.createTemporaryVariable(), retVal));
            this.emitEnsureBlocks(null);
        }
        return retVal;
    }

    public Operand buildReturn(ReturnNode returnNode) {
        Operand retVal = this.build(returnNode.getValueNode());
        if (this.scope instanceof IRClosure) {
            if (this.scope.isWithinEND()) {
                this.addInstr(new ThrowExceptionInstr(IRException.RETURN_LocalJumpError));
            } else {
                boolean definedWithinMethod;
                boolean bl = definedWithinMethod = this.scope.getNearestMethod() != null;
                if (!(this.scope instanceof IREvalScript) && !(this.scope instanceof IRFor)) {
                    this.addInstr(new CheckForLJEInstr(definedWithinMethod));
                }
                if (!this.activeRescueBlockStack.isEmpty()) {
                    RescueBlockInfo rbi = this.activeRescueBlockStack.peek();
                    this.addInstr(new PutGlobalVarInstr(this.symbol("$!"), (Operand)rbi.savedExceptionVariable));
                }
                this.addInstr(new NonlocalReturnInstr(retVal, definedWithinMethod ? this.scope.getNearestMethod().getId() : "--none--"));
            }
        } else if (this.scope.isModuleBody()) {
            IRMethod sm = this.scope.getNearestMethod();
            if (sm == null) {
                this.addInstr(new ThrowExceptionInstr(IRException.RETURN_LocalJumpError));
            }
            if (sm != null) {
                this.addInstr(new NonlocalReturnInstr(retVal, sm.getId()));
            }
        } else {
            retVal = this.processEnsureRescueBlocks(retVal);
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                this.addInstr(new TraceInstr(RubyEvent.RETURN, this.getCurrentModuleVariable(), this.getName(), this.getFileName(), returnNode.getLine() + 1));
            }
            this.addInstr(new ReturnInstr(retVal));
        }
        return U_NIL;
    }

    public InterpreterContext buildEvalRoot(RootNode rootNode) {
        this.executesOnce = false;
        this.coverageMode = 0;
        this.addInstr(this.manager.newLineNumber(this.scope.getLine()));
        this.prepareImplicitState();
        this.addCurrentModule();
        this.afterPrologueIndex = this.instructions.size() - 1;
        Operand returnValue = rootNode.getBodyNode() == null ? this.manager.getNil() : this.build(rootNode.getBodyNode());
        this.addInstr(new ReturnInstr(returnValue));
        this.computeScopeFlagsFrom(this.instructions);
        return this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 2, this.flags);
    }

    public static InterpreterContext buildRoot(IRManager manager, RootNode rootNode) {
        String file2 = rootNode.getFile();
        IRScriptBody script = new IRScriptBody(manager, file2 == null ? "(anon)" : file2, rootNode.getStaticScope());
        return IRBuilder.topIRBuilder(manager, script).buildRootInner(rootNode);
    }

    private void addCurrentModule() {
        this.addInstr(new CopyInstr(this.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
    }

    private InterpreterContext buildRootInner(RootNode rootNode) {
        this.coverageMode = rootNode.coverageMode();
        this.prepareImplicitState();
        this.addCurrentModule();
        this.afterPrologueIndex = this.instructions.size() - 1;
        this.addInstr(new ReturnInstr(this.build(rootNode.getBodyNode())));
        this.computeScopeFlagsFrom(this.instructions);
        if (this.scope.canReceiveNonlocalReturns()) {
            this.handleNonlocalReturnInMethod();
        }
        return this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
    }

    public Variable buildSelf() {
        return this.scope.getSelf();
    }

    public Operand buildSplat(SplatNode splatNode) {
        return this.addResultInstr(new BuildSplatInstr(this.createTemporaryVariable(), this.build(splatNode.getValue()), true));
    }

    public Operand buildStr(StrNode strNode) {
        Operand literal = this.buildStrRaw(strNode);
        return literal instanceof FrozenString ? literal : this.copy(literal);
    }

    public Operand buildStrRaw(StrNode strNode) {
        if (strNode instanceof FileNode) {
            return new Filename();
        }
        int line = strNode.getLine();
        if (strNode.isFrozen()) {
            return new FrozenString(strNode.getValue(), strNode.getCodeRange(), this.scope.getFile(), line);
        }
        return new MutableString(strNode.getValue(), strNode.getCodeRange(), this.scope.getFile(), line);
    }

    private Operand buildZSuper(Operand block) {
        ArrayList<Operand> callArgs = new ArrayList<Operand>(5);
        ArrayList<KeyValuePair<Operand, Operand>> keywordArgs = new ArrayList<KeyValuePair<Operand, Operand>>(3);
        IRBuilder.determineZSuperCallArgs(this.scope, this, callArgs, keywordArgs);
        boolean inClassBody = this.scope instanceof IRMethod && this.scope.getLexicalParent() instanceof IRClassBody;
        boolean isInstanceMethod = inClassBody && ((IRMethod)this.scope).isInstanceMethod;
        TemporaryVariable zsuperResult = this.createTemporaryVariable();
        int[] flags2 = new int[]{0};
        if (keywordArgs.size() == 1 && ((Operand)((KeyValuePair)keywordArgs.get(0)).getKey()).equals(Symbol.KW_REST_ARG_DUMMY)) {
            flags2[0] = flags2[0] | 6;
            Operand keywordRest = (Operand)((KeyValuePair)keywordArgs.get(0)).getValue();
            Operand[] args2 = callArgs.toArray(new Operand[callArgs.size()]);
            Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{keywordRest}));
            this.if_else(test2, this.manager.getTrue(), () -> this.receiveBreakException(block, this.determineSuperInstr(zsuperResult, args2, block, flags2[0], inClassBody, isInstanceMethod)), () -> this.receiveBreakException(block, this.determineSuperInstr(zsuperResult, IRBuilder.addArg(args2, keywordRest), block, flags2[0], inClassBody, isInstanceMethod)));
        } else {
            Operand[] args3 = IRBuilder.getZSuperCallOperands(this.scope, callArgs, keywordArgs, flags2);
            this.receiveBreakException(block, this.determineSuperInstr(zsuperResult, args3, block, flags2[0], inClassBody, isInstanceMethod));
        }
        return zsuperResult;
    }

    private CallInstr determineSuperInstr(Variable result2, Operand[] args2, Operand block, int flags2, boolean inClassBody, boolean isInstanceMethod) {
        return inClassBody ? (isInstanceMethod ? new InstanceSuperInstr(this.scope, result2, this.getCurrentModuleVariable(), this.getName(), args2, block, flags2, this.scope.maybeUsingRefinements()) : new ClassSuperInstr(this.scope, result2, this.getCurrentModuleVariable(), this.getName(), args2, block, flags2, this.scope.maybeUsingRefinements())) : new UnresolvedSuperInstr(this.scope, result2, this.buildSelf(), args2, block, flags2, this.scope.maybeUsingRefinements());
    }

    public Operand buildSuper(SuperNode callNode) {
        Operand tempBlock = this.setupCallClosure(callNode.getIterNode());
        if (tempBlock == NullBlock.INSTANCE) {
            tempBlock = this.getYieldClosureVariable();
        }
        Operand block = tempBlock;
        boolean inClassBody = this.scope instanceof IRMethod && this.scope.getLexicalParent() instanceof IRClassBody;
        boolean isInstanceMethod = inClassBody && ((IRMethod)this.scope).isInstanceMethod;
        TemporaryVariable result2 = this.createTemporaryVariable();
        int[] flags2 = new int[]{0};
        Operand[] args2 = this.setupCallArgs(callNode.getArgsNode(), flags2);
        if ((flags2[0] & 4) != 0) {
            Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{args2[args2.length - 1]}));
            this.if_else(test2, this.manager.getTrue(), () -> this.receiveBreakException(block, this.determineSuperInstr(result2, IRBuilder.removeArg(args2), block, flags2[0], inClassBody, isInstanceMethod)), () -> this.receiveBreakException(block, this.determineSuperInstr(result2, args2, block, flags2[0], inClassBody, isInstanceMethod)));
        } else {
            this.determineIfWeNeedLineNumber(callNode);
            this.receiveBreakException(block, this.determineSuperInstr(result2, args2, block, flags2[0], inClassBody, isInstanceMethod));
        }
        return result2;
    }

    public Operand buildSValue(SValueNode node) {
        return this.copy(new SValue(this.build(node.getValue())));
    }

    public Operand buildSymbol(SymbolNode node) {
        return new Symbol(node.getName());
    }

    public Operand buildTrue() {
        return this.manager.getTrue();
    }

    public Operand buildUndef(Node node) {
        Operand methName = this.build(((UndefNode)node).getName());
        return this.addResultInstr(new UndefMethodInstr(this.createTemporaryVariable(), methName));
    }

    private Operand buildConditionalLoop(Node conditionNode, Node bodyNode, boolean isWhile, boolean isLoopHeadCondition) {
        Operand cv;
        if (isLoopHeadCondition && (isWhile && conditionNode.getNodeType().alwaysFalse() || !isWhile && conditionNode.getNodeType().alwaysTrue())) {
            this.build(conditionNode);
            return this.manager.getNil();
        }
        IRLoop loop2 = new IRLoop(this.scope, this.getCurrentLoop(), this.createTemporaryVariable());
        Variable loopResult = loop2.loopResult;
        Label setupResultLabel = this.getNewLabel();
        this.loopStack.push(loop2);
        this.addInstr(new LabelInstr(loop2.loopStartLabel));
        if (isLoopHeadCondition) {
            cv = this.build(conditionNode);
            this.addInstr(IRBuilder.createBranch(cv, isWhile ? this.manager.getFalse() : this.manager.getTrue(), setupResultLabel));
        }
        this.addInstr(new LabelInstr(loop2.iterStartLabel));
        this.addInstr(new ThreadPollInstr(true));
        if (bodyNode != null) {
            this.build(bodyNode);
        }
        this.addInstr(new LabelInstr(loop2.iterEndLabel));
        if (isLoopHeadCondition) {
            this.addInstr(new JumpInstr(loop2.loopStartLabel));
        } else {
            cv = this.build(conditionNode);
            this.addInstr(IRBuilder.createBranch(cv, isWhile ? this.manager.getTrue() : this.manager.getFalse(), loop2.iterStartLabel));
        }
        this.addInstr(new LabelInstr(setupResultLabel));
        this.addInstr(new CopyInstr(loopResult, this.manager.getNil()));
        this.addInstr(new LabelInstr(loop2.loopEndLabel));
        this.loopStack.pop();
        return loopResult;
    }

    public Operand buildUntil(UntilNode untilNode) {
        return this.buildConditionalLoop(untilNode.getConditionNode(), untilNode.getBodyNode(), false, untilNode.evaluateAtStart());
    }

    public Operand buildVAlias(VAliasNode valiasNode) {
        this.addInstr(new GVarAliasInstr(new MutableString(valiasNode.getNewName()), new MutableString(valiasNode.getOldName())));
        return this.manager.getNil();
    }

    public Operand buildVCall(Variable result2, VCallNode node) {
        if (result2 == null) {
            result2 = this.createTemporaryVariable();
        }
        return this._call(result2, CallType.VARIABLE, this.buildSelf(), node.getName(), new Operand[0]);
    }

    public Operand buildWhile(WhileNode whileNode) {
        return this.buildConditionalLoop(whileNode.getConditionNode(), whileNode.getBodyNode(), true, whileNode.evaluateAtStart());
    }

    public Operand buildXStr(XStrNode node) {
        return this.fcall(this.temp(), (Operand)Self.SELF, "`", new FrozenString(node.getValue(), node.getCodeRange(), this.scope.getFile(), node.getLine()));
    }

    public Operand buildYield(YieldNode node, Variable result2) {
        Node onlyArg;
        if (this.scope instanceof IRScriptBody || this.scope instanceof IRModuleBody) {
            this.throwSyntaxError(node, "Invalid yield");
        }
        boolean unwrap = true;
        Node argNode = node.getArgsNode();
        if (argNode != null && argNode instanceof ArrayNode && ((ArrayNode)argNode).size() == 1 && (!((onlyArg = ((ArrayNode)argNode).getLast()) instanceof HashNode) || ((HashNode)onlyArg).isLiteral())) {
            argNode = onlyArg;
            unwrap = false;
        }
        Variable ret = result2 == null ? this.createTemporaryVariable() : result2;
        int[] flags2 = new int[]{0};
        Operand value2 = this.buildYieldArgs(argNode, flags2);
        this.addInstr(new YieldInstr(ret, this.getYieldClosureVariable(), value2, flags2[0], unwrap));
        return ret;
    }

    public Variable as_fixnum(Operand value2) {
        return this.addResultInstr(new AsFixnumInstr(this.temp(), value2));
    }

    public Variable copy(Operand value2) {
        return this.copy(null, value2);
    }

    public Variable copy(Variable result2, Operand value2) {
        return this.addResultInstr(new CopyInstr(result2 == null ? this.createTemporaryVariable() : result2, value2));
    }

    public Operand buildZArray(Variable result2) {
        return this.copy(result2, new Array());
    }

    private Operand buildZSuperIfNest(Operand block) {
        int depthFrom = 0;
        IRBuilder superBuilder = this;
        IRScope superScope = this.scope;
        boolean defineMethod = false;
        while (superScope instanceof IRClosure) {
            if (superBuilder != null && superBuilder.isDefineMethod()) {
                defineMethod = true;
            }
            superBuilder = superBuilder != null && superBuilder.parent != null ? superBuilder.parent : null;
            superScope = superScope.getLexicalParent();
            ++depthFrom;
        }
        int depthFromSuper = depthFrom;
        TemporaryVariable zsuperResult = this.createTemporaryVariable();
        if (superScope instanceof IRMethod && !defineMethod) {
            ArrayList<Operand> callArgs = new ArrayList<Operand>(5);
            ArrayList<KeyValuePair<Operand, Operand>> keywordArgs = new ArrayList<KeyValuePair<Operand, Operand>>(3);
            int[] flags2 = new int[]{0};
            IRBuilder.determineZSuperCallArgs(superScope, superBuilder, callArgs, keywordArgs);
            if (keywordArgs.size() == 1 && ((Operand)((KeyValuePair)keywordArgs.get(0)).getKey()).equals(Symbol.KW_REST_ARG_DUMMY)) {
                flags2[0] = flags2[0] | 6;
                Operand keywordRest = ((DepthCloneable)((KeyValuePair)keywordArgs.get(0)).getValue()).cloneForDepth(depthFromSuper);
                Operand[] args2 = this.adjustVariableDepth(callArgs.toArray(new Operand[callArgs.size()]), depthFromSuper);
                Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{keywordRest}));
                this.if_else(test2, this.manager.getTrue(), () -> this.addInstr(new ZSuperInstr(this.scope, zsuperResult, this.buildSelf(), args2, block, flags2[0], this.scope.maybeUsingRefinements())), () -> this.addInstr(new ZSuperInstr(this.scope, zsuperResult, this.buildSelf(), IRBuilder.addArg(args2, keywordRest), block, flags2[0], this.scope.maybeUsingRefinements())));
            } else {
                Operand[] args3 = this.adjustVariableDepth(IRBuilder.getZSuperCallOperands(this.scope, callArgs, keywordArgs, flags2), depthFromSuper);
                this.addInstr(new ZSuperInstr(this.scope, zsuperResult, this.buildSelf(), args3, block, flags2[0], this.scope.maybeUsingRefinements()));
            }
        } else {
            this.scope.setUsesZSuper();
            this.addRaiseError("RuntimeError", "implicit argument passing of super from method defined by define_method() is not supported. Specify all arguments explicitly.");
        }
        return zsuperResult;
    }

    private boolean isDefineMethod() {
        if (this.methodName != null) {
            String name2 = this.methodName.asJavaString();
            return "define_method".equals(name2) || "define_singleton_method".equals(name2);
        }
        return false;
    }

    private Operand addRaiseError(String id2, String message2) {
        return this.addRaiseError(id2, new MutableString(message2));
    }

    private Operand addRaiseError(String id2, Operand message2) {
        Operand exceptionClass = this.searchModuleForConst(this.manager.getObjectClass(), this.symbol(id2));
        Operand kernel = this.searchModuleForConst(this.manager.getObjectClass(), this.symbol("Kernel"));
        return this.call(this.temp(), kernel, "raise", exceptionClass, message2);
    }

    public Operand buildZSuper(ZSuperNode zsuperNode) {
        Operand block = this.setupCallClosure(zsuperNode.getIterNode());
        if (block == NullBlock.INSTANCE) {
            block = this.getYieldClosureVariable();
        }
        return this.scope instanceof IRMethod ? this.buildZSuper(block) : this.buildZSuperIfNest(block);
    }

    private Operand[] adjustVariableDepth(Operand[] args2, int depthFromSuper) {
        if (depthFromSuper == 0) {
            return args2;
        }
        Operand[] newArgs = new Operand[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newArgs[i2] = args2[i2] instanceof Hash ? ((Hash)args2[i2]).cloneForLVarDepth(depthFromSuper) : ((DepthCloneable)((Object)args2[i2])).cloneForDepth(depthFromSuper);
        }
        return newArgs;
    }

    private InterpreterContext buildModuleOrClassBody(Node bodyNode, int startLine, int endLine) {
        this.addInstr(new TraceInstr(RubyEvent.CLASS, this.getCurrentModuleVariable(), null, this.getFileName(), startLine + 1));
        this.prepareImplicitState();
        this.addCurrentModule();
        Operand bodyReturnValue = this.build(bodyNode);
        this.addInstr(this.manager.newLineNumber(endLine));
        this.addInstr(new TraceInstr(RubyEvent.END, this.getCurrentModuleVariable(), null, this.getFileName(), endLine + 1));
        this.addInstr(new ReturnInstr(bodyReturnValue));
        this.computeScopeFlagsFrom(this.instructions);
        return this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
    }

    private RubySymbol methodNameFor() {
        IRMethod method2 = this.scope.getNearestMethod();
        return method2 == null ? null : method2.getName();
    }

    private TemporaryVariable createTemporaryVariable() {
        if (this.variableBuilder != null) {
            return this.variableBuilder.createTemporaryVariable();
        }
        ++this.temporaryVariableIndex;
        if (this.scope.getScopeType() == IRScopeType.CLOSURE) {
            return new TemporaryClosureVariable(((IRClosure)this.scope).closureId, this.temporaryVariableIndex);
        }
        return this.manager.newTemporaryLocalVariable(this.temporaryVariableIndex);
    }

    public LocalVariable getLocalVariable(RubySymbol name2, int scopeDepth) {
        return this.scope.getLocalVariable(name2, scopeDepth);
    }

    public LocalVariable getNewLocalVariable(RubySymbol name2, int scopeDepth) {
        return this.scope.getNewLocalVariable(name2, scopeDepth);
    }

    public RubySymbol getName() {
        return this.scope.getName();
    }

    private Label getNewLabel() {
        return this.scope.getNewLabel();
    }

    private Label getNewLabel(String labelName) {
        return this.scope.getNewLabel(labelName);
    }

    private String getFileName() {
        return this.scope.getFile();
    }

    private RubySymbol symbol(String id2) {
        return this.manager.runtime.newSymbol(id2);
    }

    private RubySymbol symbol(ByteList bytelist) {
        return this.manager.runtime.newSymbol(bytelist);
    }

    public static void determineZSuperCallArgs(IRScope scope, IRBuilder builder, List<Operand> callArgs, List<KeyValuePair<Operand, Operand>> keywordArgs) {
        if (builder != null) {
            for (Instr instr : builder.instructions) {
                IRBuilder.extractCallOperands(callArgs, keywordArgs, instr);
            }
        } else {
            for (Instr instr : scope.interpreterContext.getInstructions()) {
                IRBuilder.extractCallOperands(callArgs, keywordArgs, instr);
            }
        }
    }

    private static void extractCallOperands(List<Operand> callArgs, List<KeyValuePair<Operand, Operand>> keywordArgs, Instr instr) {
        if (instr instanceof ReceiveKeywordRestArgInstr) {
            keywordArgs.add(0, new KeyValuePair<Symbol, Variable>(Symbol.KW_REST_ARG_DUMMY, ((ReceiveArgBase)instr).getResult()));
        } else if (instr instanceof ReceiveKeywordArgInstr) {
            ReceiveKeywordArgInstr receiveKwargInstr = (ReceiveKeywordArgInstr)instr;
            keywordArgs.add(new KeyValuePair<Symbol, Variable>(new Symbol(receiveKwargInstr.getKey()), receiveKwargInstr.getResult()));
        } else if (instr instanceof ReceiveRestArgInstr) {
            callArgs.add(new Splat(((ReceiveRestArgInstr)instr).getResult()));
        } else if (instr instanceof ReceiveArgBase) {
            callArgs.add(((ReceiveArgBase)instr).getResult());
        }
    }

    private static Operand[] getZSuperCallOperands(IRScope scope, List<Operand> callArgs, List<KeyValuePair<Operand, Operand>> keywordArgs, int[] flags2) {
        if (scope.getNearestTopLocalVariableScope().receivesKeywordArgs()) {
            flags2[0] = flags2[0] | 2;
            int i2 = 0;
            Operand[] args2 = new Operand[callArgs.size() + 1];
            for (Operand arg2 : callArgs) {
                args2[i2++] = arg2;
            }
            args2[i2] = new Hash(keywordArgs);
            return args2;
        }
        return callArgs.toArray(new Operand[callArgs.size()]);
    }

    public static Instr createBranch(Operand v1, Operand v2, Label jmpTarget) {
        if (v2 instanceof Boolean) {
            Boolean lhs = (Boolean)v2;
            if (lhs.isTrue()) {
                if (v1.isTruthyImmediate()) {
                    return new JumpInstr(jmpTarget);
                }
                if (v1.isFalseyImmediate()) {
                    return NopInstr.NOP;
                }
                return new BTrueInstr(jmpTarget, v1);
            }
            if (lhs.isFalse()) {
                if (v1.isTruthyImmediate()) {
                    return NopInstr.NOP;
                }
                if (v1.isFalseyImmediate()) {
                    return new JumpInstr(jmpTarget);
                }
                return new BFalseInstr(jmpTarget, v1);
            }
        } else if (v2 instanceof Nil) {
            if (v1 instanceof Nil) {
                return new JumpInstr(jmpTarget);
            }
            if (v1.isTruthyImmediate()) {
                return NopInstr.NOP;
            }
            return new BNilInstr(jmpTarget, v1);
        }
        if (v2 == UndefinedValue.UNDEFINED) {
            if (v1 == UndefinedValue.UNDEFINED) {
                return new JumpInstr(jmpTarget);
            }
            return new BUndefInstr(jmpTarget, v1);
        }
        throw new RuntimeException("BUG: no BEQ");
    }

    public TemporaryVariable getYieldClosureVariable() {
        this.needsYieldBlock = true;
        if (this.yieldClosureVariable == null) {
            this.yieldClosureVariable = this.createTemporaryVariable();
            return this.yieldClosureVariable;
        }
        return this.yieldClosureVariable;
    }

    public Variable getCurrentModuleVariable() {
        if (this.currentModuleVariable == null) {
            this.currentModuleVariable = this.createCurrentModuleVariable();
        }
        return this.currentModuleVariable;
    }

    public Variable createCurrentModuleVariable() {
        ++this.temporaryVariableIndex;
        return TemporaryCurrentModuleVariable.ModuleVariableFor(this.temporaryVariableIndex);
    }

    public void computeScopeFlagsFrom(List<Instr> instructions) {
        for (Instr i2 : instructions) {
            i2.computeScopeFlags(this.scope, this.flags);
        }
        this.calculateClosureScopeFlags();
        if (this.computeNeedsDynamicScopeFlag()) {
            this.flags.add(IRFlags.REQUIRES_DYNSCOPE);
        }
        this.flags.add(IRFlags.FLAGS_COMPUTED);
    }

    private void calculateClosureScopeFlags() {
        for (IRClosure cl : this.scope.getClosures()) {
            if (cl.usesEval()) {
                this.scope.setCanReceiveBreaks();
                this.scope.setCanReceiveNonlocalReturns();
                this.scope.setUsesZSuper();
                continue;
            }
            if (cl.hasBreakInstructions() || cl.canReceiveBreaks()) {
                this.scope.setCanReceiveBreaks();
            }
            if (cl.hasNonLocalReturns() || cl.canReceiveNonlocalReturns()) {
                this.scope.setCanReceiveNonlocalReturns();
            }
            if (!cl.usesZSuper()) continue;
            this.scope.setUsesZSuper();
        }
    }

    private boolean computeNeedsDynamicScopeFlag() {
        return this.scope.hasNonLocalReturns() || this.scope.canCaptureCallersBinding() || this.scope.canReceiveNonlocalReturns() || this.flags.contains((Object)IRFlags.BINDING_HAS_ESCAPED);
    }

    private void debug(String message2, Operand ... operands) {
        this.addInstr(new DebugOutputInstr(message2, operands));
    }

    static interface VoidCodeBlock {
        public void run();
    }

    static interface CodeBlock {
        public Operand run();
    }

    public static interface Consume2<T, U> {
        public void apply(T var1, U var2);
    }

    public static interface RunIt {
        public void apply();
    }

    private static class EnsureBlockInfo {
        final Label regionStart;
        final Label start;
        final Label end;
        final Label dummyRescueBlockLabel;
        Variable savedGlobalException;
        boolean needsBacktrace;
        final Label bodyRescuer;
        final IRLoop innermostLoop;
        final RescueNode matchingRescueNode;
        final List<Instr> instrs;

        public EnsureBlockInfo(IRScope s2, RescueNode n, IRLoop l, Label bodyRescuer) {
            this.regionStart = s2.getNewLabel();
            this.start = s2.getNewLabel();
            this.end = s2.getNewLabel();
            this.dummyRescueBlockLabel = s2.getNewLabel();
            this.instrs = new ArrayList<Instr>();
            this.savedGlobalException = null;
            this.innermostLoop = l;
            this.matchingRescueNode = n;
            this.bodyRescuer = bodyRescuer;
            this.needsBacktrace = true;
        }

        public void addInstr(Instr i2) {
            this.instrs.add(i2);
        }

        public void addInstrAtBeginning(Instr i2) {
            this.instrs.add(0, i2);
        }

        public void emitBody(IRBuilder b2) {
            b2.addInstr(new LabelInstr(this.start));
            for (Instr i2 : this.instrs) {
                b2.addInstr(i2);
            }
        }

        public void cloneIntoHostScope(IRBuilder builder) {
            if (this.savedGlobalException != null) {
                if (!this.needsBacktrace) {
                    builder.addInstr(builder.manager.needsBacktrace(true));
                }
                builder.addInstr(new PutGlobalVarInstr(builder.symbol("$!"), (Operand)this.savedGlobalException));
            }
            if (this.instrs.size() == 0) {
                return;
            }
            SimpleCloneInfo ii = new SimpleCloneInfo(builder.scope, true);
            ii.renameLabel(this.start);
            for (Instr i2 : this.instrs) {
                if (!(i2 instanceof LabelInstr)) continue;
                ii.renameLabel(((LabelInstr)i2).getLabel());
            }
            builder.addInstr(new LabelInstr(ii.getRenamedLabel(this.start)));
            builder.addInstr(new ExceptionRegionStartMarkerInstr(this.bodyRescuer));
            for (Instr instr : this.instrs) {
                CallBase call2;
                Operand block;
                Instr clonedInstr = instr.clone(ii);
                if (clonedInstr instanceof CallBase && (block = (call2 = (CallBase)clonedInstr).getClosureArg(NullBlock.INSTANCE)) instanceof WrappedIRClosure) {
                    builder.scope.addClosure(((WrappedIRClosure)block).getClosure());
                }
                builder.addInstr(clonedInstr);
            }
            builder.addInstr(new ExceptionRegionEndMarkerInstr());
        }
    }

    private static class RescueBlockInfo {
        final Label entryLabel;
        final Variable savedExceptionVariable;

        public RescueBlockInfo(Label l, Variable v) {
            this.entryLabel = l;
            this.savedExceptionVariable = v;
        }
    }

    private static class IRLoop {
        public final IRScope container;
        public final IRLoop parentLoop;
        public final Label loopStartLabel;
        public final Label loopEndLabel;
        public final Label iterStartLabel;
        public final Label iterEndLabel;
        public final Variable loopResult;

        public IRLoop(IRScope s2, IRLoop outerLoop, Variable result2) {
            this.container = s2;
            this.parentLoop = outerLoop;
            this.loopStartLabel = s2.getNewLabel("_LOOP_BEGIN");
            this.loopEndLabel = s2.getNewLabel("_LOOP_END");
            this.iterStartLabel = s2.getNewLabel("_ITER_BEGIN");
            this.iterEndLabel = s2.getNewLabel("_ITER_END");
            this.loopResult = result2;
            s2.setHasLoops();
        }
    }
}

