/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.util;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.node.stats.NodeStats;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.ClusterAdminClient;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.indexmanagement.indexstatemanagement.util.StepUtilsKt;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ShrinkActionProperties;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.monitor.fs.FsInfo;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a!\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u001a\u001e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e\u001a3\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 \u001a\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001a\u001a6\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0010\u001a\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010*\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010+\u001a\u00020$\u001a+\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001a2\b\b\u0002\u00100\u001a\u000201H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102\u001a)\u00103\u001a\u0002042\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106\u001a!\u00107\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006\u001a+\u00108\u001a\u0004\u0018\u00010$2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00109\u001a\u00020:H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;\u001a5\u0010<\u001a\u00020\u00012\u0006\u0010=\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006@"}, d2={"deleteShrinkLock", "", "shrinkActionProperties", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ShrinkActionProperties;", "lockService", "Lorg/opensearch/jobscheduler/spi/utils/LockService;", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ShrinkActionProperties;Lorg/opensearch/jobscheduler/spi/utils/LockService;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getActionStartTime", "Ljava/time/Instant;", "managedIndexMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "getDiskSettings", "Lorg/opensearch/common/settings/Settings;", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "getFreeBytesThresholdHigh", "", "totalNodeBytes", "getNodeFreeMemoryAfterShrink", "node", "Lorg/opensearch/action/admin/cluster/node/stats/NodeStats;", "indexSizeInBytes", "getShardIdToNodeNameSet", "", "", "", "", "shardStats", "", "Lorg/opensearch/action/admin/indices/stats/ShardStats;", "nodes", "Lorg/opensearch/cluster/node/DiscoveryNodes;", "([Lorg/opensearch/action/admin/indices/stats/ShardStats;Lorg/opensearch/cluster/node/DiscoveryNodes;)Ljava/util/Map;", "getShrinkLockID", "nodeName", "getShrinkLockModel", "Lorg/opensearch/jobscheduler/spi/LockModel;", "jobIndexName", "lockEpochSecond", "lockPrimaryTerm", "lockSeqNo", "lockDurationSecond", "getUpdatedShrinkActionProperties", "lock", "isIndexGreen", "client", "Lorg/opensearch/client/Client;", "indexName", "timeout", "Lorg/opensearch/common/unit/TimeValue;", "(Lorg/opensearch/client/Client;Ljava/lang/String;Lorg/opensearch/common/unit/TimeValue;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "issueUpdateSettingsRequest", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "settings", "(Lorg/opensearch/client/Client;Ljava/lang/String;Lorg/opensearch/common/settings/Settings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "releaseShrinkLock", "renewShrinkLock", "logger", "Lorg/apache/logging/log4j/Logger;", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ShrinkActionProperties;Lorg/opensearch/jobscheduler/spi/utils/LockService;Lorg/apache/logging/log4j/Logger;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resetReadOnlyAndRouting", "index", "originalSettings", "(Ljava/lang/String;Lorg/opensearch/client/Client;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
public final class StepUtilsKt {
    @Nullable
    public static final Object issueUpdateSettingsRequest(@NotNull Client client, @NotNull String indexName, @NotNull Settings settings, @NotNull Continuation<? super AcknowledgedResponse> $completion) {
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client.admin().indices(), (Function2)new Function2<IndicesAdminClient, ActionListener<AcknowledgedResponse>, Unit>(settings, indexName){
            final /* synthetic */ Settings $settings;
            final /* synthetic */ String $indexName;
            {
                this.$settings = $settings;
                this.$indexName = $indexName;
                super(2);
            }

            public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                String[] stringArray = new String[]{this.$indexName};
                $this$suspendUntil.updateSettings(new UpdateSettingsRequest(this.$settings, stringArray), it);
            }
        }, $completion);
    }

    @Nullable
    public static final Object releaseShrinkLock(@NotNull ShrinkActionProperties shrinkActionProperties, @NotNull LockService lockService, @NotNull Continuation<? super Boolean> $completion) {
        LockModel lock2 = StepUtilsKt.getShrinkLockModel(shrinkActionProperties);
        return OpenSearchExtensionsKt.suspendUntil(lockService, (Function2)new Function2<LockService, ActionListener<Boolean>, Unit>(lock2){
            final /* synthetic */ LockModel $lock;
            {
                this.$lock = $lock;
                super(2);
            }

            public final void invoke(@NotNull LockService $this$suspendUntil, @NotNull ActionListener<Boolean> it) {
                Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                $this$suspendUntil.release(this.$lock, it);
            }
        }, $completion);
    }

    @Nullable
    public static final Object deleteShrinkLock(@NotNull ShrinkActionProperties shrinkActionProperties, @NotNull LockService lockService, @NotNull Continuation<? super Boolean> $completion) {
        String lockID = StepUtilsKt.getShrinkLockID(shrinkActionProperties.getNodeName());
        return OpenSearchExtensionsKt.suspendUntil(lockService, (Function2)new Function2<LockService, ActionListener<Boolean>, Unit>(lockID){
            final /* synthetic */ String $lockID;
            {
                this.$lockID = $lockID;
                super(2);
            }

            public final void invoke(@NotNull LockService $this$suspendUntil, @NotNull ActionListener<Boolean> it) {
                Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                $this$suspendUntil.deleteLock(this.$lockID, it);
            }
        }, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object renewShrinkLock(@NotNull ShrinkActionProperties var0, @NotNull LockService var1_1, @NotNull Logger var2_2, @NotNull Continuation<? super LockModel> var3_3) {
        if (!(var3_3 instanceof renewShrinkLock.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StepUtilsKt.renewShrinkLock(null, null, null, (Continuation<? super LockModel>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                lock = StepUtilsKt.getShrinkLockModel(shrinkActionProperties);
                $continuation.L$0 = shrinkActionProperties;
                $continuation.L$1 = logger;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((LockService)lockService, (Function2)new Function2<LockService, ActionListener<LockModel>, Unit>(lock){
                    final /* synthetic */ LockModel $lock;
                    {
                        this.$lock = $lock;
                        super(2);
                    }

                    public final void invoke(@NotNull LockService $this$suspendUntil, @NotNull ActionListener<LockModel> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.renewLock(this.$lock, it);
                    }
                }, $continuation);
                ** if (v0 != var9_6) goto lbl21
lbl20:
                // 1 sources

                return var9_6;
lbl21:
                // 1 sources

                ** GOTO lbl29
            }
            case 1: {
                logger = (Logger)$continuation.L$1;
                shrinkActionProperties = (ShrinkActionProperties)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    var5_8 = (LockModel)v0;
                }
                catch (Exception e) {
                    logger.error("Failed to renew Shrink action lock on node [" + shrinkActionProperties.getNodeName() + "]: " + e);
                    var5_8 = null;
                }
                return var5_8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final LockModel getShrinkLockModel(@NotNull ShrinkActionProperties shrinkActionProperties) {
        Intrinsics.checkNotNullParameter((Object)shrinkActionProperties, (String)"shrinkActionProperties");
        return StepUtilsKt.getShrinkLockModel(shrinkActionProperties.getNodeName(), ".opendistro-ism-config", shrinkActionProperties.getLockEpochSecond(), shrinkActionProperties.getLockPrimaryTerm(), shrinkActionProperties.getLockSeqNo(), shrinkActionProperties.getLockDurationSecond());
    }

    @NotNull
    public static final LockModel getShrinkLockModel(@NotNull String nodeName, @NotNull String jobIndexName, long lockEpochSecond, long lockPrimaryTerm, long lockSeqNo, long lockDurationSecond) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)jobIndexName, (String)"jobIndexName");
        String lockID = StepUtilsKt.getShrinkLockID(nodeName);
        Instant instant = Instant.ofEpochSecond(lockEpochSecond);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(lockEpochSecond)");
        Instant lockCreationInstant = instant;
        return new LockModel(jobIndexName, lockID, lockCreationInstant, lockDurationSecond, false, lockSeqNo, lockPrimaryTerm);
    }

    @NotNull
    public static final ShrinkActionProperties getUpdatedShrinkActionProperties(@NotNull ShrinkActionProperties shrinkActionProperties, @NotNull LockModel lock2) {
        Intrinsics.checkNotNullParameter((Object)shrinkActionProperties, (String)"shrinkActionProperties");
        Intrinsics.checkNotNullParameter((Object)lock2, (String)"lock");
        return new ShrinkActionProperties(shrinkActionProperties.getNodeName(), shrinkActionProperties.getTargetIndexName(), shrinkActionProperties.getTargetNumShards(), lock2.getPrimaryTerm(), lock2.getSeqNo(), lock2.getLockTime().getEpochSecond(), lock2.getLockDurationSeconds(), shrinkActionProperties.getOriginalIndexSettings());
    }

    @NotNull
    public static final Instant getActionStartTime(@NotNull ManagedIndexMetaData managedIndexMetaData) {
        ActionMetaData actionMetadata;
        Intrinsics.checkNotNullParameter((Object)managedIndexMetaData, (String)"managedIndexMetaData");
        ActionMetaData actionMetaData = actionMetadata = managedIndexMetaData.getActionMetaData();
        if (actionMetaData != null) {
            Long l = actionMetaData.getStartTime();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                Instant instant = Instant.ofEpochMilli(it);
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(it)");
                return instant;
            }
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return instant;
    }

    public static final long getFreeBytesThresholdHigh(@NotNull ClusterSettings clusterSettings, long totalNodeBytes) {
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        DiskThresholdSettings diskThresholdSettings = new DiskThresholdSettings(StepUtilsKt.getDiskSettings(clusterSettings), clusterSettings);
        Double diskThresholdPercent = diskThresholdSettings.getFreeDiskThresholdHigh();
        ByteSizeValue diskThresholdBytes = diskThresholdSettings.getFreeBytesThresholdHigh();
        Intrinsics.checkNotNullExpressionValue((Object)diskThresholdPercent, (String)"diskThresholdPercent");
        return diskThresholdPercent > 0.001 ? (long)(diskThresholdPercent / (double)100 * (double)totalNodeBytes) : diskThresholdBytes.getBytes();
    }

    @NotNull
    public static final Settings getDiskSettings(@NotNull ClusterSettings clusterSettings) {
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        Settings settings = Settings.builder().put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), (String)clusterSettings.get(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING)).put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), (String)clusterSettings.get(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING)).put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), (String)clusterSettings.get(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING)).build();
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"builder().put(\n        C\u2026RK_SETTING)\n    ).build()");
        return settings;
    }

    public static final long getNodeFreeMemoryAfterShrink(@NotNull NodeStats node, long indexSizeInBytes, @NotNull ClusterSettings clusterSettings) {
        long totalNodeDisk;
        long freeBytesThresholdHigh;
        long requiredBytes;
        long diskSpaceLeftInNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        FsInfo fsStats = node.getFs();
        if (fsStats != null && (diskSpaceLeftInNode = fsStats.getTotal().getFree().getBytes()) > (requiredBytes = (long)2 * indexSizeInBytes + (freeBytesThresholdHigh = StepUtilsKt.getFreeBytesThresholdHigh(clusterSettings, totalNodeDisk = fsStats.getTotal().getTotal().getBytes())))) {
            return diskSpaceLeftInNode - requiredBytes;
        }
        return -1L;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object isIndexGreen(@NotNull Client var0, @NotNull String var1_1, @NotNull TimeValue var2_2, @NotNull Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof isIndexGreen.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var3_3){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StepUtilsKt.isIndexGreen(null, null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new String[]{indexName};
                healthReq = new ClusterHealthRequest().indices(var5_7).waitForGreenStatus().timeout((TimeValue)timeout);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client.admin().cluster(), (Function2)new Function2<ClusterAdminClient, ActionListener<ClusterHealthResponse>, Unit>(healthReq){
                    final /* synthetic */ ClusterHealthRequest $healthReq;
                    {
                        this.$healthReq = $healthReq;
                        super(2);
                    }

                    public final void invoke(ClusterAdminClient $this$suspendUntil, @NotNull ActionListener<ClusterHealthResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.health(this.$healthReq, it);
                    }
                }, $continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return Boxing.boxBoolean((boolean)((response = (ClusterHealthResponse)v0).isTimedOut() == false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object isIndexGreen$default(Client client, String string, TimeValue timeValue, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            timeValue = new TimeValue(30000L);
        }
        return StepUtilsKt.isIndexGreen(client, string, timeValue, (Continuation<? super Boolean>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object resetReadOnlyAndRouting(@NotNull String var0, @NotNull Client var1_1, @NotNull Map<String, String> var2_2, @NotNull Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof resetReadOnlyAndRouting.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var3_3){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StepUtilsKt.resetReadOnlyAndRouting(null, null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                allocationSettings = Settings.builder().put("index.routing.allocation.require._name", (String)originalSettings.get("index.routing.allocation.require._name")).put(IndexMetadata.SETTING_BLOCKS_WRITE, (String)originalSettings.get(IndexMetadata.SETTING_BLOCKS_WRITE)).build();
                Intrinsics.checkNotNullExpressionValue((Object)allocationSettings, (String)"allocationSettings");
                $continuation.label = 1;
                v0 = StepUtilsKt.issueUpdateSettingsRequest((Client)client, index, allocationSettings, (Continuation<? super AcknowledgedResponse>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!(response = (AcknowledgedResponse)v0).isAcknowledged()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final String getShrinkLockID(@NotNull String nodeName) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        return "shrink-node_name-" + nodeName;
    }

    @NotNull
    public static final Map<Integer, Set<String>> getShardIdToNodeNameSet(@NotNull ShardStats[] shardStats, @NotNull DiscoveryNodes nodes) {
        Intrinsics.checkNotNullParameter((Object)shardStats, (String)"shardStats");
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        Map shardIdToNodeList = new LinkedHashMap();
        for (ShardStats shard : shardStats) {
            String nodeName;
            int shardId = shard.getShardRouting().shardId().getId();
            if (nodes.get(shard.getShardRouting().currentNodeId()).getName() == null) continue;
            if (shardIdToNodeList.containsKey(shardId)) {
                Set set = (Set)shardIdToNodeList.get(shardId);
                if (set == null) continue;
                set.add(nodeName);
                continue;
            }
            Map map = shardIdToNodeList;
            Integer n = shardId;
            Object object = new String[]{nodeName};
            object = SetsKt.mutableSetOf((Object[])object);
            map.put(n, object);
        }
        return shardIdToNodeList;
    }
}

