/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.Float;
import org.jpl7.Integer;
import org.jpl7.JPLException;
import org.jpl7.PrologException;
import org.jpl7.Term;
import org.jpl7.Util;
import org.jpl7.Variable;
import org.jpl7.fli.Prolog;
import org.jpl7.fli.engine_t;
import org.jpl7.fli.fid_t;
import org.jpl7.fli.predicate_t;
import org.jpl7.fli.qid_t;
import org.jpl7.fli.term_t;

public class Query
implements Iterable<Map<String, Term>>,
Iterator<Map<String, Term>> {
    private static final Logger LOGGER = Logger.getLogger(Query.class.getName());
    private static final Level levelLog = Level.INFO;
    protected final Term goal_;
    protected final String hostModule = "user";
    protected final String contextModule = "user";
    private boolean open = false;
    private engine_t engine = null;
    private predicate_t predicate = null;
    private fid_t fid = null;
    private term_t term0 = null;
    private qid_t qid = null;
    private Boolean hasNextSolution = null;

    public final Term goal() {
        return this.goal_;
    }

    public final String getContext() {
        return "user";
    }

    public Query(Term term) {
        LOGGER.setLevel(levelLog);
        if (!(term instanceof Atom) && !(term instanceof Compound)) {
            if (term instanceof Float) {
                throw new JPLException("a Query's goal must be an Atom or Compound (not a Float)");
            }
            if (term instanceof Integer) {
                throw new JPLException("a Query's goal must be an Atom or Compound (not an Integer)");
            }
            if (term instanceof Variable) {
                throw new JPLException("a Query's goal must be an Atom or Compound (not a Variable)");
            }
            throw new JPLException("a Query's goal must be an Atom or Compound");
        }
        this.goal_ = term;
    }

    public Query(String string) {
        this(Term.textToTerm(string));
    }

    public Query(String string, Term[] termArray) {
        this(Query.buildQueryTerm(string, termArray));
    }

    public Query(String string, Term term) {
        this(string, new Term[]{term});
    }

    private static Term buildQueryTerm(String string, Term[] termArray) {
        Term term = Term.textToTerm(string);
        if (term instanceof Atom) {
            return new Compound(string, termArray);
        }
        return term.putParams(termArray);
    }

    @Override
    public Iterator<Map<String, Term>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreSolutions();
    }

    @Override
    public Map<String, Term> next() {
        return this.nextSolution();
    }

    @Override
    public void remove() {
    }

    public final boolean hasMoreElements() {
        return this.hasMoreSolutions();
    }

    public final Object nextElement() {
        return this.nextSolution();
    }

    public final boolean isOpen() {
        return this.open;
    }

    public final long getEngine() {
        return this.engine.value;
    }

    public final boolean hasMoreSolutions() {
        if (this.hasNextSolution == null) {
            if (!this.open) {
                this.open();
            }
            this.hasNextSolution = this.fetchNextSolution();
        }
        return this.hasNextSolution;
    }

    public final void open() {
        Term term;
        String string;
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        this.engine = Prolog.thread_self() == -1 ? Prolog.attach_pool_engine() : Prolog.current_engine();
        if (this.goal_.hasFunctor(":", 2)) {
            if (!this.goal_.arg(1).isAtom()) {
                if (this.goal_.arg(1).isVariable()) {
                    throw new PrologException(Util.textParamsToTerm("error(instantiation_error,?)", new Term[]{this.goal_}));
                }
                throw new PrologException(Util.textParamsToTerm("error(type_error(atom,?),?)", new Term[]{this.goal_.arg(1), this.goal_}));
            }
            string = this.goal_.arg(1).name();
            term = this.goal_.arg(2);
        } else {
            string = "user";
            term = this.goal_;
        }
        this.predicate = Prolog.predicate(term.name(), term.arity(), string);
        this.fid = Prolog.open_foreign_frame();
        HashMap<String, term_t> hashMap = new HashMap<String, term_t>();
        this.term0 = Term.putArgs(term, hashMap);
        this.qid = Prolog.open_query(Prolog.new_module(Prolog.new_atom(string)), 8, this.predicate, this.term0);
        this.open = true;
        this.hasNextSolution = null;
    }

    public final void reset() {
        this.close();
        this.hasNextSolution = null;
    }

    private boolean fetchNextSolution() {
        if (Prolog.next_solution(this.qid)) {
            return true;
        }
        term_t term_t2 = Prolog.exception(this.qid);
        if (term_t2.value != 0L) {
            Term term = Term.getTerm(new HashMap<term_t, Variable>(), term_t2);
            this.close();
            throw new PrologException(term);
        }
        this.close();
        return false;
    }

    @Deprecated
    public final Map<String, Term> getSolution() {
        return this.nextSolution();
    }

    @Deprecated
    public final Map<String, Term> getSubstWithNameVars() {
        if (!this.open) {
            throw new JPLException("Query is not open");
        }
        if (this.fetchNextSolution()) {
            return this.getSolutionWithVarNames();
        }
        return null;
    }

    public final Map<String, Term> nextSolution() {
        if (this.hasMoreSolutions()) {
            this.hasNextSolution = null;
            return this.getCurrentSolutionBindings();
        }
        throw new NoSuchElementException("Query has already yielded all solutions");
    }

    private Map<String, Term> getCurrentSolutionBindings() {
        if (!this.open) {
            throw new JPLException("Query is not open, cannot retrive solution bindings.");
        }
        HashMap<String, Term> hashMap = new HashMap<String, Term>();
        Term.getSubsts(hashMap, new HashMap<term_t, Variable>(), this.goal_.args());
        return hashMap;
    }

    @Deprecated
    public final Map<String, Term> getSolutionWithVarNames() {
        if (!this.open) {
            throw new JPLException("Query is not open");
        }
        Term[] termArray = this.goal_.args();
        Term term = termArray[termArray.length - 1];
        String string = ((Variable)term).name;
        HashMap<String, Term> hashMap = new HashMap<String, Term>();
        HashMap<term_t, Variable> hashMap2 = new HashMap<term_t, Variable>();
        term.getSubst(hashMap, hashMap2);
        Term term2 = (Term)hashMap.get(string);
        HashMap<String, Term> hashMap3 = new HashMap<String, Term>();
        Map<term_t, Variable> map = Util.namevarsToMap(term2);
        for (int i = 0; i < termArray.length - 1; ++i) {
            termArray[i].getSubst(hashMap3, map);
        }
        return hashMap3;
    }

    public final void close() {
        if (!this.open) {
            return;
        }
        if (Prolog.thread_self() == -1) {
            throw new JPLException("no engine is attached to this thread");
        }
        if (Prolog.current_engine().value != this.engine.value) {
            throw new JPLException("this Query's engine is not that which is attached to this thread");
        }
        qid_t qid_t2 = Prolog.current_query();
        if (qid_t2.value != this.qid.value) {
            throw new JPLException("this Query (" + this.hashCode() + ":" + this.toString() + ") is not topmost (" + qid_t2.hashCode() + ":" + qid_t2.toString() + ") within its engine[" + this.engine.value + "]");
        }
        Prolog.close_query(this.qid);
        this.qid = null;
        Prolog.discard_foreign_frame(this.fid);
        this.fid = null;
        if (Prolog.current_query() == null && Prolog.current_engine_is_pool()) {
            Prolog.release_pool_engine();
        }
        this.open = false;
        this.engine = null;
    }

    public final Map<String, Term>[] allSolutions() {
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (this.hasNext()) {
            arrayList.add(this.next());
        }
        Map[] mapArray = new HashMap[0];
        return arrayList.toArray(mapArray);
    }

    public static final Map<String, Term>[] allSolutions(Term term) {
        return new Query(term).allSolutions();
    }

    public static final Map<String, Term>[] allSolutions(String string) {
        return new Query(string).allSolutions();
    }

    public static final Map<String, Term>[] allSolutions(String string, Term[] termArray) {
        return new Query(string, termArray).allSolutions();
    }

    public final Map<String, Term>[] nSolutions(long l) {
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        long l2 = 0L;
        while (l2++ < l && this.hasMoreSolutions()) {
            arrayList.add(this.next());
        }
        Map[] mapArray = new HashMap[0];
        return arrayList.toArray(mapArray);
    }

    public static final Map<String, Term>[] nSolutions(Term term, long l) {
        return new Query(term).nSolutions(l);
    }

    public static final Map<String, Term>[] nSolutions(String string, long l) {
        return new Query(string).nSolutions(l);
    }

    public static final Map<String, Term>[] nSolutions(String string, Term[] termArray, long l) {
        return new Query(string, termArray).nSolutions(l);
    }

    public final Map<String, Term> oneSolution() {
        Map<String, Term> map;
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        if (this.hasMoreSolutions()) {
            map = this.nextSolution();
            this.close();
        } else {
            map = null;
        }
        return map;
    }

    public static final Map<String, Term> oneSolution(Term term) {
        return new Query(term).oneSolution();
    }

    public static final Map<String, Term> oneSolution(String string) {
        return new Query(string).oneSolution();
    }

    public static final Map<String, Term> oneSolution(String string, Term[] termArray) {
        return new Query(string, termArray).oneSolution();
    }

    public final boolean hasSolution() {
        return this.oneSolution() != null;
    }

    public static final boolean hasSolution(Term term) {
        return new Query(term).hasSolution();
    }

    public static final boolean hasSolution(String string) {
        return new Query(string).hasSolution();
    }

    public static final boolean hasSolution(String string, Term[] termArray) {
        return new Query(string, termArray).hasSolution();
    }

    public String toString() {
        return this.goal_.name() + "( " + Term.toString(this.goal_.args()) + " )";
    }
}

