/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ResponseUtil;
import org.apache.tomcat.util.http.parser.AcceptEncoding;
import org.apache.tomcat.util.http.parser.TokenList;
import org.apache.tomcat.util.res.StringManager;

public class CompressionConfig {
    private static final Log log = LogFactory.getLog(CompressionConfig.class);
    private static final StringManager sm = StringManager.getManager(CompressionConfig.class);
    private int compressionLevel = 0;
    private Pattern noCompressionUserAgents = null;
    private String compressibleMimeType = "text/html,text/xml,text/plain,text/css,text/javascript,application/javascript,application/json,application/xml";
    private String[] compressibleMimeTypes = null;
    private int compressionMinSize = 2048;

    public void setCompression(String string) {
        if (string.equals("on")) {
            this.compressionLevel = 1;
        } else if (string.equals("force")) {
            this.compressionLevel = 2;
        } else if (string.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.setCompressionMinSize(Integer.parseInt(string));
                this.compressionLevel = 1;
            }
            catch (Exception exception) {
                this.compressionLevel = 0;
            }
        }
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public String getNoCompressionUserAgents() {
        if (this.noCompressionUserAgents == null) {
            return null;
        }
        return this.noCompressionUserAgents.toString();
    }

    public Pattern getNoCompressionUserAgentsPattern() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String string) {
        this.noCompressionUserAgents = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public String getCompressibleMimeType() {
        return this.compressibleMimeType;
    }

    public void setCompressibleMimeType(String string) {
        this.compressibleMimeType = string;
        this.compressibleMimeTypes = null;
    }

    public String[] getCompressibleMimeTypes() {
        String[] stringArray = this.compressibleMimeTypes;
        if (stringArray != null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.compressibleMimeType, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            if (string.length() <= 0) continue;
            arrayList.add(string);
        }
        stringArray = arrayList.toArray(new String[0]);
        this.compressibleMimeTypes = stringArray;
        return stringArray;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int n) {
        this.compressionMinSize = n;
    }

    public boolean useCompression(Request request, Response response) {
        Object object;
        Object object2;
        Object object3;
        String string;
        if (this.compressionLevel == 0) {
            return false;
        }
        MimeHeaders mimeHeaders = response.getMimeHeaders();
        MessageBytes messageBytes = mimeHeaders.getValue("Content-Encoding");
        if (messageBytes != null) {
            HashSet<String> hashSet = new HashSet<String>();
            try {
                TokenList.parseTokenList(mimeHeaders.values("Content-Encoding"), hashSet);
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("compressionConfig.ContentEncodingParseFail"), (Throwable)iOException);
                return false;
            }
            if (hashSet.contains("gzip") || hashSet.contains("br")) {
                return false;
            }
        }
        if (this.compressionLevel != 2) {
            long l = response.getContentLengthLong();
            if (l != -1L && l < (long)this.compressionMinSize) {
                return false;
            }
            String[] stringArray = this.getCompressibleMimeTypes();
            if (stringArray != null && !CompressionConfig.startsWithStringArray(stringArray, response.getContentType())) {
                return false;
            }
        }
        if ((string = mimeHeaders.getHeader("ETag")) != null && !string.trim().startsWith("W/")) {
            return false;
        }
        ResponseUtil.addVaryFieldName(mimeHeaders, "accept-encoding");
        Enumeration<String> enumeration = request.getMimeHeaders().values("accept-encoding");
        boolean bl = false;
        block4: while (!bl && enumeration.hasMoreElements()) {
            object3 = null;
            try {
                object3 = AcceptEncoding.parse(new StringReader(enumeration.nextElement()));
            }
            catch (IOException iOException) {
                return false;
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (AcceptEncoding)object2.next();
                if (!"gzip".equalsIgnoreCase(((AcceptEncoding)object).getEncoding())) continue;
                bl = true;
                continue block4;
            }
        }
        if (!bl) {
            return false;
        }
        if (this.compressionLevel != 2 && (object3 = this.noCompressionUserAgents) != null && (object2 = request.getMimeHeaders().getValue("user-agent")) != null && ((Pattern)object3).matcher((CharSequence)(object = object2.toString())).matches()) {
            return false;
        }
        response.setContentLength(-1L);
        mimeHeaders.setValue("Content-Encoding").setString("gzip");
        return true;
    }

    private static boolean startsWithStringArray(String[] stringArray, String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : stringArray) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

