"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCancellationTokenHost = void 0;
const vscode = require("vscode-languageserver");
function createCancellationTokenHost(_cancellationPipeName) {
    if (_cancellationPipeName === undefined) {
        return {
            createCancellationToken(original) {
                return original;
            },
            getMtime() {
                return -1;
            }
        };
    }
    const cancellationPipeName = _cancellationPipeName;
    const fs = require('fs');
    return {
        createCancellationToken,
        getMtime,
    };
    function createCancellationToken(original) {
        const mtime = getMtime();
        const token = {
            get isCancellationRequested() {
                if (original.isCancellationRequested) {
                    return true;
                }
                return getMtime() !== mtime;
            },
            onCancellationRequested: vscode.Event.None,
        };
        return token;
    }
    function getMtime() {
        try {
            const stat = fs.statSync(cancellationPipeName, { throwIfNoEntry: false });
            return stat?.mtime.valueOf() ?? -1;
        }
        catch {
            return -1;
        }
    }
}
exports.createCancellationTokenHost = createCancellationTokenHost;
//# sourceMappingURL=cancellationPipe.js.map