import type { FileStat, FileType } from '@volar/language-service';
export interface IDtsHost {
    stat(uri: string): Promise<FileStat | undefined>;
    readFile(fileName: string): Promise<string | undefined>;
    readDirectory(dirName: string): Promise<[string, FileType][]>;
}
export declare function createJsDelivrDtsHost(versions?: Record<string, string>, onFetch?: (fileName: string, text: string) => void): DtsHost;
declare class DtsHost implements IDtsHost {
    private fetchText;
    private flat;
    fetchResults: Map<string, Promise<string | undefined>>;
    flatResults: Map<string, Promise<string[]>>;
    constructor(fetchText: (path: string) => Promise<string | undefined>, flat: (pkg: string) => Promise<string[]>);
    stat(fileName: string): Promise<{
        type: number;
        ctime: number;
        mtime: number;
        size: number;
    } | undefined>;
    readDirectory(dirName: string): Promise<[string, FileType][]>;
    readFile(fileName: string): Promise<string | undefined>;
    fetchFile(fileName: string): Promise<string | undefined>;
    valid(fileName: string): Promise<boolean>;
}
export declare function getPackageNameOfDtsPath(path: string): string | undefined;
export {};
