export type AqaraFP1RegionZone = {
    x: number;
    y: number;
};
export function buffer2DataObject(meta: any, model: any, buffer: any): {};
export function numericAttributes2Payload(msg: any, meta: any, model: any, options: any, dataObject: any): Promise<{
    detection_period: any;
    voltage: any;
    battery: any;
    power_outage_count: number;
    device_temperature: any;
    mode_switch: any;
    switch_type: any;
    illuminance: any;
    illuminance_lux: any;
    click_mode: any;
    occupancy: any;
    temperature: any;
    contact: boolean;
    water_leak: boolean;
    smoke_density: any;
    state: any;
    humidity: any;
    presence: any;
    state_right: string;
    pressure: any;
    presence_event: any;
    motion_sensitivity: any;
    monitoring_mode: any;
    approach_distance: any;
    detection_interval: any;
    trigger_indicator: boolean;
    position: any;
    energy: any;
    consumption: any;
    current: any;
    power: any;
    gas_sensitivity: any;
    detection_distance: any;
    gas: boolean;
    smoke: boolean;
    gas_density: any;
    smoke_density_dbm: any;
    test: boolean;
    buzzer_manual_mute: boolean;
    heartbeat_indicator: boolean;
    linkage_alarm: boolean;
    flip_indicator_light: string;
    operation_mode: any;
    display_unit: any;
    buzzer_manual_alarm: boolean;
    battery_cover: any;
    action: any;
    side: any;
    linkage_alarm_state: boolean;
    button_lock: string;
    power_outage_memory: boolean;
    auto_off: boolean;
    led_disabled_night: boolean;
    consumer_connected: boolean;
    overload_protection: any;
    button_switch_mode: string;
    hand_open: boolean;
    options: any;
    charging_status: boolean;
    target_position: any;
    motor_state: any;
    running: boolean;
    hooks_lock: any;
    hooks_state: any;
    dimmer_mode: any;
}>;
export function numericAttributes2Options(definition: any): exposes.Numeric[];
export namespace VOCKQJK11LMDisplayUnit {
    const mgm3_celsius: number;
    const ppb_celsius: number;
    const mgm3_fahrenheit: number;
    const ppb_fahrenheit: number;
}
export namespace fp1 {
    export { fp1Constants as constants };
    export { fp1Mappers as mappers };
    export function encodeXCellsDefinition(xCells: Set<number>): number;
    export function encodeXCellIdx(cellXIdx: number): number;
    export function parseAqaraFp1RegionDeleteInput(input: unknown): {
        isSuccess: false;
        error: {
            reason: string;
        };
    } | {
        /** @type true */
        isSuccess: true;
        payload: {
            command: {
                region_id: number;
            };
        };
    };
    export function parseAqaraFp1RegionUpsertInput(input: unknown): {
        isSuccess: false;
        error: {
            reason: string;
        };
    } | {
        /** @type true */
        isSuccess: true;
        payload: {
            command: {
                region_id: number;
                zones: AqaraFP1RegionZone[];
            };
        };
    };
    export function isAqaraFp1RegionId(value: unknown): value is number;
    export function isAqaraFp1RegionZoneDefinition(value: unknown): value is AqaraFP1RegionZone;
    export function failure<ErrorType extends Record<string, unknown>>(error: ErrorType): {
        isSuccess: false;
        error: ErrorType;
    };
}
export namespace trv {
    function decodeFirmwareVersionString(value: any): string;
    function decodePreset(value: any): {
        setup: boolean;
        preset: any;
    };
    function decodeHeartbeat(meta: any, model: any, messageBuffer: any): {};
    /**
     * Decode a Zigbee schedule configuration message into a schedule configuration object.
     * @param {Buffer} buffer
     * @return {TrvScheduleConfig}
     */
    function decodeSchedule(buffer: Buffer): TrvScheduleConfig;
    /**
     * @param {TrvScheduleConfig} schedule
     * @return {void}
     */
    function validateSchedule(schedule: TrvScheduleConfig): void;
    /**
     * Encodes a schedule object into Zigbee message format.
     * @param {TrvScheduleConfig} schedule
     * @return {Buffer}
     */
    function encodeSchedule(schedule: TrvScheduleConfig): Buffer;
    /**
     * Converts a schedule config object into a configuration string.
     * @param {TrvScheduleConfig} schedule
     * @return {string}
     */
    function stringifySchedule(schedule: TrvScheduleConfig): string;
    /**
     * Parses a schedule configuration string into a configuration object.
     * @param {string} stringifiedSchedule
     * @return {TrvScheduleConfig}
     */
    function parseSchedule(stringifiedSchedule: string): TrvScheduleConfig;
}
import exposes = require("../lib/exposes");
declare namespace fp1Constants {
    const region_event_key: number;
    namespace region_event_types {
        const Enter: number;
        const Leave: number;
        const Occupied: number;
        const Unoccupied: number;
    }
    const region_config_write_attribute: number;
    const region_config_write_attribute_type: number;
    namespace region_config_cmds {
        export const create: number;
        export const modify: number;
        const _delete: number;
        export { _delete as delete };
    }
    const region_config_regionId_min: number;
    const region_config_regionId_max: number;
    const region_config_zoneY_min: number;
    const region_config_zoneY_max: number;
    const region_config_zoneX_min: number;
    const region_config_zoneX_max: number;
    const region_config_cmd_suffix_upsert: number;
    const region_config_cmd_suffix_delete: number;
}
declare namespace fp1Mappers {
    namespace aqara_fp1 {
        const region_event_type_names: {
            [x: number]: string;
        };
    }
}
export declare const manufacturerCode: number;
export {};
//# sourceMappingURL=xiaomi.d.ts.map