/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DecimalNumberField
extends JTextField {
    private final boolean _allowNegative;
    private final NumberFormat _localFormatter;

    public DecimalNumberField() {
        this(false);
    }

    public DecimalNumberField(boolean bl) {
        super(6);
        this._allowNegative = bl;
        this.setDocument(new DecimalNumberDocument(bl));
        this._localFormatter = NumberFormat.getNumberInstance();
        if (this._localFormatter instanceof DecimalFormat) {
            ((DecimalFormat)this._localFormatter).applyPattern("0.00");
        }
    }

    @Override
    public String getText() {
        throw new IllegalArgumentException("Should not be called, use getValue instead");
    }

    public double getValue() {
        double d = 0.0;
        try {
            d = this._localFormatter.parse(super.getText()).doubleValue();
        }
        catch (NumberFormatException | ParseException exception) {}
        if (!this._allowNegative) {
            d = Math.max(0.0, d);
        }
        return d;
    }

    public boolean isEmpty() {
        return super.getText().isEmpty();
    }

    public void setValue(double d) {
        double d2 = this._allowNegative ? d : Math.max(0.0, d);
        this.setText(this._localFormatter.format(d2));
    }

    public void setValue(String string) {
        try {
            this.setValue(Double.parseDouble(string));
        }
        catch (Exception exception) {
            this.setValue(0.0);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width < 50) {
            dimension.width = 50;
        }
        return dimension;
    }

    protected static class DecimalNumberDocument
    extends PlainDocument {
        private final boolean _allowNegative;
        private final char _decimalPoint;
        private static final int MAX_LENGTH = 10;

        DecimalNumberDocument(boolean bl) {
            this._allowNegative = bl;
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            this._decimalPoint = decimalFormatSymbols.getDecimalSeparator();
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.getLength() > 10) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (!(!this._allowNegative && c == '-' || c != this._decimalPoint && "01234567890-".indexOf(c) < 0)) {
                    stringBuilder.append(c);
                }
                ++n2;
            }
            super.insertString(n, stringBuilder.toString(), attributeSet);
        }
    }
}

