/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.phase;

import java.util.List;
import org.opensearch.painless.AnalyzerCaster;
import org.opensearch.painless.Location;
import org.opensearch.painless.ScriptClassInfo;
import org.opensearch.painless.lookup.PainlessCast;
import org.opensearch.painless.lookup.PainlessLookupUtility;
import org.opensearch.painless.lookup.def;
import org.opensearch.painless.node.AExpression;
import org.opensearch.painless.node.AStatement;
import org.opensearch.painless.node.SBlock;
import org.opensearch.painless.node.SExpression;
import org.opensearch.painless.node.SFunction;
import org.opensearch.painless.node.SReturn;
import org.opensearch.painless.phase.DefaultSemanticAnalysisPhase;
import org.opensearch.painless.symbol.Decorations;
import org.opensearch.painless.symbol.FunctionTable;
import org.opensearch.painless.symbol.ScriptScope;
import org.opensearch.painless.symbol.SemanticScope;
import org.opensearch.repackage.org.objectweb.asm.commons.Method;

public class PainlessSemanticAnalysisPhase
extends DefaultSemanticAnalysisPhase {
    protected String functionName = "";

    @Override
    public void visitFunction(SFunction userFunctionNode, ScriptScope scriptScope) {
        this.functionName = userFunctionNode.getFunctionName();
        if ("execute".equals(this.functionName)) {
            Class<?> typeParameter;
            int i;
            ScriptClassInfo scriptClassInfo = scriptScope.getScriptClassInfo();
            FunctionTable.LocalFunction localFunction = scriptScope.getFunctionTable().getFunction(this.functionName, scriptClassInfo.getExecuteArguments().size());
            List<Class<?>> typeParameters = localFunction.getTypeParameters();
            SemanticScope.FunctionScope functionScope = SemanticScope.newFunctionScope(scriptScope, localFunction.getReturnType());
            for (i = 0; i < typeParameters.size(); ++i) {
                typeParameter = localFunction.getTypeParameters().get(i);
                String parameterName = scriptClassInfo.getExecuteArguments().get(i).getName();
                functionScope.defineVariable(userFunctionNode.getLocation(), typeParameter, parameterName, false);
            }
            for (i = 0; i < scriptClassInfo.getGetMethods().size(); ++i) {
                typeParameter = scriptClassInfo.getGetReturns().get(i);
                Method method = scriptClassInfo.getGetMethods().get(i);
                Object parameterName = method.getName().substring(3);
                parameterName = Character.toLowerCase(((String)parameterName).charAt(0)) + ((String)parameterName).substring(1);
                functionScope.defineVariable(userFunctionNode.getLocation(), typeParameter, (String)parameterName, false);
            }
            SBlock userBlockNode = userFunctionNode.getBlockNode();
            if (userBlockNode.getStatementNodes().isEmpty()) {
                throw userFunctionNode.createError(new IllegalArgumentException("invalid function definition: found no statements for function [" + this.functionName + "] with [" + typeParameters.size() + "] parameters"));
            }
            functionScope.setCondition(userBlockNode, Decorations.LastSource.class);
            this.visit(userBlockNode, functionScope.newLocalScope());
            boolean methodEscape = functionScope.getCondition(userBlockNode, Decorations.MethodEscape.class);
            if (methodEscape) {
                functionScope.setCondition(userFunctionNode, Decorations.MethodEscape.class);
            }
            scriptScope.setUsedVariables(functionScope.getUsedVariables());
        } else {
            super.visitFunction(userFunctionNode, scriptScope);
        }
        this.functionName = "";
    }

    @Override
    public void visitExpression(SExpression userExpressionNode, SemanticScope semanticScope) {
        boolean rtn;
        Class<?> rtnType = semanticScope.getReturnType();
        boolean isVoid = rtnType == Void.TYPE;
        boolean lastSource = semanticScope.getCondition(userExpressionNode, Decorations.LastSource.class);
        AExpression userStatementNode = userExpressionNode.getStatementNode();
        if (lastSource && !isVoid) {
            semanticScope.setCondition(userStatementNode, Decorations.Read.class);
        }
        this.checkedVisit(userStatementNode, semanticScope);
        Class<?> expressionValueType = semanticScope.getDecoration(userStatementNode, Decorations.ValueType.class).getValueType();
        boolean bl = rtn = lastSource && !isVoid && expressionValueType != Void.TYPE;
        if (rtn) {
            semanticScope.putDecoration(userStatementNode, new Decorations.TargetType(rtnType));
            semanticScope.setCondition(userStatementNode, Decorations.Internal.class);
            if ("execute".equals(this.functionName)) {
                this.decorateWithCastForReturn(userStatementNode, userExpressionNode, semanticScope, semanticScope.getScriptScope().getScriptClassInfo());
            } else {
                this.decorateWithCast(userStatementNode, semanticScope);
            }
            semanticScope.setCondition(userExpressionNode, Decorations.MethodEscape.class);
            semanticScope.setCondition(userExpressionNode, Decorations.LoopEscape.class);
            semanticScope.setCondition(userExpressionNode, Decorations.AllEscape.class);
        }
    }

    @Override
    public void visitReturn(SReturn userReturnNode, SemanticScope semanticScope) {
        AExpression userValueNode = userReturnNode.getValueNode();
        if (userValueNode == null) {
            if (semanticScope.getReturnType() != Void.TYPE) {
                throw userReturnNode.createError(new ClassCastException("cannot cast from [" + semanticScope.getReturnCanonicalTypeName() + "] to [" + PainlessLookupUtility.typeToCanonicalTypeName(Void.TYPE) + "]"));
            }
        } else {
            semanticScope.setCondition(userValueNode, Decorations.Read.class);
            semanticScope.putDecoration(userValueNode, new Decorations.TargetType(semanticScope.getReturnType()));
            semanticScope.setCondition(userValueNode, Decorations.Internal.class);
            this.checkedVisit(userValueNode, semanticScope);
            if ("execute".equals(this.functionName)) {
                this.decorateWithCastForReturn(userValueNode, userReturnNode, semanticScope, semanticScope.getScriptScope().getScriptClassInfo());
            } else {
                this.decorateWithCast(userValueNode, semanticScope);
            }
        }
        semanticScope.setCondition(userReturnNode, Decorations.MethodEscape.class);
        semanticScope.setCondition(userReturnNode, Decorations.LoopEscape.class);
        semanticScope.setCondition(userReturnNode, Decorations.AllEscape.class);
    }

    public void decorateWithCastForReturn(AExpression userExpressionNode, AStatement parent, SemanticScope semanticScope, ScriptClassInfo scriptClassInfo) {
        boolean isInternalCast;
        boolean isExplicitCast;
        PainlessCast painlessCast;
        Location location = userExpressionNode.getLocation();
        Class<?> valueType = semanticScope.getDecoration(userExpressionNode, Decorations.ValueType.class).getValueType();
        Class<?> targetType = semanticScope.getDecoration(userExpressionNode, Decorations.TargetType.class).getTargetType();
        if (valueType == def.class) {
            if (scriptClassInfo.defConverter != null) {
                semanticScope.putDecoration(parent, new Decorations.Converter(scriptClassInfo.defConverter));
                return;
            }
        } else {
            for (FunctionTable.LocalFunction converter : scriptClassInfo.converters) {
                try {
                    PainlessCast painlessCast2 = AnalyzerCaster.getLegalCast(location, valueType, converter.getTypeParameters().get(0), false, true);
                    if (painlessCast2 != null) {
                        semanticScope.putDecoration(userExpressionNode, new Decorations.ExpressionPainlessCast(painlessCast2));
                    }
                    semanticScope.putDecoration(parent, new Decorations.Converter(converter));
                    return;
                }
                catch (ClassCastException classCastException) {
                }
            }
        }
        if ((painlessCast = AnalyzerCaster.getLegalCast(location, valueType, targetType, isExplicitCast = semanticScope.getCondition(userExpressionNode, Decorations.Explicit.class), isInternalCast = semanticScope.getCondition(userExpressionNode, Decorations.Internal.class))) != null) {
            semanticScope.putDecoration(userExpressionNode, new Decorations.ExpressionPainlessCast(painlessCast));
        }
    }
}

