/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.allocator;

import com.carrotsearch.hppc.ObjectIntHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.RoutingNodes;
import org.opensearch.cluster.routing.RoutingPool;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.opensearch.cluster.routing.allocation.MoveDecision;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.allocator.ShardsBalancer;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.opensearch.common.Randomness;

public final class RemoteShardsBalancer
extends ShardsBalancer {
    private final Logger logger;
    private final RoutingAllocation allocation;
    private final RoutingNodes routingNodes;

    public RemoteShardsBalancer(Logger logger, RoutingAllocation allocation) {
        this.logger = logger;
        this.allocation = allocation;
        this.routingNodes = allocation.routingNodes();
    }

    @Override
    void allocateUnassigned() {
        this.unassignIgnoredRemoteShards(this.allocation);
        if (this.routingNodes.unassigned().isEmpty()) {
            this.logger.debug("No unassigned remote shards found.");
            return;
        }
        Queue<RoutingNode> nodeQueue = this.getShuffledRemoteNodes();
        if (nodeQueue.isEmpty()) {
            this.logger.debug("No remote searcher nodes available for unassigned remote shards.");
            this.failUnattemptedShards();
            return;
        }
        Map<String, UnassignedIndexShards> unassignedShardMap = this.groupUnassignedShardsByIndex();
        this.allocateUnassignedPrimaries(nodeQueue, unassignedShardMap);
        this.allocateUnassignedReplicas(nodeQueue, unassignedShardMap);
        this.ignoreRemainingShards(unassignedShardMap);
    }

    @Override
    void moveShards() {
        ArrayDeque<RoutingNode> eligibleNodes = new ArrayDeque<RoutingNode>();
        ArrayDeque<RoutingNode> excludedNodes = new ArrayDeque<RoutingNode>();
        this.classifyNodesForShardMovement(eligibleNodes, excludedNodes);
        if (excludedNodes.isEmpty()) {
            this.logger.debug("No excluded nodes found. Returning...");
            return;
        }
        block0: while (!eligibleNodes.isEmpty() && !excludedNodes.isEmpty()) {
            RoutingNode sourceNode = (RoutingNode)excludedNodes.poll();
            for (ShardRouting ineligibleShard : sourceNode) {
                if (!ineligibleShard.started() || !RoutingPool.REMOTE_CAPABLE.equals((Object)RoutingPool.getShardPool(ineligibleShard, this.allocation))) continue;
                if (eligibleNodes.isEmpty()) continue block0;
                this.tryShardMovementToEligibleNode(eligibleNodes, ineligibleShard);
            }
        }
    }

    private void classifyNodesForShardMovement(Queue<RoutingNode> eligibleNodes, Queue<RoutingNode> excludedNodes) {
        List<RoutingNode> remoteRoutingNodes = this.getRemoteRoutingNodes();
        int throttledNodeCount = 0;
        for (RoutingNode node : remoteRoutingNodes) {
            Decision nodeDecision = this.allocation.deciders().canAllocateAnyShardToNode(node, this.allocation);
            if (nodeDecision.type() == Decision.Type.NO) {
                excludedNodes.add(node);
            } else if (nodeDecision.type() == Decision.Type.YES) {
                eligibleNodes.add(node);
            } else {
                ++throttledNodeCount;
            }
            this.logger.debug("Excluded Node Count: [{}], Eligible Node Count: [{}], Throttled Node Count: [{}]", (Object)excludedNodes.size(), (Object)eligibleNodes.size(), (Object)throttledNodeCount);
        }
    }

    private void tryShardMovementToEligibleNode(Queue<RoutingNode> eligibleNodes, ShardRouting shard) {
        HashSet<String> nodesCheckedForShard = new HashSet<String>();
        while (!eligibleNodes.isEmpty()) {
            Decision nodeLevelDecision;
            RoutingNode targetNode = eligibleNodes.poll();
            Decision currentShardDecision = this.allocation.deciders().canAllocate(shard, targetNode, this.allocation);
            if (currentShardDecision.type() == Decision.Type.YES) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Moving shard: {} from node: [{}] to node: [{}]", (Object)this.shardShortSummary(shard), (Object)shard.currentNodeId(), (Object)targetNode.nodeId());
                }
                this.routingNodes.relocateShard(shard, targetNode.nodeId(), this.allocation.clusterInfo().getShardSize(shard, -1L), this.allocation.changes());
                eligibleNodes.offer(targetNode);
                break;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Cannot move shard: {} to node: [{}]. Decisions: [{}]", (Object)this.shardShortSummary(shard), (Object)targetNode.nodeId(), currentShardDecision.getDecisions());
            }
            if ((nodeLevelDecision = this.allocation.deciders().canAllocateAnyShardToNode(targetNode, this.allocation)).type() == Decision.Type.YES) {
                this.logger.debug("Node: [{}] can still accept shards. Adding it back to the queue.", (Object)targetNode.nodeId());
                eligibleNodes.offer(targetNode);
                nodesCheckedForShard.add(targetNode.nodeId());
            } else {
                this.logger.debug("Node: [{}] cannot accept any more shards. Removing it from queue.", (Object)targetNode.nodeId());
            }
            if (!eligibleNodes.stream().allMatch(rn -> nodesCheckedForShard.contains(rn.nodeId()))) continue;
            break;
        }
    }

    @Override
    void balance() {
        List<RoutingNode> remoteRoutingNodes = this.getRemoteRoutingNodes();
        this.logger.trace("Performing balancing for remote shards.");
        if (remoteRoutingNodes.isEmpty()) {
            this.logger.info("No eligible remote nodes found to perform balancing");
            return;
        }
        ObjectIntHashMap<String> nodePrimaryShardCount = this.calculateNodePrimaryShardCount(remoteRoutingNodes);
        int totalPrimaryShardCount = Arrays.stream(nodePrimaryShardCount.values).sum();
        int avgPrimaryPerNode = ((totalPrimaryShardCount += this.routingNodes.unassigned().getNumPrimaries()) + this.routingNodes.size() - 1) / this.routingNodes.size();
        ArrayDeque<RoutingNode> sourceNodes = new ArrayDeque<RoutingNode>();
        ArrayDeque<RoutingNode> targetNodes = new ArrayDeque<RoutingNode>();
        for (RoutingNode node : remoteRoutingNodes) {
            if (nodePrimaryShardCount.get((Object)node.nodeId()) > avgPrimaryPerNode) {
                sourceNodes.add(node);
                continue;
            }
            if (nodePrimaryShardCount.get((Object)node.nodeId()) >= avgPrimaryPerNode) continue;
            targetNodes.add(node);
        }
        while (!sourceNodes.isEmpty() && !targetNodes.isEmpty()) {
            RoutingNode sourceNode = (RoutingNode)sourceNodes.poll();
            this.tryRebalanceNode(sourceNode, targetNodes, avgPrimaryPerNode, nodePrimaryShardCount);
        }
    }

    private ObjectIntHashMap<String> calculateNodePrimaryShardCount(List<RoutingNode> remoteRoutingNodes) {
        ObjectIntHashMap primaryShardCount = new ObjectIntHashMap();
        for (RoutingNode node : remoteRoutingNodes) {
            int totalPrimaryShardsPerNode = 0;
            for (ShardRouting shard : node) {
                if (!RoutingPool.REMOTE_CAPABLE.equals((Object)RoutingPool.getShardPool(shard, this.allocation)) || !shard.primary() || !shard.initializing() && !shard.started()) continue;
                ++totalPrimaryShardsPerNode;
            }
            primaryShardCount.put((Object)node.nodeId(), totalPrimaryShardsPerNode);
        }
        return primaryShardCount;
    }

    @Override
    AllocateUnassignedDecision decideAllocateUnassigned(ShardRouting shardRouting) {
        throw new UnsupportedOperationException("remote shards balancer does not support decision operations");
    }

    @Override
    MoveDecision decideMove(ShardRouting shardRouting) {
        throw new UnsupportedOperationException("remote shards balancer does not support decision operations");
    }

    @Override
    MoveDecision decideRebalance(ShardRouting shardRouting) {
        throw new UnsupportedOperationException("remote shards balancer does not support decision operations");
    }

    public Map<String, UnassignedIndexShards> groupUnassignedShardsByIndex() {
        HashMap<String, UnassignedIndexShards> unassignedShardMap = new HashMap<String, UnassignedIndexShards>();
        for (ShardRouting shard : this.routingNodes.unassigned().drain()) {
            String index = shard.getIndexName();
            if (!RoutingPool.REMOTE_CAPABLE.equals((Object)RoutingPool.getShardPool(shard, this.allocation))) {
                this.routingNodes.unassigned().add(shard);
                continue;
            }
            if (!unassignedShardMap.containsKey(index)) {
                unassignedShardMap.put(index, new UnassignedIndexShards());
            }
            unassignedShardMap.get(index).addShard(shard);
        }
        return unassignedShardMap;
    }

    private void unassignIgnoredRemoteShards(RoutingAllocation routingAllocation) {
        RoutingNodes.UnassignedShards unassignedShards = routingAllocation.routingNodes().unassigned();
        for (ShardRouting shard : unassignedShards.drainIgnored()) {
            RoutingPool pool = RoutingPool.getShardPool(shard, routingAllocation);
            if (pool == RoutingPool.REMOTE_CAPABLE && shard.unassigned() && (shard.primary() || !shard.unassignedInfo().isDelayed())) {
                ShardRouting unassignedShard = shard;
                if (shard.primary() && !RecoverySource.Type.SNAPSHOT.equals((Object)shard.recoverySource().getType())) {
                    unassignedShard = shard.updateUnassigned(shard.unassignedInfo(), RecoverySource.EmptyStoreRecoverySource.INSTANCE);
                }
                unassignedShards.add(unassignedShard);
                continue;
            }
            unassignedShards.ignoreShard(shard, shard.unassignedInfo().getLastAllocationStatus(), routingAllocation.changes());
        }
    }

    private void allocateUnassignedPrimaries(Queue<RoutingNode> nodeQueue, Map<String, UnassignedIndexShards> unassignedShardMap) {
        this.allocateUnassignedShards(true, nodeQueue, unassignedShardMap);
    }

    private void allocateUnassignedReplicas(Queue<RoutingNode> nodeQueue, Map<String, UnassignedIndexShards> unassignedShardMap) {
        this.allocateUnassignedShards(false, nodeQueue, unassignedShardMap);
    }

    private void ignoreRemainingShards(Map<String, UnassignedIndexShards> unassignedShardMap) {
        for (UnassignedIndexShards indexShards : unassignedShardMap.values()) {
            for (ShardRouting shard : indexShards.getPrimaries()) {
                this.routingNodes.unassigned().ignoreShard(shard, UnassignedInfo.AllocationStatus.DECIDERS_NO, this.allocation.changes());
            }
            for (ShardRouting shard : indexShards.getReplicas()) {
                this.routingNodes.unassigned().ignoreShard(shard, UnassignedInfo.AllocationStatus.DECIDERS_NO, this.allocation.changes());
            }
        }
    }

    private void allocateUnassignedShards(boolean primaries, Queue<RoutingNode> nodeQueue, Map<String, UnassignedIndexShards> unassignedShardMap) {
        this.logger.debug("Allocating unassigned {}. Nodes available in queue: [{}]", (Object)(primaries ? "primaries" : "replicas"), (Object)nodeQueue.size());
        for (String index : unassignedShardMap.keySet()) {
            Queue<ShardRouting> shardsToAllocate;
            if (nodeQueue.isEmpty()) break;
            UnassignedIndexShards indexShards = unassignedShardMap.get(index);
            Queue<ShardRouting> queue = shardsToAllocate = primaries ? indexShards.getPrimaries() : indexShards.getReplicas();
            if (shardsToAllocate.isEmpty()) continue;
            this.logger.debug("Allocating shards for index: [{}]", (Object)index);
            while (!shardsToAllocate.isEmpty() && !nodeQueue.isEmpty()) {
                ShardRouting shard = shardsToAllocate.poll();
                if (shard.assignedToNode()) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Shard: {} already assigned to node: [{}]", (Object)this.shardShortSummary(shard), (Object)shard.currentNodeId());
                    continue;
                }
                Decision shardLevelDecision = this.allocation.deciders().canAllocate(shard, this.allocation);
                if (shardLevelDecision.type() == Decision.Type.NO) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Ignoring shard: [{}] as is cannot be allocated to any node. Shard level decisions: [{}][{}].", (Object)this.shardShortSummary(shard), shardLevelDecision.getDecisions(), (Object)shardLevelDecision.getExplanation());
                    }
                    this.routingNodes.unassigned().ignoreShard(shard, UnassignedInfo.AllocationStatus.DECIDERS_NO, this.allocation.changes());
                    continue;
                }
                this.tryAllocateUnassignedShard(nodeQueue, shard);
            }
        }
    }

    private void tryAllocateUnassignedShard(Queue<RoutingNode> nodeQueue, ShardRouting shard) {
        boolean allocated = false;
        boolean throttled = false;
        HashSet<String> nodesCheckedForShard = new HashSet<String>();
        while (!nodeQueue.isEmpty()) {
            RoutingNode node = nodeQueue.poll();
            Decision allocateDecision = this.allocation.deciders().canAllocate(shard, node, this.allocation);
            nodesCheckedForShard.add(node.nodeId());
            if (allocateDecision.type() == Decision.Type.YES) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Assigned shard [{}] to [{}]", (Object)this.shardShortSummary(shard), (Object)node.nodeId());
                }
                long shardSize = DiskThresholdDecider.getExpectedShardSize(shard, -1L, this.allocation.clusterInfo(), this.allocation.snapshotShardSizeInfo(), this.allocation.metadata(), this.allocation.routingTable());
                ShardRouting initShard = this.routingNodes.initializeShard(shard, node.nodeId(), null, shardSize, this.allocation.changes());
                nodeQueue.offer(node);
                allocated = true;
                break;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Cannot allocate shard: {} on node [{}]. Decisions: [{}]", (Object)this.shardShortSummary(shard), (Object)node.nodeId(), allocateDecision.getDecisions());
            }
            throttled = throttled || allocateDecision.type() == Decision.Type.THROTTLE;
            Decision nodeLevelDecision = this.allocation.deciders().canAllocateAnyShardToNode(node, this.allocation);
            if (nodeLevelDecision.type() == Decision.Type.YES) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Node: [{}] can still accept shards, retaining it in queue - [{}]", (Object)node.nodeId(), nodeLevelDecision.getDecisions());
                }
                nodeQueue.offer(node);
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("Cannot allocate any shard to node: [{}]. Removing from queue. Node level decisions: [{}],[{}]", (Object)node.nodeId(), nodeLevelDecision.getDecisions(), (Object)nodeLevelDecision.getExplanation());
            }
            if (!nodeQueue.stream().allMatch(rn -> nodesCheckedForShard.contains(rn.nodeId()))) continue;
            throttled = true;
            break;
        }
        if (!allocated) {
            UnassignedInfo.AllocationStatus status = throttled ? UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED : UnassignedInfo.AllocationStatus.DECIDERS_NO;
            this.routingNodes.unassigned().ignoreShard(shard, status, this.allocation.changes());
        }
    }

    private void tryRebalanceNode(RoutingNode sourceNode, ArrayDeque<RoutingNode> targetNodes, int avgPrimary, ObjectIntHashMap<String> primaryCount) {
        long shardsToBalance = primaryCount.get((Object)sourceNode.nodeId()) - avgPrimary;
        assert (shardsToBalance >= 0L) : "Shards to balance should be greater than 0, but found negative";
        Iterator<ShardRouting> shardIterator = sourceNode.copyShards().iterator();
        HashSet<String> nodesCheckedForRelocation = new HashSet<String>();
        block0: while (shardsToBalance > 0L && shardIterator.hasNext() && !targetNodes.isEmpty()) {
            ShardRouting shard = shardIterator.next();
            if (!shard.started() || !shard.primary() || !RoutingPool.REMOTE_CAPABLE.equals((Object)RoutingPool.getShardPool(shard, this.allocation))) continue;
            while (!targetNodes.isEmpty()) {
                RoutingNode targetNode = targetNodes.poll();
                if (primaryCount.get((Object)targetNode.nodeId()) >= avgPrimary) {
                    this.logger.trace("Avg shard limit reached for node: [{}]. Removing from queue.", (Object)targetNode.nodeId());
                    continue;
                }
                Decision rebalanceDecision = this.tryRelocateShard(shard, targetNode);
                if (rebalanceDecision.type() == Decision.Type.YES) {
                    --shardsToBalance;
                    primaryCount.addTo((Object)targetNode.nodeId(), 1);
                    targetNodes.offer(targetNode);
                    continue block0;
                }
                Decision nodeDecision = this.allocation.deciders().canAllocateAnyShardToNode(targetNode, this.allocation);
                if (nodeDecision.type() == Decision.Type.YES) {
                    targetNodes.offer(targetNode);
                    nodesCheckedForRelocation.add(targetNode.nodeId());
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Cannot allocate any shard to node: [{}]. Removing from queue. Node level decisions: [{}],[{}]", (Object)targetNode.nodeId(), nodeDecision.getDecisions(), (Object)nodeDecision.toString());
                }
                if (!targetNodes.stream().allMatch(node -> nodesCheckedForRelocation.contains(node.nodeId()))) continue;
                continue block0;
            }
        }
    }

    private Decision tryRelocateShard(ShardRouting shard, RoutingNode destinationNode) {
        ShardRouting replicaShard = destinationNode.getByShardId(shard.shardId());
        if (replicaShard != null) {
            assert (!replicaShard.primary()) : "Primary Shard found while expected Replica during shard rebalance";
            return this.executeSwapShard(shard, replicaShard, this.allocation);
        }
        Decision allocationDecision = this.allocation.deciders().canAllocate(shard, destinationNode, this.allocation);
        Decision rebalanceDecision = this.allocation.deciders().canRebalance(shard, this.allocation);
        this.logger.trace("Relocating shard [{}] from node [{}] to node [{}]. AllocationDecision: [{}]. AllocationExplanation: [{}]. RebalanceDecision: [{}]. RebalanceExplanation: [{}]", (Object)shard.id(), (Object)shard.currentNodeId(), (Object)destinationNode.nodeId(), (Object)allocationDecision.type(), (Object)allocationDecision.toString(), (Object)rebalanceDecision.type(), (Object)rebalanceDecision.toString());
        if (allocationDecision.type() == Decision.Type.YES && rebalanceDecision.type() == Decision.Type.YES) {
            long shardSize = this.allocation.clusterInfo().getShardSize(shard, -1L);
            ShardRouting targetShard = (ShardRouting)this.routingNodes.relocateShard(shard, destinationNode.nodeId(), shardSize, this.allocation.changes()).v2();
            this.logger.info("Relocated shard [{}] to node [{}] during primary Rebalance", (Object)shard, (Object)targetShard.currentNodeId());
            return Decision.YES;
        }
        if (allocationDecision.type() == Decision.Type.THROTTLE || rebalanceDecision.type() == Decision.Type.THROTTLE) {
            return Decision.THROTTLE;
        }
        return Decision.NO;
    }

    private Decision executeSwapShard(ShardRouting primaryShard, ShardRouting replicaShard, RoutingAllocation allocation) {
        if (!replicaShard.started()) {
            return new Decision.Single(Decision.Type.NO);
        }
        allocation.routingNodes().swapPrimaryWithReplica(this.logger, primaryShard, replicaShard, allocation.changes());
        return new Decision.Single(Decision.Type.YES);
    }

    private void failUnattemptedShards() {
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = this.routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            ShardRouting shard = unassignedIterator.next();
            UnassignedInfo unassignedInfo = shard.unassignedInfo();
            if (!shard.primary() || unassignedInfo.getLastAllocationStatus() != UnassignedInfo.AllocationStatus.NO_ATTEMPT) continue;
            unassignedIterator.updateUnassigned(new UnassignedInfo(unassignedInfo.getReason(), unassignedInfo.getMessage(), unassignedInfo.getFailure(), unassignedInfo.getNumFailedAllocations(), unassignedInfo.getUnassignedTimeInNanos(), unassignedInfo.getUnassignedTimeInMillis(), unassignedInfo.isDelayed(), UnassignedInfo.AllocationStatus.DECIDERS_NO, Collections.emptySet()), shard.recoverySource(), this.allocation.changes());
        }
    }

    private Queue<RoutingNode> getShuffledRemoteNodes() {
        List<RoutingNode> nodeList = this.getRemoteRoutingNodes();
        Randomness.shuffle(nodeList);
        return new ArrayDeque<RoutingNode>(nodeList);
    }

    private List<RoutingNode> getRemoteRoutingNodes() {
        ArrayList<RoutingNode> nodeList = new ArrayList<RoutingNode>();
        for (RoutingNode rNode : this.routingNodes) {
            if (!RoutingPool.REMOTE_CAPABLE.equals((Object)RoutingPool.getNodePool(rNode))) continue;
            nodeList.add(rNode);
        }
        return nodeList;
    }

    private String shardShortSummary(ShardRouting shard) {
        return "[" + shard.getIndexName() + "][" + shard.getId() + "][" + (shard.primary() ? "p" : "r") + "]";
    }

    public static class UnassignedIndexShards {
        private final Queue<ShardRouting> primaries = new ArrayDeque<ShardRouting>();
        private final Queue<ShardRouting> replicas = new ArrayDeque<ShardRouting>();

        public void addShard(ShardRouting shard) {
            if (shard.primary()) {
                this.primaries.add(shard);
            } else {
                this.replicas.add(shard);
            }
        }

        public Queue<ShardRouting> getPrimaries() {
            return this.primaries;
        }

        public Queue<ShardRouting> getReplicas() {
            return this.replicas;
        }
    }
}

