/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.hot_node;

import java.util.function.Predicate;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ReaderMetrics;
import org.opensearch.performanceanalyzer.rca.store.rca.hot_node.ThreadMetricsSlidingWindow;

public class ThreadAnalysis {
    private final ThreadMetricsSlidingWindow blockedTimeWindow;
    private final ThreadMetricsSlidingWindow waitedTimeWindow;
    private final Predicate<String> typeFilter;
    private final ReaderMetrics blockedThreadCountMetric;
    private final ReaderMetrics waitedThreadCountMetric;
    private final ReaderMetrics maxBlockedTimeMetric;
    private final ReaderMetrics maxWaitedTimeMetric;

    public ThreadAnalysis(Predicate<String> typeFilter, ReaderMetrics blockedThreadCountMetric, ReaderMetrics waitedThreadCount, ReaderMetrics maxBlockedTime, ReaderMetrics maxWaitedTimeMetric) {
        this.typeFilter = typeFilter;
        this.blockedThreadCountMetric = blockedThreadCountMetric;
        this.waitedThreadCountMetric = waitedThreadCount;
        this.maxBlockedTimeMetric = maxBlockedTime;
        this.maxWaitedTimeMetric = maxWaitedTimeMetric;
        this.blockedTimeWindow = new ThreadMetricsSlidingWindow();
        this.waitedTimeWindow = new ThreadMetricsSlidingWindow();
    }

    public ThreadMetricsSlidingWindow getBlockedTimeWindow() {
        return this.blockedTimeWindow;
    }

    public ThreadMetricsSlidingWindow getWaitedTimeWindow() {
        return this.waitedTimeWindow;
    }

    public Predicate<String> getTypeFilter() {
        return this.typeFilter;
    }

    public ReaderMetrics getBlockedThreadCountMetric() {
        return this.blockedThreadCountMetric;
    }

    public ReaderMetrics getWaitedThreadCountMetric() {
        return this.waitedThreadCountMetric;
    }

    public ReaderMetrics getMaxBlockedTimeMetric() {
        return this.maxBlockedTimeMetric;
    }

    public ReaderMetrics getMaxWaitedTimeMetric() {
        return this.maxWaitedTimeMetric;
    }
}

