/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.opensearch.indices.breaker.CircuitBreakerStats;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;

public class CircuitBreakerCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(CircuitBreakerCollector.class)).samplingInterval;
    private static final int KEYS_PATH_LENGTH = 0;
    private StringBuilder value = new StringBuilder();

    public CircuitBreakerCollector() {
        super(SAMPLING_TIME_INTERVAL, "CircuitBreaker");
    }

    public void collectMetrics(long startTime) {
        if (OpenSearchResources.INSTANCE.getCircuitBreakerService() == null) {
            return;
        }
        CircuitBreakerStats[] allCircuitBreakerStats = OpenSearchResources.INSTANCE.getCircuitBreakerService().stats().getAllStats();
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds());
        for (CircuitBreakerStats stats : allCircuitBreakerStats) {
            this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(new CircuitBreakerStatus(stats.getName(), stats.getEstimated(), stats.getTrippedCount(), stats.getLimit()).serialize());
        }
        this.saveMetricValues(this.value.toString(), startTime, new String[0]);
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"circuit_breaker"});
    }

    static class CircuitBreakerStatus
    extends MetricStatus {
        private final String type;
        private final long estimated;
        private final long tripped;
        private final long limitConfigured;

        CircuitBreakerStatus(String type, long estimated, long tripped, long limitConfigured) {
            this.type = type;
            this.estimated = estimated;
            this.tripped = tripped;
            this.limitConfigured = limitConfigured;
        }

        @JsonProperty(value="CBType")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="CB_EstimatedSize")
        public long getEstimated() {
            return this.estimated;
        }

        @JsonProperty(value="CB_TrippedEvents")
        public long getTripped() {
            return this.tripped;
        }

        @JsonProperty(value="CB_ConfiguredSize")
        public long getLimitConfigured() {
            return this.limitConfigured;
        }
    }
}

