/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.listener;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.shard.SearchOperationListener;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.listener.NoOpSearchListener;
import org.opensearch.performanceanalyzer.listener.SearchListener;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.metrics.ThreadIDUtil;
import org.opensearch.performanceanalyzer.rca.framework.metrics.WriterMetrics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;
import org.opensearch.search.internal.SearchContext;

public class PerformanceAnalyzerSearchListener
implements SearchOperationListener,
SearchListener,
MetricsProcessor {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerSearchListener.class);
    private static final SearchListener NO_OP_SEARCH_LISTENER = new NoOpSearchListener();
    private static final int KEYS_PATH_LENGTH = 4;
    private final PerformanceAnalyzerController controller;
    private SearchListener searchListener;

    public PerformanceAnalyzerSearchListener(PerformanceAnalyzerController controller) {
        this.controller = controller;
    }

    public String toString() {
        return PerformanceAnalyzerSearchListener.class.getSimpleName();
    }

    private SearchListener getSearchListener() {
        return this.controller.isPerformanceAnalyzerEnabled() ? this : NO_OP_SEARCH_LISTENER;
    }

    public void onPreQueryPhase(SearchContext searchContext) {
        try {
            this.getSearchListener().preQueryPhase(searchContext);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR, "", (Number)1);
        }
    }

    public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
        try {
            this.getSearchListener().queryPhase(searchContext, tookInNanos);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR, "", (Number)1);
        }
    }

    public void onFailedQueryPhase(SearchContext searchContext) {
        try {
            this.getSearchListener().failedQueryPhase(searchContext);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR, "", (Number)1);
        }
    }

    public void onPreFetchPhase(SearchContext searchContext) {
        try {
            this.getSearchListener().preFetchPhase(searchContext);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR, "", (Number)1);
        }
    }

    public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
        try {
            this.getSearchListener().fetchPhase(searchContext, tookInNanos);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR, "", (Number)1);
        }
    }

    public void onFailedFetchPhase(SearchContext searchContext) {
        try {
            this.getSearchListener().failedFetchPhase(searchContext);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR, "", (Number)1);
        }
    }

    @Override
    public void preQueryPhase(SearchContext searchContext) {
        long currTime = System.currentTimeMillis();
        this.saveMetricValues(PerformanceAnalyzerSearchListener.generateStartMetrics(currTime, searchContext.request().shardId().getIndexName(), searchContext.request().shardId().getId()), currTime, new String[]{String.valueOf(ThreadIDUtil.INSTANCE.getNativeCurrentThreadId()), "shardquery", String.valueOf(searchContext.id()), "start"});
    }

    @Override
    public void queryPhase(SearchContext searchContext, long tookInNanos) {
        long currTime = System.currentTimeMillis();
        this.saveMetricValues(PerformanceAnalyzerSearchListener.generateFinishMetrics(currTime, false, searchContext.request().shardId().getIndexName(), searchContext.request().shardId().getId()), currTime, new String[]{String.valueOf(ThreadIDUtil.INSTANCE.getNativeCurrentThreadId()), "shardquery", String.valueOf(searchContext.id()), "finish"});
    }

    @Override
    public void failedQueryPhase(SearchContext searchContext) {
        long currTime = System.currentTimeMillis();
        this.saveMetricValues(PerformanceAnalyzerSearchListener.generateFinishMetrics(currTime, true, searchContext.request().shardId().getIndexName(), searchContext.request().shardId().getId()), currTime, new String[]{String.valueOf(ThreadIDUtil.INSTANCE.getNativeCurrentThreadId()), "shardquery", String.valueOf(searchContext.id()), "finish"});
    }

    @Override
    public void preFetchPhase(SearchContext searchContext) {
        long currTime = System.currentTimeMillis();
        this.saveMetricValues(PerformanceAnalyzerSearchListener.generateStartMetrics(currTime, searchContext.request().shardId().getIndexName(), searchContext.request().shardId().getId()), currTime, new String[]{String.valueOf(ThreadIDUtil.INSTANCE.getNativeCurrentThreadId()), "shardfetch", String.valueOf(searchContext.id()), "start"});
    }

    @Override
    public void fetchPhase(SearchContext searchContext, long tookInNanos) {
        long currTime = System.currentTimeMillis();
        this.saveMetricValues(PerformanceAnalyzerSearchListener.generateFinishMetrics(currTime, false, searchContext.request().shardId().getIndexName(), searchContext.request().shardId().getId()), currTime, new String[]{String.valueOf(ThreadIDUtil.INSTANCE.getNativeCurrentThreadId()), "shardfetch", String.valueOf(searchContext.id()), "finish"});
    }

    @Override
    public void failedFetchPhase(SearchContext searchContext) {
        long currTime = System.currentTimeMillis();
        this.saveMetricValues(PerformanceAnalyzerSearchListener.generateFinishMetrics(currTime, true, searchContext.request().shardId().getIndexName(), searchContext.request().shardId().getId()), currTime, new String[]{String.valueOf(ThreadIDUtil.INSTANCE.getNativeCurrentThreadId()), "shardfetch", String.valueOf(searchContext.id()), "finish"});
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 4) {
            throw new RuntimeException("keys length should be 4");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"threads", keysPath[0], keysPath[1], keysPath[2], keysPath[3]});
    }

    public static String generateStartMetrics(long startTime, String indexName, int shardId) {
        return PerformanceAnalyzerMetrics.getCurrentTimeMetric() + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.CommonMetric.START_TIME.toString() + ":" + startTime + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.CommonDimension.INDEX_NAME.toString() + ":" + indexName + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.CommonDimension.SHARD_ID.toString() + ":" + shardId;
    }

    public static String generateFinishMetrics(long finishTime, boolean failed, String indexName, int shardId) {
        return PerformanceAnalyzerMetrics.getCurrentTimeMetric() + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.CommonMetric.FINISH_TIME.toString() + ":" + finishTime + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.CommonDimension.FAILED.toString() + ":" + failed + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.CommonDimension.INDEX_NAME.toString() + ":" + indexName + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.CommonDimension.SHARD_ID.toString() + ":" + shardId;
    }
}

