/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.action.SearchMonitorRequest;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transport.TransportSearchMonitorActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B/\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00022\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#H\u0014J&\u0010$\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u00022\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#2\b\u0010%\u001a\u0004\u0018\u00010&J\u001c\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lorg/opensearch/alerting/transport/TransportSearchMonitorAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/SearchMonitorRequest;", "Lorg/opensearch/action/search/SearchResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/action/support/ActionFilters;)V", "getClient", "()Lorg/opensearch/client/Client;", "filterByEnabled", "", "getFilterByEnabled", "()Z", "setFilterByEnabled", "(Z)V", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "addOwnerFieldIfNotExists", "", "searchRequest", "Lorg/opensearch/action/search/SearchRequest;", "doExecute", "task", "Lorg/opensearch/tasks/Task;", "searchMonitorRequest", "actionListener", "Lorg/opensearch/action/ActionListener;", "resolve", "user", "Lorg/opensearch/commons/authuser/User;", "search", "opensearch-alerting"})
public final class TransportSearchMonitorAction
extends HandledTransportAction<SearchMonitorRequest, SearchResponse>
implements SecureTransportAction {
    @NotNull
    private final Settings settings;
    @NotNull
    private final Client client;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportSearchMonitorAction(@NotNull TransportService transportService, @NotNull Settings settings, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull ActionFilters actionFilters) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        super("cluster:admin/opendistro/alerting/monitor/search", transportService, actionFilters, SearchMonitorRequest::new);
        this.settings = settings;
        this.client = client;
        Object object = AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"AlertingSettings.FILTER_\u2026CKEND_ROLES.get(settings)");
        this.filterByEnabled = (Boolean)object;
        this.listenFilterBySettingChange(clusterService);
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @Override
    public boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    @Override
    public void setFilterByEnabled(boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull SearchMonitorRequest searchMonitorRequest, @NotNull ActionListener<SearchResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)searchMonitorRequest), (String)"searchMonitorRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        SearchSourceBuilder searchSourceBuilder = searchMonitorRequest.getSearchRequest().source();
        BoolQueryBuilder queryBuilder = searchSourceBuilder.query() == null ? new BoolQueryBuilder() : QueryBuilders.boolQuery().must(searchSourceBuilder.query());
        queryBuilder.filter((QueryBuilder)QueryBuilders.existsQuery((String)"monitor"));
        searchSourceBuilder.query((QueryBuilder)queryBuilder).seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
        this.addOwnerFieldIfNotExists(searchMonitorRequest.getSearchRequest());
        User user = this.readUserFromThreadContext(this.client);
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            this.resolve(searchMonitorRequest, actionListener, user);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void resolve(@NotNull SearchMonitorRequest searchMonitorRequest, @NotNull ActionListener<SearchResponse> actionListener, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)searchMonitorRequest), (String)"searchMonitorRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (user == null) {
            this.search(searchMonitorRequest.getSearchRequest(), actionListener);
        } else if (!this.doFilterForUser(user)) {
            this.search(searchMonitorRequest.getSearchRequest(), actionListener);
        } else {
            TransportSearchMonitorActionKt.access$getLog$p().info("Filtering result by: " + user.getBackendRoles());
            SearchSourceBuilder searchSourceBuilder = searchMonitorRequest.getSearchRequest().source();
            Intrinsics.checkNotNullExpressionValue((Object)searchSourceBuilder, (String)"searchMonitorRequest.searchRequest.source()");
            OpenSearchExtensionsKt.addFilter((User)user, (SearchSourceBuilder)searchSourceBuilder, (String)"monitor.user.backend_roles.keyword");
            this.search(searchMonitorRequest.getSearchRequest(), actionListener);
        }
    }

    public final void search(@NotNull SearchRequest searchRequest, @NotNull ActionListener<SearchResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)searchRequest, (String)"searchRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(actionListener){
            final /* synthetic */ ActionListener<SearchResponse> $actionListener;
            {
                this.$actionListener = $actionListener;
            }

            public void onResponse(@NotNull SearchResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.$actionListener.onResponse((Object)response2);
            }

            public void onFailure(@NotNull Exception t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
            }
        });
    }

    private final void addOwnerFieldIfNotExists(SearchRequest searchRequest) {
        if (searchRequest.source().query() == null || !StringsKt.contains$default((CharSequence)searchRequest.source().query().toString(), (CharSequence)"monitor.owner", (boolean)false, (int)2, null)) {
            BoolQueryBuilder boolQueryBuilder;
            if (searchRequest.source().query() == null) {
                boolQueryBuilder = new BoolQueryBuilder();
            } else {
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery().must(searchRequest.source().query());
                Intrinsics.checkNotNullExpressionValue((Object)boolQueryBuilder2, (String)"boolQuery().must(searchRequest.source().query())");
                boolQueryBuilder = boolQueryBuilder2;
            }
            BoolQueryBuilder boolQueryBuilder3 = boolQueryBuilder;
            BoolQueryBuilder bqb = new BoolQueryBuilder();
            bqb.should().add(new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder("monitor.owner")));
            bqb.should().add(new BoolQueryBuilder().must((QueryBuilder)new MatchQueryBuilder("monitor.owner", (Object)"alerting")));
            boolQueryBuilder3.filter((QueryBuilder)bqb);
            searchRequest.source().query((QueryBuilder)boolQueryBuilder3);
        }
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.DefaultImpls.listenFilterBySettingChange(this, clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.DefaultImpls.readUserFromThreadContext(this, client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.doFilterForUser(this, user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.isAdmin(this, user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.DefaultImpls.validateUserBackendRoles(this, user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.DefaultImpls.checkUserPermissionsWithResource(this, requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }
}

