// Copyright (c) 2016  GeometryFactory SARL (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org)
//
// $URL: https://github.com/CGAL/cgal/blob/v5.5.2/Installation/include/CGAL/license/Polygon_mesh_processing/combinatorial_repair.h $
// $Id: combinatorial_repair.h 5a992f6 2022-11-22T10:31:34+01:00 Sébastien Loriot
// SPDX-License-Identifier: LGPL-3.0-or-later OR LicenseRef-Commercial
//
// Author(s) : Andreas Fabri
//
// Warning: this file is generated, see include/CGAL/licence/README.md
//          not entirely true due to the backward compatibility issue

#ifndef CGAL_LICENSE_POLYGON_MESH_PROCESSING_COMBINATORIAL_REPAIR_H
#define CGAL_LICENSE_POLYGON_MESH_PROCESSING_COMBINATORIAL_REPAIR_H

#include <CGAL/config.h>
#include <CGAL/license.h>

// backward compatibility
#ifdef CGAL_POLYGON_MESH_PROCESSING_REPAIR_COMMERCIAL_LICENSE
#define CGAL_POLYGON_MESH_PROCESSING_COMBINATORIAL_REPAIR_COMMERCIAL_LICENSE CGAL_POLYGON_MESH_PROCESSING_REPAIR_COMMERCIAL_LICENSE
#endif

#ifdef CGAL_POLYGON_MESH_PROCESSING_COMBINATORIAL_REPAIR_COMMERCIAL_LICENSE

#  if CGAL_POLYGON_MESH_PROCESSING_COMBINATORIAL_REPAIR_COMMERCIAL_LICENSE < CGAL_RELEASE_DATE

#    if defined(CGAL_LICENSE_WARNING)

       CGAL_pragma_warning("Your commercial license for CGAL does not cover "
                           "this release of the Polygon Mesh Processing - Combinatorial Repair package.")
#    endif

#    ifdef CGAL_LICENSE_ERROR
#      error "Your commercial license for CGAL does not cover this release \
              of the Polygon Mesh Processing - Combinatorial Repair package. \
              You get this error, as you defined CGAL_LICENSE_ERROR."
#    endif // CGAL_LICENSE_ERROR

#  endif // CGAL_POLYGON_MESH_PROCESSING_COMBINATORIAL_REPAIR_COMMERCIAL_LICENSE < CGAL_RELEASE_DATE

#else // no CGAL_POLYGON_MESH_PROCESSING_COMBINATORIAL_REPAIR_COMMERCIAL_LICENSE

#  if defined(CGAL_LICENSE_WARNING)
     CGAL_pragma_warning("\nThe macro CGAL_POLYGON_MESH_PROCESSING_COMBINATORIAL_REPAIR_COMMERCIAL_LICENSE is not defined."
                          "\nYou use the CGAL Polygon Mesh Processing - Combinatorial Repair package under "
                          "the terms of the GPLv3+.")
#  endif // CGAL_LICENSE_WARNING

#  ifdef CGAL_LICENSE_ERROR
#    error "The macro CGAL_POLYGON_MESH_PROCESSING_COMBINATORIAL_REPAIR_COMMERCIAL_LICENSE is not defined.\
            You use the CGAL Polygon Mesh Processing - Combinatorial Repair package under the terms of \
            the GPLv3+. You get this error, as you defined CGAL_LICENSE_ERROR."
#  endif // CGAL_LICENSE_ERROR

#endif // no CGAL_POLYGON_MESH_PROCESSING_COMBINATORIAL_REPAIR_COMMERCIAL_LICENSE

#endif // CGAL_LICENSE_POLYGON_MESH_PROCESSING_COMBINATORIAL_REPAIR_H
