/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.grails.datastore.mapping.services.DefaultServiceDefinition;
import org.grails.datastore.mapping.services.ServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;
import org.springframework.util.ClassUtils;

public final class SoftServiceLoader<S>
implements Iterable<ServiceDefinition<S>> {
    public static final String PROPERTY_GRAILS_CLASSLOADER_LOGGING = "grails.classloader.logging";
    public static final String META_INF_SERVICES = "META-INF/services";
    public static final Logger REFLECTION_LOGGER;
    private static final boolean ENABLE_CLASS_LOADER_LOGGING;
    private final Class<S> serviceType;
    private final ClassLoader classLoader;
    private final Map<String, ServiceDefinition<S>> loadedServices = new LinkedHashMap<String, ServiceDefinition<S>>();
    private final Iterator<ServiceDefinition<S>> unloadedServices;
    private final Predicate<String> condition;

    private SoftServiceLoader(Class<S> serviceType, ClassLoader classLoader) {
        this(serviceType, classLoader, name -> true);
    }

    private SoftServiceLoader(Class<S> serviceType, ClassLoader classLoader, Predicate<String> condition) {
        this.serviceType = serviceType;
        this.classLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        this.unloadedServices = new ServiceLoaderIterator();
        this.condition = condition == null ? name -> true : condition;
    }

    public static Logger getLogger(Class type) {
        if (ENABLE_CLASS_LOADER_LOGGING) {
            return LoggerFactory.getLogger((Class)type);
        }
        return NOPLogger.NOP_LOGGER;
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service) {
        return SoftServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new SoftServiceLoader<S>(service, loader);
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service, ClassLoader loader, Predicate<String> condition) {
        return new SoftServiceLoader<S>(service, loader, condition);
    }

    public Optional<ServiceDefinition<S>> first() {
        Iterator<ServiceDefinition<S>> i = this.iterator();
        if (i.hasNext()) {
            return Optional.of(i.next());
        }
        return Optional.empty();
    }

    public Optional<ServiceDefinition<S>> firstOr(String alternative, ClassLoader classLoader) {
        Optional<Object> alternativeClass;
        block4: {
            Iterator<ServiceDefinition<S>> i = this.iterator();
            if (i.hasNext()) {
                return Optional.of(i.next());
            }
            alternativeClass = Optional.empty();
            try {
                alternativeClass = Optional.of(ClassUtils.forName((String)alternative, (ClassLoader)classLoader));
            }
            catch (ClassNotFoundException e) {
                if (!REFLECTION_LOGGER.isDebugEnabled()) break block4;
                REFLECTION_LOGGER.debug("Class {} is not present", (Object)alternative);
            }
        }
        if (alternativeClass.isPresent()) {
            return Optional.of(this.newService(alternative, alternativeClass));
        }
        return Optional.empty();
    }

    @Override
    public Iterator<ServiceDefinition<S>> iterator() {
        return new Iterator<ServiceDefinition<S>>(){
            Iterator<ServiceDefinition<S>> loaded;
            {
                this.loaded = SoftServiceLoader.this.loadedServices.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.loaded.hasNext()) {
                    return true;
                }
                return SoftServiceLoader.this.unloadedServices.hasNext();
            }

            @Override
            public ServiceDefinition<S> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.loaded.hasNext()) {
                    return this.loaded.next();
                }
                if (SoftServiceLoader.this.unloadedServices.hasNext()) {
                    ServiceDefinition nextService = (ServiceDefinition)SoftServiceLoader.this.unloadedServices.next();
                    SoftServiceLoader.this.loadedServices.put(nextService.getName(), nextService);
                    return nextService;
                }
                throw new Error("Bug in iterator");
            }
        };
    }

    protected ServiceDefinition<S> newService(String name, Optional<Class> loadedClass) {
        return new DefaultServiceDefinition(name, loadedClass);
    }

    static {
        ENABLE_CLASS_LOADER_LOGGING = Boolean.getBoolean(PROPERTY_GRAILS_CLASSLOADER_LOGGING);
        REFLECTION_LOGGER = SoftServiceLoader.getLogger(ClassUtils.class);
    }

    private final class ServiceLoaderIterator
    implements Iterator<ServiceDefinition<S>> {
        private Enumeration<URL> serviceConfigs = null;
        private Iterator<String> unprocessed = null;

        private ServiceLoaderIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.serviceConfigs == null) {
                String name = SoftServiceLoader.this.serviceType.getName();
                try {
                    this.serviceConfigs = SoftServiceLoader.this.classLoader.getResources("META-INF/services/" + name);
                }
                catch (IOException e) {
                    throw new ServiceConfigurationError("Failed to load resources for service: " + name, e);
                }
            }
            while (this.unprocessed == null || !this.unprocessed.hasNext()) {
                if (!this.serviceConfigs.hasMoreElements()) {
                    return false;
                }
                URL url = this.serviceConfigs.nextElement();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                    Throwable throwable = null;
                    try {
                        List lines = reader.lines().filter(line -> line.length() != 0 && line.charAt(0) != '#').filter(SoftServiceLoader.this.condition).map(line -> {
                            int i = line.indexOf(35);
                            if (i > -1) {
                                line = line.substring(0, i);
                            }
                            return line;
                        }).collect(Collectors.toList());
                        this.unprocessed = lines.iterator();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return this.unprocessed.hasNext();
        }

        @Override
        public ServiceDefinition<S> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String nextName = this.unprocessed.next();
            try {
                Class<?> loadedClass = Class.forName(nextName, false, SoftServiceLoader.this.classLoader);
                return SoftServiceLoader.this.newService(nextName, Optional.of(loadedClass));
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                return SoftServiceLoader.this.newService(nextName, Optional.empty());
            }
        }
    }
}

