/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import org.openstreetmap.josm.data.oauth.IOAuthParameters;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuth20Exception;
import org.openstreetmap.josm.data.oauth.OAuth20Parameters;
import org.openstreetmap.josm.data.oauth.OAuthException;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.data.oauth.SignpostAdapters;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class OAuthParameters
implements IOAuthParameters {
    public static final String DEFAULT_JOSM_CONSUMER_KEY = "F7zPYlVCqE2BUH9Hr4SsWZSOnrKjpug1EgqkbsSb";
    public static final String DEFAULT_JOSM_CONSUMER_SECRET = "rIkjpPcBNkMQxrqzcOvOC4RRuYupYr7k8mfP13H5";
    private final String consumerKey;
    private final String consumerSecret;
    private final String requestTokenUrl;
    private final String accessTokenUrl;
    private final String authoriseUrl;
    private final String osmLoginUrl;
    private final String osmLogoutUrl;

    public static OAuthParameters createDefault() {
        return OAuthParameters.createDefault(null);
    }

    public static OAuthParameters createDefault(String apiUrl) {
        return (OAuthParameters)OAuthParameters.createDefault(apiUrl, OAuthVersion.OAuth10a);
    }

    public static IOAuthParameters createDefault(String apiUrl, OAuthVersion oAuthVersion) {
        if (!Utils.isValidUrl(apiUrl)) {
            apiUrl = null;
        }
        switch (oAuthVersion) {
            case OAuth10a: {
                return OAuthParameters.getDefaultOAuth10Parameters(apiUrl);
            }
            case OAuth20: 
            case OAuth21: {
                return OAuthParameters.getDefaultOAuth20Parameters(apiUrl);
            }
        }
        throw new IllegalArgumentException("Unknown OAuth version: " + (Object)((Object)oAuthVersion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OAuth20Parameters getDefaultOAuth20Parameters(String apiUrl) {
        String redirectUri;
        String baseUrl;
        String clientSecret;
        String clientId;
        if (apiUrl != null && !Config.getUrls().getDefaultOsmApiUrl().equals(apiUrl) && !"http://invalid".equals(apiUrl)) {
            clientId = "";
            clientSecret = "";
            baseUrl = apiUrl;
            HttpClient client = null;
            redirectUri = "";
            try {
                client = HttpClient.create(new URL(apiUrl + (apiUrl.endsWith("/") ? "" : "/") + ".well-known/oauth-authorization-server"));
                HttpClient.Response response = client.connect();
                if (response.getResponseCode() != 200) return new OAuth20Parameters(clientId, clientSecret, baseUrl, apiUrl, redirectUri);
                try (BufferedReader reader = response.getContentReader();
                     JsonReader jsonReader = Json.createReader(reader);){
                    JsonStructure structure = jsonReader.read();
                    if (structure.getValueType() != JsonValue.ValueType.OBJECT) return new OAuth20Parameters(clientId, clientSecret, baseUrl, apiUrl, redirectUri);
                    OAuth20Parameters oAuth20Parameters = OAuthParameters.parseAuthorizationServerMetadataResponse(clientId, clientSecret, apiUrl, redirectUri, structure.asJsonObject());
                    return oAuth20Parameters;
                }
            }
            catch (IOException | OAuthException e) {
                Logging.trace(e);
                return new OAuth20Parameters(clientId, clientSecret, baseUrl, apiUrl, redirectUri);
            }
            finally {
                if (client != null) {
                    client.disconnect();
                }
            }
        } else {
            clientId = "edPII614Lm0_0zEpc_QzEltA9BUll93-Y-ugRQUoHMI";
            clientSecret = null;
            baseUrl = "https://www.openstreetmap.org/oauth2";
            redirectUri = "http://127.0.0.1:8111/oauth_authorization";
            apiUrl = OsmApi.getOsmApi().getBaseUrl();
        }
        return new OAuth20Parameters(clientId, clientSecret, baseUrl, apiUrl, redirectUri);
    }

    private static OAuth20Parameters parseAuthorizationServerMetadataResponse(String clientId, String clientSecret, String apiUrl, String redirectUri, JsonObject serverMetadata) throws OAuthException {
        String authorizationEndpoint = serverMetadata.getString("authorization_endpoint", null);
        String tokenEndpoint = serverMetadata.getString("token_endpoint", null);
        if (authorizationEndpoint == null || tokenEndpoint == null) {
            throw new OAuth20Exception("Either token endpoint or authorization endpoints are missing");
        }
        return new OAuth20Parameters(clientId, clientSecret, tokenEndpoint, authorizationEndpoint, apiUrl, redirectUri);
    }

    private static OAuthParameters getDefaultOAuth10Parameters(String apiUrl) {
        String serverUrl;
        String consumerSecret;
        String consumerKey;
        if (apiUrl != null && !Config.getUrls().getDefaultOsmApiUrl().equals(apiUrl)) {
            consumerKey = "";
            consumerSecret = "";
            serverUrl = apiUrl.replaceAll("/api$", "");
        } else {
            consumerKey = DEFAULT_JOSM_CONSUMER_KEY;
            consumerSecret = DEFAULT_JOSM_CONSUMER_SECRET;
            serverUrl = Config.getUrls().getOSMWebsite();
        }
        return new OAuthParameters(consumerKey, consumerSecret, serverUrl + "/oauth/request_token", serverUrl + "/oauth/access_token", serverUrl + "/oauth/authorize", serverUrl + "/login", serverUrl + "/logout");
    }

    public static OAuthParameters createFromApiUrl(String apiUrl) {
        return (OAuthParameters)OAuthParameters.createFromApiUrl(apiUrl, OAuthVersion.OAuth10a);
    }

    public static IOAuthParameters createFromApiUrl(String apiUrl, OAuthVersion oAuthVersion) {
        IOAuthParameters parameters = OAuthParameters.createDefault(apiUrl, oAuthVersion);
        switch (oAuthVersion) {
            case OAuth10a: {
                OAuthParameters oauth10aParameters = (OAuthParameters)parameters;
                return new OAuthParameters(Config.getPref().get("oauth.settings.consumer-key", oauth10aParameters.getConsumerKey()), Config.getPref().get("oauth.settings.consumer-secret", oauth10aParameters.getConsumerSecret()), Config.getPref().get("oauth.settings.request-token-url", oauth10aParameters.getRequestTokenUrl()), Config.getPref().get("oauth.settings.access-token-url", oauth10aParameters.getAccessTokenUrl()), Config.getPref().get("oauth.settings.authorise-url", oauth10aParameters.getAuthoriseUrl()), Config.getPref().get("oauth.settings.osm-login-url", oauth10aParameters.getOsmLoginUrl()), Config.getPref().get("oauth.settings.osm-logout-url", oauth10aParameters.getOsmLogoutUrl()));
            }
            case OAuth20: 
            case OAuth21: {
                OAuth20Parameters oAuth20Parameters = (OAuth20Parameters)parameters;
                try {
                    IOAuthToken storedToken = CredentialsManager.getInstance().lookupOAuthAccessToken(apiUrl);
                    return storedToken != null ? storedToken.getParameters() : oAuth20Parameters;
                }
                catch (CredentialsAgentException e) {
                    Logging.trace(e);
                    return oAuth20Parameters;
                }
            }
        }
        throw new IllegalArgumentException("Unknown OAuth version: " + (Object)((Object)oAuthVersion));
    }

    @Override
    public void rememberPreferences() {
        Config.getPref().put("oauth.settings.consumer-key", this.getConsumerKey());
        Config.getPref().put("oauth.settings.consumer-secret", this.getConsumerSecret());
        Config.getPref().put("oauth.settings.request-token-url", this.getRequestTokenUrl());
        Config.getPref().put("oauth.settings.access-token-url", this.getAccessTokenUrl());
        Config.getPref().put("oauth.settings.authorise-url", this.getAuthoriseUrl());
        Config.getPref().put("oauth.settings.osm-login-url", this.getOsmLoginUrl());
        Config.getPref().put("oauth.settings.osm-logout-url", this.getOsmLogoutUrl());
    }

    public OAuthParameters(String consumerKey, String consumerSecret, String requestTokenUrl, String accessTokenUrl, String authoriseUrl, String osmLoginUrl, String osmLogoutUrl) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.requestTokenUrl = requestTokenUrl;
        this.accessTokenUrl = accessTokenUrl;
        this.authoriseUrl = authoriseUrl;
        this.osmLoginUrl = osmLoginUrl;
        this.osmLogoutUrl = osmLogoutUrl;
    }

    public OAuthParameters(OAuthParameters other) {
        CheckParameterUtil.ensureParameterNotNull(other, "other");
        this.consumerKey = other.consumerKey;
        this.consumerSecret = other.consumerSecret;
        this.accessTokenUrl = other.accessTokenUrl;
        this.requestTokenUrl = other.requestTokenUrl;
        this.authoriseUrl = other.authoriseUrl;
        this.osmLoginUrl = other.osmLoginUrl;
        this.osmLogoutUrl = other.osmLogoutUrl;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }

    @Override
    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    @Override
    public String getAuthorizationUrl() {
        return this.authoriseUrl;
    }

    @Override
    public OAuthVersion getOAuthVersion() {
        return OAuthVersion.OAuth10a;
    }

    @Override
    public String getClientId() {
        return this.consumerKey;
    }

    @Override
    public String getClientSecret() {
        return this.consumerSecret;
    }

    public String getAuthoriseUrl() {
        return this.getAuthorizationUrl();
    }

    public String getOsmLoginUrl() {
        return this.osmLoginUrl;
    }

    public String getOsmLogoutUrl() {
        return this.osmLogoutUrl;
    }

    public OAuthConsumer buildConsumer() {
        return new SignpostAdapters.OAuthConsumer(this.consumerKey, this.consumerSecret);
    }

    public OAuthProvider buildProvider(OAuthConsumer consumer) {
        CheckParameterUtil.ensureParameterNotNull(consumer, "consumer");
        return new SignpostAdapters.OAuthProvider(this.requestTokenUrl, this.accessTokenUrl, this.authoriseUrl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthParameters that = (OAuthParameters)o;
        return Objects.equals(this.consumerKey, that.consumerKey) && Objects.equals(this.consumerSecret, that.consumerSecret) && Objects.equals(this.requestTokenUrl, that.requestTokenUrl) && Objects.equals(this.accessTokenUrl, that.accessTokenUrl) && Objects.equals(this.authoriseUrl, that.authoriseUrl) && Objects.equals(this.osmLoginUrl, that.osmLoginUrl) && Objects.equals(this.osmLogoutUrl, that.osmLogoutUrl);
    }

    public int hashCode() {
        return Objects.hash(this.consumerKey, this.consumerSecret, this.requestTokenUrl, this.accessTokenUrl, this.authoriseUrl, this.osmLoginUrl, this.osmLogoutUrl);
    }
}

