/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class DownloadRelationTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private final Collection<Relation> relations;
    private final OsmDataLayer layer;
    private MultiFetchServerObjectReader multiObjectReader;

    public DownloadRelationTask(Collection<Relation> relations, OsmDataLayer layer) {
        super(I18n.tr("Download relations", new Object[0]), false);
        CheckParameterUtil.ensureParameterNotNull(relations, "relations");
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.relations = relations;
        this.layer = layer;
        if (!layer.isDownloadable()) {
            throw new IllegalArgumentException("Non-downloadable layer: " + layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        DownloadRelationTask downloadRelationTask = this;
        synchronized (downloadRelationTask) {
            if (this.multiObjectReader != null) {
                this.multiObjectReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            DataSet allDownloads = new DataSet();
            this.getProgressMonitor().setTicksCount(this.relations.size());
            DataSet dataSet = null;
            DownloadRelationTask downloadRelationTask = this;
            synchronized (downloadRelationTask) {
                if (this.canceled) {
                    return;
                }
                this.multiObjectReader = MultiFetchServerObjectReader.create();
                this.multiObjectReader.setRecurseDownRelations(true).setRecurseDownAppended(false);
                this.multiObjectReader.append(this.relations);
                dataSet = this.multiObjectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            if (dataSet == null) {
                return;
            }
            downloadRelationTask = this;
            synchronized (downloadRelationTask) {
                if (this.canceled) {
                    return;
                }
            }
            new DataSetMerger(allDownloads, dataSet).merge();
            SwingUtilities.invokeAndWait(() -> {
                this.layer.mergeFrom(allDownloads);
                this.layer.onPostDownloadFromServer();
                MainApplication.getMap().repaint();
            });
        }
        catch (InterruptedException | InvocationTargetException | OsmTransferException e) {
            if (this.canceled) {
                Logging.warn(I18n.tr("Ignoring exception because task was canceled. Exception: {0}", e.toString()));
                return;
            }
            this.lastException = e;
        }
    }
}

