/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MoreObjects {
    public static <T> T firstNonNull(@Nullable T first, @Nullable T second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException("Both parameters are null");
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(self.getClass().getSimpleName());
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(clazz.getSimpleName());
    }

    public static ToStringHelper toStringHelper(String className2) {
        return new ToStringHelper(className2);
    }

    private MoreObjects() {
    }

    public static final class ToStringHelper {
        private final String className;
        private final ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;

        private ToStringHelper(String className2) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.className = Preconditions.checkNotNull(className2);
        }

        @CanIgnoreReturnValue
        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, @Nullable Object value2) {
            return this.addHolder(name, value2);
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, boolean value2) {
            return this.addHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, char value2) {
            return this.addHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, double value2) {
            return this.addHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, float value2) {
            return this.addHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, int value2) {
            return this.addHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, long value2) {
            return this.addHolder(name, String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(@Nullable Object value2) {
            return this.addHolder(value2);
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(boolean value2) {
            return this.addHolder(String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(char value2) {
            return this.addHolder(String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(double value2) {
            return this.addHolder(String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(float value2) {
            return this.addHolder(String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(int value2) {
            return this.addHolder(String.valueOf(value2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(long value2) {
            return this.addHolder(String.valueOf(value2));
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            String nextSeparator = "";
            StringBuilder builder2 = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                Object value2 = valueHolder.value;
                if (!omitNullValuesSnapshot || value2 != null) {
                    builder2.append(nextSeparator);
                    nextSeparator = ", ";
                    if (valueHolder.name != null) {
                        builder2.append(valueHolder.name).append('=');
                    }
                    if (value2 != null && value2.getClass().isArray()) {
                        Object[] objectArray = new Object[]{value2};
                        String arrayString = Arrays.deepToString(objectArray);
                        builder2.append(arrayString, 1, arrayString.length() - 1);
                    } else {
                        builder2.append(value2);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return builder2.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        private ToStringHelper addHolder(@Nullable Object value2) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value2;
            return this;
        }

        private ToStringHelper addHolder(String name, @Nullable Object value2) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value2;
            valueHolder.name = Preconditions.checkNotNull(name);
            return this;
        }

        private static final class ValueHolder {
            @Nullable String name;
            @Nullable Object value;
            @Nullable ValueHolder next;

            private ValueHolder() {
            }
        }
    }
}

