/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.plugins;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.plugins.PluginClasspathAndOptions;
import org.jetbrains.kotlin.cli.plugins.PluginsOptionsParserKt;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.compiler.plugin.CompilerPluginRegistrar;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.PluginProcessingException;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.util.ServiceLoaderLite;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J0\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0003J \u0010\u000e\u001a\u00020\t2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0002JE\u0010\u0010\u001a\u00020\u00112\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00122\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u0014J:\u0010\u0010\u001a\u00020\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\f\u001a\u00020\rH\u0007J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J(\u0010\u0019\u001a\u00020\t2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser;", "", "()V", "createClassLoader", "Ljava/net/URLClassLoader;", "classpath", "", "", "loadPluginsLegacyStyle", "", "pluginClasspaths", "pluginOptions", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "loadPluginsModernStyle", "rawPluginConfigurations", "loadPluginsSafe", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "", "pluginConfigurations", "([Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "", "loadRegisteredPluginsInfo", "", "Lorg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser$RegisteredPluginInfo;", "processPluginOptions", "classLoader", "RegisteredPluginInfo", "cli"})
@SourceDebugExtension(value={"SMAP\nPluginCliParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginCliParser.kt\norg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,166:1\n1549#2:167\n1620#2,3:168\n1549#2:172\n1620#2,3:173\n1#3:171\n37#4,2:176\n*E\n*S KotlinDebug\n*F\n+ 1 PluginCliParser.kt\norg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser\n*L\n84#1:167\n84#1,3:168\n163#1:172\n163#1,3:173\n163#1,2:176\n*E\n"})
public final class PluginCliParser {
    @NotNull
    public static final PluginCliParser INSTANCE;

    @JvmStatic
    @NotNull
    public static final ExitCode loadPluginsSafe(@Nullable String[] pluginClasspaths, @Nullable String[] pluginOptions, @Nullable String[] pluginConfigurations, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Object object = pluginClasspaths;
        Object object2 = pluginOptions;
        Object object3 = pluginConfigurations;
        return PluginCliParser.loadPluginsSafe(pluginClasspaths != null && (object = ArraysKt.toList(object)) != null ? (Collection)object : (Collection)CollectionsKt.emptyList(), pluginOptions != null && (object2 = ArraysKt.toList(object2)) != null ? (Collection)object2 : (Collection)CollectionsKt.emptyList(), pluginConfigurations != null && (object3 = ArraysKt.toList(object3)) != null ? (Collection)object3 : (Collection)CollectionsKt.emptyList(), configuration2);
    }

    @JvmStatic
    @NotNull
    public static final ExitCode loadPluginsSafe(@NotNull Collection<String> pluginClasspaths, @NotNull Collection<String> pluginOptions, @NotNull Collection<String> pluginConfigurations, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter(pluginClasspaths, "pluginClasspaths");
        Intrinsics.checkNotNullParameter(pluginOptions, "pluginOptions");
        Intrinsics.checkNotNullParameter(pluginConfigurations, "pluginConfigurations");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        MessageCollector messageCollector = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue(messageCollector, "configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        try {
            PluginCliParser.loadPluginsLegacyStyle((Iterable<String>)pluginClasspaths, (Iterable<String>)pluginOptions, configuration2);
            INSTANCE.loadPluginsModernStyle((Iterable<String>)pluginConfigurations, configuration2);
            return ExitCode.OK;
        }
        catch (PluginProcessingException e) {
            String string2 = e.getMessage();
            Intrinsics.checkNotNull(string2);
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, string2, null, 4, null);
        }
        catch (PluginCliOptionProcessingException e) {
            String message = e.getMessage() + "\n\n" + CliOptionsKt.cliPluginUsageString(e.getPluginId(), e.getOptions());
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, message, null, 4, null);
        }
        catch (CliOptionProcessingException e) {
            String string3 = e.getMessage();
            Intrinsics.checkNotNull(string3);
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, string3, null, 4, null);
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageCollector2, t);
        }
        return ExitCode.INTERNAL_ERROR;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RegisteredPluginInfo> loadRegisteredPluginsInfo(Iterable<String> rawPluginConfigurations) {
        void $this$mapTo$iv$iv;
        List<PluginClasspathAndOptions> pluginConfigurations = PluginsOptionsParserKt.extractPluginClasspathAndOptions(rawPluginConfigurations);
        Iterable $this$map$iv = pluginConfigurations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pluginConfiguration;
            PluginClasspathAndOptions pluginClasspathAndOptions = (PluginClasspathAndOptions)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            URLClassLoader classLoader2 = INSTANCE.createClassLoader((Iterable<String>)pluginConfiguration.getClasspath());
            List<ComponentRegistrar> componentRegistrars = ServiceLoaderLite.INSTANCE.loadImplementations(ComponentRegistrar.class, classLoader2);
            List<CompilerPluginRegistrar> compilerPluginRegistrars = ServiceLoaderLite.INSTANCE.loadImplementations(CompilerPluginRegistrar.class, classLoader2);
            Function1<List<? extends Object>, String> $fun$multiplePluginsErrorMessage$1 = new Function1<List<? extends Object>, String>((PluginClasspathAndOptions)pluginConfiguration){
                final /* synthetic */ PluginClasspathAndOptions $pluginConfiguration;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke(@NotNull List<? extends Object> pluginObjects) {
                    void $this$mapNotNullTo$iv$iv;
                    StringBuilder stringBuilder2;
                    Intrinsics.checkNotNullParameter(pluginObjects, "pluginObjects");
                    StringBuilder $this$buildString = stringBuilder2 = new StringBuilder();
                    boolean bl = false;
                    $this$buildString.append("Multiple plugins found in given classpath: ");
                    Iterable $this$mapNotNull$iv = pluginObjects;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        String string2;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl2 = false;
                        T it = element$iv$iv;
                        boolean bl3 = false;
                        if (Reflection.getOrCreateKotlinClass(it.getClass()).getQualifiedName() == null) continue;
                        String it$iv$iv = string2;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List extensionNames = (List)destination$iv$iv;
                    StringBuilder stringBuilder3 = $this$buildString;
                    String string3 = CollectionsKt.joinToString$default(extensionNames, ", ", null, null, 0, null, null, 62, null);
                    StringBuilder stringBuilder4 = stringBuilder3.append(string3);
                    Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(value)");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append('\\n')");
                    $this$buildString.append("  Plugin configuration is: " + this.$pluginConfiguration.getRawArgument());
                    String string4 = stringBuilder2.toString();
                    Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
                    return string4;
                }
                {
                    this.$pluginConfiguration = pluginClasspathAndOptions;
                    super(1);
                }
            };
            switch (componentRegistrars.size() + compilerPluginRegistrars.size()) {
                case 0: {
                    throw (Throwable)new PluginProcessingException("No plugins found in given classpath: " + CollectionsKt.joinToString$default(pluginConfiguration.getClasspath(), ",", null, null, 0, null, null, 62, null), null, 2, null);
                }
                case 1: {
                    break;
                }
                default: {
                    throw (Throwable)new PluginProcessingException($fun$multiplePluginsErrorMessage$1.invoke(CollectionsKt.plus((Collection)componentRegistrars, (Iterable)compilerPluginRegistrars)), null, 2, null);
                }
            }
            List<CommandLineProcessor> commandLineProcessor = ServiceLoaderLite.INSTANCE.loadImplementations(CommandLineProcessor.class, classLoader2);
            if (commandLineProcessor.size() > 1) {
                throw (Throwable)new PluginProcessingException($fun$multiplePluginsErrorMessage$1.invoke((List<Object>)commandLineProcessor), null, 2, null);
            }
            RegisteredPluginInfo registeredPluginInfo = new RegisteredPluginInfo(CollectionsKt.firstOrNull(componentRegistrars), CollectionsKt.firstOrNull(compilerPluginRegistrars), CollectionsKt.firstOrNull(commandLineProcessor), pluginConfiguration.getOptions());
            collection.add(registeredPluginInfo);
        }
        List pluginInfos2 = (List)destination$iv$iv;
        return pluginInfos2;
    }

    private final void loadPluginsModernStyle(Iterable<String> rawPluginConfigurations, CompilerConfiguration configuration2) {
        if (rawPluginConfigurations == null) {
            return;
        }
        List<RegisteredPluginInfo> pluginInfos2 = this.loadRegisteredPluginsInfo(rawPluginConfigurations);
        for (RegisteredPluginInfo pluginInfo : pluginInfos2) {
            CommandLineProcessor commandLineProcessor;
            Object it;
            Object object;
            if (pluginInfo.getComponentRegistrar() != null) {
                it = object;
                boolean bl = false;
                configuration2.add(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS(), it);
            }
            if (pluginInfo.getCompilerPluginRegistrar() != null) {
                it = object;
                boolean bl = false;
                configuration2.add(CompilerPluginRegistrar.Companion.getCOMPILER_PLUGIN_REGISTRARS(), it);
            }
            if (pluginInfo.getPluginOptions().isEmpty()) continue;
            if (pluginInfo.getCommandLineProcessor() == null) {
                throw (Throwable)new RuntimeException();
            }
            PluginsOptionsParserKt.processCompilerPluginOptions(commandLineProcessor, pluginInfo.getPluginOptions(), configuration2);
        }
    }

    @JvmStatic
    private static final void loadPluginsLegacyStyle(Iterable<String> pluginClasspaths, Iterable<String> pluginOptions, CompilerConfiguration configuration2) {
        Iterable iterable = pluginClasspaths;
        if (iterable == null) {
            iterable = CollectionsKt.emptyList();
        }
        URLClassLoader classLoader2 = INSTANCE.createClassLoader(iterable);
        List<ComponentRegistrar> componentRegistrars = ServiceLoaderLite.INSTANCE.loadImplementations(ComponentRegistrar.class, classLoader2);
        configuration2.addAll(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS(), (Collection)componentRegistrars);
        List<CompilerPluginRegistrar> compilerPluginRegistrars = ServiceLoaderLite.INSTANCE.loadImplementations(CompilerPluginRegistrar.class, classLoader2);
        configuration2.addAll(CompilerPluginRegistrar.Companion.getCOMPILER_PLUGIN_REGISTRARS(), (Collection)compilerPluginRegistrars);
        INSTANCE.processPluginOptions(pluginOptions, configuration2, classLoader2);
    }

    private final void processPluginOptions(Iterable<String> pluginOptions, CompilerConfiguration configuration2, URLClassLoader classLoader2) {
        List<CommandLineProcessor> commandLineProcessors = ServiceLoaderLite.INSTANCE.loadImplementations(CommandLineProcessor.class, classLoader2);
        PluginsOptionsParserKt.processCompilerPluginsOptions(configuration2, pluginOptions, commandLineProcessors);
    }

    /*
     * WARNING - void declaration
     */
    private final URLClassLoader createClassLoader(Iterable<String> classpath) {
        Collection<URL> collection;
        void $this$mapTo$iv$iv;
        Iterable<String> $this$map$iv = classpath;
        boolean $i$f$map = false;
        Iterable<String> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            URL uRL = new File((String)it).toURI().toURL();
            collection.add(uRL);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ClassLoader classLoader2 = this.getClass().getClassLoader();
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        return new URLClassLoader(uRLArray, classLoader2);
    }

    private PluginCliParser() {
    }

    static {
        PluginCliParser pluginCliParser;
        INSTANCE = pluginCliParser = new PluginCliParser();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser$RegisteredPluginInfo;", "", "componentRegistrar", "Lorg/jetbrains/kotlin/compiler/plugin/ComponentRegistrar;", "compilerPluginRegistrar", "Lorg/jetbrains/kotlin/compiler/plugin/CompilerPluginRegistrar;", "commandLineProcessor", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "pluginOptions", "", "Lorg/jetbrains/kotlin/compiler/plugin/CliOptionValue;", "(Lorg/jetbrains/kotlin/compiler/plugin/ComponentRegistrar;Lorg/jetbrains/kotlin/compiler/plugin/CompilerPluginRegistrar;Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;Ljava/util/List;)V", "getCommandLineProcessor", "()Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "getCompilerPluginRegistrar", "()Lorg/jetbrains/kotlin/compiler/plugin/CompilerPluginRegistrar;", "getComponentRegistrar", "()Lorg/jetbrains/kotlin/compiler/plugin/ComponentRegistrar;", "getPluginOptions", "()Ljava/util/List;", "cli"})
    public static final class RegisteredPluginInfo {
        @Nullable
        private final ComponentRegistrar componentRegistrar;
        @Nullable
        private final CompilerPluginRegistrar compilerPluginRegistrar;
        @Nullable
        private final CommandLineProcessor commandLineProcessor;
        @NotNull
        private final List<CliOptionValue> pluginOptions;

        @Nullable
        public final ComponentRegistrar getComponentRegistrar() {
            return this.componentRegistrar;
        }

        @Nullable
        public final CompilerPluginRegistrar getCompilerPluginRegistrar() {
            return this.compilerPluginRegistrar;
        }

        @Nullable
        public final CommandLineProcessor getCommandLineProcessor() {
            return this.commandLineProcessor;
        }

        @NotNull
        public final List<CliOptionValue> getPluginOptions() {
            return this.pluginOptions;
        }

        public RegisteredPluginInfo(@Nullable ComponentRegistrar componentRegistrar, @Nullable CompilerPluginRegistrar compilerPluginRegistrar, @Nullable CommandLineProcessor commandLineProcessor, @NotNull List<CliOptionValue> pluginOptions) {
            Intrinsics.checkNotNullParameter(pluginOptions, "pluginOptions");
            this.componentRegistrar = componentRegistrar;
            this.compilerPluginRegistrar = compilerPluginRegistrar;
            this.commandLineProcessor = commandLineProcessor;
            this.pluginOptions = pluginOptions;
        }
    }
}

