/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.CheckersComponentKt;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.util.LocalPropertyAndCapturedWriteCollector;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.cfa.FirControlFlowChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationCheckers;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirControlFlowGraphOwner;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0018\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0018\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ControlFlowAnalysisDiagnosticComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "declarationCheckers", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationCheckers;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationCheckers;)V", "cfaCheckers", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/cfa/FirControlFlowChecker;", "variableAssignmentCheckers", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "analyze", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirControlFlowGraphOwner;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "data", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkers"})
@SourceDebugExtension(value={"SMAP\nControlFlowAnalysisDiagnosticComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowAnalysisDiagnosticComponent.kt\norg/jetbrains/kotlin/fir/analysis/collectors/components/ControlFlowAnalysisDiagnosticComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1855#2,2:73\n1855#2,2:75\n*S KotlinDebug\n*F\n+ 1 ControlFlowAnalysisDiagnosticComponent.kt\norg/jetbrains/kotlin/fir/analysis/collectors/components/ControlFlowAnalysisDiagnosticComponent\n*L\n29#1:73,2\n34#1:75,2\n*E\n"})
public final class ControlFlowAnalysisDiagnosticComponent
extends AbstractDiagnosticCollectorComponent {
    @NotNull
    private final Set<FirControlFlowChecker> cfaCheckers;
    @NotNull
    private final Set<AbstractFirPropertyInitializationChecker> variableAssignmentCheckers;

    public ControlFlowAnalysisDiagnosticComponent(@NotNull FirSession session2, @NotNull DiagnosticReporter reporter, @NotNull DeclarationCheckers declarationCheckers) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declarationCheckers, "declarationCheckers");
        super(session2, reporter);
        this.cfaCheckers = declarationCheckers.getControlFlowAnalyserCheckers();
        this.variableAssignmentCheckers = declarationCheckers.getVariableAssignmentCfaBasedCheckers();
    }

    public /* synthetic */ ControlFlowAnalysisDiagnosticComponent(FirSession firSession, DiagnosticReporter diagnosticReporter, DeclarationCheckers declarationCheckers, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            declarationCheckers = CheckersComponentKt.getCheckersComponent(firSession).getDeclarationCheckers();
        }
        this(firSession, diagnosticReporter, declarationCheckers);
    }

    private final void analyze(FirControlFlowGraphOwner declaration, CheckerContext context) {
        Object object = declaration.getControlFlowGraphReference();
        if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return;
        }
        Object graph = object;
        if (((ControlFlowGraph)graph).isSubGraph()) {
            return;
        }
        Iterable $this$forEach$iv = this.cfaCheckers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirControlFlowChecker it = (FirControlFlowChecker)element$iv;
            boolean bl = false;
            it.analyze((ControlFlowGraph)graph, this.getReporter(), context);
        }
        Pair<Set<FirPropertySymbol>, Set<FirVariableAssignment>> pair = LocalPropertyAndCapturedWriteCollector.Companion.collect((ControlFlowGraph)graph);
        Set<FirPropertySymbol> properties2 = pair.component1();
        Set<FirVariableAssignment> capturedWrites = pair.component2();
        if (!((Collection)properties2).isEmpty()) {
            PropertyInitializationInfoData data2 = new PropertyInitializationInfoData(properties2, (ControlFlowGraph)graph);
            Iterable $this$forEach$iv2 = this.variableAssignmentCheckers;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AbstractFirPropertyInitializationChecker it = (AbstractFirPropertyInitializationChecker)element$iv;
                boolean bl = false;
                it.analyze((ControlFlowGraph)graph, this.getReporter(), data2, properties2, capturedWrites, context);
            }
        }
    }

    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(regularClass, data2);
    }

    @Override
    public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(anonymousObject, data2);
    }

    @Override
    public void visitProperty(@NotNull FirProperty property2, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(property2, "property");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(property2, data2);
    }

    @Override
    public void visitFunction(@NotNull FirFunction function2, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(function2, data2);
    }

    @Override
    public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(simpleFunction, data2);
    }

    @Override
    public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(propertyAccessor, "propertyAccessor");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(propertyAccessor, data2);
    }

    @Override
    public void visitConstructor(@NotNull FirConstructor constructor2, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.analyze(constructor2, data2);
    }
}

