/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.AbstractIrTypeSubstitutor;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeSubstitutor;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/types/IrTypeSubstitutor;", "Lorg/jetbrains/kotlin/ir/types/AbstractIrTypeSubstitutor;", "typeParameters", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "typeArguments", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/ir/IrBuiltIns;)V", "substitution", "", "getSubstitutionArgument", "typeParameter", "isEmptySubstitution", "", "ir.tree"})
public final class IrTypeSubstitutor
extends AbstractIrTypeSubstitutor {
    @NotNull
    private final Map<IrTypeParameterSymbol, IrTypeArgument> substitution;

    public IrTypeSubstitutor(@NotNull List<? extends IrTypeParameterSymbol> typeParameters2, @NotNull List<? extends IrTypeArgument> typeArguments, @NotNull IrBuiltIns irBuiltIns) {
        boolean bl;
        Intrinsics.checkNotNullParameter(typeParameters2, "typeParameters");
        Intrinsics.checkNotNullParameter(typeArguments, "typeArguments");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        super(irBuiltIns);
        boolean bl2 = bl = typeParameters2.size() == typeArguments.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Unexpected number of type arguments: " + typeArguments.size() + "\nType parameters are:\n" + CollectionsKt.joinToString$default(typeParameters2, "\n", null, null, 0, null, 1.1.INSTANCE, 30, null) + "Type arguments are:\n" + CollectionsKt.joinToString$default(typeArguments, "\n", null, null, 0, null, 1.2.INSTANCE, 30, null);
            throw new AssertionError((Object)string2);
        }
        this.substitution = MapsKt.toMap(CollectionsKt.zip((Iterable)typeParameters2, (Iterable)typeArguments));
    }

    @Override
    @NotNull
    public IrTypeArgument getSubstitutionArgument(@NotNull IrTypeParameterSymbol typeParameter2) {
        Intrinsics.checkNotNullParameter(typeParameter2, "typeParameter");
        IrTypeArgument irTypeArgument = this.substitution.get(typeParameter2);
        if (irTypeArgument == null) {
            throw new AssertionError((Object)("Unsubstituted type parameter: " + RenderIrElementKt.render((IrElement)typeParameter2.getOwner())));
        }
        return irTypeArgument;
    }

    @Override
    public boolean isEmptySubstitution() {
        return this.substitution.isEmpty();
    }
}

