// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATtiny87.atdf, see http://packs.download.atmel.com/

//go:build avr && attiny87

// Device information for the ATtiny87.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATtiny87"
	ARCH   = "AVR8"
	FAMILY = "tinyAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Reset, Power-on Reset and Watchdog Reset
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_INT1         = 2  // External Interrupt Request 1
	IRQ_PCINT0       = 3  // Pin Change Interrupt Request 0
	IRQ_PCINT1       = 4  // Pin Change Interrupt Request 1
	IRQ_WDT          = 5  // Watchdog Time-Out Interrupt
	IRQ_TIMER1_CAPT  = 6  // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 7  // Timer/Counter1 Compare Match 1A
	IRQ_TIMER1_COMPB = 8  // Timer/Counter1 Compare Match 1B
	IRQ_TIMER1_OVF   = 9  // Timer/Counter1 Overflow
	IRQ_TIMER0_COMPA = 10 // Timer/Counter0 Compare Match 0A
	IRQ_TIMER0_OVF   = 11 // Timer/Counter0 Overflow
	IRQ_LIN_TC       = 12 // LIN Transfer Complete
	IRQ_LIN_ERR      = 13 // LIN Error
	IRQ_SPI_STC      = 14 // SPI Serial Transfer Complete
	IRQ_ADC          = 15 // ADC Conversion Complete
	IRQ_EE_RDY       = 16 // EEPROM Ready
	IRQ_ANA_COMP     = 17 // Analog Comparator
	IRQ_USI_START    = 18 // USI Start Condition Detection
	IRQ_USI_OVF      = 19 // USI Counter Overflow
	IRQ_max          = 19 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_INT1
//go:interrupt
func interruptINT1() {
	callHandlers(IRQ_INT1)
}

//export __vector_PCINT0
//go:interrupt
func interruptPCINT0() {
	callHandlers(IRQ_PCINT0)
}

//export __vector_PCINT1
//go:interrupt
func interruptPCINT1() {
	callHandlers(IRQ_PCINT1)
}

//export __vector_WDT
//go:interrupt
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIMER0_COMPA
//go:interrupt
func interruptTIMER0_COMPA() {
	callHandlers(IRQ_TIMER0_COMPA)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_LIN_TC
//go:interrupt
func interruptLIN_TC() {
	callHandlers(IRQ_LIN_TC)
}

//export __vector_LIN_ERR
//go:interrupt
func interruptLIN_ERR() {
	callHandlers(IRQ_LIN_ERR)
}

//export __vector_SPI_STC
//go:interrupt
func interruptSPI_STC() {
	callHandlers(IRQ_SPI_STC)
}

//export __vector_ADC
//go:interrupt
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export __vector_EE_RDY
//go:interrupt
func interruptEE_RDY() {
	callHandlers(IRQ_EE_RDY)
}

//export __vector_ANA_COMP
//go:interrupt
func interruptANA_COMP() {
	callHandlers(IRQ_ANA_COMP)
}

//export __vector_USI_START
//go:interrupt
func interruptUSI_START() {
	callHandlers(IRQ_USI_START)
}

//export __vector_USI_OVF
//go:interrupt
func interruptUSI_OVF() {
	callHandlers(IRQ_USI_OVF)
}

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// I/O Port
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))

	// Local Interconnect Network
	LINCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc8)))
	LINSIR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc9)))
	LINENIR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xca)))
	LINERR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcb)))
	LINBTR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcc)))
	LINBRRL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcd)))
	LINBRRH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xce)))
	LINDLR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcf)))
	LINIDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd0)))
	LINSEL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd1)))
	LINDAT  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd2)))

	// Universal Serial Interface
	USIPP = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbc)))
	USIBR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbb)))
	USIDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xba)))
	USISR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb9)))
	USICR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb8)))

	// Timer/Counter, 8-bit Async
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	ASSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb6)))
	GTCCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))

	// Timer/Counter, 16-bit
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCCR1D = (*volatile.Register8)(unsafe.Pointer(uintptr(0x83)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))

	// Watchdog Timer
	WDTCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// Serial Peripheral Interface
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))

	// Analog-to-Digital Converter
	ADMUX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	ADCL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	ADCH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	ADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	ADCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7b)))
	AMISCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x77)))
	DIDR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))
	DIDR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))

	// Current Source

	// Analog Comparator
	ACSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))

	// Bootloader
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// CPU Registers
	SREG    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	PRR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))
	SPL     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	MCUCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	SMCR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	OSCCAL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	CLKPR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	CLKSELR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x63)))
	CLKCSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x62)))
	DWDR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x51)))
	GPIOR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	GPIOR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	GPIOR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	PORTCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x32)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_SELFPRGEN     = 0x1 // Self Programming enable
	EXTENDED_SELFPRGEN_Msk = 0x1 // Self Programming enable

	// HIGH
	HIGH_RSTDISBL     = 0x80 // Reset Disabled (Enable PB7 as i/o pin)
	HIGH_RSTDISBL_Msk = 0x80 // Reset Disabled (Enable PB7 as i/o pin)
	HIGH_DWEN         = 0x40 // Debug Wire enable
	HIGH_DWEN_Msk     = 0x40 // Debug Wire enable
	HIGH_SPIEN        = 0x20 // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk    = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON        = 0x10 // Watch-dog Timer always ON
	HIGH_WDTON_Msk    = 0x10 // Watch-dog Timer always ON
	HIGH_EESAVE       = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk   = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BODLEVEL0    = 0x1  // Brown-out Detector trigger level
	HIGH_BODLEVEL1    = 0x2  // Brown-out Detector trigger level
	HIGH_BODLEVEL2    = 0x4  // Brown-out Detector trigger level
	HIGH_BODLEVEL_Msk = 0x7  // Brown-out Detector trigger level

	// LOW
	LOW_CKDIV8        = 0x80 // Divide clock by 8 internally
	LOW_CKDIV8_Msk    = 0x80 // Divide clock by 8 internally
	LOW_CKOUT         = 0x40 // Clock output on PORTB5
	LOW_CKOUT_Msk     = 0x40 // Clock output on PORTB5
	LOW_SUT_CKSEL0    = 0x1  // Select Clock source
	LOW_SUT_CKSEL1    = 0x2  // Select Clock source
	LOW_SUT_CKSEL2    = 0x4  // Select Clock source
	LOW_SUT_CKSEL3    = 0x8  // Select Clock source
	LOW_SUT_CKSEL4    = 0x10 // Select Clock source
	LOW_SUT_CKSEL5    = 0x20 // Select Clock source
	LOW_SUT_CKSEL_Msk = 0x3f // Select Clock source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0    = 0x1 // Memory Lock
	LOCKBIT_LB1    = 0x2 // Memory Lock
	LOCKBIT_LB_Msk = 0x3 // Memory Lock
)

// Bitfields for LINUART: Local Interconnect Network
const (
	// LINCR: LIN Control Register
	LINCR_LSWRES     = 0x80 // Software Reset
	LINCR_LSWRES_Msk = 0x80 // Software Reset
	LINCR_LIN13      = 0x40 // LIN Standard
	LINCR_LIN13_Msk  = 0x40 // LIN Standard
	LINCR_LCONF0     = 0x10 // LIN Configuration bits
	LINCR_LCONF1     = 0x20 // LIN Configuration bits
	LINCR_LCONF_Msk  = 0x30 // LIN Configuration bits
	LINCR_LENA       = 0x8  // LIN or UART Enable
	LINCR_LENA_Msk   = 0x8  // LIN or UART Enable
	LINCR_LCMD0      = 0x1  // LIN Command and Mode bits
	LINCR_LCMD1      = 0x2  // LIN Command and Mode bits
	LINCR_LCMD2      = 0x4  // LIN Command and Mode bits
	LINCR_LCMD_Msk   = 0x7  // LIN Command and Mode bits

	// LINSIR: LIN Status and Interrupt Register
	LINSIR_LIDST0    = 0x20 // Identifier Status bits
	LINSIR_LIDST1    = 0x40 // Identifier Status bits
	LINSIR_LIDST2    = 0x80 // Identifier Status bits
	LINSIR_LIDST_Msk = 0xe0 // Identifier Status bits
	LINSIR_LBUSY     = 0x10 // Busy Signal
	LINSIR_LBUSY_Msk = 0x10 // Busy Signal
	LINSIR_LERR      = 0x8  // Error Interrupt
	LINSIR_LERR_Msk  = 0x8  // Error Interrupt
	LINSIR_LIDOK     = 0x4  // Identifier Interrupt
	LINSIR_LIDOK_Msk = 0x4  // Identifier Interrupt
	LINSIR_LTXOK     = 0x2  // Transmit Performed Interrupt
	LINSIR_LTXOK_Msk = 0x2  // Transmit Performed Interrupt
	LINSIR_LRXOK     = 0x1  // Receive Performed Interrupt
	LINSIR_LRXOK_Msk = 0x1  // Receive Performed Interrupt

	// LINENIR: LIN Enable Interrupt Register
	LINENIR_LENERR      = 0x8 // Enable Error Interrupt
	LINENIR_LENERR_Msk  = 0x8 // Enable Error Interrupt
	LINENIR_LENIDOK     = 0x4 // Enable Identifier Interrupt
	LINENIR_LENIDOK_Msk = 0x4 // Enable Identifier Interrupt
	LINENIR_LENTXOK     = 0x2 // Enable Transmit Performed Interrupt
	LINENIR_LENTXOK_Msk = 0x2 // Enable Transmit Performed Interrupt
	LINENIR_LENRXOK     = 0x1 // Enable Receive Performed Interrupt
	LINENIR_LENRXOK_Msk = 0x1 // Enable Receive Performed Interrupt

	// LINERR: LIN Error Register
	LINERR_LABORT     = 0x80 // Abort Flag
	LINERR_LABORT_Msk = 0x80 // Abort Flag
	LINERR_LTOERR     = 0x40 // Frame Time Out Error Flag
	LINERR_LTOERR_Msk = 0x40 // Frame Time Out Error Flag
	LINERR_LOVERR     = 0x20 // Overrun Error Flag
	LINERR_LOVERR_Msk = 0x20 // Overrun Error Flag
	LINERR_LFERR      = 0x10 // Framing Error Flag
	LINERR_LFERR_Msk  = 0x10 // Framing Error Flag
	LINERR_LSERR      = 0x8  // Synchronization Error Flag
	LINERR_LSERR_Msk  = 0x8  // Synchronization Error Flag
	LINERR_LPERR      = 0x4  // Parity Error Flag
	LINERR_LPERR_Msk  = 0x4  // Parity Error Flag
	LINERR_LCERR      = 0x2  // Checksum Error Flag
	LINERR_LCERR_Msk  = 0x2  // Checksum Error Flag
	LINERR_LBERR      = 0x1  // Bit Error Flag
	LINERR_LBERR_Msk  = 0x1  // Bit Error Flag

	// LINBTR: LIN Bit Timing Register
	LINBTR_LDISR     = 0x80 // Disable Bit Timing Resynchronization
	LINBTR_LDISR_Msk = 0x80 // Disable Bit Timing Resynchronization
	LINBTR_LBT0      = 0x1  // LIN Bit Timing bits
	LINBTR_LBT1      = 0x2  // LIN Bit Timing bits
	LINBTR_LBT2      = 0x4  // LIN Bit Timing bits
	LINBTR_LBT3      = 0x8  // LIN Bit Timing bits
	LINBTR_LBT4      = 0x10 // LIN Bit Timing bits
	LINBTR_LBT5      = 0x20 // LIN Bit Timing bits
	LINBTR_LBT_Msk   = 0x3f // LIN Bit Timing bits

	// LINBRRL: LIN Baud Rate Low Register
	LINBRRL_LDIV0    = 0x1
	LINBRRL_LDIV1    = 0x2
	LINBRRL_LDIV2    = 0x4
	LINBRRL_LDIV3    = 0x8
	LINBRRL_LDIV4    = 0x10
	LINBRRL_LDIV5    = 0x20
	LINBRRL_LDIV6    = 0x40
	LINBRRL_LDIV7    = 0x80
	LINBRRL_LDIV_Msk = 0xff

	// LINBRRH: LIN Baud Rate High Register
	LINBRRH_LDIV0    = 0x1
	LINBRRH_LDIV1    = 0x2
	LINBRRH_LDIV2    = 0x4
	LINBRRH_LDIV3    = 0x8
	LINBRRH_LDIV_Msk = 0xf

	// LINDLR: LIN Data Length Register
	LINDLR_LTXDL0    = 0x10 // LIN Transmit Data Length bits
	LINDLR_LTXDL1    = 0x20 // LIN Transmit Data Length bits
	LINDLR_LTXDL2    = 0x40 // LIN Transmit Data Length bits
	LINDLR_LTXDL3    = 0x80 // LIN Transmit Data Length bits
	LINDLR_LTXDL_Msk = 0xf0 // LIN Transmit Data Length bits
	LINDLR_LRXDL0    = 0x1  // LIN Receive Data Length bits
	LINDLR_LRXDL1    = 0x2  // LIN Receive Data Length bits
	LINDLR_LRXDL2    = 0x4  // LIN Receive Data Length bits
	LINDLR_LRXDL3    = 0x8  // LIN Receive Data Length bits
	LINDLR_LRXDL_Msk = 0xf  // LIN Receive Data Length bits

	// LINIDR: LIN Identifier Register
	LINIDR_LP0     = 0x40 // Parity bits
	LINIDR_LP1     = 0x80 // Parity bits
	LINIDR_LP_Msk  = 0xc0 // Parity bits
	LINIDR_LID0    = 0x1  // Identifier bit 5 or Data Length bits
	LINIDR_LID1    = 0x2  // Identifier bit 5 or Data Length bits
	LINIDR_LID2    = 0x4  // Identifier bit 5 or Data Length bits
	LINIDR_LID3    = 0x8  // Identifier bit 5 or Data Length bits
	LINIDR_LID4    = 0x10 // Identifier bit 5 or Data Length bits
	LINIDR_LID5    = 0x20 // Identifier bit 5 or Data Length bits
	LINIDR_LID_Msk = 0x3f // Identifier bit 5 or Data Length bits

	// LINSEL: LIN Data Buffer Selection Register
	LINSEL_LAINC     = 0x8 // Auto Increment of Data Buffer Index (Active Low)
	LINSEL_LAINC_Msk = 0x8 // Auto Increment of Data Buffer Index (Active Low)
	LINSEL_LINDX0    = 0x1 // FIFO LIN Data Buffer Index bits
	LINSEL_LINDX1    = 0x2 // FIFO LIN Data Buffer Index bits
	LINSEL_LINDX2    = 0x4 // FIFO LIN Data Buffer Index bits
	LINSEL_LINDX_Msk = 0x7 // FIFO LIN Data Buffer Index bits

	// LINDAT: LIN Data Register
	LINDAT_LDATA0    = 0x1
	LINDAT_LDATA1    = 0x2
	LINDAT_LDATA2    = 0x4
	LINDAT_LDATA3    = 0x8
	LINDAT_LDATA4    = 0x10
	LINDAT_LDATA5    = 0x20
	LINDAT_LDATA6    = 0x40
	LINDAT_LDATA7    = 0x80
	LINDAT_LDATA_Msk = 0xff
)

// Bitfields for USI: Universal Serial Interface
const (
	// USISR: USI Status Register
	USISR_USISIF     = 0x80 // Start Condition Interrupt Flag
	USISR_USISIF_Msk = 0x80 // Start Condition Interrupt Flag
	USISR_USIOIF     = 0x40 // Counter Overflow Interrupt Flag
	USISR_USIOIF_Msk = 0x40 // Counter Overflow Interrupt Flag
	USISR_USIPF      = 0x20 // Stop Condition Flag
	USISR_USIPF_Msk  = 0x20 // Stop Condition Flag
	USISR_USIDC      = 0x10 // Data Output Collision
	USISR_USIDC_Msk  = 0x10 // Data Output Collision
	USISR_USICNT0    = 0x1  // USI Counter Value Bits
	USISR_USICNT1    = 0x2  // USI Counter Value Bits
	USISR_USICNT2    = 0x4  // USI Counter Value Bits
	USISR_USICNT3    = 0x8  // USI Counter Value Bits
	USISR_USICNT_Msk = 0xf  // USI Counter Value Bits

	// USICR: USI Control Register
	USICR_USISIE     = 0x80 // Start Condition Interrupt Enable
	USICR_USISIE_Msk = 0x80 // Start Condition Interrupt Enable
	USICR_USIOIE     = 0x40 // Counter Overflow Interrupt Enable
	USICR_USIOIE_Msk = 0x40 // Counter Overflow Interrupt Enable
	USICR_USIWM0     = 0x10 // USI Wire Mode Bits
	USICR_USIWM1     = 0x20 // USI Wire Mode Bits
	USICR_USIWM_Msk  = 0x30 // USI Wire Mode Bits
	USICR_USICS0     = 0x4  // USI Clock Source Select Bits
	USICR_USICS1     = 0x8  // USI Clock Source Select Bits
	USICR_USICS_Msk  = 0xc  // USI Clock Source Select Bits
	USICR_USICLK     = 0x2  // Clock Strobe
	USICR_USICLK_Msk = 0x2  // Clock Strobe
	USICR_USITC      = 0x1  // Toggle Clock Port Pin
	USICR_USITC_Msk  = 0x1  // Toggle Clock Port Pin
)

// Bitfields for TC8_ASYNC: Timer/Counter, 8-bit Async
const (
	// TIMSK0: Timer/Counter0 Interrupt Mask register
	TIMSK0_OCIE0A     = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_OCIE0A_Msk = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0      = 0x1 // Timer/Counter0 Overflow Interrupt Enable
	TIMSK0_TOIE0_Msk  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag Register
	TIFR0_OCF0A     = 0x2 // Output Compare Flag 0A
	TIFR0_OCF0A_Msk = 0x2 // Output Compare Flag 0A
	TIFR0_TOV0      = 0x1 // Timer/Counter0 Overflow Flag
	TIFR0_TOV0_Msk  = 0x1 // Timer/Counter0 Overflow Flag

	// TCCR0A: Timer/Counter0 Control Register A
	TCCR0A_COM0A0    = 0x40 // Compare Output Mode bits
	TCCR0A_COM0A1    = 0x80 // Compare Output Mode bits
	TCCR0A_COM0A_Msk = 0xc0 // Compare Output Mode bits
	TCCR0A_WGM00     = 0x1  // Waveform Genration Mode bits
	TCCR0A_WGM01     = 0x2  // Waveform Genration Mode bits
	TCCR0A_WGM0_Msk  = 0x3  // Waveform Genration Mode bits

	// TCCR0B: Timer/Counter0 Control Register B
	TCCR0B_FOC0A     = 0x80 // Force Output Compare A
	TCCR0B_FOC0A_Msk = 0x80 // Force Output Compare A
	TCCR0B_CS00      = 0x1  // Clock Select bits
	TCCR0B_CS01      = 0x2  // Clock Select bits
	TCCR0B_CS02      = 0x4  // Clock Select bits
	TCCR0B_CS0_Msk   = 0x7  // Clock Select bits

	// ASSR: Asynchronous Status Register
	ASSR_EXCLK       = 0x40 // Enable External Clock Input
	ASSR_EXCLK_Msk   = 0x40 // Enable External Clock Input
	ASSR_AS0         = 0x20 // Asynchronous Timer/Counter0
	ASSR_AS0_Msk     = 0x20 // Asynchronous Timer/Counter0
	ASSR_TCN0UB      = 0x10 // Timer/Counter0 Update Busy
	ASSR_TCN0UB_Msk  = 0x10 // Timer/Counter0 Update Busy
	ASSR_OCR0AUB     = 0x8  // Output Compare Register 0A  Update Busy
	ASSR_OCR0AUB_Msk = 0x8  // Output Compare Register 0A  Update Busy
	ASSR_TCR0AUB     = 0x2  // Timer/Counter0 Control Register A Update Busy
	ASSR_TCR0AUB_Msk = 0x2  // Timer/Counter0 Control Register A Update Busy
	ASSR_TCR0BUB     = 0x1  // Timer/Counter0 Control Register B Update Busy
	ASSR_TCR0BUB_Msk = 0x1  // Timer/Counter0 Control Register B Update Busy

	// GTCCR: General Timer Counter Control register
	GTCCR_TSM      = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_TSM_Msk  = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_PSR0     = 0x2  // Prescaler Reset Asynchronous 8-bit Timer/Counter0
	GTCCR_PSR0_Msk = 0x2  // Prescaler Reset Asynchronous 8-bit Timer/Counter0
	GTCCR_PSR1     = 0x1  // Prescaler Reset Synchronous 16-bit Timer/Counter1
	GTCCR_PSR1_Msk = 0x1  // Prescaler Reset Synchronous 16-bit Timer/Counter1
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TIMSK1: Timer/Counter1 Interrupt Mask Register
	TIMSK1_ICIE1      = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_ICIE1_Msk  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1B     = 0x4  // Timer/Counter1 Output Compare B Match Interrupt Enable
	TIMSK1_OCIE1B_Msk = 0x4  // Timer/Counter1 Output Compare B Match Interrupt Enable
	TIMSK1_OCIE1A     = 0x2  // Timer/Counter1 Output Compare A Match Interrupt Enable
	TIMSK1_OCIE1A_Msk = 0x2  // Timer/Counter1 Output Compare A Match Interrupt Enable
	TIMSK1_TOIE1      = 0x1  // Timer/Counter1 Overflow Interrupt Enable
	TIMSK1_TOIE1_Msk  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter1 Interrupt Flag register
	TIFR1_ICF1      = 0x20 // Timer/Counter1 Input Capture Flag
	TIFR1_ICF1_Msk  = 0x20 // Timer/Counter1 Input Capture Flag
	TIFR1_OCF1B     = 0x4  // Timer/Counter1 Output Compare B Match Flag
	TIFR1_OCF1B_Msk = 0x4  // Timer/Counter1 Output Compare B Match Flag
	TIFR1_OCF1A     = 0x2  // Timer/Counter1 Output Compare A Match Flag
	TIFR1_OCF1A_Msk = 0x2  // Timer/Counter1 Output Compare A Match Flag
	TIFR1_TOV1      = 0x1  // Timer/Counter1 Overflow Flag
	TIFR1_TOV1_Msk  = 0x1  // Timer/Counter1 Overflow Flag

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0    = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1    = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1B_Msk = 0x30 // Compare Output Mode 1B, bits
	TCCR1A_WGM10     = 0x1  // Pulse Width Modulator Select Bits
	TCCR1A_WGM11     = 0x2  // Pulse Width Modulator Select Bits
	TCCR1A_WGM1_Msk  = 0x3  // Pulse Width Modulator Select Bits

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1     = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICNC1_Msk = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1     = 0x40 // Input Capture 1 Edge Select
	TCCR1B_ICES1_Msk = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10     = 0x8  // Waveform Generation Mode Bits
	TCCR1B_WGM11     = 0x10 // Waveform Generation Mode Bits
	TCCR1B_WGM1_Msk  = 0x18 // Waveform Generation Mode Bits
	TCCR1B_CS10      = 0x1  // Timer/Counter1 Clock Select bits
	TCCR1B_CS11      = 0x2  // Timer/Counter1 Clock Select bits
	TCCR1B_CS12      = 0x4  // Timer/Counter1 Clock Select bits
	TCCR1B_CS1_Msk   = 0x7  // Timer/Counter1 Clock Select bits

	// TCCR1C: Timer/Counter1 Control Register C
	TCCR1C_FOC1A     = 0x80 // Timer/Counter1 Force Output Compare for Channel A
	TCCR1C_FOC1A_Msk = 0x80 // Timer/Counter1 Force Output Compare for Channel A
	TCCR1C_FOC1B     = 0x40 // Timer/Counter1 Force Output Compare for Channel B
	TCCR1C_FOC1B_Msk = 0x40 // Timer/Counter1 Force Output Compare for Channel B

	// TCCR1D: Timer/Counter1 Control Register D
	TCCR1D_OC1BX     = 0x80 // Timer/Counter1 Output Compare X-pin Enable for Channel B
	TCCR1D_OC1BX_Msk = 0x80 // Timer/Counter1 Output Compare X-pin Enable for Channel B
	TCCR1D_OC1BW     = 0x40 // Timer/Counter1 Output Compare W-pin Enable for Channel B
	TCCR1D_OC1BW_Msk = 0x40 // Timer/Counter1 Output Compare W-pin Enable for Channel B
	TCCR1D_OC1BV     = 0x20 // Timer/Counter1 Output Compare V-pin Enable for Channel B
	TCCR1D_OC1BV_Msk = 0x20 // Timer/Counter1 Output Compare V-pin Enable for Channel B
	TCCR1D_OC1BU     = 0x10 // Timer/Counter1 Output Compare U-pin Enable for Channel B
	TCCR1D_OC1BU_Msk = 0x10 // Timer/Counter1 Output Compare U-pin Enable for Channel B
	TCCR1D_OC1AX     = 0x8  // Timer/Counter1 Output Compare X-pin Enable for Channel A
	TCCR1D_OC1AX_Msk = 0x8  // Timer/Counter1 Output Compare X-pin Enable for Channel A
	TCCR1D_OC1AW     = 0x4  // Timer/Counter1 Output Compare W-pin Enable for Channel A
	TCCR1D_OC1AW_Msk = 0x4  // Timer/Counter1 Output Compare W-pin Enable for Channel A
	TCCR1D_OC1AV     = 0x2  // Timer/Counter1 Output Compare V-pin Enable for Channel A
	TCCR1D_OC1AV_Msk = 0x2  // Timer/Counter1 Output Compare V-pin Enable for Channel A
	TCCR1D_OC1AU     = 0x1  // Timer/Counter1 Output Compare U-pin Enable for Channel A
	TCCR1D_OC1AU_Msk = 0x1  // Timer/Counter1 Output Compare U-pin Enable for Channel A
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCR: Watchdog Timer Control Register
	WDTCR_WDIF     = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCR_WDIF_Msk = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCR_WDIE     = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCR_WDIE_Msk = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCR_WDP0     = 0x1  // Watchdog Timer Prescaler Bits
	WDTCR_WDP1     = 0x2  // Watchdog Timer Prescaler Bits
	WDTCR_WDP2     = 0x4  // Watchdog Timer Prescaler Bits
	WDTCR_WDP3     = 0x20 // Watchdog Timer Prescaler Bits
	WDTCR_WDP_Msk  = 0x27 // Watchdog Timer Prescaler Bits
	WDTCR_WDCE     = 0x10 // Watchdog Change Enable
	WDTCR_WDCE_Msk = 0x10 // Watchdog Change Enable
	WDTCR_WDE      = 0x8  // Watch Dog Enable
	WDTCR_WDE_Msk  = 0x8  // Watch Dog Enable
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EEPM0     = 0x10 // EEPROM Programming Mode Bits
	EECR_EEPM1     = 0x20 // EEPROM Programming Mode Bits
	EECR_EEPM_Msk  = 0x30 // EEPROM Programming Mode Bits
	EECR_EERIE     = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EEMPE     = 0x4  // EEPROM Master Write Enable
	EECR_EEMPE_Msk = 0x4  // EEPROM Master Write Enable
	EECR_EEPE      = 0x2  // EEPROM Write Enable
	EECR_EEPE_Msk  = 0x2  // EEPROM Write Enable
	EECR_EERE      = 0x1  // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1  // EEPROM Read Enable
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPSR: SPI Status Register
	SPSR_SPIF      = 0x80 // SPI Interrupt Flag
	SPSR_SPIF_Msk  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL      = 0x40 // Write Collision Flag
	SPSR_WCOL_Msk  = 0x40 // Write Collision Flag
	SPSR_SPI2X     = 0x1  // Double SPI Speed Bit
	SPSR_SPI2X_Msk = 0x1  // Double SPI Speed Bit

	// SPCR: SPI Control Register
	SPCR_SPIE     = 0x80 // SPI Interrupt Enable
	SPCR_SPIE_Msk = 0x80 // SPI Interrupt Enable
	SPCR_SPE      = 0x40 // SPI Enable
	SPCR_SPE_Msk  = 0x40 // SPI Enable
	SPCR_DORD     = 0x20 // Data Order
	SPCR_DORD_Msk = 0x20 // Data Order
	SPCR_MSTR     = 0x10 // Master/Slave Select
	SPCR_MSTR_Msk = 0x10 // Master/Slave Select
	SPCR_CPOL     = 0x8  // Clock polarity
	SPCR_CPOL_Msk = 0x8  // Clock polarity
	SPCR_CPHA     = 0x4  // Clock Phase
	SPCR_CPHA_Msk = 0x4  // Clock Phase
	SPCR_SPR0     = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1     = 0x2  // SPI Clock Rate Selects
	SPCR_SPR_Msk  = 0x3  // SPI Clock Rate Selects
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0     = 0x40 // Reference Selection Bits
	ADMUX_REFS1     = 0x80 // Reference Selection Bits
	ADMUX_REFS_Msk  = 0xc0 // Reference Selection Bits
	ADMUX_ADLAR     = 0x20 // Left Adjust Result
	ADMUX_ADLAR_Msk = 0x20 // Left Adjust Result
	ADMUX_MUX0      = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1      = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2      = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3      = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX4      = 0x10 // Analog Channel and Gain Selection Bits
	ADMUX_MUX_Msk   = 0x1f // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status register A
	ADCSRA_ADEN      = 0x80 // ADC Enable
	ADCSRA_ADEN_Msk  = 0x80 // ADC Enable
	ADCSRA_ADSC      = 0x40 // ADC Start Conversion
	ADCSRA_ADSC_Msk  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE     = 0x20 // ADC  Auto Trigger Enable
	ADCSRA_ADATE_Msk = 0x20 // ADC  Auto Trigger Enable
	ADCSRA_ADIF      = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIF_Msk  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE      = 0x8  // ADC Interrupt Enable
	ADCSRA_ADIE_Msk  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0     = 0x1  // ADC  Prescaler Select Bits
	ADCSRA_ADPS1     = 0x2  // ADC  Prescaler Select Bits
	ADCSRA_ADPS2     = 0x4  // ADC  Prescaler Select Bits
	ADCSRA_ADPS_Msk  = 0x7  // ADC  Prescaler Select Bits

	// ADCSRB: The ADC Control and Status register B (Shared with ANALOG_COMPARATOR IO_MODULE)
	ADCSRB_BIN      = 0x80 // Bipolar Input Mode
	ADCSRB_BIN_Msk  = 0x80 // Bipolar Input Mode
	ADCSRB_ADTS0    = 0x1  // ADC Auto Trigger Source bits
	ADCSRB_ADTS1    = 0x2  // ADC Auto Trigger Source bits
	ADCSRB_ADTS2    = 0x4  // ADC Auto Trigger Source bits
	ADCSRB_ADTS_Msk = 0x7  // ADC Auto Trigger Source bits
	ADCSRB_ACME     = 0x40 // Analog Comparator Multiplexer Enable
	ADCSRB_ACME_Msk = 0x40 // Analog Comparator Multiplexer Enable
	ADCSRB_ACIR0    = 0x10 // Analog Comparator Internal Voltage Reference Select Bits
	ADCSRB_ACIR1    = 0x20 // Analog Comparator Internal Voltage Reference Select Bits
	ADCSRB_ACIR_Msk = 0x30 // Analog Comparator Internal Voltage Reference Select Bits

	// AMISCR: Analog Miscellaneous Control Register (Shared with CURRENT_SOURCE IO_MODULE)
	AMISCR_AREFEN     = 0x4 // External Voltage Reference Input Enable
	AMISCR_AREFEN_Msk = 0x4 // External Voltage Reference Input Enable
	AMISCR_XREFEN     = 0x2 // Internal Voltage Reference Output Enable
	AMISCR_XREFEN_Msk = 0x2 // Internal Voltage Reference Output Enable
	AMISCR_ISRCEN     = 0x1 // Current Source Enable
	AMISCR_ISRCEN_Msk = 0x1 // Current Source Enable

	// DIDR1: Digital Input Disable Register 1
	DIDR1_ADC10D     = 0x40
	DIDR1_ADC10D_Msk = 0x40
	DIDR1_ADC9D      = 0x20
	DIDR1_ADC9D_Msk  = 0x20
	DIDR1_ADC8D      = 0x10
	DIDR1_ADC8D_Msk  = 0x10

	// DIDR0: Digital Input Disable Register 0
	DIDR0_ADC7D     = 0x80
	DIDR0_ADC7D_Msk = 0x80
	DIDR0_ADC6D     = 0x40
	DIDR0_ADC6D_Msk = 0x40
	DIDR0_ADC5D     = 0x20
	DIDR0_ADC5D_Msk = 0x20
	DIDR0_ADC4D     = 0x10
	DIDR0_ADC4D_Msk = 0x10
	DIDR0_ADC3D     = 0x8
	DIDR0_ADC3D_Msk = 0x8
	DIDR0_ADC2D     = 0x4
	DIDR0_ADC2D_Msk = 0x4
	DIDR0_ADC1D     = 0x2
	DIDR0_ADC1D_Msk = 0x2
	DIDR0_ADC0D     = 0x1
	DIDR0_ADC0D_Msk = 0x1
)

// Bitfields for AC: Analog Comparator
const (
	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD       = 0x80 // Analog Comparator Disable
	ACSR_ACD_Msk   = 0x80 // Analog Comparator Disable
	ACSR_ACIRS     = 0x40 // Analog Comparator Internal Reference Select
	ACSR_ACIRS_Msk = 0x40 // Analog Comparator Internal Reference Select
	ACSR_ACO       = 0x20 // Analog Compare Output
	ACSR_ACO_Msk   = 0x20 // Analog Compare Output
	ACSR_ACI       = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACI_Msk   = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE      = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIE_Msk  = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIC      = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIC_Msk  = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIS0     = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS1     = 0x2  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS_Msk  = 0x3  // Analog Comparator Interrupt Mode Select bits
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register
	EICRA_ISC10    = 0x4 // External Interrupt Sense Control 1 Bits
	EICRA_ISC11    = 0x8 // External Interrupt Sense Control 1 Bits
	EICRA_ISC1_Msk = 0xc // External Interrupt Sense Control 1 Bits
	EICRA_ISC00    = 0x1 // External Interrupt Sense Control 0 Bits
	EICRA_ISC01    = 0x2 // External Interrupt Sense Control 0 Bits
	EICRA_ISC0_Msk = 0x3 // External Interrupt Sense Control 0 Bits

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0    = 0x1 // External Interrupt Request 1 Enable
	EIMSK_INT1    = 0x2 // External Interrupt Request 1 Enable
	EIMSK_INT_Msk = 0x3 // External Interrupt Request 1 Enable

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0    = 0x1 // External Interrupt Flags
	EIFR_INTF1    = 0x2 // External Interrupt Flags
	EIFR_INTF_Msk = 0x3 // External Interrupt Flags

	// PCICR: Pin Change Interrupt Control Register
	PCICR_PCIE0    = 0x1 // Pin Change Interrupt Enable  on any PCINT14..8 pin
	PCICR_PCIE1    = 0x2 // Pin Change Interrupt Enable  on any PCINT14..8 pin
	PCICR_PCIE_Msk = 0x3 // Pin Change Interrupt Enable  on any PCINT14..8 pin

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_PCIF0    = 0x1 // Pin Change Interrupt Flags
	PCIFR_PCIF1    = 0x2 // Pin Change Interrupt Flags
	PCIFR_PCIF_Msk = 0x3 // Pin Change Interrupt Flags

	// PCMSK1: Pin Change Mask Register 1
	PCMSK1_PCINT0    = 0x1  // Pin Change Enable Masks
	PCMSK1_PCINT1    = 0x2  // Pin Change Enable Masks
	PCMSK1_PCINT2    = 0x4  // Pin Change Enable Masks
	PCMSK1_PCINT3    = 0x8  // Pin Change Enable Masks
	PCMSK1_PCINT4    = 0x10 // Pin Change Enable Masks
	PCMSK1_PCINT5    = 0x20 // Pin Change Enable Masks
	PCMSK1_PCINT6    = 0x40 // Pin Change Enable Masks
	PCMSK1_PCINT7    = 0x80 // Pin Change Enable Masks
	PCMSK1_PCINT_Msk = 0xff // Pin Change Enable Masks

	// PCMSK0: Pin Change Mask Register 0
	PCMSK0_PCINT0    = 0x1  // Pin Change Enable Masks
	PCMSK0_PCINT1    = 0x2  // Pin Change Enable Masks
	PCMSK0_PCINT2    = 0x4  // Pin Change Enable Masks
	PCMSK0_PCINT3    = 0x8  // Pin Change Enable Masks
	PCMSK0_PCINT4    = 0x10 // Pin Change Enable Masks
	PCMSK0_PCINT5    = 0x20 // Pin Change Enable Masks
	PCMSK0_PCINT6    = 0x40 // Pin Change Enable Masks
	PCMSK0_PCINT7    = 0x80 // Pin Change Enable Masks
	PCMSK0_PCINT_Msk = 0xff // Pin Change Enable Masks
)

// Bitfields for BOOT_LOAD: Bootloader
const (
	// SPMCSR: Store Program Memory Control Register
	SPMCSR_RWWSB     = 0x40 // Read While Write Section Busy
	SPMCSR_RWWSB_Msk = 0x40 // Read While Write Section Busy
	SPMCSR_SIGRD     = 0x20 // Signature Row Read
	SPMCSR_SIGRD_Msk = 0x20 // Signature Row Read
	SPMCSR_CTPB      = 0x10 // Clear Temporary Page Buffer
	SPMCSR_CTPB_Msk  = 0x10 // Clear Temporary Page Buffer
	SPMCSR_RFLB      = 0x8  // Read Fuse and Lock Bits
	SPMCSR_RFLB_Msk  = 0x8  // Read Fuse and Lock Bits
	SPMCSR_PGWRT     = 0x4  // Page Write
	SPMCSR_PGWRT_Msk = 0x4  // Page Write
	SPMCSR_PGERS     = 0x2  // Page Erase
	SPMCSR_PGERS_Msk = 0x2  // Page Erase
	SPMCSR_SPMEN     = 0x1  // Store Program Memory Enable
	SPMCSR_SPMEN_Msk = 0x1  // Store Program Memory Enable
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// PRR: Power Reduction Register
	PRR_PRLIN      = 0x20 // Power Reduction LINUART
	PRR_PRLIN_Msk  = 0x20 // Power Reduction LINUART
	PRR_PRSPI      = 0x10 // Power Reduction SPI
	PRR_PRSPI_Msk  = 0x10 // Power Reduction SPI
	PRR_PRTIM1     = 0x8  // Power Reduction Timer/Counter1
	PRR_PRTIM1_Msk = 0x8  // Power Reduction Timer/Counter1
	PRR_PRTIM0     = 0x4  // Power Reduction Timer/Counter0
	PRR_PRTIM0_Msk = 0x4  // Power Reduction Timer/Counter0
	PRR_PRUSI      = 0x2  // Power Reduction USI
	PRR_PRUSI_Msk  = 0x2  // Power Reduction USI
	PRR_PRADC      = 0x1  // Power Reduction ADC
	PRR_PRADC_Msk  = 0x1  // Power Reduction ADC

	// MCUCR: MCU Control Register
	MCUCR_BODS      = 0x40 // BOD Sleep
	MCUCR_BODS_Msk  = 0x40 // BOD Sleep
	MCUCR_BODSE     = 0x20 // BOD Sleep Enable
	MCUCR_BODSE_Msk = 0x20 // BOD Sleep Enable
	MCUCR_PUD       = 0x10 // Pull-up Disable
	MCUCR_PUD_Msk   = 0x10 // Pull-up Disable

	// MCUSR: MCU Status register
	MCUSR_WDRF      = 0x8 // Watchdog Reset Flag
	MCUSR_WDRF_Msk  = 0x8 // Watchdog Reset Flag
	MCUSR_BORF      = 0x4 // Brown-out Reset Flag
	MCUSR_BORF_Msk  = 0x4 // Brown-out Reset Flag
	MCUSR_EXTRF     = 0x2 // External Reset Flag
	MCUSR_EXTRF_Msk = 0x2 // External Reset Flag
	MCUSR_PORF      = 0x1 // Power-On Reset Flag
	MCUSR_PORF_Msk  = 0x1 // Power-On Reset Flag

	// SMCR: Sleep Mode Control Register
	SMCR_SM0    = 0x2 // Sleep Mode Select Bits
	SMCR_SM1    = 0x4 // Sleep Mode Select Bits
	SMCR_SM_Msk = 0x6 // Sleep Mode Select Bits
	SMCR_SE     = 0x1 // Sleep Enable
	SMCR_SE_Msk = 0x1 // Sleep Enable

	// OSCCAL: Oscillator Calibration Register
	OSCCAL_OSCCAL0    = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1    = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2    = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3    = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4    = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5    = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6    = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7    = 0x80 // Oscillator Calibration
	OSCCAL_OSCCAL_Msk = 0xff // Oscillator Calibration

	// CLKPR: Clock Prescale Register
	CLKPR_CLKPCE     = 0x80 // Clock Prescaler Change Enable
	CLKPR_CLKPCE_Msk = 0x80 // Clock Prescaler Change Enable
	CLKPR_CLKPS0     = 0x1  // Clock Prescaler Select Bits
	CLKPR_CLKPS1     = 0x2  // Clock Prescaler Select Bits
	CLKPR_CLKPS2     = 0x4  // Clock Prescaler Select Bits
	CLKPR_CLKPS3     = 0x8  // Clock Prescaler Select Bits
	CLKPR_CLKPS_Msk  = 0xf  // Clock Prescaler Select Bits

	// CLKSELR: Clock Selection Register
	CLKSELR_COUT     = 0x40 // Clock Out - CKOUT fuse substitution
	CLKSELR_COUT_Msk = 0x40 // Clock Out - CKOUT fuse substitution
	CLKSELR_CSUT0    = 0x10 // Clock Start-up Time bit 1 - SUT1 fuse substitution
	CLKSELR_CSUT1    = 0x20 // Clock Start-up Time bit 1 - SUT1 fuse substitution
	CLKSELR_CSUT_Msk = 0x30 // Clock Start-up Time bit 1 - SUT1 fuse substitution
	CLKSELR_CSEL0    = 0x1  // Clock Source Select bit 3 - CKSEL3 fuse substitution
	CLKSELR_CSEL1    = 0x2  // Clock Source Select bit 3 - CKSEL3 fuse substitution
	CLKSELR_CSEL2    = 0x4  // Clock Source Select bit 3 - CKSEL3 fuse substitution
	CLKSELR_CSEL3    = 0x8  // Clock Source Select bit 3 - CKSEL3 fuse substitution
	CLKSELR_CSEL_Msk = 0xf  // Clock Source Select bit 3 - CKSEL3 fuse substitution

	// CLKCSR: Clock Control & Status Register
	CLKCSR_CLKCCE     = 0x80 // Clock Control Change Enable
	CLKCSR_CLKCCE_Msk = 0x80 // Clock Control Change Enable
	CLKCSR_CLKRDY     = 0x10 // Clock Ready Flag
	CLKCSR_CLKRDY_Msk = 0x10 // Clock Ready Flag
	CLKCSR_CLKC0      = 0x1  // Clock Control bits
	CLKCSR_CLKC1      = 0x2  // Clock Control bits
	CLKCSR_CLKC2      = 0x4  // Clock Control bits
	CLKCSR_CLKC3      = 0x8  // Clock Control bits
	CLKCSR_CLKC_Msk   = 0xf  // Clock Control bits

	// PORTCR: Port Control Register
	PORTCR_BBMB     = 0x20
	PORTCR_BBMB_Msk = 0x20
	PORTCR_BBMA     = 0x10
	PORTCR_BBMA_Msk = 0x10
	PORTCR_PUDB     = 0x2
	PORTCR_PUDB_Msk = 0x2
	PORTCR_PUDA     = 0x1
	PORTCR_PUDA_Msk = 0x1
)
