/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

class ObjectSizeSettings {
    static final int OBJECT_ALIGNMENT = 8;
    static final int ARRAY_OVERHEAD = 4;
    static final Logger LOG = Logger.getLogger(ObjectSizeSettings.class.getName());
    private final HprofHeap hprofHeap;
    private int minimumInstanceSize;
    private int oopSize;

    ObjectSizeSettings(HprofHeap heap) {
        this.hprofHeap = heap;
    }

    int getMinimumInstanceSize() {
        if (this.minimumInstanceSize == 0) {
            this.minimumInstanceSize = this.hprofHeap.dumpBuffer.getIDSize() + this.getOopSize();
            LOG.log(Level.CONFIG, "MinimumInstanceSize computed as {0}", this.minimumInstanceSize);
        }
        return this.minimumInstanceSize;
    }

    int getElementSize(byte type) {
        if (type == 2) {
            return this.getOopSize();
        }
        return this.hprofHeap.getValueSize(type);
    }

    void setMinimumInstanceSize(int objectSize) {
        this.minimumInstanceSize = objectSize;
        LOG.log(Level.CONFIG, "MinimumInstanceSize set to {0}", this.minimumInstanceSize);
    }

    int getOopSize() {
        if (this.oopSize == 0) {
            int idSize = this.hprofHeap.dumpBuffer.getIDSize();
            LOG.log(Level.CONFIG, "OopSize uses idSize {0}", idSize);
            if (idSize == 8) {
                if (this.hprofHeap.getClassDumpSegment().newSize) {
                    this.oopSize = this.getMinimumInstanceSize() - idSize;
                    LOG.log(Level.CONFIG, "OopSize computed as {0}", this.oopSize);
                } else {
                    this.oopSize = this.guessOopSize(idSize);
                }
            } else {
                LOG.log(Level.CONFIG, "OopSize set to idSize {0}", idSize);
                this.oopSize = idSize;
            }
        }
        return this.oopSize;
    }

    private int guessOopSize(int idSize) {
        int size = this.getFieldsDiff("java.lang.Class$Atomic", "annotationDataOffset", "annotationTypeOffset");
        if (size != 0) {
            return size;
        }
        size = this.getFieldsDiff("java.util.concurrent.FutureTask", "runnerOffset", "waitersOffset");
        if (size != 0) {
            return size;
        }
        Properties sysProp = this.hprofHeap.getSystemProperties();
        if (sysProp.getProperty("java.vm.compressedOopsMode") != null) {
            LOG.log(Level.CONFIG, "OopSize guessed (A2) as {0}", 4);
            return 4;
        }
        LOG.log(Level.CONFIG, "OopSize defaults to {0}", idSize);
        return idSize;
    }

    private int getFieldsDiff(String javaClass, String field1Name, String field2Name) {
        JavaClass jcls = this.hprofHeap.getJavaClassByName(javaClass);
        if (jcls != null) {
            int guessedSize;
            Object field1Offset = jcls.getValueOfStaticField(field1Name);
            Object field2Offset = jcls.getValueOfStaticField(field2Name);
            if (field1Offset instanceof Long && field2Offset instanceof Long && ((guessedSize = (int)((Long)field2Offset - (Long)field1Offset)) == 4 || guessedSize == 8)) {
                LOG.log(Level.CONFIG, "OopSize guessed ({0}) as {1}", new Object[]{javaClass, guessedSize});
                return guessedSize;
            }
        }
        return 0;
    }
}

