<?php

declare(strict_types=1);

/**
 * @copyright Copyright (c) 2023 Julius Härtl <jus@bitgrid.net>
 *
 * @author Julius Härtl <jus@bitgrid.net>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


namespace OCA\Notes\Migration;

use OCA\Notes\AppInfo\Application;
use OCP\IConfig;
use OCP\IUser;
use OCP\IUserManager;
use OCP\Migration\IOutput;
use OCP\Migration\IRepairStep;

class EditorHint implements IRepairStep {
	private IConfig $config;
	private IUserManager $userManager;
	public function __construct(IConfig $config, IUserManager $userManager) {
		$this->config = $config;
		$this->userManager = $userManager;
	}

	public function getName() {
		return 'Show a hint about the new editor to existing users';
	}

	public function run(IOutput $output) {
		$appVersion = $this->config->getAppValue('text', 'installed_version');

		if (!$appVersion || version_compare($appVersion, '4.7.0') !== -1) {
			return;
		}

		$this->userManager->callForSeenUsers(function (IUser $user) {
			if ($this->config->getUserValue($user->getUID(), Application::APP_ID, 'notesLastViewedNote', '') === '') {
				return;
			}

			$this->config->setUserValue($user->getUID(), Application::APP_ID, 'editorHint', 'yes');
		});
	}
}
