sap.ui.define([
		'sap/ui/core/message/ControlMessageProcessor',
		'sap/ui/core/message/Message',
		'sap/ui/core/mvc/Controller',
		'sap/ui/core/library',
		'sap/ui/model/json/JSONModel',
		'sap/m/MessagePopover',
		'sap/m/MessagePopoverItem',
		'sap/m/MessageToast',
		'sap/ui/core/Core'
	], function(ControlMessageProcessor, Message, Controller, coreLibrary, JSONModel, MessagePopover, MessagePopoverItem, MessageToast, oCore) {
	"use strict";

	var MessageType = coreLibrary.MessageType;

	var PageController = Controller.extend("sap.m.sample.SemanticPageDraftIndicator.Page", {

		onInit: function () {
			var oModel = new JSONModel(sap.ui.require.toUrl("sap/ui/demo/mock/products.json"));
			this.getView().setModel(oModel);


			var oMessageProcessor = new ControlMessageProcessor();
			var oMessageManager = oCore.getMessageManager();

			oMessageManager.registerMessageProcessor(oMessageProcessor);

			oMessageManager.addMessages(
					new Message({
						message: "Something wrong happened",
						type: MessageType.Error,
						processor: oMessageProcessor
					})
			);
		},
		handleLiveChange: function(oEvent) {
			var oDraftIndi = this.byId("draftIndi");
			oDraftIndi.showDraftSaving();
			oDraftIndi.showDraftSaved();
			oDraftIndi.clearDraftState();
		},
		onPress: function (oEvent) {

			MessageToast.show("Pressed custom button " + oEvent.getSource().getId());
		},
		onSemanticButtonPress: function (oEvent) {

			var sAction = oEvent.getSource().getMetadata().getName();
			sAction = sAction.replace(oEvent.getSource().getMetadata().getLibraryName() + ".", "");

			MessageToast.show("Pressed: " + sAction);
		},
		onNavButtonPress: function () {
			MessageToast.show("Pressed navigation button");
		},
		onMessagesButtonPress: function(oEvent) {

			var oMessagesButton = oEvent.getSource();
			if (!this._messagePopover) {
				this._messagePopover = new MessagePopover({
					items: {
						path: "message>/",
						template: new MessagePopoverItem({
							description: "{message>description}",
							type: "{message>type}",
							title: "{message>message}"
						})
					}
				});
				oMessagesButton.addDependent(this._messagePopover);
			}
			this._messagePopover.toggle(oMessagesButton);
		}
	});


	return PageController;

});