from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Adaptor3d import *
from OCC.Core.gp import *
from OCC.Core.TColgp import *
from OCC.Core.Geom import *
from OCC.Core.TColStd import *
from OCC.Core.TColGeom2d import *
from OCC.Core.Message import *
from OCC.Core.Geom2d import *
from OCC.Core.GeomLProp import *
from OCC.Core.Adaptor2d import *
from OCC.Core.Law import *
from OCC.Core.AdvApp2Var import *
from OCC.Core.GeomAbs import *
from OCC.Core.Plate import *


class GeomPlate_Array1OfHCurve:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class GeomPlate_Array1OfSequenceOfReal:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> TColStd_SequenceOfReal: ...
    def __setitem__(self, index: int, value: TColStd_SequenceOfReal) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[TColStd_SequenceOfReal]: ...
    def next(self) -> TColStd_SequenceOfReal: ...
    __next__ = next
    def Init(self, theValue: TColStd_SequenceOfReal) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> TColStd_SequenceOfReal: ...
    def Last(self) -> TColStd_SequenceOfReal: ...
    def Value(self, theIndex: int) -> TColStd_SequenceOfReal: ...
    def SetValue(self, theIndex: int, theValue: TColStd_SequenceOfReal) -> None: ...

class GeomPlate_SequenceOfAij:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> GeomPlate_Aij: ...
    def Last(self) -> GeomPlate_Aij: ...
    def Length(self) -> int: ...
    def Append(self, theItem: GeomPlate_Aij) -> GeomPlate_Aij: ...
    def Prepend(self, theItem: GeomPlate_Aij) -> GeomPlate_Aij: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> GeomPlate_Aij: ...
    def SetValue(self, theIndex: int, theValue: GeomPlate_Aij) -> None: ...

class GeomPlate_SequenceOfCurveConstraint:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class GeomPlate_SequenceOfPointConstraint:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class GeomPlate_Aij:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, anInd1: int, anInd2: int, aVec: gp_Vec) -> None: ...

class GeomPlate_BuildAveragePlane:
    @overload
    def __init__(self, Pts: TColgp_HArray1OfPnt, NbBoundPoints: int, Tol: float, POption: int, NOption: int) -> None: ...
    @overload
    def __init__(self, Normals: TColgp_SequenceOfVec, Pts: TColgp_HArray1OfPnt) -> None: ...
    @staticmethod
    def HalfSpace(NewNormals: TColgp_SequenceOfVec, Normals: TColgp_SequenceOfVec, Bset: GeomPlate_SequenceOfAij, LinTol: float, AngTol: float) -> bool: ...
    def IsLine(self) -> bool: ...
    def IsPlane(self) -> bool: ...
    def Line(self) -> Geom_Line: ...
    def MinMaxBox(self) -> Tuple[float, float, float, float]: ...
    def Plane(self) -> Geom_Plane: ...

class GeomPlate_BuildPlateSurface:
    @overload
    def __init__(self, NPoints: TColStd_HArray1OfInteger, TabCurve: GeomPlate_HArray1OfHCurve, Tang: TColStd_HArray1OfInteger, Degree: int, NbIter: Optional[int] = 3, Tol2d: Optional[float] = 0.00001, Tol3d: Optional[float] = 0.0001, TolAng: Optional[float] = 0.01, TolCurv: Optional[float] = 0.1, Anisotropie: Optional[bool] = False) -> None: ...
    @overload
    def __init__(self, Surf: Geom_Surface, Degree: Optional[int] = 3, NbPtsOnCur: Optional[int] = 10, NbIter: Optional[int] = 3, Tol2d: Optional[float] = 0.00001, Tol3d: Optional[float] = 0.0001, TolAng: Optional[float] = 0.01, TolCurv: Optional[float] = 0.1, Anisotropie: Optional[bool] = False) -> None: ...
    @overload
    def __init__(self, Degree: Optional[int] = 3, NbPtsOnCur: Optional[int] = 10, NbIter: Optional[int] = 3, Tol2d: Optional[float] = 0.00001, Tol3d: Optional[float] = 0.0001, TolAng: Optional[float] = 0.01, TolCurv: Optional[float] = 0.1, Anisotropie: Optional[bool] = False) -> None: ...
    @overload
    def Add(self, Cont: GeomPlate_CurveConstraint) -> None: ...
    @overload
    def Add(self, Cont: GeomPlate_PointConstraint) -> None: ...
    def CurveConstraint(self, order: int) -> GeomPlate_CurveConstraint: ...
    def Curves2d(self) -> TColGeom2d_HArray1OfCurve: ...
    def Disc2dContour(self, nbp: int, Seq2d: TColgp_SequenceOfXY) -> None: ...
    def Disc3dContour(self, nbp: int, iordre: int, Seq3d: TColgp_SequenceOfXYZ) -> None: ...
    @overload
    def G0Error(self) -> float: ...
    @overload
    def G0Error(self, Index: int) -> float: ...
    @overload
    def G1Error(self) -> float: ...
    @overload
    def G1Error(self, Index: int) -> float: ...
    @overload
    def G2Error(self) -> float: ...
    @overload
    def G2Error(self, Index: int) -> float: ...
    def Init(self) -> None: ...
    def IsDone(self) -> bool: ...
    def LoadInitSurface(self, Surf: Geom_Surface) -> None: ...
    def Order(self) -> TColStd_HArray1OfInteger: ...
    def Perform(self, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    def PointConstraint(self, order: int) -> GeomPlate_PointConstraint: ...
    def Sense(self) -> TColStd_HArray1OfInteger: ...
    def SetNbBounds(self, NbBounds: int) -> None: ...
    def SurfInit(self) -> Geom_Surface: ...
    def Surface(self) -> GeomPlate_Surface: ...

class GeomPlate_CurveConstraint(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Boundary: Adaptor3d_Curve, Order: int, NPt: Optional[int] = 10, TolDist: Optional[float] = 0.0001, TolAng: Optional[float] = 0.01, TolCurv: Optional[float] = 0.1) -> None: ...
    def Curve2dOnSurf(self) -> Geom2d_Curve: ...
    def Curve3d(self) -> Adaptor3d_Curve: ...
    def D0(self, U: float, P: gp_Pnt) -> None: ...
    def D1(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
    def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec, V4: gp_Vec, V5: gp_Vec) -> None: ...
    def FirstParameter(self) -> float: ...
    def G0Criterion(self, U: float) -> float: ...
    def G1Criterion(self, U: float) -> float: ...
    def G2Criterion(self, U: float) -> float: ...
    def LPropSurf(self, U: float) -> GeomLProp_SLProps: ...
    def LastParameter(self) -> float: ...
    def Length(self) -> float: ...
    def NbPoints(self) -> int: ...
    def Order(self) -> int: ...
    def ProjectedCurve(self) -> Adaptor2d_Curve2d: ...
    def SetCurve2dOnSurf(self, Curve2d: Geom2d_Curve) -> None: ...
    def SetG0Criterion(self, G0Crit: Law_Function) -> None: ...
    def SetG1Criterion(self, G1Crit: Law_Function) -> None: ...
    def SetG2Criterion(self, G2Crit: Law_Function) -> None: ...
    def SetNbPoints(self, NewNb: int) -> None: ...
    def SetOrder(self, Order: int) -> None: ...
    def SetProjectedCurve(self, Curve2d: Adaptor2d_Curve2d, TolU: float, TolV: float) -> None: ...

class GeomPlate_MakeApprox:
    @overload
    def __init__(self, SurfPlate: GeomPlate_Surface, PlateCrit: AdvApp2Var_Criterion, Tol3d: float, Nbmax: int, dgmax: int, Continuity: Optional[GeomAbs_Shape] = GeomAbs_C1, EnlargeCoeff: Optional[float] = 1.1) -> None: ...
    @overload
    def __init__(self, SurfPlate: GeomPlate_Surface, Tol3d: float, Nbmax: int, dgmax: int, dmax: float, CritOrder: Optional[int] = 0, Continuity: Optional[GeomAbs_Shape] = GeomAbs_C1, EnlargeCoeff: Optional[float] = 1.1) -> None: ...
    def ApproxError(self) -> float: ...
    def CriterionError(self) -> float: ...
    def Surface(self) -> Geom_BSplineSurface: ...

class GeomPlate_PlateG0Criterion(AdvApp2Var_Criterion):
    def __init__(self, Data: TColgp_SequenceOfXY, G0Data: TColgp_SequenceOfXYZ, Maximum: float, Type: Optional[AdvApp2Var_CriterionType] = AdvApp2Var_Absolute, Repart: Optional[AdvApp2Var_CriterionRepartition] = AdvApp2Var_Regular) -> None: ...
    def IsSatisfied(self, P: AdvApp2Var_Patch) -> bool: ...
    def Value(self, P: AdvApp2Var_Patch, C: AdvApp2Var_Context) -> None: ...

class GeomPlate_PlateG1Criterion(AdvApp2Var_Criterion):
    def __init__(self, Data: TColgp_SequenceOfXY, G1Data: TColgp_SequenceOfXYZ, Maximum: float, Type: Optional[AdvApp2Var_CriterionType] = AdvApp2Var_Absolute, Repart: Optional[AdvApp2Var_CriterionRepartition] = AdvApp2Var_Regular) -> None: ...
    def IsSatisfied(self, P: AdvApp2Var_Patch) -> bool: ...
    def Value(self, P: AdvApp2Var_Patch, C: AdvApp2Var_Context) -> None: ...

class GeomPlate_PointConstraint(Standard_Transient):
    @overload
    def __init__(self, Pt: gp_Pnt, Order: int, TolDist: Optional[float] = 0.0001) -> None: ...
    @overload
    def __init__(self, U: float, V: float, Surf: Geom_Surface, Order: int, TolDist: Optional[float] = 0.0001, TolAng: Optional[float] = 0.01, TolCurv: Optional[float] = 0.1) -> None: ...
    def D0(self, P: gp_Pnt) -> None: ...
    def D1(self, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
    def D2(self, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec, V4: gp_Vec, V5: gp_Vec) -> None: ...
    def G0Criterion(self) -> float: ...
    def G1Criterion(self) -> float: ...
    def G2Criterion(self) -> float: ...
    def HasPnt2dOnSurf(self) -> bool: ...
    def LPropSurf(self) -> GeomLProp_SLProps: ...
    def Order(self) -> int: ...
    def Pnt2dOnSurf(self) -> gp_Pnt2d: ...
    def SetG0Criterion(self, TolDist: float) -> None: ...
    def SetG1Criterion(self, TolAng: float) -> None: ...
    def SetG2Criterion(self, TolCurv: float) -> None: ...
    def SetOrder(self, Order: int) -> None: ...
    def SetPnt2dOnSurf(self, Pnt: gp_Pnt2d) -> None: ...

class GeomPlate_Surface(Geom_Surface):
    def __init__(self, Surfinit: Geom_Surface, Surfinter: Plate_Plate) -> None: ...
    def Bounds(self) -> Tuple[float, float, float, float]: ...
    def CallSurfinit(self) -> Geom_Surface: ...
    def Constraints(self, Seq: TColgp_SequenceOfXY) -> None: ...
    def Continuity(self) -> GeomAbs_Shape: ...
    def Copy(self) -> Geom_Geometry: ...
    def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
    def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
    def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
    def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
    def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
    def IsCNu(self, N: int) -> bool: ...
    def IsCNv(self, N: int) -> bool: ...
    def IsUClosed(self) -> bool: ...
    def IsUPeriodic(self) -> bool: ...
    def IsVClosed(self) -> bool: ...
    def IsVPeriodic(self) -> bool: ...
    def ParametricTransformation(self, T: gp_Trsf) -> gp_GTrsf2d: ...
    def RealBounds(self) -> Tuple[float, float, float, float]: ...
    def SetBounds(self, Umin: float, Umax: float, Vmin: float, Vmax: float) -> None: ...
    def Transform(self, T: gp_Trsf) -> None: ...
    def TransformParameters(self, T: gp_Trsf) -> Tuple[float, float]: ...
    def UIso(self, U: float) -> Geom_Curve: ...
    def UPeriod(self) -> float: ...
    def UReverse(self) -> None: ...
    def UReversedParameter(self, U: float) -> float: ...
    def VIso(self, V: float) -> Geom_Curve: ...
    def VPeriod(self) -> float: ...
    def VReverse(self) -> None: ...
    def VReversedParameter(self, V: float) -> float: ...

# harray1 classes

class GeomPlate_HArray1OfSequenceOfReal(GeomPlate_Array1OfSequenceOfReal, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> GeomPlate_Array1OfSequenceOfReal: ...


class GeomPlate_HArray1OfHCurve(GeomPlate_Array1OfHCurve, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> GeomPlate_Array1OfHCurve: ...

# harray2 classes
# hsequence classes

class GeomPlate_HSequenceOfPointConstraint(GeomPlate_SequenceOfPointConstraint, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GeomPlate_SequenceOfPointConstraint) -> None: ...
    def Sequence(self) -> GeomPlate_SequenceOfPointConstraint: ...
    def Append(self, theSequence: GeomPlate_SequenceOfPointConstraint) -> None: ...


class GeomPlate_HSequenceOfCurveConstraint(GeomPlate_SequenceOfCurveConstraint, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GeomPlate_SequenceOfCurveConstraint) -> None: ...
    def Sequence(self) -> GeomPlate_SequenceOfCurveConstraint: ...
    def Append(self, theSequence: GeomPlate_SequenceOfCurveConstraint) -> None: ...


GeomPlate_BuildAveragePlane_HalfSpace = GeomPlate_BuildAveragePlane.HalfSpace
