/**
 * <p>See <a href="http://raml.org">http://raml.org</a> for more information about RAML.</p>
 *
 * <p>This parser is at a beta state of development, as part of the API Workbench development cycle (<a href="http://apiworkbench.com">http://apiworkbench.com</a>).</p>
 *
 * <p><a href="https://github.com/raml-org/raml-js-parser-2/blob/master/documentation/GettingStarted.md">Getting Started Guide</a> describes the first steps with the parser.</p>
 *
 * <h2>Installation</h2>
 *
 * <pre><code>git clone https://github.com/raml-org/raml-js-parser-2
 *
 * cd raml-js-parser-2
 *
 * npm install
 *
 * node test/test.js  //here you should observe JSON representation of XKCD API in your console
 *
 * node test/testAsync.js  //same as above but in asynchronous mode
 * </code></pre>
 *
 * <h2>Usage</h2>
 *
 * <ul>
 * <li>For parser usage example refer to <code>test/test.js</code></li>
 * <li>For asynchrounous usage example refer to <code>test/testAsync.js</code></li>
 * </ul>
 **/
import hl = require("../../parser/highLevelAST");
import core = require("../../parser/wrapped-ast/parserCore");
import coreApi = require("../../parser/wrapped-ast/parserCoreApi");
import pApi = require("./raml10parserapi");
import Api = pApi.Api;
import ApiScalarsAnnotations = pApi.ApiScalarsAnnotations;
import LibraryBase = pApi.LibraryBase;
import FragmentDeclaration = pApi.FragmentDeclaration;
import Annotable = pApi.Annotable;
import AnnotationRef = pApi.AnnotationRef;
import Reference = pApi.Reference;
import ValueType = pApi.ValueType;
import StringType = pApi.StringType;
import UriTemplate = pApi.UriTemplate;
import RelativeUriString = pApi.RelativeUriString;
import FullUriTemplateString = pApi.FullUriTemplateString;
import StatusCodeString = pApi.StatusCodeString;
import FixedUriString = pApi.FixedUriString;
import ContentType = pApi.ContentType;
import MarkdownString = pApi.MarkdownString;
import SchemaString = pApi.SchemaString;
import MimeType = pApi.MimeType;
import AnyType = pApi.AnyType;
import NumberType = pApi.NumberType;
import IntegerType = pApi.IntegerType;
import NullType = pApi.NullType;
import TimeOnlyType = pApi.TimeOnlyType;
import DateOnlyType = pApi.DateOnlyType;
import DateTimeOnlyType = pApi.DateTimeOnlyType;
import DateTimeType = pApi.DateTimeType;
import FileType = pApi.FileType;
import BooleanType = pApi.BooleanType;
import AnnotationTarget = pApi.AnnotationTarget;
import TypeInstance = pApi.TypeInstance;
import TraitRef = pApi.TraitRef;
import Trait = pApi.Trait;
import TraitScalarsAnnotations = pApi.TraitScalarsAnnotations;
import MethodBase = pApi.MethodBase;
import MethodBaseScalarsAnnotations = pApi.MethodBaseScalarsAnnotations;
import Operation = pApi.Operation;
import TypeDeclaration = pApi.TypeDeclaration;
import TypeDeclarationScalarsAnnotations = pApi.TypeDeclarationScalarsAnnotations;
import ModelLocation = pApi.ModelLocation;
import LocationKind = pApi.LocationKind;
import ExampleSpec = pApi.ExampleSpec;
import UsesDeclaration = pApi.UsesDeclaration;
import UsesDeclarationScalarsAnnotations = pApi.UsesDeclarationScalarsAnnotations;
import XMLFacetInfo = pApi.XMLFacetInfo;
import XMLFacetInfoScalarsAnnotations = pApi.XMLFacetInfoScalarsAnnotations;
import ArrayTypeDeclaration = pApi.ArrayTypeDeclaration;
import ArrayTypeDeclarationScalarsAnnotations = pApi.ArrayTypeDeclarationScalarsAnnotations;
import UnionTypeDeclaration = pApi.UnionTypeDeclaration;
import ObjectTypeDeclaration = pApi.ObjectTypeDeclaration;
import ObjectTypeDeclarationScalarsAnnotations = pApi.ObjectTypeDeclarationScalarsAnnotations;
import StringTypeDeclaration = pApi.StringTypeDeclaration;
import StringTypeDeclarationScalarsAnnotations = pApi.StringTypeDeclarationScalarsAnnotations;
import BooleanTypeDeclaration = pApi.BooleanTypeDeclaration;
import BooleanTypeDeclarationScalarsAnnotations = pApi.BooleanTypeDeclarationScalarsAnnotations;
import NumberTypeDeclaration = pApi.NumberTypeDeclaration;
import NumberTypeDeclarationScalarsAnnotations = pApi.NumberTypeDeclarationScalarsAnnotations;
import IntegerTypeDeclaration = pApi.IntegerTypeDeclaration;
import IntegerTypeDeclarationScalarsAnnotations = pApi.IntegerTypeDeclarationScalarsAnnotations;
import DateOnlyTypeDeclaration = pApi.DateOnlyTypeDeclaration;
import TimeOnlyTypeDeclaration = pApi.TimeOnlyTypeDeclaration;
import DateTimeOnlyTypeDeclaration = pApi.DateTimeOnlyTypeDeclaration;
import DateTimeTypeDeclaration = pApi.DateTimeTypeDeclaration;
import DateTimeTypeDeclarationScalarsAnnotations = pApi.DateTimeTypeDeclarationScalarsAnnotations;
import FileTypeDeclaration = pApi.FileTypeDeclaration;
import FileTypeDeclarationScalarsAnnotations = pApi.FileTypeDeclarationScalarsAnnotations;
import Response = pApi.Response;
import ResponseScalarsAnnotations = pApi.ResponseScalarsAnnotations;
import SecuritySchemePart = pApi.SecuritySchemePart;
import SecuritySchemeRef = pApi.SecuritySchemeRef;
import AbstractSecurityScheme = pApi.AbstractSecurityScheme;
import AbstractSecuritySchemeScalarsAnnotations = pApi.AbstractSecuritySchemeScalarsAnnotations;
import SecuritySchemeSettings = pApi.SecuritySchemeSettings;
import OAuth1SecuritySchemeSettings = pApi.OAuth1SecuritySchemeSettings;
import OAuth1SecuritySchemeSettingsScalarsAnnotations = pApi.OAuth1SecuritySchemeSettingsScalarsAnnotations;
import OAuth2SecuritySchemeSettings = pApi.OAuth2SecuritySchemeSettings;
import OAuth2SecuritySchemeSettingsScalarsAnnotations = pApi.OAuth2SecuritySchemeSettingsScalarsAnnotations;
import OAuth2SecurityScheme = pApi.OAuth2SecurityScheme;
import OAuth1SecurityScheme = pApi.OAuth1SecurityScheme;
import PassThroughSecurityScheme = pApi.PassThroughSecurityScheme;
import BasicSecurityScheme = pApi.BasicSecurityScheme;
import DigestSecurityScheme = pApi.DigestSecurityScheme;
import CustomSecurityScheme = pApi.CustomSecurityScheme;
import Method = pApi.Method;
import MethodScalarsAnnotations = pApi.MethodScalarsAnnotations;
import ResourceTypeRef = pApi.ResourceTypeRef;
import ResourceType = pApi.ResourceType;
import ResourceTypeScalarsAnnotations = pApi.ResourceTypeScalarsAnnotations;
import ResourceBase = pApi.ResourceBase;
import ResourceBaseScalarsAnnotations = pApi.ResourceBaseScalarsAnnotations;
import Resource = pApi.Resource;
import ResourceScalarsAnnotations = pApi.ResourceScalarsAnnotations;
import DocumentationItem = pApi.DocumentationItem;
import DocumentationItemScalarsAnnotations = pApi.DocumentationItemScalarsAnnotations;
import Library = pApi.Library;
import LibraryScalarsAnnotations = pApi.LibraryScalarsAnnotations;
import Overlay = pApi.Overlay;
import OverlayScalarsAnnotations = pApi.OverlayScalarsAnnotations;
import Extension = pApi.Extension;
import ExtensionScalarsAnnotations = pApi.ExtensionScalarsAnnotations;
export declare class AnnotableImpl extends core.BasicNodeImpl implements Annotable {
    /**
     * Most of RAML model elements may have attached annotations decribing additional meta data about this element
     **/
    annotations(): AnnotationRef[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class ValueTypeImpl extends core.AttributeNodeImpl implements ValueType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * @return JS representation of the node value
     **/
    value(): any;
}
export declare class StringTypeImpl extends ValueTypeImpl implements StringType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * @return String representation of the node value
     **/
    value(): string;
}
/**
 * This type currently serves both for absolute and relative urls
 **/
export declare class UriTemplateImpl extends StringTypeImpl implements UriTemplate {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * This  type describes relative uri templates
 **/
export declare class RelativeUriStringImpl extends UriTemplateImpl implements RelativeUriString {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * This  type describes absolute uri templates
 **/
export declare class FullUriTemplateStringImpl extends UriTemplateImpl implements FullUriTemplateString {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class StatusCodeStringImpl extends StringTypeImpl implements StatusCodeString {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * This  type describes fixed uris
 **/
export declare class FixedUriStringImpl extends StringTypeImpl implements FixedUriString {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class ContentTypeImpl extends StringTypeImpl implements ContentType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * [GitHub Flavored Markdown](https://help.github.com/articles/github-flavored-markdown/)
 **/
export declare class MarkdownStringImpl extends StringTypeImpl implements MarkdownString {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * Schema at this moment only two subtypes are supported (json schema and xsd)
 **/
export declare class SchemaStringImpl extends StringTypeImpl implements SchemaString {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * This sub type of the string represents mime types
 **/
export declare class MimeTypeImpl extends StringTypeImpl implements MimeType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class AnyTypeImpl extends ValueTypeImpl implements AnyType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class NumberTypeImpl extends ValueTypeImpl implements NumberType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * @return Number representation of the node value
     **/
    value(): number;
}
export declare class IntegerTypeImpl extends ValueTypeImpl implements IntegerType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class NullTypeImpl extends ValueTypeImpl implements NullType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class TimeOnlyTypeImpl extends ValueTypeImpl implements TimeOnlyType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class DateOnlyTypeImpl extends ValueTypeImpl implements DateOnlyType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class DateTimeOnlyTypeImpl extends ValueTypeImpl implements DateTimeOnlyType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class DateTimeTypeImpl extends ValueTypeImpl implements DateTimeType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class FileTypeImpl extends ValueTypeImpl implements FileType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class BooleanTypeImpl extends ValueTypeImpl implements BooleanType {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * @return Boolean representation of the node value
     **/
    value(): boolean;
}
/**
 * Elements to which this Annotation can be applied (enum)
 **/
export declare class AnnotationTargetImpl extends ValueTypeImpl implements AnnotationTarget {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class ReferenceImpl extends core.AttributeNodeImpl implements Reference {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * @return StructuredValue object representing the node value
     **/
    value(): hl.IStructuredValue;
    structuredValue(): TypeInstance;
    name(): string;
}
export declare class TraitRefImpl extends ReferenceImpl implements TraitRef {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    trait(): Trait;
}
export declare class OperationImpl extends AnnotableImpl implements Operation {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * An APIs resources MAY be filtered (to return a subset of results) or altered (such as transforming  a response body from JSON to XML format) by the use of query strings. If the resource or its method supports a query string, the query string MUST be defined by the queryParameters property
     **/
    queryParameters(): TypeDeclaration[];
    /**
     * Headers that allowed at this position
     **/
    headers(): TypeDeclaration[];
    /**
     * Specifies the query string needed by this method. Mutually exclusive with queryParameters.
     **/
    queryString(): TypeDeclaration;
    /**
     * Information about the expected responses to a request
     **/
    responses(): Response[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class TypeDeclarationImpl extends AnnotableImpl implements TypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Type name for top level types. For properties and parameters -- property o parameter name, respectively. For bodies -- media type.
     **/
    name(): string;
    /**
     * @hidden
     * Set name value
     **/
    setName(param: string): this;
    /**
     * The displayName attribute specifies the type display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    displayName(): string;
    /**
     * @hidden
     * Set displayName value
     **/
    setDisplayName(param: string): this;
    /**
     * When extending from a type you can define new facets (which can then be set to concrete values by subtypes).
     **/
    facets(): TypeDeclaration[];
    /**
     * Alias for the equivalent "type" property, for compatibility with RAML 0.8. Deprecated - API definitions should use the "type" property, as the "schema" alias for that property name may be removed in a future RAML version. The "type" property allows for XML and JSON schemas.
     * @hidden
     **/
    schema_original(): string[];
    /**
     * @hidden
     * Set schema value
     **/
    setSchema(param: string): this;
    /**
     * A base type which the current type extends, or more generally a type expression.
     * @hidden
     **/
    type_original(): string[];
    /**
     * @hidden
     * Set type value
     **/
    setType(param: string): this;
    /**
     * Location of the parameter (can not be edited by user)
     **/
    location(): ModelLocation;
    /**
     * Kind of location
     **/
    locationKind(): LocationKind;
    /**
     * Provides default value for a property
     **/
    "default"(): any;
    /**
     * @hidden
     * Set default value
     **/
    setDefault(param: any): this;
    /**
     * An example of this type instance represented as string or yaml map/sequence. This can be used, e.g., by documentation generators to generate sample values for an object of this type. Cannot be present if the examples property is present.
     * @hidden
     **/
    example_original(): ExampleSpec;
    /**
     * An example of this type instance represented as string. This can be used, e.g., by documentation generators to generate sample values for an object of this type. Cannot be present if the example property is present.
     * @hidden
     **/
    examples_original(): ExampleSpec[];
    /**
     * For property or parameter states if it is required.
     **/
    required(): boolean;
    /**
     * @hidden
     * Set required value
     **/
    setRequired(param: boolean): this;
    /**
     * A longer, human-friendly description of the type
     **/
    description(): MarkdownString;
    xml(): XMLFacetInfo;
    /**
     * Restrictions on where annotations of this type can be applied. If this property is specified, annotations of this type may only be applied on a property corresponding to one of the target names specified as the value of this property.
     **/
    allowedTargets(): AnnotationTarget[];
    /**
     * Whether the type represents annotation
     **/
    isAnnotation(): boolean;
    /**
     * @hidden
     * Set isAnnotation value
     **/
    setIsAnnotation(param: boolean): this;
    /**
     * Most of RAML model elements may have attached annotations decribing additional meta data about this element
     **/
    annotations(): AnnotationRef[];
    uses(): UsesDeclaration[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Runtime representation of type represented by this AST node
     **/
    runtimeType(): hl.ITypeDefinition;
    /**
     * validate an instance against type
     **/
    validateInstance(value: any): string[];
    /**
     * validate an instance against type
     **/
    validateInstanceWithDetailedStatuses(value: any): any;
    /**
     * An example of this type instance represented as string or yaml map/sequence. This can be used, e.g., by documentation generators to generate sample values for an object of this type. Cannot be present if the examples property is present.
     **/
    example(): ExampleSpec;
    /**
     * An example of this type instance represented as string. This can be used, e.g., by documentation generators to generate sample values for an object of this type. Cannot be present if the example property is present.
     **/
    examples(): ExampleSpec[];
    fixedFacets(): TypeInstance;
    /**
     * A base type which the current type extends, or more generally a type expression.
     **/
    "type"(): string[];
    /**
     * Alias for the equivalent "type" property, for compatibility with RAML 0.8. Deprecated - API definitions should use the "type" property, as the "schema" alias for that property name may be removed in a future RAML version. The "type" property allows for XML and JSON schemas.
     **/
    schema(): string[];
    /**
     * Inlined supertype definition.
     **/
    structuredType(): TypeInstance;
    parametrizedProperties(): TypeInstance;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): TypeDeclarationScalarsAnnotationsImpl;
}
export declare class ModelLocationImpl implements ModelLocation {
    protected attr: hl.IAttribute;
    constructor(attr: hl.IAttribute);
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class LocationKindImpl implements LocationKind {
    protected attr: hl.IAttribute;
    constructor(attr: hl.IAttribute);
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class UsesDeclarationImpl extends AnnotableImpl implements UsesDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Name prefix (without dot) used to refer imported declarations
     **/
    key(): string;
    /**
     * @hidden
     * Set key value
     **/
    setKey(param: string): this;
    /**
     * Content of the schema
     **/
    value(): string;
    /**
     * @hidden
     * Set value value
     **/
    setValue(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Returns the root node of the AST, uses statement refers.
     **/
    ast(): Library;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): UsesDeclarationScalarsAnnotationsImpl;
}
/**
 * UsesDeclaration scalar properties annotations accessor
 **/
export declare class UsesDeclarationScalarsAnnotationsImpl implements UsesDeclarationScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * UsesDeclaration.value annotations
     **/
    value(): AnnotationRef[];
}
export declare class XMLFacetInfoImpl extends AnnotableImpl implements XMLFacetInfo {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * If attribute is set to true, a type instance should be serialized as an XML attribute. It can only be true for scalar types.
     **/
    attribute(): boolean;
    /**
     * @hidden
     * Set attribute value
     **/
    setAttribute(param: boolean): this;
    /**
     * If wrapped is set to true, a type instance should be wrapped in its own XML element. It can not be true for scalar types and it can not be true at the same moment when attribute is true.
     **/
    wrapped(): boolean;
    /**
     * @hidden
     * Set wrapped value
     **/
    setWrapped(param: boolean): this;
    /**
     * Allows to override the name of the XML element or XML attribute in it's XML representation.
     **/
    name(): string;
    /**
     * @hidden
     * Set name value
     **/
    setName(param: string): this;
    /**
     * Allows to configure the name of the XML namespace.
     **/
    namespace(): string;
    /**
     * @hidden
     * Set namespace value
     **/
    setNamespace(param: string): this;
    /**
     * Allows to configure the prefix which will be used during serialization to XML.
     **/
    prefix(): string;
    /**
     * @hidden
     * Set prefix value
     **/
    setPrefix(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): XMLFacetInfoScalarsAnnotationsImpl;
}
/**
 * XMLFacetInfo scalar properties annotations accessor
 **/
export declare class XMLFacetInfoScalarsAnnotationsImpl implements XMLFacetInfoScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * XMLFacetInfo.attribute annotations
     **/
    attribute(): AnnotationRef[];
    /**
     * XMLFacetInfo.wrapped annotations
     **/
    wrapped(): AnnotationRef[];
    /**
     * XMLFacetInfo.name annotations
     **/
    name(): AnnotationRef[];
    /**
     * XMLFacetInfo.namespace annotations
     **/
    namespace(): AnnotationRef[];
    /**
     * XMLFacetInfo.prefix annotations
     **/
    prefix(): AnnotationRef[];
}
export declare class ArrayTypeDeclarationImpl extends TypeDeclarationImpl implements ArrayTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Should items in array be unique
     **/
    uniqueItems(): boolean;
    /**
     * @hidden
     * Set uniqueItems value
     **/
    setUniqueItems(param: boolean): this;
    /**
     * Array component type.
     * @hidden
     **/
    items_original(): string[];
    /**
     * @hidden
     * Set items value
     **/
    setItems(param: string): this;
    /**
     * Minimum amount of items in array
     **/
    minItems(): number;
    /**
     * @hidden
     * Set minItems value
     **/
    setMinItems(param: number): this;
    /**
     * Maximum amount of items in array
     **/
    maxItems(): number;
    /**
     * @hidden
     * Set maxItems value
     **/
    setMaxItems(param: number): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Inlined component type definition.
     **/
    structuredItems(): TypeInstance;
    /**
     * Array component type.
     **/
    items(): string[];
    /**
     * Returns anonymous type defined by "items" keyword, or a component type if declaration can be found.
     * Does not resolve type expressions. Only returns component type declaration if it is actually defined
     * somewhere in AST.
     **/
    findComponentTypeDeclaration(): TypeDeclaration;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): ArrayTypeDeclarationScalarsAnnotationsImpl;
}
/**
 * TypeDeclaration scalar properties annotations accessor
 **/
export declare class TypeDeclarationScalarsAnnotationsImpl implements TypeDeclarationScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * TypeDeclaration.displayName annotations
     **/
    displayName(): AnnotationRef[];
    /**
     * TypeDeclaration.schema annotations
     **/
    schema(): AnnotationRef[][];
    /**
     * TypeDeclaration.type annotations
     **/
    "type"(): AnnotationRef[][];
    /**
     * TypeDeclaration.location annotations
     **/
    location(): AnnotationRef[];
    /**
     * TypeDeclaration.locationKind annotations
     **/
    locationKind(): AnnotationRef[];
    /**
     * TypeDeclaration.default annotations
     **/
    "default"(): AnnotationRef[];
    /**
     * TypeDeclaration.required annotations
     **/
    required(): AnnotationRef[];
    /**
     * TypeDeclaration.description annotations
     **/
    description(): AnnotationRef[];
    /**
     * TypeDeclaration.allowedTargets annotations
     **/
    allowedTargets(): AnnotationRef[][];
    /**
     * TypeDeclaration.isAnnotation annotations
     **/
    isAnnotation(): AnnotationRef[];
}
/**
 * ArrayTypeDeclaration scalar properties annotations accessor
 **/
export declare class ArrayTypeDeclarationScalarsAnnotationsImpl extends TypeDeclarationScalarsAnnotationsImpl implements ArrayTypeDeclarationScalarsAnnotations {
    /**
     * ArrayTypeDeclaration.uniqueItems annotations
     **/
    uniqueItems(): AnnotationRef[];
    /**
     * ArrayTypeDeclaration.items annotations
     **/
    items(): AnnotationRef[][];
    /**
     * ArrayTypeDeclaration.minItems annotations
     **/
    minItems(): AnnotationRef[];
    /**
     * ArrayTypeDeclaration.maxItems annotations
     **/
    maxItems(): AnnotationRef[];
}
export declare class UnionTypeDeclarationImpl extends TypeDeclarationImpl implements UnionTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class ObjectTypeDeclarationImpl extends TypeDeclarationImpl implements ObjectTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * The properties that instances of this type may or must have.
     **/
    properties(): TypeDeclaration[];
    /**
     * The minimum number of properties allowed for instances of this type.
     **/
    minProperties(): number;
    /**
     * @hidden
     * Set minProperties value
     **/
    setMinProperties(param: number): this;
    /**
     * The maximum number of properties allowed for instances of this type.
     **/
    maxProperties(): number;
    /**
     * @hidden
     * Set maxProperties value
     **/
    setMaxProperties(param: number): this;
    /**
     * A Boolean that indicates if an object instance has additional properties.
     **/
    additionalProperties(): boolean;
    /**
     * @hidden
     * Set additionalProperties value
     **/
    setAdditionalProperties(param: boolean): this;
    /**
     * Type property name to be used as discriminator, or boolean
     **/
    discriminator(): string;
    /**
     * @hidden
     * Set discriminator value
     **/
    setDiscriminator(param: string): this;
    /**
     * The value of discriminator for the type.
     **/
    discriminatorValue(): string;
    /**
     * @hidden
     * Set discriminatorValue value
     **/
    setDiscriminatorValue(param: string): this;
    enum(): any[];
    /**
     * @hidden
     * Set enum value
     **/
    setEnum(param: any): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): ObjectTypeDeclarationScalarsAnnotationsImpl;
}
/**
 * ObjectTypeDeclaration scalar properties annotations accessor
 **/
export declare class ObjectTypeDeclarationScalarsAnnotationsImpl extends TypeDeclarationScalarsAnnotationsImpl implements ObjectTypeDeclarationScalarsAnnotations {
    /**
     * ObjectTypeDeclaration.minProperties annotations
     **/
    minProperties(): AnnotationRef[];
    /**
     * ObjectTypeDeclaration.maxProperties annotations
     **/
    maxProperties(): AnnotationRef[];
    /**
     * ObjectTypeDeclaration.additionalProperties annotations
     **/
    additionalProperties(): AnnotationRef[];
    /**
     * ObjectTypeDeclaration.discriminator annotations
     **/
    discriminator(): AnnotationRef[];
    /**
     * ObjectTypeDeclaration.discriminatorValue annotations
     **/
    discriminatorValue(): AnnotationRef[];
    /**
     * ObjectTypeDeclaration.enum annotations
     **/
    enum(): AnnotationRef[][];
}
/**
 * Value must be a string
 **/
export declare class StringTypeDeclarationImpl extends TypeDeclarationImpl implements StringTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Regular expression that this string should path
     **/
    pattern(): string;
    /**
     * @hidden
     * Set pattern value
     **/
    setPattern(param: string): this;
    /**
     * Minimum length of the string
     **/
    minLength(): number;
    /**
     * @hidden
     * Set minLength value
     **/
    setMinLength(param: number): this;
    /**
     * Maximum length of the string
     **/
    maxLength(): number;
    /**
     * @hidden
     * Set maxLength value
     **/
    setMaxLength(param: number): this;
    /**
     * (Optional, applicable only for parameters of type string) The enum attribute provides an enumeration of the parameter's valid values. This MUST be an array. If the enum attribute is defined, API clients and servers MUST verify that a parameter's value matches a value in the enum array. If there is no matching value, the clients and servers MUST treat this as an error.
     **/
    enum(): string[];
    /**
     * @hidden
     * Set enum value
     **/
    setEnum(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): StringTypeDeclarationScalarsAnnotationsImpl;
}
/**
 * StringTypeDeclaration scalar properties annotations accessor
 **/
export declare class StringTypeDeclarationScalarsAnnotationsImpl extends TypeDeclarationScalarsAnnotationsImpl implements StringTypeDeclarationScalarsAnnotations {
    /**
     * StringTypeDeclaration.pattern annotations
     **/
    pattern(): AnnotationRef[];
    /**
     * StringTypeDeclaration.minLength annotations
     **/
    minLength(): AnnotationRef[];
    /**
     * StringTypeDeclaration.maxLength annotations
     **/
    maxLength(): AnnotationRef[];
    /**
     * StringTypeDeclaration.enum annotations
     **/
    enum(): AnnotationRef[][];
}
/**
 * Value must be a boolean
 **/
export declare class BooleanTypeDeclarationImpl extends TypeDeclarationImpl implements BooleanTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    enum(): boolean[];
    /**
     * @hidden
     * Set enum value
     **/
    setEnum(param: boolean): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): BooleanTypeDeclarationScalarsAnnotationsImpl;
}
/**
 * BooleanTypeDeclaration scalar properties annotations accessor
 **/
export declare class BooleanTypeDeclarationScalarsAnnotationsImpl extends TypeDeclarationScalarsAnnotationsImpl implements BooleanTypeDeclarationScalarsAnnotations {
    /**
     * BooleanTypeDeclaration.enum annotations
     **/
    enum(): AnnotationRef[][];
}
/**
 * Value MUST be a number. Indicate floating point numbers as defined by YAML.
 **/
export declare class NumberTypeDeclarationImpl extends TypeDeclarationImpl implements NumberTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * (Optional, applicable only for parameters of type number or integer) The minimum attribute specifies the parameter's minimum value.
     **/
    minimum(): number;
    /**
     * @hidden
     * Set minimum value
     **/
    setMinimum(param: number): this;
    /**
     * (Optional, applicable only for parameters of type number or integer) The maximum attribute specifies the parameter's maximum value.
     **/
    maximum(): number;
    /**
     * @hidden
     * Set maximum value
     **/
    setMaximum(param: number): this;
    /**
     * (Optional, applicable only for parameters of type string) The enum attribute provides an enumeration of the parameter's valid values. This MUST be an array. If the enum attribute is defined, API clients and servers MUST verify that a parameter's value matches a value in the enum array. If there is no matching value, the clients and servers MUST treat this as an error.
     **/
    enum(): number[];
    /**
     * @hidden
     * Set enum value
     **/
    setEnum(param: number): this;
    /**
     * Value format
     **/
    format(): string;
    /**
     * @hidden
     * Set format value
     **/
    setFormat(param: string): this;
    /**
     * A numeric instance is valid against "multipleOf" if the result of the division of the instance by this keyword's value is an integer.
     **/
    multipleOf(): number;
    /**
     * @hidden
     * Set multipleOf value
     **/
    setMultipleOf(param: number): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): NumberTypeDeclarationScalarsAnnotationsImpl;
}
/**
 * Value MUST be a integer.
 **/
export declare class IntegerTypeDeclarationImpl extends NumberTypeDeclarationImpl implements IntegerTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Value format
     **/
    format(): string;
    /**
     * @hidden
     * Set format value
     **/
    setFormat(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): IntegerTypeDeclarationScalarsAnnotationsImpl;
}
/**
 * NumberTypeDeclaration scalar properties annotations accessor
 **/
export declare class NumberTypeDeclarationScalarsAnnotationsImpl extends TypeDeclarationScalarsAnnotationsImpl implements NumberTypeDeclarationScalarsAnnotations {
    /**
     * NumberTypeDeclaration.minimum annotations
     **/
    minimum(): AnnotationRef[];
    /**
     * NumberTypeDeclaration.maximum annotations
     **/
    maximum(): AnnotationRef[];
    /**
     * NumberTypeDeclaration.enum annotations
     **/
    enum(): AnnotationRef[][];
    /**
     * NumberTypeDeclaration.format annotations
     **/
    format(): AnnotationRef[];
    /**
     * NumberTypeDeclaration.multipleOf annotations
     **/
    multipleOf(): AnnotationRef[];
}
/**
 * IntegerTypeDeclaration scalar properties annotations accessor
 **/
export declare class IntegerTypeDeclarationScalarsAnnotationsImpl extends NumberTypeDeclarationScalarsAnnotationsImpl implements IntegerTypeDeclarationScalarsAnnotations {
    /**
     * IntegerTypeDeclaration.format annotations
     **/
    format(): AnnotationRef[];
}
/**
 * the "full-date" notation of RFC3339, namely yyyy-mm-dd (no implications about time or timezone-offset)
 **/
export declare class DateOnlyTypeDeclarationImpl extends TypeDeclarationImpl implements DateOnlyTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * the "partial-time" notation of RFC3339, namely hh:mm:ss[.ff...] (no implications about date or timezone-offset)
 **/
export declare class TimeOnlyTypeDeclarationImpl extends TypeDeclarationImpl implements TimeOnlyTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * combined date-only and time-only with a separator of "T", namely yyyy-mm-ddThh:mm:ss[.ff...] (no implications about timezone-offset)
 **/
export declare class DateTimeOnlyTypeDeclarationImpl extends TypeDeclarationImpl implements DateTimeOnlyTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * a timestamp, either in the "date-time" notation of RFC3339, if format is omitted or is set to rfc3339, or in the format defined in RFC2616, if format is set to rfc2616.
 **/
export declare class DateTimeTypeDeclarationImpl extends TypeDeclarationImpl implements DateTimeTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Format used for this date time rfc3339 or rfc2616
     **/
    format(): string;
    /**
     * @hidden
     * Set format value
     **/
    setFormat(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): DateTimeTypeDeclarationScalarsAnnotationsImpl;
}
/**
 * DateTimeTypeDeclaration scalar properties annotations accessor
 **/
export declare class DateTimeTypeDeclarationScalarsAnnotationsImpl extends TypeDeclarationScalarsAnnotationsImpl implements DateTimeTypeDeclarationScalarsAnnotations {
    /**
     * DateTimeTypeDeclaration.format annotations
     **/
    format(): AnnotationRef[];
}
/**
 * (Applicable only to Form properties) Value is a file. Client generators SHOULD use this type to handle file uploads correctly.
 **/
export declare class FileTypeDeclarationImpl extends TypeDeclarationImpl implements FileTypeDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * A list of valid content-type strings for the file. The file type * /* should be a valid value.
     **/
    fileTypes(): ContentType[];
    /**
     * The minLength attribute specifies the parameter value's minimum number of bytes.
     **/
    minLength(): number;
    /**
     * @hidden
     * Set minLength value
     **/
    setMinLength(param: number): this;
    /**
     * The maxLength attribute specifies the parameter value's maximum number of bytes.
     **/
    maxLength(): number;
    /**
     * @hidden
     * Set maxLength value
     **/
    setMaxLength(param: number): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): FileTypeDeclarationScalarsAnnotationsImpl;
}
/**
 * FileTypeDeclaration scalar properties annotations accessor
 **/
export declare class FileTypeDeclarationScalarsAnnotationsImpl extends TypeDeclarationScalarsAnnotationsImpl implements FileTypeDeclarationScalarsAnnotations {
    /**
     * FileTypeDeclaration.fileTypes annotations
     **/
    fileTypes(): AnnotationRef[][];
    /**
     * FileTypeDeclaration.minLength annotations
     **/
    minLength(): AnnotationRef[];
    /**
     * FileTypeDeclaration.maxLength annotations
     **/
    maxLength(): AnnotationRef[];
}
export declare class ResponseImpl extends AnnotableImpl implements Response {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Responses MUST be a map of one or more HTTP status codes, where each status code itself is a map that describes that status code.
     **/
    code(): StatusCodeString;
    /**
     * Detailed information about any response headers returned by this method
     **/
    headers(): TypeDeclaration[];
    /**
     * The body of the response: a body declaration
     **/
    body(): TypeDeclaration[];
    /**
     * A longer, human-friendly description of the response
     **/
    description(): MarkdownString;
    /**
     * Most of RAML model elements may have attached annotations decribing additional meta data about this element
     **/
    annotations(): AnnotationRef[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * true for codes < 400 and false otherwise
     **/
    isOkRange(): boolean;
    parametrizedProperties(): TypeInstance;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): ResponseScalarsAnnotationsImpl;
}
/**
 * Response scalar properties annotations accessor
 **/
export declare class ResponseScalarsAnnotationsImpl implements ResponseScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * Response.description annotations
     **/
    description(): AnnotationRef[];
}
export declare class SecuritySchemePartImpl extends OperationImpl implements SecuritySchemePart {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Annotations to be applied to this security scheme part. Annotations are any property whose key begins with "(" and ends with ")" and whose name (the part between the beginning and ending parentheses) is a declared annotation name.
     **/
    annotations(): AnnotationRef[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class MethodBaseImpl extends OperationImpl implements MethodBase {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Some method verbs expect the resource to be sent as a request body. For example, to create a resource, the request must include the details of the resource to create. Resources CAN have alternate representations. For example, an API might support both JSON and XML representations. A method's body is defined in the body property as a hashmap, in which the key MUST be a valid media type.
     **/
    body(): TypeDeclaration[];
    /**
     * A method can override the protocols specified in the resource or at the API root, by employing this property.
     **/
    protocols(): string[];
    /**
     * @hidden
     * Set protocols value
     **/
    setProtocols(param: string): this;
    /**
     * Instantiation of applyed traits
     **/
    is(): TraitRef[];
    /**
     * securityScheme may also be applied to a resource by using the securedBy key, which is equivalent to applying the securityScheme to all methods that may be declared, explicitly or implicitly, by defining the resourceTypes or traits property for that resource. To indicate that the method may be called without applying any securityScheme, the method may be annotated with the null securityScheme.
     **/
    securedBy(): SecuritySchemeRef[];
    description(): MarkdownString;
    displayName(): string;
    /**
     * @hidden
     * Set displayName value
     **/
    setDisplayName(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): MethodBaseScalarsAnnotationsImpl;
}
export declare class SecuritySchemeRefImpl extends ReferenceImpl implements SecuritySchemeRef {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    securitySchemeName(): string;
    securityScheme(): AbstractSecurityScheme;
}
/**
 * Declares globally referable security scheme definition
 **/
export declare class AbstractSecuritySchemeImpl extends AnnotableImpl implements AbstractSecurityScheme {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Name of the security scheme
     **/
    name(): string;
    /**
     * @hidden
     * Set name value
     **/
    setName(param: string): this;
    /**
     * The securitySchemes property MUST be used to specify an API's security mechanisms, including the required settings and the authentication methods that the API supports. one authentication method is allowed if the API supports them.
     **/
    "type"(): string;
    /**
     * @hidden
     * Set type value
     **/
    setType(param: string): this;
    /**
     * The description MAY be used to describe a securityScheme.
     **/
    description(): MarkdownString;
    /**
     * A description of the request components related to Security that are determined by the scheme: the headers, query parameters or responses. As a best practice, even for standard security schemes, API designers SHOULD describe these properties of security schemes. Including the security scheme description completes an API documentation.
     **/
    describedBy(): SecuritySchemePart;
    /**
     * The displayName attribute specifies the security scheme display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    displayName(): string;
    /**
     * @hidden
     * Set displayName value
     **/
    setDisplayName(param: string): this;
    /**
     * The settings attribute MAY be used to provide security scheme-specific information. The required attributes vary depending on the type of security scheme is being declared. It describes the minimum set of properties which any processing application MUST provide and validate if it chooses to implement the security scheme. Processing applications MAY choose to recognize other properties for things such as token lifetime, preferred cryptographic algorithms, and more.
     **/
    settings(): SecuritySchemeSettings;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): AbstractSecuritySchemeScalarsAnnotationsImpl;
}
export declare class SecuritySchemeSettingsImpl extends AnnotableImpl implements SecuritySchemeSettings {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class OAuth1SecuritySchemeSettingsImpl extends SecuritySchemeSettingsImpl implements OAuth1SecuritySchemeSettings {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * The URI of the Temporary Credential Request endpoint as defined in RFC5849 Section 2.1
     **/
    requestTokenUri(): FixedUriString;
    /**
     * The URI of the Resource Owner Authorization endpoint as defined in RFC5849 Section 2.2
     **/
    authorizationUri(): FixedUriString;
    /**
     * The URI of the Token Request endpoint as defined in RFC5849 Section 2.3
     **/
    tokenCredentialsUri(): FixedUriString;
    /**
     * List of the signature methods used by the server. Available methods: HMAC-SHA1, RSA-SHA1, PLAINTEXT
     **/
    signatures(): string[];
    /**
     * @hidden
     * Set signatures value
     **/
    setSignatures(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl;
}
/**
 * OAuth1SecuritySchemeSettings scalar properties annotations accessor
 **/
export declare class OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl implements OAuth1SecuritySchemeSettingsScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * OAuth1SecuritySchemeSettings.requestTokenUri annotations
     **/
    requestTokenUri(): AnnotationRef[];
    /**
     * OAuth1SecuritySchemeSettings.authorizationUri annotations
     **/
    authorizationUri(): AnnotationRef[];
    /**
     * OAuth1SecuritySchemeSettings.tokenCredentialsUri annotations
     **/
    tokenCredentialsUri(): AnnotationRef[];
    /**
     * OAuth1SecuritySchemeSettings.signatures annotations
     **/
    signatures(): AnnotationRef[][];
}
export declare class OAuth2SecuritySchemeSettingsImpl extends SecuritySchemeSettingsImpl implements OAuth2SecuritySchemeSettings {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * The URI of the Token Endpoint as defined in RFC6749 Section 3.2. Not required forby implicit grant type.
     **/
    accessTokenUri(): FixedUriString;
    /**
     * The URI of the Authorization Endpoint as defined in RFC6749 Section 3.1. Required forby authorization_code and implicit grant types.
     **/
    authorizationUri(): FixedUriString;
    /**
     * A list of the Authorization grants supported by the API as defined in RFC6749 Sections 4.1, 4.2, 4.3 and 4.4, can be any of: authorization_code, password, client_credentials, implicit, or any absolute url.
     **/
    authorizationGrants(): string[];
    /**
     * @hidden
     * Set authorizationGrants value
     **/
    setAuthorizationGrants(param: string): this;
    /**
     * A list of scopes supported by the security scheme as defined in RFC6749 Section 3.3
     **/
    scopes(): string[];
    /**
     * @hidden
     * Set scopes value
     **/
    setScopes(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl;
}
/**
 * OAuth2SecuritySchemeSettings scalar properties annotations accessor
 **/
export declare class OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl implements OAuth2SecuritySchemeSettingsScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * OAuth2SecuritySchemeSettings.accessTokenUri annotations
     **/
    accessTokenUri(): AnnotationRef[];
    /**
     * OAuth2SecuritySchemeSettings.authorizationUri annotations
     **/
    authorizationUri(): AnnotationRef[];
    /**
     * OAuth2SecuritySchemeSettings.authorizationGrants annotations
     **/
    authorizationGrants(): AnnotationRef[][];
    /**
     * OAuth2SecuritySchemeSettings.scopes annotations
     **/
    scopes(): AnnotationRef[][];
}
/**
 * Declares globally referable security scheme definition
 **/
export declare class OAuth2SecuritySchemeImpl extends AbstractSecuritySchemeImpl implements OAuth2SecurityScheme {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    settings(): OAuth2SecuritySchemeSettings;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * Declares globally referable security scheme definition
 **/
export declare class OAuth1SecuritySchemeImpl extends AbstractSecuritySchemeImpl implements OAuth1SecurityScheme {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    settings(): OAuth1SecuritySchemeSettings;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * Declares globally referable security scheme definition
 **/
export declare class PassThroughSecuritySchemeImpl extends AbstractSecuritySchemeImpl implements PassThroughSecurityScheme {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    settings(): SecuritySchemeSettings;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * Declares globally referable security scheme definition
 **/
export declare class BasicSecuritySchemeImpl extends AbstractSecuritySchemeImpl implements BasicSecurityScheme {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * Declares globally referable security scheme definition
 **/
export declare class DigestSecuritySchemeImpl extends AbstractSecuritySchemeImpl implements DigestSecurityScheme {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * Declares globally referable security scheme definition
 **/
export declare class CustomSecuritySchemeImpl extends AbstractSecuritySchemeImpl implements CustomSecurityScheme {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
/**
 * AbstractSecurityScheme scalar properties annotations accessor
 **/
export declare class AbstractSecuritySchemeScalarsAnnotationsImpl implements AbstractSecuritySchemeScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * AbstractSecurityScheme.type annotations
     **/
    "type"(): AnnotationRef[];
    /**
     * AbstractSecurityScheme.description annotations
     **/
    description(): AnnotationRef[];
    /**
     * AbstractSecurityScheme.displayName annotations
     **/
    displayName(): AnnotationRef[];
}
export declare class MethodImpl extends MethodBaseImpl implements Method {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Method that can be called
     **/
    method(): string;
    /**
     * @hidden
     * Set method value
     **/
    setMethod(param: string): this;
    /**
     * The displayName attribute specifies the method display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    displayName(): string;
    /**
     * @hidden
     * Set displayName value
     **/
    setDisplayName(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * For methods of Resources returns parent resource. For methods of ResourceTypes returns null.
     **/
    parentResource(): Resource;
    /**
     * Api owning the resource as a sibling
     **/
    ownerApi(): Api;
    /**
     * For methods of Resources: `{parent Resource relative path} {methodName}`.
     * For methods of ResourceTypes: `{parent ResourceType name} {methodName}`.
     * For other methods throws Exception.
     **/
    methodId(): string;
    /**
     * Returns security schemes, resource or method is secured with. If no security schemes are set at resource or method level,
     * returns schemes defined with `securedBy` at API level.
     * @deprecated
     **/
    allSecuredBy(): SecuritySchemeRef[];
    parametrizedProperties(): TypeInstance;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): MethodScalarsAnnotationsImpl;
}
/**
 * MethodBase scalar properties annotations accessor
 **/
export declare class MethodBaseScalarsAnnotationsImpl implements MethodBaseScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * MethodBase.protocols annotations
     **/
    protocols(): AnnotationRef[][];
    /**
     * MethodBase.is annotations
     **/
    is(): AnnotationRef[][];
    /**
     * MethodBase.securedBy annotations
     **/
    securedBy(): AnnotationRef[][];
    /**
     * MethodBase.description annotations
     **/
    description(): AnnotationRef[];
    /**
     * MethodBase.displayName annotations
     **/
    displayName(): AnnotationRef[];
}
/**
 * Method scalar properties annotations accessor
 **/
export declare class MethodScalarsAnnotationsImpl extends MethodBaseScalarsAnnotationsImpl implements MethodScalarsAnnotations {
    /**
     * Method.displayName annotations
     **/
    displayName(): AnnotationRef[];
}
export declare class TraitImpl extends MethodBaseImpl implements Trait {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Name of the trait
     **/
    name(): string;
    /**
     * @hidden
     * Set name value
     **/
    setName(param: string): this;
    /**
     * Instructions on how and when the trait should be used.
     **/
    usage(): string;
    /**
     * @hidden
     * Set usage value
     **/
    setUsage(param: string): this;
    /**
     * The displayName attribute specifies the trait display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    displayName(): string;
    /**
     * @hidden
     * Set displayName value
     **/
    setDisplayName(param: string): this;
    uses(): UsesDeclaration[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    parametrizedProperties(): TypeInstance;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): TraitScalarsAnnotationsImpl;
}
/**
 * Trait scalar properties annotations accessor
 **/
export declare class TraitScalarsAnnotationsImpl extends MethodBaseScalarsAnnotationsImpl implements TraitScalarsAnnotations {
    /**
     * Trait.usage annotations
     **/
    usage(): AnnotationRef[];
    /**
     * Trait.displayName annotations
     **/
    displayName(): AnnotationRef[];
}
export declare class ResourceTypeRefImpl extends ReferenceImpl implements ResourceTypeRef {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    resourceType(): ResourceType;
}
export declare class ResourceBaseImpl extends AnnotableImpl implements ResourceBase {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Methods that are part of this resource type definition
     **/
    methods(): Method[];
    /**
     * A list of the traits to apply to all methods declared (implicitly or explicitly) for this resource. Individual methods may override this declaration
     **/
    is(): TraitRef[];
    /**
     * The resource type which this resource inherits.
     **/
    "type"(): ResourceTypeRef;
    description(): MarkdownString;
    /**
     * The security schemes that apply to all methods declared (implicitly or explicitly) for this resource.
     **/
    securedBy(): SecuritySchemeRef[];
    /**
     * Detailed information about any URI parameters of this resource
     * @hidden
     **/
    uriParameters_original(): TypeDeclaration[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Detailed information about any URI parameters of this resource
     **/
    uriParameters(): TypeDeclaration[];
    /**
     * Retrieve an ordered list of all uri parameters including those which are not described in the `uriParameters` node.
     * Consider a fragment of RAML specification:
     * ```yaml
     * /resource/{objectId}/{propertyId}:
     * uriParameters:
     * objectId:
     * ```
     * Here `propertyId` uri parameter is not described in the `uriParameters` node,
     * but it is among Resource.allUriParameters().
     * @deprecated
     **/
    allUriParameters(): TypeDeclaration[];
    /**
     * Returns security schemes, resource or method is secured with. If no security schemes are set at resource or method level,
     * returns schemes defined with `securedBy` at API level.
     * @deprecated
     **/
    allSecuredBy(): SecuritySchemeRef[];
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): ResourceBaseScalarsAnnotationsImpl;
}
export declare class ResourceImpl extends ResourceBaseImpl implements Resource {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Relative URL of this resource from the parent resource
     **/
    relativeUri(): RelativeUriString;
    /**
     * The displayName attribute specifies the resource display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    displayName(): string;
    /**
     * @hidden
     * Set displayName value
     **/
    setDisplayName(param: string): this;
    /**
     * A nested resource is identified as any property whose name begins with a slash ("/") and is therefore treated as a relative URI.
     **/
    resources(): Resource[];
    /**
     * A longer, human-friendly description of the resource.
     **/
    description(): MarkdownString;
    /**
     * Most of RAML model elements may have attached annotations decribing additional meta data about this element
     **/
    annotations(): AnnotationRef[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Path relative to API root
     **/
    completeRelativeUri(): string;
    /**
     * baseUri of owning Api concatenated with completeRelativeUri
     **/
    absoluteUri(): string;
    /**
     * Parent resource for non top level resources
     **/
    parentResource(): Resource;
    /**
     * Get child resource by its relative path
     **/
    childResource(relPath: string): Resource;
    /**
     * Get child method by its name
     **/
    childMethod(method: string): Method[];
    /**
     * Api owning the resource as a sibling
     **/
    ownerApi(): Api;
    /**
     * Retrieve an ordered list of all absolute uri parameters. Returns a union of `Api.baseUriParameters()`
     * for `Api` owning the `Resource` and `Resource.uriParameters()`.
     **/
    absoluteUriParameters(): TypeDeclaration[];
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): ResourceScalarsAnnotationsImpl;
}
/**
 * ResourceBase scalar properties annotations accessor
 **/
export declare class ResourceBaseScalarsAnnotationsImpl implements ResourceBaseScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * ResourceBase.is annotations
     **/
    is(): AnnotationRef[][];
    /**
     * ResourceBase.type annotations
     **/
    "type"(): AnnotationRef[];
    /**
     * ResourceBase.description annotations
     **/
    description(): AnnotationRef[];
    /**
     * ResourceBase.securedBy annotations
     **/
    securedBy(): AnnotationRef[][];
}
/**
 * Resource scalar properties annotations accessor
 **/
export declare class ResourceScalarsAnnotationsImpl extends ResourceBaseScalarsAnnotationsImpl implements ResourceScalarsAnnotations {
    /**
     * Resource.displayName annotations
     **/
    displayName(): AnnotationRef[];
    /**
     * Resource.description annotations
     **/
    description(): AnnotationRef[];
}
export declare class ResourceTypeImpl extends ResourceBaseImpl implements ResourceType {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * The displayName attribute specifies the resource type display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    displayName(): string;
    /**
     * @hidden
     * Set displayName value
     **/
    setDisplayName(param: string): this;
    /**
     * Name of the resource type
     **/
    name(): string;
    /**
     * @hidden
     * Set name value
     **/
    setName(param: string): this;
    /**
     * Instructions on how and when the resource type should be used.
     **/
    usage(): string;
    /**
     * @hidden
     * Set usage value
     **/
    setUsage(param: string): this;
    uses(): UsesDeclaration[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    parametrizedProperties(): TypeInstance;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): ResourceTypeScalarsAnnotationsImpl;
}
/**
 * ResourceType scalar properties annotations accessor
 **/
export declare class ResourceTypeScalarsAnnotationsImpl extends ResourceBaseScalarsAnnotationsImpl implements ResourceTypeScalarsAnnotations {
    /**
     * ResourceType.displayName annotations
     **/
    displayName(): AnnotationRef[];
    /**
     * ResourceType.usage annotations
     **/
    usage(): AnnotationRef[];
}
/**
 * Annotations allow you to attach information to your API
 **/
export declare class AnnotationRefImpl extends ReferenceImpl implements AnnotationRef {
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    annotation(): TypeDeclaration;
}
export declare class DocumentationItemImpl extends AnnotableImpl implements DocumentationItem {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Title of documentation section
     **/
    title(): string;
    /**
     * @hidden
     * Set title value
     **/
    setTitle(param: string): this;
    /**
     * Content of documentation section
     **/
    content(): MarkdownString;
    uses(): UsesDeclaration[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): DocumentationItemScalarsAnnotationsImpl;
}
/**
 * DocumentationItem scalar properties annotations accessor
 **/
export declare class DocumentationItemScalarsAnnotationsImpl implements DocumentationItemScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * DocumentationItem.title annotations
     **/
    title(): AnnotationRef[];
    /**
     * DocumentationItem.content annotations
     **/
    content(): AnnotationRef[];
}
export declare class FragmentDeclarationImpl extends AnnotableImpl implements FragmentDeclaration {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    uses(): UsesDeclaration[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
}
export declare class LibraryBaseImpl extends FragmentDeclarationImpl implements LibraryBase {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Alias for the equivalent "types" property, for compatibility with RAML 0.8. Deprecated - API definitions should use the "types" property, as the "schemas" alias for that property name may be removed in a future RAML version. The "types" property allows for XML and JSON schemas.
     **/
    schemas(): TypeDeclaration[];
    /**
     * Declarations of (data) types for use within this API
     **/
    types(): TypeDeclaration[];
    /**
     * Declarations of traits for use within this API
     * @hidden
     **/
    traits_original(): Trait[];
    /**
     * Declarations of resource types for use within this API
     * @hidden
     **/
    resourceTypes_original(): ResourceType[];
    /**
     * Declarations of annotation types for use by annotations
     **/
    annotationTypes(): TypeDeclaration[];
    /**
     * Declarations of security schemes for use within this API.
     **/
    securitySchemes(): AbstractSecurityScheme[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Declarations of traits for use within this API
     **/
    traits(): Trait[];
    /**
     * Retrieve all traits including those defined in libraries
     * @deprecated
     **/
    allTraits(): Trait[];
    /**
     * Declarations of resource types for use within this API
     **/
    resourceTypes(): ResourceType[];
    /**
     * Retrieve all resource types including those defined in libraries
     * @deprecated
     **/
    allResourceTypes(): ResourceType[];
}
export declare class LibraryImpl extends LibraryBaseImpl implements Library {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * contains description of why library exist
     **/
    usage(): string;
    /**
     * @hidden
     * Set usage value
     **/
    setUsage(param: string): this;
    /**
     * Namespace which the library is imported under
     **/
    name(): string;
    /**
     * @hidden
     * Set name value
     **/
    setName(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Equivalent Library which contains all its dependencies
     **/
    expand(): Library;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): LibraryScalarsAnnotationsImpl;
}
/**
 * Library scalar properties annotations accessor
 **/
export declare class LibraryScalarsAnnotationsImpl implements LibraryScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * Library.usage annotations
     **/
    usage(): AnnotationRef[];
}
export declare class ApiImpl extends LibraryBaseImpl implements Api {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * Short plain-text label for the API
     **/
    title(): string;
    /**
     * @hidden
     * Set title value
     **/
    setTitle(param: string): this;
    /**
     * A longer, human-friendly description of the API
     **/
    description(): MarkdownString;
    /**
     * The version of the API, e.g. 'v1'
     **/
    version(): string;
    /**
     * @hidden
     * Set version value
     **/
    setVersion(param: string): this;
    /**
     * A URI that's to be used as the base of all the resources' URIs. Often used as the base of the URL of each resource, containing the location of the API. Can be a template URI.
     **/
    baseUri(): FullUriTemplateString;
    /**
     * Named parameters used in the baseUri (template)
     * @hidden
     **/
    baseUriParameters_original(): TypeDeclaration[];
    /**
     * The protocols supported by the API
     **/
    protocols(): string[];
    /**
     * @hidden
     * Set protocols value
     **/
    setProtocols(param: string): this;
    /**
     * The default media type to use for request and response bodies (payloads), e.g. "application/json"
     **/
    mediaType(): MimeType[];
    /**
     * The security schemes that apply to every resource and method in the API
     **/
    securedBy(): SecuritySchemeRef[];
    /**
     * The resources of the API, identified as relative URIs that begin with a slash (/). Every property whose key begins with a slash (/), and is either at the root of the API definition or is the child property of a resource property, is a resource property, e.g.: /users, /{groupId}, etc
     **/
    resources(): Resource[];
    /**
     * Additional overall documentation for the API
     **/
    documentation(): DocumentationItem[];
    /**
     * Most of RAML model elements may have attached annotations decribing additional meta data about this element
     **/
    annotations(): AnnotationRef[];
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     * @hidden
     **/
    RAMLVersion_original(): string;
    /**
     * Equivalent API with traits and resource types expanded
     * @expLib whether to apply library expansion or not
     **/
    expand(expLib?: boolean): Api;
    /**
     * Get child resource by its relative path
     **/
    childResource(relPath: string): Resource;
    /**
     * Retrieve all resources of the Api
     **/
    allResources(): Resource[];
    /**
     * Named parameters used in the baseUri (template)
     **/
    baseUriParameters(): TypeDeclaration[];
    /**
     * Retrieve an ordered list of all base uri parameters regardless of whether they are described in `baseUriParameters` or not
     * Consider a fragment of RAML specification:
     * ```yaml
     * version: v1
     * baseUri: https://{organization}.example.com/{version}/{service}
     * baseUriParameters:
     * service:
     * ```
     * Here `version` and `organization` are base uri parameters which are not described in the `baseUriParameters` node,
     * but they are among `Api.allBaseUriParameters()`.
     * @deprecated
     **/
    allBaseUriParameters(): TypeDeclaration[];
    /**
     * Protocols used by the API. Returns the `protocols` property value if it is specified.
     * Otherwise, returns protocol, specified in the base URI.
     * @deprecated
     **/
    allProtocols(): string[];
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): ApiScalarsAnnotationsImpl;
}
export declare class OverlayImpl extends ApiImpl implements Overlay {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * contains description of why overlay exist
     **/
    usage(): string;
    /**
     * @hidden
     * Set usage value
     **/
    setUsage(param: string): this;
    /**
     * Location of a valid RAML API definition (or overlay or extension), the overlay is applied to.
     **/
    extends(): string;
    /**
     * @hidden
     * Set extends value
     **/
    setExtends(param: string): this;
    /**
     * Short plain-text label for the API
     **/
    title(): string;
    /**
     * @hidden
     * Set title value
     **/
    setTitle(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): OverlayScalarsAnnotationsImpl;
}
/**
 * Api scalar properties annotations accessor
 **/
export declare class ApiScalarsAnnotationsImpl implements ApiScalarsAnnotations {
    protected node: hl.IHighLevelNode;
    constructor(node: hl.IHighLevelNode);
    /**
     * Api.title annotations
     **/
    title(): AnnotationRef[];
    /**
     * Api.description annotations
     **/
    description(): AnnotationRef[];
    /**
     * Api.version annotations
     **/
    version(): AnnotationRef[];
    /**
     * Api.baseUri annotations
     **/
    baseUri(): AnnotationRef[];
    /**
     * Api.protocols annotations
     **/
    protocols(): AnnotationRef[][];
    /**
     * Api.mediaType annotations
     **/
    mediaType(): AnnotationRef[][];
    /**
     * Api.securedBy annotations
     **/
    securedBy(): AnnotationRef[][];
}
/**
 * Overlay scalar properties annotations accessor
 **/
export declare class OverlayScalarsAnnotationsImpl extends ApiScalarsAnnotationsImpl implements OverlayScalarsAnnotations {
    /**
     * Overlay.usage annotations
     **/
    usage(): AnnotationRef[];
    /**
     * Overlay.extends annotations
     **/
    extends(): AnnotationRef[];
    /**
     * Overlay.title annotations
     **/
    title(): AnnotationRef[];
}
export declare class ExtensionImpl extends ApiImpl implements Extension {
    protected nodeOrKey: hl.IHighLevelNode | string;
    protected setAsTopLevel: boolean;
    constructor(nodeOrKey: hl.IHighLevelNode | string, setAsTopLevel?: boolean);
    /**
     * contains description of why extension exist
     **/
    usage(): string;
    /**
     * @hidden
     * Set usage value
     **/
    setUsage(param: string): this;
    /**
     * Location of a valid RAML API definition (or overlay or extension), the extension is applied to
     **/
    extends(): string;
    /**
     * @hidden
     * Set extends value
     **/
    setExtends(param: string): this;
    /**
     * Short plain-text label for the API
     **/
    title(): string;
    /**
     * @hidden
     * Set title value
     **/
    setTitle(param: string): this;
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    wrapperClassName(): string;
    /**
     * @return Actual name of instance interface
     **/
    kind(): string;
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    allKinds(): string[];
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    allWrapperClassNames(): string[];
    /**
     * @return Whether specified object is an instance of this class
     **/
    static isInstance(instance: any): boolean;
    /**
     * @return RAML version of the node
     **/
    RAMLVersion(): string;
    /**
     * Scalar properties annotations accessor
     **/
    scalarsAnnotations(): ExtensionScalarsAnnotationsImpl;
}
/**
 * Extension scalar properties annotations accessor
 **/
export declare class ExtensionScalarsAnnotationsImpl extends ApiScalarsAnnotationsImpl implements ExtensionScalarsAnnotations {
    /**
     * Extension.usage annotations
     **/
    usage(): AnnotationRef[];
    /**
     * Extension.extends annotations
     **/
    extends(): AnnotationRef[];
    /**
     * Extension.title annotations
     **/
    title(): AnnotationRef[];
}
/**
 * Load API synchronously. If the 'rejectOnErrors' option is set to true, [[ApiLoadingError]] is thrown for Api which contains errors.
 * @param apiPath Path to API: local file system path or Web URL
 * @param options Load options
 * @return Api instance.
 **/
export declare function loadApiSync(apiPath: string, options?: coreApi.Options): Api;
/**
 * Load API synchronously. If the 'rejectOnErrors' option is set to true, [[ApiLoadingError]] is thrown for Api which contains errors.
 * @param apiPath Path to API: local file system path or Web URL
 * @param options Load options
 * @param extensionsAndOverlays Paths to extensions and overlays to be applied listed in the order of application. Relevant for RAML 1.0 only.
 * @return Api instance.
 **/
export declare function loadApiSync(apiPath: string, extensionsAndOverlays: string[], options?: coreApi.Options): Api;
/**
 * Load RAML synchronously. May load both Api and Typed fragments. If the 'rejectOnErrors' option is set to true, [[ApiLoadingError]] is thrown for RAML which contains errors.
 * @param ramlPath Path to RAML: local file system path or Web URL
 * @param options Load options
 * @param extensionsAndOverlays Paths to extensions and overlays to be applied listed in the order of application. Relevant for RAML 1.0 only.
 * @return hl.BasicNode instance.
 **/
export declare function loadRAMLSync(ramlPath: string, extensionsAndOverlays: string[], options?: coreApi.Options): hl.BasicNode;
/**
 * Load API asynchronously. The Promise is rejected with [[ApiLoadingError]] if the resulting Api contains errors and the 'rejectOnErrors' option is set to 'true'.
 * @param apiPath Path to API: local file system path or Web URL
 * @param options Load options
 * @return Promise&lt;Api&gt;.
 **/
export declare function loadApi(apiPath: string, options?: coreApi.Options): Promise<Api>;
/**
 * Load API asynchronously. The Promise is rejected with [[ApiLoadingError]] if the resulting Api contains errors and the 'rejectOnErrors' option is set to 'true'.
 * @param apiPath Path to API: local file system path or Web URL
 * @param options Load options
 * @param extensionsAndOverlays Paths to extensions and overlays to be applied listed in the order of application. Relevant for RAML 1.0 only.
 * @return Promise&lt;Api&gt;.
 **/
export declare function loadApi(apiPath: string, extensionsAndOverlays: string[], options?: coreApi.Options): Promise<Api>;
/**
 * Load RAML asynchronously. May load both Api and Typed fragments. The Promise is rejected with [[ApiLoadingError]] if the resulting hl.BasicNode contains errors and the 'rejectOnErrors' option is set to 'true'.
 * @param ramlPath Path to RAML: local file system path or Web URL
 * @param options Load options
 * @param extensionsAndOverlays Paths to extensions and overlays to be applied listed in the order of application. Relevant for RAML 1.0 only.
 * @return Promise&lt;hl.BasicNode&gt;.
 **/
export declare function loadRAML(ramlPath: string, extensionsAndOverlays: string[], options?: coreApi.Options): Promise<hl.BasicNode>;
/**
 * Gets AST node by runtime type, if runtime type matches any.
 * @param runtimeType - runtime type to find the match for
 */
export declare function getLanguageElementByRuntimeType(runtimeType: hl.ITypeDefinition): core.BasicNode;
