/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnVectorField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.opensearch.common.Explicit;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.VectorField;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.util.KNNEngine;

public class LuceneFieldMapper
extends KNNVectorFieldMapper {
    private static final int LUCENE_MAX_DIMENSION = 1024;
    private final FieldType vectorFieldType;

    LuceneFieldMapper(CreateLuceneFieldMapperInput input) {
        super(input.getName(), input.getMappedFieldType(), input.getMultiFields(), input.getCopyTo(), input.getIgnoreMalformed(), input.isStored(), input.isHasDocValues());
        this.knnMethod = input.getKnnMethodContext();
        VectorSimilarityFunction vectorSimilarityFunction = this.knnMethod.getSpaceType().getVectorSimilarityFunction();
        int dimension = input.getMappedFieldType().getDimension();
        if (dimension > 1024) {
            throw new IllegalArgumentException(String.format("Dimension value cannot be greater than [%s] but got [%s] for vector [%s]", 1024, dimension, input.getName()));
        }
        this.fieldType = KnnVectorField.createFieldType((int)dimension, (VectorSimilarityFunction)vectorSimilarityFunction);
        this.vectorFieldType = this.hasDocValues ? LuceneFieldMapper.buildDocValuesFieldType(this.knnMethod.getKnnEngine()) : null;
    }

    private static FieldType buildDocValuesFieldType(KNNEngine knnEngine) {
        FieldType field = new FieldType();
        field.putAttribute("engine", knnEngine.getName());
        field.setDocValuesType(DocValuesType.BINARY);
        field.freeze();
        return field;
    }

    @Override
    protected void parseCreateField(ParseContext context, int dimension) throws IOException {
        this.validateIfKNNPluginEnabled();
        this.validateIfCircuitBreakerIsNotTriggered();
        Optional<float[]> arrayOptional = this.getFloatsFromContext(context, dimension);
        if (arrayOptional.isEmpty()) {
            return;
        }
        float[] array = arrayOptional.get();
        KnnVectorField point = new KnnVectorField(this.name(), array, this.fieldType);
        context.doc().add((IndexableField)point);
        if (this.fieldType.stored()) {
            context.doc().add((IndexableField)new StoredField(this.name(), point.toString()));
        }
        if (this.hasDocValues && this.vectorFieldType != null) {
            context.doc().add((IndexableField)new VectorField(this.name(), array, (IndexableFieldType)this.vectorFieldType));
        }
        context.path().remove();
    }

    @Override
    void updateEngineStats() {
        KNNEngine.LUCENE.setInitialized(true);
    }

    static class CreateLuceneFieldMapperInput {
        @NonNull
        String name;
        @NonNull
        KNNVectorFieldMapper.KNNVectorFieldType mappedFieldType;
        @NonNull
        FieldMapper.MultiFields multiFields;
        @NonNull
        FieldMapper.CopyTo copyTo;
        @NonNull
        Explicit<Boolean> ignoreMalformed;
        boolean stored;
        boolean hasDocValues;
        @NonNull
        KNNMethodContext knnMethodContext;

        @Generated
        public static CreateLuceneFieldMapperInputBuilder builder() {
            return new CreateLuceneFieldMapperInputBuilder();
        }

        @Generated
        public CreateLuceneFieldMapperInput(@NonNull String name, @NonNull KNNVectorFieldMapper.KNNVectorFieldType mappedFieldType, @NonNull FieldMapper.MultiFields multiFields, @NonNull FieldMapper.CopyTo copyTo, @NonNull Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, @NonNull KNNMethodContext knnMethodContext) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (mappedFieldType == null) {
                throw new NullPointerException("mappedFieldType is marked non-null but is null");
            }
            if (multiFields == null) {
                throw new NullPointerException("multiFields is marked non-null but is null");
            }
            if (copyTo == null) {
                throw new NullPointerException("copyTo is marked non-null but is null");
            }
            if (ignoreMalformed == null) {
                throw new NullPointerException("ignoreMalformed is marked non-null but is null");
            }
            if (knnMethodContext == null) {
                throw new NullPointerException("knnMethodContext is marked non-null but is null");
            }
            this.name = name;
            this.mappedFieldType = mappedFieldType;
            this.multiFields = multiFields;
            this.copyTo = copyTo;
            this.ignoreMalformed = ignoreMalformed;
            this.stored = stored;
            this.hasDocValues = hasDocValues;
            this.knnMethodContext = knnMethodContext;
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public KNNVectorFieldMapper.KNNVectorFieldType getMappedFieldType() {
            return this.mappedFieldType;
        }

        @NonNull
        @Generated
        public FieldMapper.MultiFields getMultiFields() {
            return this.multiFields;
        }

        @NonNull
        @Generated
        public FieldMapper.CopyTo getCopyTo() {
            return this.copyTo;
        }

        @NonNull
        @Generated
        public Explicit<Boolean> getIgnoreMalformed() {
            return this.ignoreMalformed;
        }

        @Generated
        public boolean isStored() {
            return this.stored;
        }

        @Generated
        public boolean isHasDocValues() {
            return this.hasDocValues;
        }

        @NonNull
        @Generated
        public KNNMethodContext getKnnMethodContext() {
            return this.knnMethodContext;
        }

        @Generated
        public static class CreateLuceneFieldMapperInputBuilder {
            @Generated
            private String name;
            @Generated
            private KNNVectorFieldMapper.KNNVectorFieldType mappedFieldType;
            @Generated
            private FieldMapper.MultiFields multiFields;
            @Generated
            private FieldMapper.CopyTo copyTo;
            @Generated
            private Explicit<Boolean> ignoreMalformed;
            @Generated
            private boolean stored;
            @Generated
            private boolean hasDocValues;
            @Generated
            private KNNMethodContext knnMethodContext;

            @Generated
            CreateLuceneFieldMapperInputBuilder() {
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder mappedFieldType(@NonNull KNNVectorFieldMapper.KNNVectorFieldType mappedFieldType) {
                if (mappedFieldType == null) {
                    throw new NullPointerException("mappedFieldType is marked non-null but is null");
                }
                this.mappedFieldType = mappedFieldType;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder multiFields(@NonNull FieldMapper.MultiFields multiFields) {
                if (multiFields == null) {
                    throw new NullPointerException("multiFields is marked non-null but is null");
                }
                this.multiFields = multiFields;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder copyTo(@NonNull FieldMapper.CopyTo copyTo) {
                if (copyTo == null) {
                    throw new NullPointerException("copyTo is marked non-null but is null");
                }
                this.copyTo = copyTo;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder ignoreMalformed(@NonNull Explicit<Boolean> ignoreMalformed) {
                if (ignoreMalformed == null) {
                    throw new NullPointerException("ignoreMalformed is marked non-null but is null");
                }
                this.ignoreMalformed = ignoreMalformed;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder stored(boolean stored) {
                this.stored = stored;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder hasDocValues(boolean hasDocValues) {
                this.hasDocValues = hasDocValues;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder knnMethodContext(@NonNull KNNMethodContext knnMethodContext) {
                if (knnMethodContext == null) {
                    throw new NullPointerException("knnMethodContext is marked non-null but is null");
                }
                this.knnMethodContext = knnMethodContext;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInput build() {
                return new CreateLuceneFieldMapperInput(this.name, this.mappedFieldType, this.multiFields, this.copyTo, this.ignoreMalformed, this.stored, this.hasDocValues, this.knnMethodContext);
            }

            @Generated
            public String toString() {
                return "LuceneFieldMapper.CreateLuceneFieldMapperInput.CreateLuceneFieldMapperInputBuilder(name=" + this.name + ", mappedFieldType=" + this.mappedFieldType + ", multiFields=" + this.multiFields + ", copyTo=" + this.copyTo + ", ignoreMalformed=" + this.ignoreMalformed + ", stored=" + this.stored + ", hasDocValues=" + this.hasDocValues + ", knnMethodContext=" + this.knnMethodContext + ")";
            }
        }
    }
}

