/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.aggregation;

import java.util.List;
import java.util.Locale;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.aggregation.AggregationState;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.utils.ExpressionUtils;

public class AvgAggregator
extends Aggregator<AvgState> {
    public AvgAggregator(List<Expression> arguments, ExprCoreType returnType) {
        super(BuiltinFunctionName.AVG.getName(), arguments, returnType);
    }

    @Override
    public AvgState create() {
        return new AvgState();
    }

    @Override
    protected AvgState iterate(ExprValue value, AvgState state) {
        ++state.count;
        state.total += ExprValueUtils.getDoubleValue(value).doubleValue();
        return state;
    }

    public String toString() {
        return String.format(Locale.ROOT, "avg(%s)", ExpressionUtils.format(this.getArguments()));
    }

    protected static class AvgState
    implements AggregationState {
        private int count = 0;
        private double total = 0.0;

        AvgState() {
        }

        @Override
        public ExprValue result() {
            return this.count == 0 ? ExprNullValue.of() : ExprValueUtils.doubleValue(this.total / (double)this.count);
        }
    }
}

