# This file has been autogenerated by the pywayland scanner

# Copyright 2016 The Chromium Authors.
# Copyright 2017 Intel Corporation
# Copyright 2018 Collabora, Ltd
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from ..wayland import WlSurface
from .zwp_linux_surface_synchronization_v1 import ZwpLinuxSurfaceSynchronizationV1


class ZwpLinuxExplicitSynchronizationV1(Interface):
    """Protocol for providing explicit synchronization

    This global is a factory interface, allowing clients to request explicit
    synchronization for buffers on a per-surface basis.

    See
    :class:`~pywayland.protocol.zwp_linux_explicit_synchronization_unstable_v1.ZwpLinuxSurfaceSynchronizationV1`
    for more information.

    This interface is derived from Chromium's
    zcr_linux_explicit_synchronization_v1.

    Warning! The protocol described in this file is experimental and backward
    incompatible changes may be made. Backward compatible changes may be added
    together with the corresponding interface version bump. Backward
    incompatible changes are done by bumping the version number in the protocol
    and interface names and resetting the interface version. Once the protocol
    is to be declared stable, the 'z' prefix and the version number in the
    protocol and interface names are removed and the interface version number
    is reset.
    """

    name = "zwp_linux_explicit_synchronization_v1"
    version = 2

    class error(enum.IntEnum):
        synchronization_exists = 0


class ZwpLinuxExplicitSynchronizationV1Proxy(Proxy[ZwpLinuxExplicitSynchronizationV1]):
    interface = ZwpLinuxExplicitSynchronizationV1

    @ZwpLinuxExplicitSynchronizationV1.request()
    def destroy(self) -> None:
        """Destroy explicit synchronization factory object

        Destroy this explicit synchronization factory object. Other objects,
        including
        :class:`~pywayland.protocol.zwp_linux_explicit_synchronization_unstable_v1.ZwpLinuxSurfaceSynchronizationV1`
        objects created by this factory, shall not be affected by this request.
        """
        self._marshal(0)
        self._destroy()

    @ZwpLinuxExplicitSynchronizationV1.request(
        Argument(ArgumentType.NewId, interface=ZwpLinuxSurfaceSynchronizationV1),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_synchronization(self, surface: WlSurface) -> Proxy[ZwpLinuxSurfaceSynchronizationV1]:
        """Extend surface interface for explicit synchronization

        Instantiate an interface extension for the given
        :class:`~pywayland.protocol.wayland.WlSurface` to provide explicit
        synchronization.

        If the given :class:`~pywayland.protocol.wayland.WlSurface` already has
        an explicit synchronization object associated, the
        synchronization_exists protocol error is raised.

        Graphics APIs, like EGL or Vulkan, that manage the buffer queue and
        commits of a :class:`~pywayland.protocol.wayland.WlSurface` themselves,
        are likely to be using this extension internally. If a client is using
        such an API for a :class:`~pywayland.protocol.wayland.WlSurface`, it
        should not directly use this extension on that surface, to avoid
        raising a synchronization_exists protocol error.

        :param surface:
            the surface
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.zwp_linux_explicit_synchronization_unstable_v1.ZwpLinuxSurfaceSynchronizationV1`
            -- the new synchronization interface id
        """
        id = self._marshal_constructor(1, ZwpLinuxSurfaceSynchronizationV1, surface)
        return id


class ZwpLinuxExplicitSynchronizationV1Resource(Resource):
    interface = ZwpLinuxExplicitSynchronizationV1


class ZwpLinuxExplicitSynchronizationV1Global(Global):
    interface = ZwpLinuxExplicitSynchronizationV1


ZwpLinuxExplicitSynchronizationV1._gen_c()
ZwpLinuxExplicitSynchronizationV1.proxy_class = ZwpLinuxExplicitSynchronizationV1Proxy
ZwpLinuxExplicitSynchronizationV1.resource_class = ZwpLinuxExplicitSynchronizationV1Resource
ZwpLinuxExplicitSynchronizationV1.global_class = ZwpLinuxExplicitSynchronizationV1Global
