/* Exception types throwable
(C) 2017-2022 Niall Douglas <http://www.nedproductions.biz/> (9 commits)
File Created: Oct 2017


Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#ifndef BOOST_OUTCOME_BAD_ACCESS_HPP
#define BOOST_OUTCOME_BAD_ACCESS_HPP

#include "config.hpp"

#include <stdexcept>

BOOST_OUTCOME_V2_NAMESPACE_EXPORT_BEGIN

/*! AWAITING HUGO JSON CONVERSION TOOL 
type definition  bad_result_access. Potential doc page: `bad_result_access`
*/
class BOOST_OUTCOME_SYMBOL_VISIBLE bad_result_access : public std::logic_error
{
public:
  explicit bad_result_access(const char *what)
      : std::logic_error(what)
  {
  }
};

/*! AWAITING HUGO JSON CONVERSION TOOL 
type definition template <class S> bad_result_access_with. Potential doc page: `bad_result_access_with<EC>`
*/
template <class S> class BOOST_OUTCOME_SYMBOL_VISIBLE bad_result_access_with : public bad_result_access
{
  S _error;

public:
  explicit bad_result_access_with(S v)
      : bad_result_access("no value")
      , _error(std::move(v))
  {
  }
  /*! AWAITING HUGO JSON CONVERSION TOOL 
SIGNATURE NOT RECOGNISED
*/
  const S &error() const & { return _error; }
  /*! AWAITING HUGO JSON CONVERSION TOOL 
SIGNATURE NOT RECOGNISED
*/
  S &error() & { return _error; }
  /*! AWAITING HUGO JSON CONVERSION TOOL 
SIGNATURE NOT RECOGNISED
*/
  const S &&error() const && { return _error; }
  /*! AWAITING HUGO JSON CONVERSION TOOL 
SIGNATURE NOT RECOGNISED
*/
  S &&error() && { return _error; }
};

/*! AWAITING HUGO JSON CONVERSION TOOL 
type definition  bad_outcome_access. Potential doc page: `bad_outcome_access`
*/
class BOOST_OUTCOME_SYMBOL_VISIBLE bad_outcome_access : public std::logic_error
{
public:
  explicit bad_outcome_access(const char *what)
      : std::logic_error(what)
  {
  }
};

BOOST_OUTCOME_V2_NAMESPACE_END

#endif
