/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.event.KeyEvent;
import java.util.HashMap;
import org.GNOME.Accessibility.GNOMEKeyMapping;

public class AtkKeyEvent {
    private static HashMap<String, String> nonAlphaNumericMap = null;
    public static final int ATK_KEY_EVENT_PRESSED = 0;
    public static final int ATK_KEY_EVENT_RELEASED = 1;
    public int type;
    public boolean isShiftKeyDown = false;
    public boolean isCtrlKeyDown = false;
    public boolean isAltKeyDown = false;
    public boolean isMetaKeyDown = false;
    public boolean isAltGrKeyDown = false;
    public int keyval = 0;
    public String string;
    public int keycode;
    public int timestamp;

    public AtkKeyEvent(KeyEvent keyEvent) {
        Object object;
        switch (keyEvent.getID()) {
            case 400: 
            case 401: {
                this.type = 0;
                break;
            }
            case 402: {
                this.type = 1;
                break;
            }
            default: {
                this.type = 0;
            }
        }
        int n = keyEvent.getModifiersEx();
        if ((n & 0x40) != 0) {
            this.isShiftKeyDown = true;
        }
        if ((n & 0x80) != 0) {
            this.isCtrlKeyDown = true;
        }
        if ((n & 0x200) != 0) {
            this.isAltKeyDown = true;
        }
        if ((n & 0x100) != 0) {
            this.isMetaKeyDown = true;
        }
        if ((n & 0x2000) != 0) {
            this.isAltGrKeyDown = true;
        }
        GNOMEKeyMapping.GNOMEKeyInfo gNOMEKeyInfo = GNOMEKeyMapping.getKey(keyEvent);
        switch (keyEvent.getKeyChar()) {
            case '\uffff': {
                if (gNOMEKeyInfo != null) {
                    this.keyval = gNOMEKeyInfo.getGdkKeyCode();
                    this.string = gNOMEKeyInfo.getGdkKeyString();
                    break;
                }
                this.string = KeyEvent.getKeyText(keyEvent.getKeyCode());
                if (this.string != null) break;
                this.string = "";
                break;
            }
            default: {
                object = new char[1];
                if (gNOMEKeyInfo == null) {
                    this.keyval = keyEvent.getKeyChar();
                    object[0] = (char)this.keyval;
                    this.string = new String((char[])object);
                    break;
                }
                this.keyval = gNOMEKeyInfo.getGdkKeyCode();
                this.string = gNOMEKeyInfo.getGdkKeyString();
            }
        }
        object = keyEvent.paramString();
        int n2 = ((String)object).lastIndexOf("rawCode=") + 8;
        int n3 = ((String)object).indexOf(44, n2);
        String string = ((String)object).substring(n2, n3);
        this.keycode = Integer.valueOf(string);
        this.timestamp = (int)keyEvent.getWhen();
        String string2 = nonAlphaNumericMap.get(this.string);
        if (string2 != null) {
            this.string = string2;
        }
    }

    static {
        nonAlphaNumericMap = new HashMap(40);
        nonAlphaNumericMap.put("!", "exclam");
        nonAlphaNumericMap.put("@", "at");
        nonAlphaNumericMap.put("#", "numbersign");
        nonAlphaNumericMap.put("$", "dollar");
        nonAlphaNumericMap.put("%", "percent");
        nonAlphaNumericMap.put("^", "asciicircum");
        nonAlphaNumericMap.put("&", "ampersand");
        nonAlphaNumericMap.put("*", "asterisk");
        nonAlphaNumericMap.put("(", "parenleft");
        nonAlphaNumericMap.put(")", "parenright");
        nonAlphaNumericMap.put("-", "minus");
        nonAlphaNumericMap.put("_", "underscore");
        nonAlphaNumericMap.put("=", "equal");
        nonAlphaNumericMap.put("+", "plus");
        nonAlphaNumericMap.put("\\", "backslash");
        nonAlphaNumericMap.put("|", "bar");
        nonAlphaNumericMap.put("`", "grave");
        nonAlphaNumericMap.put("~", "asciitilde");
        nonAlphaNumericMap.put("[", "bracketleft");
        nonAlphaNumericMap.put("{", "braceleft");
        nonAlphaNumericMap.put("]", "bracketright");
        nonAlphaNumericMap.put("}", "braceright");
        nonAlphaNumericMap.put(";", "semicolon");
        nonAlphaNumericMap.put(":", "colon");
        nonAlphaNumericMap.put("'", "apostrophe");
        nonAlphaNumericMap.put("\"", "quotedbl");
        nonAlphaNumericMap.put(",", "comma");
        nonAlphaNumericMap.put("<", "less");
        nonAlphaNumericMap.put(".", "period");
        nonAlphaNumericMap.put(">", "greater");
        nonAlphaNumericMap.put("/", "slash");
        nonAlphaNumericMap.put("?", "question");
    }
}

