/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatTreeUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;

public class FlatTreeCollapsedIcon
extends FlatAbstractIcon {
    private final boolean chevron = FlatUIUtils.isChevron(UIManager.getString("Component.arrowType"));

    public FlatTreeCollapsedIcon() {
        this(UIManager.getColor("Tree.icon.collapsedColor"));
    }

    FlatTreeCollapsedIcon(Color color) {
        super(11, 11, color);
    }

    @Override
    protected void paintIcon(Component c, Graphics2D g2) {
        boolean chevron;
        this.setStyleColorFromTreeUI(c, g2);
        this.rotate(c, g2);
        String arrowType = FlatTreeCollapsedIcon.getStyleFromTreeUI(c, ui -> ui.iconArrowType);
        boolean bl = chevron = arrowType != null ? FlatUIUtils.isChevron(arrowType) : this.chevron;
        if (chevron) {
            g2.fill(FlatUIUtils.createPath(3.0, 1.0, 3.0, 2.5, 6.0, 5.5, 3.0, 8.5, 3.0, 10.0, 4.5, 10.0, 9.0, 5.5, 4.5, 1.0));
        } else {
            g2.fill(FlatUIUtils.createPath(2.0, 1.0, 2.0, 10.0, 10.0, 5.5));
        }
    }

    void setStyleColorFromTreeUI(Component c, Graphics2D g2) {
        FlatTreeCollapsedIcon.setStyleColorFromTreeUI(c, g2, ui -> ui.iconCollapsedColor);
    }

    void rotate(Component c, Graphics2D g2) {
        if (!c.getComponentOrientation().isLeftToRight()) {
            g2.rotate(Math.toRadians(180.0), (double)this.width / 2.0, (double)this.height / 2.0);
        }
    }

    static <T> T getStyleFromTreeUI(Component c, Function<FlatTreeUI, T> f) {
        TreeUI ui;
        JTree tree;
        JTree jTree = tree = c instanceof JTree ? (JTree)c : (JTree)SwingUtilities.getAncestorOfClass(JTree.class, c);
        if (tree != null && (ui = tree.getUI()) instanceof FlatTreeUI) {
            return f.apply((FlatTreeUI)ui);
        }
        return null;
    }

    static void setStyleColorFromTreeUI(Component c, Graphics2D g2, Function<FlatTreeUI, Color> f) {
        Color color = FlatTreeCollapsedIcon.getStyleFromTreeUI(c, f);
        if (color != null) {
            g2.setColor(color);
        }
    }
}

