/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEvent;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.tools.Helper;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Text;

@DefaultProperty(value="children")
public class LeaderBoardItem
extends Region
implements Comparable<LeaderBoardItem> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 30.0;
    private static final double MINIMUM_WIDTH = 25.0;
    private static final double MINIMUM_HEIGHT = 25.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 72.0;
    private static final double ASPECT_RATIO = 0.12;
    private double width;
    private double height;
    private double size;
    private double parentWidth;
    private double parentHeight;
    private Text nameText;
    private Text valueText;
    private Path triangle;
    private Line separator;
    private Pane pane;
    private ChartData chartData;
    private ObjectProperty<Color> nameColor;
    private ObjectProperty<Color> valueColor;
    private ObjectProperty<Color> separatorColor;
    private boolean shortenNumbers;
    private State state;
    private String formatString;
    private String durationFormatString;
    private DateTimeFormatter timestampFormatter;
    private Locale locale;
    private int index;
    private int lastIndex;
    private Tile.ItemSortingTopic itemSortingTopic;

    public LeaderBoardItem() {
        this("", 0.0, Instant.now(), Duration.ZERO);
    }

    public LeaderBoardItem(String NAME) {
        this(NAME, 0.0, Instant.now(), Duration.ZERO);
    }

    public LeaderBoardItem(String NAME, double VALUE) {
        this(NAME, VALUE, Instant.now(), Duration.ZERO);
    }

    public LeaderBoardItem(String NAME, Instant TIMESTAMP) {
        this(NAME, 0.0, TIMESTAMP, Duration.ZERO);
    }

    public LeaderBoardItem(String NAME, Duration DURATION) {
        this(NAME, 0.0, Instant.now(), DURATION);
    }

    public LeaderBoardItem(String NAME, double VALUE, Instant TIMESTAMP) {
        this(NAME, VALUE, TIMESTAMP, Duration.ZERO);
    }

    public LeaderBoardItem(String NAME, double VALUE, Duration DURATION) {
        this(NAME, VALUE, Instant.now(), DURATION);
    }

    public LeaderBoardItem(String NAME, double VALUE, Instant TIMESTAMP, Duration DURATION) {
        this(NAME, VALUE, TIMESTAMP, DURATION, false);
    }

    public LeaderBoardItem(String NAME, double VALUE, Instant TIMESTAMP, Duration DURATION, boolean SHORTEN_NUMBERS) {
        this.chartData = new ChartData(NAME, VALUE, null == TIMESTAMP ? Instant.now() : TIMESTAMP, null == DURATION ? Duration.ZERO : DURATION);
        this.nameColor = new ObjectPropertyBase<Color>(Tile.FOREGROUND){

            protected void invalidated() {
                LeaderBoardItem.this.nameText.setFill((Paint)this.get());
            }

            public Object getBean() {
                return LeaderBoardItem.this;
            }

            public String getName() {
                return "nameColor";
            }
        };
        this.valueColor = new ObjectPropertyBase<Color>(Tile.FOREGROUND){

            protected void invalidated() {
                LeaderBoardItem.this.valueText.setFill((Paint)this.get());
            }

            public Object getBean() {
                return LeaderBoardItem.this;
            }

            public String getName() {
                return "valueColor";
            }
        };
        this.separatorColor = new ObjectPropertyBase<Color>(Color.rgb((int)72, (int)72, (int)72)){

            protected void invalidated() {
                LeaderBoardItem.this.separator.setStroke((Paint)this.get());
            }

            public Object getBean() {
                return LeaderBoardItem.this;
            }

            public String getName() {
                return "separatorColor";
            }
        };
        this.shortenNumbers = SHORTEN_NUMBERS;
        this.itemSortingTopic = Tile.ItemSortingTopic.VALUE;
        this.formatString = "%.0f";
        this.durationFormatString = "%d:%02d:%02d";
        this.timestampFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy hh:mm:ss");
        this.locale = Locale.US;
        this.index = 1024;
        this.lastIndex = 1024;
        this.parentWidth = 250.0;
        this.parentHeight = 250.0;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 30.0);
            }
        }
        this.state = State.CONSTANT;
        this.triangle = new Path();
        this.triangle.setStroke(null);
        this.triangle.setFill((Paint)this.state.color);
        this.triangle.setRotate(this.state.angle);
        this.nameText = new Text(this.getName());
        this.nameText.setTextOrigin(VPos.TOP);
        this.valueText = new Text();
        this.valueText.setTextOrigin(VPos.TOP);
        this.updateValueText();
        this.separator = new Line();
        this.pane = new Pane(new Node[]{this.triangle, this.nameText, this.valueText, this.separator});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    protected double computeMinWidth(double HEIGHT) {
        return 25.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 25.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 72.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public String getName() {
        return this.chartData.getName();
    }

    public void setName(String NAME) {
        this.chartData.setName(NAME);
    }

    public double getValue() {
        return this.chartData.getValue();
    }

    public void setValue(double VALUE) {
        this.chartData.setValue(VALUE);
        if (null == this.getParent()) {
            return;
        }
        this.updateValueText();
    }

    public Instant getTimestamp() {
        return this.chartData.getTimestamp();
    }

    public void setTimestamp(Instant TIMESTAMP) {
        this.chartData.setTimestamp(TIMESTAMP);
    }

    public Duration getDuration() {
        return this.chartData.getDuration();
    }

    public void setDuration(Duration DURATION) {
        this.chartData.setDuration(DURATION);
    }

    public Color getNameColor() {
        return (Color)this.nameColor.get();
    }

    public void setNameColor(Color COLOR) {
        this.nameColor.set((Object)COLOR);
    }

    public ObjectProperty<Color> nameColorProperty() {
        return this.nameColor;
    }

    public Color getValueColor() {
        return (Color)this.valueColor.get();
    }

    public void setValueColor(Color COLOR) {
        this.valueColor.set((Object)COLOR);
    }

    public ObjectProperty<Color> valueColorProperty() {
        return this.valueColor;
    }

    public ChartData getChartData() {
        return this.chartData;
    }

    public void setChartData(ChartData DATA) {
        this.chartData = DATA;
        this.chartData.fireChartDataEvent(new ChartDataEvent(ChartDataEvent.EventType.UPDATE, this.chartData));
    }

    public Color getSeparatorColor() {
        return (Color)this.separatorColor.get();
    }

    public void setSeparatorColor(Color COLOR) {
        this.separatorColor.set((Object)COLOR);
    }

    public ObjectProperty<Color> separatorColorProperty() {
        return this.separatorColor;
    }

    public boolean getShortenNumbers() {
        return this.shortenNumbers;
    }

    public void setShortenNumbers(boolean SHORTEN) {
        this.shortenNumbers = this.shortenNumbers;
        this.updateValueText();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int INDEX) {
        this.lastIndex = this.index;
        this.index = INDEX;
        this.state = this.index > this.lastIndex ? State.FALL : (this.index < this.lastIndex ? State.RISE : State.CONSTANT);
        this.triangle.setFill((Paint)this.state.color);
        this.triangle.setRotate(this.state.angle);
        this.updateValueText();
        this.valueText.relocate(this.parentWidth - this.size * 0.05 - this.valueText.getLayoutBounds().getWidth(), 0.0);
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public State getState() {
        return this.state;
    }

    @Override
    public int compareTo(LeaderBoardItem ITEM) {
        switch (this.itemSortingTopic) {
            case DURATION: {
                return Long.compare(this.getDuration().toMillis(), ITEM.getDuration().toMillis());
            }
            case TIMESTAMP: {
                return Long.compare(this.getTimestamp().toEpochMilli(), ITEM.getTimestamp().toEpochMilli());
            }
        }
        return Double.compare(this.getValue(), ITEM.getValue());
    }

    public void setLocale(Locale LOCALE) {
        this.locale = LOCALE;
        this.updateValueText();
    }

    public void setItemSortingTopic(Tile.ItemSortingTopic ITEM_SORTING_TOPIC) {
        this.itemSortingTopic = ITEM_SORTING_TOPIC;
        this.updateValueText();
    }

    public void setFormatString(String FORMAT_STRING) {
        this.formatString = FORMAT_STRING;
        this.updateValueText();
    }

    public void setDurationFormatString(String DURATION_FORMAT_STRING) {
        this.durationFormatString = DURATION_FORMAT_STRING;
        this.updateValueText();
    }

    public void setTimestampFormatter(DateTimeFormatter TIMESTAMP_FORMATTER) {
        this.timestampFormatter = TIMESTAMP_FORMATTER;
        this.updateValueText();
    }

    public void setParentSize(double WIDTH, double HEIGHT) {
        this.parentWidth = WIDTH;
        this.parentHeight = HEIGHT;
        this.resize();
    }

    private void drawTriangle() {
        MoveTo moveTo = new MoveTo(0.0, 0.028 * this.size);
        LineTo lineTo1 = new LineTo(0.022 * this.size, 0.0);
        LineTo lineTo2 = new LineTo(0.044 * this.size, 0.028 * this.size);
        LineTo lineTo3 = new LineTo(0.0, 0.028 * this.size);
        ClosePath closePath = new ClosePath();
        this.triangle.getElements().setAll((Object[])new PathElement[]{moveTo, lineTo1, lineTo2, lineTo3, closePath});
    }

    private void updateValueText() {
        switch (this.itemSortingTopic) {
            case DURATION: {
                long seconds = this.chartData.getDuration().getSeconds();
                long absSeconds = Math.abs(seconds);
                this.valueText.setText(String.format(this.locale, this.durationFormatString, absSeconds / 3600L, absSeconds % 3600L / 60L, absSeconds % 60L));
                break;
            }
            case TIMESTAMP: {
                this.valueText.setText(this.timestampFormatter.format(ZonedDateTime.ofInstant(this.getTimestamp(), ZoneId.systemDefault())));
                break;
            }
            default: {
                if (this.getShortenNumbers()) {
                    this.valueText.setText(Helper.shortenNumber((long)this.getValue()));
                    break;
                }
                this.valueText.setText(String.format(this.locale, this.formatString, this.getValue()));
            }
        }
        this.valueText.relocate(this.parentWidth - this.size * 0.05 - this.valueText.getLayoutBounds().getWidth(), 0.0);
    }

    public void setOnChartDataEvent(ChartDataEventListener LISTENER) {
        this.chartData.addChartDataEventListener(LISTENER);
    }

    public void addChartDataEventListener(ChartDataEventListener LISTENER) {
        this.chartData.addChartDataEventListener(LISTENER);
    }

    public void removeChartDataEventListener(ChartDataEventListener LISTENER) {
        this.chartData.removeChartDataEventListener(LISTENER);
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.parentWidth < this.parentHeight ? this.parentWidth : this.parentHeight;
        if (0.12 * this.width > this.height) {
            this.width = 1.0 / (0.12 / this.height);
        } else if (1.0 / (0.12 / this.height) > this.width) {
            this.height = 0.12 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            double itemHeight = Helper.clamp(25.0, 72.0, this.height * 0.14);
            this.pane.setMinSize(this.parentWidth, itemHeight);
            this.pane.setMaxSize(this.parentWidth, itemHeight);
            this.pane.setPrefSize(this.parentWidth, itemHeight);
            this.drawTriangle();
            this.triangle.setLayoutX(this.size * 0.05);
            this.triangle.setLayoutY((this.height - this.triangle.getBoundsInLocal().getHeight()) * 0.25);
            double fontSize = Helper.clamp(12.0, 36.0, this.size * 0.06);
            this.nameText.setFont(Fonts.latoRegular(fontSize));
            this.nameText.setX(this.size * 0.12);
            this.nameText.setY(0.0);
            this.valueText.setFont(Fonts.latoRegular(fontSize));
            this.valueText.relocate(this.parentWidth - this.size * 0.05 - this.valueText.getLayoutBounds().getWidth(), 0.0);
            this.separator.setStartX(this.size * 0.05);
            this.separator.setStartY(fontSize * 1.5);
            this.separator.setEndX(this.parentWidth - this.size * 0.05);
            this.separator.setEndY(fontSize * 1.5);
            this.redraw();
        }
    }

    private void redraw() {
        this.nameText.setFill((Paint)this.getNameColor());
        this.valueText.setFill((Paint)this.getValueColor());
        this.triangle.setFill((Paint)this.state.color);
        this.separator.setStroke((Paint)this.getSeparatorColor());
    }

    public String toString() {
        return this.getName() + "," + this.getValue() + ",";
    }

    public static enum State {
        RISE(Tile.GREEN, 0.0),
        FALL(Tile.RED, 180.0),
        CONSTANT(Color.TRANSPARENT, 90.0);

        public final Color color;
        public final double angle;

        private State(Color COLOR, double ANGLE) {
            this.color = COLOR;
            this.angle = ANGLE;
        }
    }
}

