/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*                  This file is part of the class library                   */
/*       SoPlex --- the Sequential object-oriented simPlex.                  */
/*                                                                           */
/*  Copyright 1996-2022 Zuse Institute Berlin                                */
/*                                                                           */
/*  Licensed under the Apache License, Version 2.0 (the "License");          */
/*  you may not use this file except in compliance with the License.         */
/*  You may obtain a copy of the License at                                  */
/*                                                                           */
/*      http://www.apache.org/licenses/LICENSE-2.0                           */
/*                                                                           */
/*  Unless required by applicable law or agreed to in writing, software      */
/*  distributed under the License is distributed on an "AS IS" BASIS,        */
/*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. */
/*  See the License for the specific language governing permissions and      */
/*  limitations under the License.                                           */
/*                                                                           */
/*  You should have received a copy of the Apache-2.0 license                */
/*  along with SoPlex; see the file LICENSE. If not email to soplex@zib.de.  */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/**@file  spxsumst.h
 * @brief Simple heuristic SPxStarter.
 */
#ifndef _SPXSUMST_H_
#define _SPXSUMST_H_


#include <assert.h>

#include "soplex/spxvectorst.h"

namespace soplex
{

/**@brief   Simple heuristic SPxStarter.
   @ingroup Algo

   Testing version of an SPxVectorST using a very simplistic heuristic to
   build up an approximated solution vector.
*/
template <class R>
class SPxSumST : public SPxVectorST<R>
{
protected:

   //-------------------------------------
   /**@name Protected helpers */
   ///@{
   /// sets up variable weights.
   void setupWeights(SPxSolverBase<R>& base);
   ///@}

public:

   //-------------------------------------
   /**@name Construction / destruction */
   ///@{
   /// default constructor.
   SPxSumST()
   {
      this->m_name = "Sum";
   }
   /// copy constructor
   SPxSumST(const SPxSumST& old)
      : SPxVectorST<R>(old)
   {
      assert(this->isConsistent());
   }
   /// assignment operator
   SPxSumST& operator=(const SPxSumST& rhs)
   {
      if(this != &rhs)
      {
         SPxVectorST<R>::operator=(rhs);

         assert(this->isConsistent());
      }

      return *this;
   }
   /// destructor.
   virtual ~SPxSumST()
   {}
   /// clone function for polymorphism
   inline virtual SPxStarter<R>* clone() const
   {
      return new SPxSumST(*this);
   }
   ///@}

};

} // namespace soplex

#include "spxsumst.hpp"
#endif // _SPXSUMST_H_
