/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class LoggingProtocolSocketFactory
extends SSLSocketFactory {
    LoggingProtocolSocketFactory() {
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return new LogSocket((SSLSocket)SSLSocketFactory.getDefault().createSocket(address, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return new LogSocket((SSLSocket)SSLSocketFactory.getDefault().createSocket(address, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket(String sHost, int nPort, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return new LogSocket((SSLSocket)SSLSocketFactory.getDefault().createSocket(sHost, nPort, clientHost, clientPort));
    }

    @Override
    public Socket createSocket(String sHost, int nPort) throws IOException, UnknownHostException {
        return new LogSocket((SSLSocket)SSLSocketFactory.getDefault().createSocket(sHost, nPort));
    }

    @Override
    public Socket createSocket(Socket aSocket, String sHost, int nPort, boolean bAutoClose) throws IOException {
        return new LogSocket((SSLSocket)((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(aSocket, sHost, nPort, bAutoClose));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getSupportedCipherSuites();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof LoggingProtocolSocketFactory;
    }

    public int hashCode() {
        return LoggingProtocolSocketFactory.class.hashCode();
    }

    private static class LogSocket
    extends SSLSocket {
        private final SSLSocket m_Socket;

        public LogSocket(SSLSocket socket) {
            this.m_Socket = socket;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new LogStream(this.m_Socket.getOutputStream());
        }

        @Override
        public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
            this.m_Socket.addHandshakeCompletedListener(listener);
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return this.m_Socket.getEnabledCipherSuites();
        }

        @Override
        public String[] getEnabledProtocols() {
            return this.m_Socket.getEnabledProtocols();
        }

        @Override
        public boolean getEnableSessionCreation() {
            return this.m_Socket.getEnableSessionCreation();
        }

        @Override
        public boolean getNeedClientAuth() {
            return this.m_Socket.getNeedClientAuth();
        }

        @Override
        public SSLSession getSession() {
            return this.m_Socket.getSession();
        }

        @Override
        public SSLParameters getSSLParameters() {
            return this.m_Socket.getSSLParameters();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.m_Socket.getSupportedCipherSuites();
        }

        @Override
        public String[] getSupportedProtocols() {
            return this.m_Socket.getSupportedProtocols();
        }

        @Override
        public boolean getUseClientMode() {
            return this.m_Socket.getUseClientMode();
        }

        @Override
        public boolean getWantClientAuth() {
            return this.m_Socket.getWantClientAuth();
        }

        @Override
        public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
            this.m_Socket.removeHandshakeCompletedListener(listener);
        }

        @Override
        public void setEnabledCipherSuites(String[] suites) {
            this.m_Socket.setEnabledCipherSuites(suites);
        }

        @Override
        public void setEnabledProtocols(String[] protocols) {
            this.m_Socket.setEnabledProtocols(protocols);
        }

        @Override
        public void setEnableSessionCreation(boolean flag) {
            this.m_Socket.setEnableSessionCreation(flag);
        }

        @Override
        public void setNeedClientAuth(boolean need) {
            this.m_Socket.setNeedClientAuth(need);
        }

        @Override
        public void setSSLParameters(SSLParameters params) {
            this.m_Socket.setSSLParameters(params);
        }

        @Override
        public void setUseClientMode(boolean mode) {
            this.m_Socket.setUseClientMode(mode);
        }

        @Override
        public void setWantClientAuth(boolean want) {
            this.m_Socket.setWantClientAuth(want);
        }

        @Override
        public void startHandshake() throws IOException {
            this.m_Socket.startHandshake();
        }

        @Override
        public void bind(SocketAddress bindpoint) throws IOException {
            this.m_Socket.bind(bindpoint);
        }

        @Override
        public void close() throws IOException {
            this.m_Socket.close();
        }

        @Override
        public void connect(SocketAddress endpoint) throws IOException {
            this.m_Socket.connect(endpoint);
        }

        @Override
        public void connect(SocketAddress endpoint, int timeout) throws IOException {
            this.m_Socket.connect(endpoint, timeout);
        }

        @Override
        public SocketChannel getChannel() {
            return this.m_Socket.getChannel();
        }

        @Override
        public InetAddress getInetAddress() {
            return this.m_Socket.getInetAddress();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.m_Socket.getInputStream();
        }

        @Override
        public boolean getKeepAlive() throws SocketException {
            return this.m_Socket.getKeepAlive();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.m_Socket.getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return this.m_Socket.getLocalPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.m_Socket.getLocalSocketAddress();
        }

        @Override
        public boolean getOOBInline() throws SocketException {
            return this.m_Socket.getOOBInline();
        }

        @Override
        public int getPort() {
            return this.m_Socket.getPort();
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return this.m_Socket.getReceiveBufferSize();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.m_Socket.getRemoteSocketAddress();
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.m_Socket.getReuseAddress();
        }

        @Override
        public int getSendBufferSize() throws SocketException {
            return this.m_Socket.getSendBufferSize();
        }

        @Override
        public int getSoLinger() throws SocketException {
            return this.m_Socket.getSoLinger();
        }

        @Override
        public int getSoTimeout() throws SocketException {
            return this.m_Socket.getSoTimeout();
        }

        @Override
        public boolean getTcpNoDelay() throws SocketException {
            return this.m_Socket.getTcpNoDelay();
        }

        @Override
        public int getTrafficClass() throws SocketException {
            return this.m_Socket.getTrafficClass();
        }

        @Override
        public boolean isBound() {
            return this.m_Socket.isBound();
        }

        @Override
        public boolean isClosed() {
            return this.m_Socket.isClosed();
        }

        @Override
        public boolean isConnected() {
            return this.m_Socket.isConnected();
        }

        @Override
        public boolean isInputShutdown() {
            return this.m_Socket.isInputShutdown();
        }

        @Override
        public boolean isOutputShutdown() {
            return this.m_Socket.isOutputShutdown();
        }

        @Override
        public void sendUrgentData(int data) throws IOException {
            this.m_Socket.sendUrgentData(data);
        }

        @Override
        public void setKeepAlive(boolean on) throws SocketException {
            this.m_Socket.setKeepAlive(on);
        }

        @Override
        public void setOOBInline(boolean on) throws SocketException {
            this.m_Socket.setOOBInline(on);
        }

        @Override
        public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
            this.m_Socket.setPerformancePreferences(connectionTime, latency, bandwidth);
        }

        @Override
        public void setReceiveBufferSize(int size) throws SocketException {
            this.m_Socket.setReceiveBufferSize(size);
        }

        @Override
        public void setReuseAddress(boolean on) throws SocketException {
            this.m_Socket.setReuseAddress(on);
        }

        @Override
        public void setSendBufferSize(int size) throws SocketException {
            this.m_Socket.setSendBufferSize(size);
        }

        @Override
        public void setSoLinger(boolean on, int linger) throws SocketException {
            this.m_Socket.setSoLinger(on, linger);
        }

        @Override
        public void setSoTimeout(int timeout) throws SocketException {
            this.m_Socket.setSoTimeout(timeout);
        }

        @Override
        public void setTcpNoDelay(boolean on) throws SocketException {
            this.m_Socket.setTcpNoDelay(on);
        }

        @Override
        public void setTrafficClass(int tc) throws SocketException {
            this.m_Socket.setTrafficClass(tc);
        }

        @Override
        public void shutdownInput() throws IOException {
            this.m_Socket.shutdownInput();
        }

        @Override
        public void shutdownOutput() throws IOException {
            this.m_Socket.shutdownOutput();
        }

        @Override
        public String toString() {
            return this.m_Socket.toString();
        }

        private static class LogStream
        extends FilterOutputStream {
            public LogStream(OutputStream stream) {
                super(stream);
            }

            @Override
            public void write(byte[] buf, int offset, int len) throws IOException {
                System.err.println("LogStream.write: \"" + new String(buf, offset, len, "UTF-8") + "\"");
                this.out.write(buf, offset, len);
            }
        }
    }
}

