/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.osmand.data.LatLon;
import net.osmand.data.PointDescription;
import net.osmand.plus.api.SQLiteAPI;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;

public class SearchHistoryHelper {
    private static final int HISTORY_LIMIT = 1500;
    private OsmWindow context;
    private List<HistoryEntry> loadedEntries = new ArrayList<HistoryEntry>();
    private Map<PointDescription, HistoryEntry> mp = new HashMap<PointDescription, HistoryEntry>();
    private static SearchHistoryHelper instance = null;
    private static final int[] DEF_INTERVALS_MIN = new int[]{5, 60, 1440, 7200, 14400, 43200};
    private static Comparator<HistoryEntry> historyEntryComparator = new Comparator<HistoryEntry>(){

        @Override
        public int compare(HistoryEntry lhs, HistoryEntry rhs) {
            long time = System.currentTimeMillis();
            double l = lhs.getRank(time);
            double r = rhs.getRank(time);
            return -Double.compare(l, r);
        }
    };

    public SearchHistoryHelper(OsmWindow context) {
        this.context = context;
    }

    public static SearchHistoryHelper getInstance(OsmWindow context) {
        if (instance == null) {
            instance = new SearchHistoryHelper(context);
        }
        return instance;
    }

    public List<HistoryEntry> getHistoryEntries() {
        if (this.loadedEntries == null) {
            // empty if block
        }
        return new ArrayList<HistoryEntry>(this.loadedEntries);
    }

    private HistoryItemDBHelper checkLoadedEntries() {
        HistoryItemDBHelper helper = new HistoryItemDBHelper();
        if (this.loadedEntries == null) {
            this.loadedEntries = helper.getEntries();
            Collections.sort(this.loadedEntries, historyEntryComparator);
            for (HistoryEntry he : this.loadedEntries) {
                this.mp.put(he.getName(), he);
            }
        }
        return helper;
    }

    public void remove(HistoryEntry model) {
        HistoryItemDBHelper helper = this.checkLoadedEntries();
        if (helper.remove(model)) {
            this.loadedEntries.remove(model);
            this.mp.remove(model.getName());
        }
    }

    public void removeAll() {
        HistoryItemDBHelper helper = this.checkLoadedEntries();
        if (helper.removeAll()) {
            this.loadedEntries.clear();
            this.mp.clear();
        }
    }

    public void addNewItemToHistory(HistoryEntry model) {
        HistoryItemDBHelper helper = this.checkLoadedEntries();
        if (this.mp.containsKey(model.getName())) {
            model = this.mp.get(model.getName());
            model.markAsAccessed(System.currentTimeMillis());
            helper.update(model);
        } else {
            this.loadedEntries.add(model);
            this.mp.put(model.getName(), model);
            model.markAsAccessed(System.currentTimeMillis());
            helper.add(model);
        }
        Collections.sort(this.loadedEntries, historyEntryComparator);
        if (this.loadedEntries.size() > 1500 && helper.remove(this.loadedEntries.get(this.loadedEntries.size() - 1))) {
            this.loadedEntries.remove(this.loadedEntries.size() - 1);
        }
    }

    public void addNewItemToHistory(double latitude, double longitude, PointDescription pointDescription) {
        this.addNewItemToHistory(new HistoryEntry(latitude, longitude, pointDescription));
    }

    private class HistoryItemDBHelper {
        private static final String DB_NAME = "search_history";
        private static final int DB_VERSION = 2;
        private static final String HISTORY_TABLE_NAME = "history_recents";
        private static final String HISTORY_COL_NAME = "name";
        private static final String HISTORY_COL_TIME = "time";
        private static final String HISTORY_COL_FREQ_INTERVALS = "freq_intervals";
        private static final String HISTORY_COL_FREQ_VALUES = "freq_values";
        private static final String HISTORY_COL_LAT = "latitude";
        private static final String HISTORY_COL_LON = "longitude";
        private static final String HISTORY_TABLE_CREATE = "CREATE TABLE IF NOT EXISTS history_recents (name TEXT, time long, freq_intervals TEXT, freq_values TEXT, latitude double, longitude double);";

        private SQLiteAPI.SQLiteConnection openConnection(boolean readonly) {
            SQLiteAPI.SQLiteConnection conn = SearchHistoryHelper.this.context.getSQLiteAPI().getOrCreateDatabase(DB_NAME, readonly);
            if (conn.getVersion() == 0 || 2 != conn.getVersion()) {
                if (readonly) {
                    conn.close();
                    conn = SearchHistoryHelper.this.context.getSQLiteAPI().getOrCreateDatabase(DB_NAME, readonly);
                }
                if (conn.getVersion() == 0) {
                    this.onCreate(conn);
                } else {
                    this.onUpgrade(conn, conn.getVersion(), 2);
                }
                conn.setVersion(2);
            }
            return conn;
        }

        public void onCreate(SQLiteAPI.SQLiteConnection db) {
            db.execSQL(HISTORY_TABLE_CREATE);
        }

        public void onUpgrade(SQLiteAPI.SQLiteConnection db, int oldVersion, int newVersion) {
            if (newVersion == 2) {
                db.execSQL(HISTORY_TABLE_CREATE);
                for (HistoryEntry he : this.getLegacyEntries(db)) {
                    this.insert(he, db);
                }
            }
        }

        public boolean remove(HistoryEntry e) {
            SQLiteAPI.SQLiteConnection db = this.openConnection(false);
            if (db != null) {
                try {
                    this.removeQuery(e.getSerializedName(), db);
                }
                finally {
                    db.close();
                }
                return true;
            }
            return false;
        }

        private void removeQuery(String name, SQLiteAPI.SQLiteConnection db) {
            db.execSQL("DELETE FROM history_recents WHERE name = ?", new Object[]{name});
        }

        public boolean removeAll() {
            SQLiteAPI.SQLiteConnection db = this.openConnection(false);
            if (db != null) {
                try {
                    db.execSQL("DELETE FROM history_recents");
                }
                finally {
                    db.close();
                }
                return true;
            }
            return false;
        }

        public boolean update(HistoryEntry e) {
            SQLiteAPI.SQLiteConnection db = this.openConnection(false);
            if (db != null) {
                try {
                    db.execSQL("UPDATE history_recents SET time= ? , freq_intervals = ? , freq_values= ? WHERE name = ?", new Object[]{e.getLastAccessTime(), e.getIntervals(), e.getIntervalsValues(), e.getSerializedName()});
                }
                finally {
                    db.close();
                }
                return true;
            }
            return false;
        }

        public boolean add(HistoryEntry e) {
            SQLiteAPI.SQLiteConnection db = this.openConnection(false);
            if (db != null) {
                try {
                    this.insert(e, db);
                }
                finally {
                    db.close();
                }
                return true;
            }
            return false;
        }

        private void insert(HistoryEntry e, SQLiteAPI.SQLiteConnection db) {
            db.execSQL("INSERT INTO history_recents VALUES (?, ?, ?, ?, ?, ?)", new Object[]{e.getSerializedName(), e.getLastAccessTime(), e.getIntervals(), e.getIntervalsValues(), e.getLat(), e.getLon()});
        }

        public List<HistoryEntry> getLegacyEntries(SQLiteAPI.SQLiteConnection db) {
            ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
            if (db != null) {
                SQLiteAPI.SQLiteCursor query = db.rawQuery("SELECT name, latitude, longitude, time FROM history ORDER BY time DESC", null);
                if (query.moveToFirst()) {
                    do {
                        String name = query.getString(0);
                        String type = "marker";
                        if (name.contains(SearchHistoryHelper.this.context.getString(735))) {
                            type = "favorite";
                        } else if (name.contains(SearchHistoryHelper.this.context.getString(866))) {
                            type = "address";
                        } else if (name.contains(SearchHistoryHelper.this.context.getString(864))) {
                            type = "address";
                        } else if (name.contains(SearchHistoryHelper.this.context.getString(865))) {
                            type = "address";
                        } else if (name.contains(SearchHistoryHelper.this.context.getString(868))) {
                            type = "address";
                        } else if (name.contains(SearchHistoryHelper.this.context.getString(784))) {
                            type = "poi";
                        }
                        if (name.contains(":")) {
                            name = name.substring(name.indexOf(58) + 1);
                        }
                        HistoryEntry e = new HistoryEntry(query.getDouble(1), query.getDouble(2), new PointDescription(type, name));
                        e.markAsAccessed(query.getLong(3));
                        entries.add(e);
                    } while (query.moveToNext());
                }
                query.close();
            }
            return entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<HistoryEntry> getEntries() {
            ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
            SQLiteAPI.SQLiteConnection db = this.openConnection(true);
            if (db != null) {
                try {
                    SQLiteAPI.SQLiteCursor query = db.rawQuery("SELECT name, latitude,longitude, time, freq_intervals, freq_values FROM history_recents", null);
                    HashMap<PointDescription, HistoryEntry> st = new HashMap<PointDescription, HistoryEntry>();
                    if (query.moveToFirst()) {
                        boolean reinsert = false;
                        do {
                            String name = query.getString(0);
                            PointDescription p = PointDescription.deserializeFromString(name, new LatLon(query.getDouble(1), query.getDouble(2)));
                            HistoryEntry e = new HistoryEntry(query.getDouble(1), query.getDouble(2), p);
                            long time = query.getLong(3);
                            e.setLastAccessTime(time);
                            e.setFrequency(query.getString(4), query.getString(5));
                            if (st.containsKey(p)) {
                                reinsert = true;
                            }
                            entries.add(e);
                            st.put(p, e);
                        } while (query.moveToNext());
                        if (reinsert) {
                            System.err.println("Reinsert all values for search history");
                            db.execSQL("DELETE FROM history_recents");
                            entries.clear();
                            entries.addAll(st.values());
                            for (HistoryEntry he : entries) {
                                this.insert(he, db);
                            }
                        }
                    }
                    query.close();
                }
                finally {
                    db.close();
                }
            }
            return entries;
        }
    }

    public static class HistoryEntry {
        double lat;
        double lon;
        PointDescription name;
        private long lastAccessedTime;
        private int[] intervals = new int[0];
        private double[] intervalValues = new double[0];

        public HistoryEntry(double lat, double lon, PointDescription name) {
            this.lat = lat;
            this.lon = lon;
            this.name = name;
        }

        private double rankFunction(double cf, double timeDiff) {
            if (timeDiff <= 0.0) {
                return 0.0;
            }
            return cf / timeDiff;
        }

        public double getRank(long time) {
            double baseTimeDiff = (time - this.lastAccessedTime) / 1000L + 1L;
            double timeDiff = 0.0;
            double vl = 1.0;
            double rnk = this.rankFunction(vl, baseTimeDiff + timeDiff);
            for (int k = 0; k < this.intervals.length; ++k) {
                double ntimeDiff = this.intervals[k] * 60 * 1000;
                double nvl = this.intervalValues[k];
                if (ntimeDiff < timeDiff || nvl <= vl) continue;
                rnk += this.rankFunction(nvl - vl, baseTimeDiff + (ntimeDiff - timeDiff) / 2.0 + timeDiff);
                vl = nvl - vl;
                timeDiff = ntimeDiff;
            }
            return rnk;
        }

        public PointDescription getName() {
            return this.name;
        }

        public String getSerializedName() {
            return PointDescription.serializeToString(this.name);
        }

        public double getLat() {
            return this.lat;
        }

        public double getLon() {
            return this.lon;
        }

        public void markAsAccessed(long time) {
            int[] nintervals = new int[DEF_INTERVALS_MIN.length];
            double[] nintervalValues = new double[DEF_INTERVALS_MIN.length];
            for (int k = 0; k < nintervals.length; ++k) {
                nintervals[k] = DEF_INTERVALS_MIN[k];
                nintervalValues[k] = this.getUsageLastTime(time, 0, 0, nintervals[k]) + 1.0;
            }
            this.intervals = nintervals;
            this.intervalValues = nintervalValues;
            this.lastAccessedTime = time;
        }

        public double getUsageLastTime(long time, int days, int hours, int minutes) {
            long mins = minutes + (hours + 24 * days) * 60;
            long timeInPast = time - mins * 60L * 1000L;
            if (this.lastAccessedTime <= timeInPast) {
                return 0.0;
            }
            double res = 0.0;
            for (int k = 0; k < this.intervals.length; ++k) {
                long intPast = this.intervals[k] * 60 * 1000;
                if (intPast <= 0L) continue;
                double r = this.lastAccessedTime - timeInPast >= intPast ? this.intervalValues[k] : this.intervalValues[k] * ((double)this.lastAccessedTime - (double)timeInPast) / (double)intPast;
                res = Math.max(res, r);
            }
            return res;
        }

        public void setFrequency(String intervalsString, String values) {
            if (Algorithms.isEmpty(intervalsString) || Algorithms.isEmpty(values)) {
                this.markAsAccessed(this.lastAccessedTime);
                return;
            }
            String[] ints = intervalsString.split(",");
            String[] vsl = values.split(",");
            this.intervals = new int[ints.length];
            this.intervalValues = new double[ints.length];
            try {
                for (int i = 0; i < ints.length && i < vsl.length; ++i) {
                    this.intervals[i] = Integer.parseInt(ints[i]);
                    this.intervalValues[i] = Double.parseDouble(vsl[i]);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        public long getLastAccessTime() {
            return this.lastAccessedTime;
        }

        public String getIntervalsValues() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.intervalValues.length; ++i) {
                if (i > 0) {
                    s.append(",");
                }
                s.append(this.intervalValues[i]);
            }
            return s.toString();
        }

        public String getIntervals() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.intervals.length; ++i) {
                if (i > 0) {
                    s.append(",");
                }
                s.append(this.intervals[i]);
            }
            return s.toString();
        }

        public void setLastAccessTime(long time) {
            this.lastAccessedTime = time;
        }
    }
}

