# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Units module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_units.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Units
else:
    import _Units

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Units.delete_SwigPyIterator

    def value(self):
        return _Units.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Units.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Units.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Units.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Units.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Units.SwigPyIterator_copy(self)

    def next(self):
        return _Units.SwigPyIterator_next(self)

    def __next__(self):
        return _Units.SwigPyIterator___next__(self)

    def previous(self):
        return _Units.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Units.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Units.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Units.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Units.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Units.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Units.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Units.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Units:
_Units.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _Units.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TCollection
import OCC.Core.TColStd

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_Units_Dimensions_Create():
    return _Units.Handle_Units_Dimensions_Create()

def Handle_Units_Dimensions_DownCast(t):
    return _Units.Handle_Units_Dimensions_DownCast(t)

def Handle_Units_Dimensions_IsNull(t):
    return _Units.Handle_Units_Dimensions_IsNull(t)

def Handle_Units_Lexicon_Create():
    return _Units.Handle_Units_Lexicon_Create()

def Handle_Units_Lexicon_DownCast(t):
    return _Units.Handle_Units_Lexicon_DownCast(t)

def Handle_Units_Lexicon_IsNull(t):
    return _Units.Handle_Units_Lexicon_IsNull(t)

def Handle_Units_Quantity_Create():
    return _Units.Handle_Units_Quantity_Create()

def Handle_Units_Quantity_DownCast(t):
    return _Units.Handle_Units_Quantity_DownCast(t)

def Handle_Units_Quantity_IsNull(t):
    return _Units.Handle_Units_Quantity_IsNull(t)

def Handle_Units_Token_Create():
    return _Units.Handle_Units_Token_Create()

def Handle_Units_Token_DownCast(t):
    return _Units.Handle_Units_Token_DownCast(t)

def Handle_Units_Token_IsNull(t):
    return _Units.Handle_Units_Token_IsNull(t)

def Handle_Units_Unit_Create():
    return _Units.Handle_Units_Unit_Create()

def Handle_Units_Unit_DownCast(t):
    return _Units.Handle_Units_Unit_DownCast(t)

def Handle_Units_Unit_IsNull(t):
    return _Units.Handle_Units_Unit_IsNull(t)

def Handle_Units_UnitsDictionary_Create():
    return _Units.Handle_Units_UnitsDictionary_Create()

def Handle_Units_UnitsDictionary_DownCast(t):
    return _Units.Handle_Units_UnitsDictionary_DownCast(t)

def Handle_Units_UnitsDictionary_IsNull(t):
    return _Units.Handle_Units_UnitsDictionary_IsNull(t)

def Handle_Units_UnitsSystem_Create():
    return _Units.Handle_Units_UnitsSystem_Create()

def Handle_Units_UnitsSystem_DownCast(t):
    return _Units.Handle_Units_UnitsSystem_DownCast(t)

def Handle_Units_UnitsSystem_IsNull(t):
    return _Units.Handle_Units_UnitsSystem_IsNull(t)

def Handle_Units_ShiftedToken_Create():
    return _Units.Handle_Units_ShiftedToken_Create()

def Handle_Units_ShiftedToken_DownCast(t):
    return _Units.Handle_Units_ShiftedToken_DownCast(t)

def Handle_Units_ShiftedToken_IsNull(t):
    return _Units.Handle_Units_ShiftedToken_IsNull(t)

def Handle_Units_ShiftedUnit_Create():
    return _Units.Handle_Units_ShiftedUnit_Create()

def Handle_Units_ShiftedUnit_DownCast(t):
    return _Units.Handle_Units_ShiftedUnit_DownCast(t)

def Handle_Units_ShiftedUnit_IsNull(t):
    return _Units.Handle_Units_ShiftedUnit_IsNull(t)

def Handle_Units_UnitsLexicon_Create():
    return _Units.Handle_Units_UnitsLexicon_Create()

def Handle_Units_UnitsLexicon_DownCast(t):
    return _Units.Handle_Units_UnitsLexicon_DownCast(t)

def Handle_Units_UnitsLexicon_IsNull(t):
    return _Units.Handle_Units_UnitsLexicon_IsNull(t)

def Handle_Units_TokensSequence_Create():
    return _Units.Handle_Units_TokensSequence_Create()

def Handle_Units_TokensSequence_DownCast(t):
    return _Units.Handle_Units_TokensSequence_DownCast(t)

def Handle_Units_TokensSequence_IsNull(t):
    return _Units.Handle_Units_TokensSequence_IsNull(t)

def Handle_Units_QuantitiesSequence_Create():
    return _Units.Handle_Units_QuantitiesSequence_Create()

def Handle_Units_QuantitiesSequence_DownCast(t):
    return _Units.Handle_Units_QuantitiesSequence_DownCast(t)

def Handle_Units_QuantitiesSequence_IsNull(t):
    return _Units.Handle_Units_QuantitiesSequence_IsNull(t)

def Handle_Units_UnitsSequence_Create():
    return _Units.Handle_Units_UnitsSequence_Create()

def Handle_Units_UnitsSequence_DownCast(t):
    return _Units.Handle_Units_UnitsSequence_DownCast(t)

def Handle_Units_UnitsSequence_IsNull(t):
    return _Units.Handle_Units_UnitsSequence_IsNull(t)
class Units_QtsSequence(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Units.Units_QtsSequence_begin(self)

    def end(self):
        return _Units.Units_QtsSequence_end(self)

    def cbegin(self):
        return _Units.Units_QtsSequence_cbegin(self)

    def cend(self):
        return _Units.Units_QtsSequence_cend(self)

    def __init__(self, *args):
        _Units.Units_QtsSequence_swiginit(self, _Units.new_Units_QtsSequence(*args))

    def Size(self):
        return _Units.Units_QtsSequence_Size(self)

    def Length(self):
        return _Units.Units_QtsSequence_Length(self)

    def Lower(self):
        return _Units.Units_QtsSequence_Lower(self)

    def Upper(self):
        return _Units.Units_QtsSequence_Upper(self)

    def IsEmpty(self):
        return _Units.Units_QtsSequence_IsEmpty(self)

    def Reverse(self):
        return _Units.Units_QtsSequence_Reverse(self)

    def Exchange(self, I, J):
        return _Units.Units_QtsSequence_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _Units.Units_QtsSequence_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _Units.Units_QtsSequence_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _Units.Units_QtsSequence_Assign(self, theOther)

    def Set(self, theOther):
        return _Units.Units_QtsSequence_Set(self, theOther)

    def Remove(self, *args):
        return _Units.Units_QtsSequence_Remove(self, *args)

    def Append(self, *args):
        return _Units.Units_QtsSequence_Append(self, *args)

    def Prepend(self, *args):
        return _Units.Units_QtsSequence_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _Units.Units_QtsSequence_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _Units.Units_QtsSequence_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _Units.Units_QtsSequence_Split(self, theIndex, theSeq)

    def First(self):
        return _Units.Units_QtsSequence_First(self)

    def ChangeFirst(self):
        return _Units.Units_QtsSequence_ChangeFirst(self)

    def Last(self):
        return _Units.Units_QtsSequence_Last(self)

    def ChangeLast(self):
        return _Units.Units_QtsSequence_ChangeLast(self)

    def Value(self, theIndex):
        return _Units.Units_QtsSequence_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Units.Units_QtsSequence_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Units.Units_QtsSequence___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Units.Units_QtsSequence_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Units.delete_Units_QtsSequence

    def __len__(self):
        return self.Size()


# Register Units_QtsSequence in _Units:
_Units.Units_QtsSequence_swigregister(Units_QtsSequence)
class Units_TksSequence(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Units.Units_TksSequence_begin(self)

    def end(self):
        return _Units.Units_TksSequence_end(self)

    def cbegin(self):
        return _Units.Units_TksSequence_cbegin(self)

    def cend(self):
        return _Units.Units_TksSequence_cend(self)

    def __init__(self, *args):
        _Units.Units_TksSequence_swiginit(self, _Units.new_Units_TksSequence(*args))

    def Size(self):
        return _Units.Units_TksSequence_Size(self)

    def Length(self):
        return _Units.Units_TksSequence_Length(self)

    def Lower(self):
        return _Units.Units_TksSequence_Lower(self)

    def Upper(self):
        return _Units.Units_TksSequence_Upper(self)

    def IsEmpty(self):
        return _Units.Units_TksSequence_IsEmpty(self)

    def Reverse(self):
        return _Units.Units_TksSequence_Reverse(self)

    def Exchange(self, I, J):
        return _Units.Units_TksSequence_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _Units.Units_TksSequence_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _Units.Units_TksSequence_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _Units.Units_TksSequence_Assign(self, theOther)

    def Set(self, theOther):
        return _Units.Units_TksSequence_Set(self, theOther)

    def Remove(self, *args):
        return _Units.Units_TksSequence_Remove(self, *args)

    def Append(self, *args):
        return _Units.Units_TksSequence_Append(self, *args)

    def Prepend(self, *args):
        return _Units.Units_TksSequence_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _Units.Units_TksSequence_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _Units.Units_TksSequence_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _Units.Units_TksSequence_Split(self, theIndex, theSeq)

    def First(self):
        return _Units.Units_TksSequence_First(self)

    def ChangeFirst(self):
        return _Units.Units_TksSequence_ChangeFirst(self)

    def Last(self):
        return _Units.Units_TksSequence_Last(self)

    def ChangeLast(self):
        return _Units.Units_TksSequence_ChangeLast(self)

    def Value(self, theIndex):
        return _Units.Units_TksSequence_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Units.Units_TksSequence_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Units.Units_TksSequence___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Units.Units_TksSequence_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Units.delete_Units_TksSequence

    def __len__(self):
        return self.Size()


# Register Units_TksSequence in _Units:
_Units.Units_TksSequence_swigregister(Units_TksSequence)
class Units_UtsSequence(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Units.Units_UtsSequence_begin(self)

    def end(self):
        return _Units.Units_UtsSequence_end(self)

    def cbegin(self):
        return _Units.Units_UtsSequence_cbegin(self)

    def cend(self):
        return _Units.Units_UtsSequence_cend(self)

    def __init__(self, *args):
        _Units.Units_UtsSequence_swiginit(self, _Units.new_Units_UtsSequence(*args))

    def Size(self):
        return _Units.Units_UtsSequence_Size(self)

    def Length(self):
        return _Units.Units_UtsSequence_Length(self)

    def Lower(self):
        return _Units.Units_UtsSequence_Lower(self)

    def Upper(self):
        return _Units.Units_UtsSequence_Upper(self)

    def IsEmpty(self):
        return _Units.Units_UtsSequence_IsEmpty(self)

    def Reverse(self):
        return _Units.Units_UtsSequence_Reverse(self)

    def Exchange(self, I, J):
        return _Units.Units_UtsSequence_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _Units.Units_UtsSequence_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _Units.Units_UtsSequence_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _Units.Units_UtsSequence_Assign(self, theOther)

    def Set(self, theOther):
        return _Units.Units_UtsSequence_Set(self, theOther)

    def Remove(self, *args):
        return _Units.Units_UtsSequence_Remove(self, *args)

    def Append(self, *args):
        return _Units.Units_UtsSequence_Append(self, *args)

    def Prepend(self, *args):
        return _Units.Units_UtsSequence_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _Units.Units_UtsSequence_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _Units.Units_UtsSequence_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _Units.Units_UtsSequence_Split(self, theIndex, theSeq)

    def First(self):
        return _Units.Units_UtsSequence_First(self)

    def ChangeFirst(self):
        return _Units.Units_UtsSequence_ChangeFirst(self)

    def Last(self):
        return _Units.Units_UtsSequence_Last(self)

    def ChangeLast(self):
        return _Units.Units_UtsSequence_ChangeLast(self)

    def Value(self, theIndex):
        return _Units.Units_UtsSequence_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Units.Units_UtsSequence_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Units.Units_UtsSequence___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Units.Units_UtsSequence_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Units.delete_Units_UtsSequence

    def __len__(self):
        return self.Size()


# Register Units_UtsSequence in _Units:
_Units.Units_UtsSequence_swigregister(Units_UtsSequence)
class units(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Convert(*args):
        r"""
        Converts <avalue> expressed in <afirstunit> into the <asecondunit>.

        Parameters
        ----------
        avalue: float
        afirstunit: char *
        asecondunit: char *

        Returns
        -------
        float

        """
        return _Units.units_Convert(*args)

    @staticmethod
    def DictionaryOfUnits(*args):
        r"""
        Returns a unique instance of the dictionary of units. if <amode> is true, then it forces the recomputation of the dictionary of units.

        Parameters
        ----------
        amode: bool,optional
        	default value is Standard_False

        Returns
        -------
        opencascade::handle<Units_UnitsDictionary>

        """
        return _Units.units_DictionaryOfUnits(*args)

    @staticmethod
    def Dimensions(*args):
        r"""
        Return the dimension associated to the type.

        Parameters
        ----------
        aType: char *

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.units_Dimensions(*args)

    @staticmethod
    def FirstQuantity(*args):
        r"""
        Returns the first quantity string founded from the unit <aunit>.

        Parameters
        ----------
        aunit: char *

        Returns
        -------
        char *

        """
        return _Units.units_FirstQuantity(*args)

    @staticmethod
    def FromSI(*args):
        r"""
        No available documentation.

        Parameters
        ----------
        aData: float
        aUnit: char *

        Returns
        -------
        float
        No available documentation.

        Parameters
        ----------
        aData: float
        aUnit: char *
        aDim: Units_Dimensions

        Returns
        -------
        float

        """
        return _Units.units_FromSI(*args)

    @staticmethod
    def LexiconFile(*args):
        r"""
        Defines the location of the file containing the lexicon useful in manipulating composite units.

        Parameters
        ----------
        afile: char *

        Returns
        -------
        None

        """
        return _Units.units_LexiconFile(*args)

    @staticmethod
    def LexiconFormula(*args):
        r"""
        Return a unique instance of lexiconformula.

        Returns
        -------
        opencascade::handle<Units_Lexicon>

        """
        return _Units.units_LexiconFormula(*args)

    @staticmethod
    def LexiconUnits(*args):
        r"""
        Returns a unique instance of the units_lexicon. if <amode> is true, it forces the recomputation of the dictionary of units, and by consequence the completion of the units_lexicon.

        Parameters
        ----------
        amode: bool,optional
        	default value is Standard_True

        Returns
        -------
        opencascade::handle<Units_Lexicon>

        """
        return _Units.units_LexiconUnits(*args)

    @staticmethod
    def NullDimensions(*args):
        r"""
        Returns always the same instance of dimensions.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.units_NullDimensions(*args)

    @staticmethod
    def Quantity(*args):
        r"""
        Returns a unique quantity instance corresponding to <aquantity>.

        Parameters
        ----------
        aquantity: char *

        Returns
        -------
        opencascade::handle<Units_Quantity>

        """
        return _Units.units_Quantity(*args)

    @staticmethod
    def ToSI(*args):
        r"""
        No available documentation.

        Parameters
        ----------
        aData: float
        aUnit: char *

        Returns
        -------
        float
        No available documentation.

        Parameters
        ----------
        aData: float
        aUnit: char *
        aDim: Units_Dimensions

        Returns
        -------
        float

        """
        return _Units.units_ToSI(*args)

    @staticmethod
    def UnitsFile(*args):
        r"""
        Defines the location of the file containing all the information useful in creating the dictionary of all the units known to the system.

        Parameters
        ----------
        afile: char *

        Returns
        -------
        None

        """
        return _Units.units_UnitsFile(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _Units.units_swiginit(self, _Units.new_units())
    __swig_destroy__ = _Units.delete_units

# Register units in _Units:
_Units.units_swigregister(units)
class Units_Dimensions(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns a dimensions object which represents the dimension of a physical quantity. each of the <amass>, <alength>, <atime>, <anelectriccurrent>, <athermodynamictemperature>, <anamountofsubstance>, <aluminousintensity>, <aplaneangle>, <asolidangle> are the powers for the 7 fundamental units of physical quantity and the 2 secondary fundamental units of physical quantity.

        Parameters
        ----------
        amass: float
        alength: float
        atime: float
        anelectriccurrent: float
        athermodynamictemperature: float
        anamountofsubstance: float
        aluminousintensity: float
        aplaneangle: float
        asolidangle: float

        Returns
        -------
        None

        """
        _Units.Units_Dimensions_swiginit(self, _Units.new_Units_Dimensions(*args))

    @staticmethod
    def AAmountOfSubstance(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_AAmountOfSubstance(*args)

    @staticmethod
    def AElectricCurrent(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_AElectricCurrent(*args)

    @staticmethod
    def ALength(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_ALength(*args)

    @staticmethod
    def ALess(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_ALess(*args)

    @staticmethod
    def ALuminousIntensity(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_ALuminousIntensity(*args)

    @staticmethod
    def AMass(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_AMass(*args)

    @staticmethod
    def APlaneAngle(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_APlaneAngle(*args)

    @staticmethod
    def ASolidAngle(*args):
        r"""
        Returns the basic dimensions.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_ASolidAngle(*args)

    @staticmethod
    def AThermodynamicTemperature(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_AThermodynamicTemperature(*args)

    @staticmethod
    def ATime(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_ATime(*args)

    def AmountOfSubstance(self, *args):
        r"""
        Returns the power of quantity of material (mole) stored in the dimensions.

        Returns
        -------
        float

        """
        return _Units.Units_Dimensions_AmountOfSubstance(self, *args)

    def Divide(self, *args):
        r"""
        Creates and returns a new dimensions object which is the result of the division of <self> by <adimensions>.

        Parameters
        ----------
        adimensions: Units_Dimensions

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_Divide(self, *args)

    def Dump(self, *args):
        r"""
        Useful for degugging.

        Parameters
        ----------
        ashift: int

        Returns
        -------
        None

        """
        return _Units.Units_Dimensions_Dump(self, *args)

    def ElectricCurrent(self, *args):
        r"""
        Returns the power of electrical intensity (current) stored in the dimensions.

        Returns
        -------
        float

        """
        return _Units.Units_Dimensions_ElectricCurrent(self, *args)

    def IsEqual(self, *args):
        r"""
        Returns true if <self> and <adimensions> have the same dimensions, false otherwise.

        Parameters
        ----------
        adimensions: Units_Dimensions

        Returns
        -------
        bool

        """
        return _Units.Units_Dimensions_IsEqual(self, *args)

    def IsNotEqual(self, *args):
        r"""
        Returns false if <self> and <adimensions> have the same dimensions, true otherwise.

        Parameters
        ----------
        adimensions: Units_Dimensions

        Returns
        -------
        bool

        """
        return _Units.Units_Dimensions_IsNotEqual(self, *args)

    def Length(self, *args):
        r"""
        Returns the power of length stored in the dimensions.

        Returns
        -------
        float

        """
        return _Units.Units_Dimensions_Length(self, *args)

    def LuminousIntensity(self, *args):
        r"""
        Returns the power of light intensity stored in the dimensions.

        Returns
        -------
        float

        """
        return _Units.Units_Dimensions_LuminousIntensity(self, *args)

    def Mass(self, *args):
        r"""
        Returns the power of mass stored in the dimensions.

        Returns
        -------
        float

        """
        return _Units.Units_Dimensions_Mass(self, *args)

    def Multiply(self, *args):
        r"""
        Creates and returns a new dimensions object which is the result of the multiplication of <self> and <adimensions>.

        Parameters
        ----------
        adimensions: Units_Dimensions

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_Multiply(self, *args)

    def PlaneAngle(self, *args):
        r"""
        Returns the power of plane angle stored in the dimensions.

        Returns
        -------
        float

        """
        return _Units.Units_Dimensions_PlaneAngle(self, *args)

    def Power(self, *args):
        r"""
        Creates and returns a new dimensions object which is the result of the power of <self> and <anexponent>.

        Parameters
        ----------
        anexponent: float

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Dimensions_Power(self, *args)

    def Quantity(self, *args):
        r"""
        Returns the quantity string of the dimension.

        Returns
        -------
        char *

        """
        return _Units.Units_Dimensions_Quantity(self, *args)

    def SolidAngle(self, *args):
        r"""
        Returns the power of solid angle stored in the dimensions.

        Returns
        -------
        float

        """
        return _Units.Units_Dimensions_SolidAngle(self, *args)

    def ThermodynamicTemperature(self, *args):
        r"""
        Returns the power of temperature stored in the dimensions.

        Returns
        -------
        float

        """
        return _Units.Units_Dimensions_ThermodynamicTemperature(self, *args)

    def Time(self, *args):
        r"""
        Returns the power of time stored in the dimensions.

        Returns
        -------
        float

        """
        return _Units.Units_Dimensions_Time(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Units_Dimensions_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_Dimensions

# Register Units_Dimensions in _Units:
_Units.Units_Dimensions_swigregister(Units_Dimensions)
class Units_Explorer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor of the class.

        Returns
        -------
        None
        Creates a new instance of the class, initialized with the unitssystem <aunitssystem>.

        Parameters
        ----------
        aunitssystem: Units_UnitsSystem

        Returns
        -------
        None
        Creates a new instance of the class, initialized with the unitsdictionary <aunitsdictionary>.

        Parameters
        ----------
        aunitsdictionary: Units_UnitsDictionary

        Returns
        -------
        None
        Creates a new instance of the class, initialized with the unitssystem <aunitssystem> and positioned at the quantity <aquantity>.

        Parameters
        ----------
        aunitssystem: Units_UnitsSystem
        aquantity: char *

        Returns
        -------
        None
        Creates a new instance of the class, initialized with the unitsdictionary <aunitsdictionary> and positioned at the quantity <aquantity>.

        Parameters
        ----------
        aunitsdictionary: Units_UnitsDictionary
        aquantity: char *

        Returns
        -------
        None

        """
        _Units.Units_Explorer_swiginit(self, _Units.new_Units_Explorer(*args))

    def Init(self, *args):
        r"""
        Initializes the instance of the class with the unitssystem <aunitssystem>.

        Parameters
        ----------
        aunitssystem: Units_UnitsSystem

        Returns
        -------
        None
        Initializes the instance of the class with the unitsdictionary <aunitsdictionary>.

        Parameters
        ----------
        aunitsdictionary: Units_UnitsDictionary

        Returns
        -------
        None
        Initializes the instance of the class with the unitssystem <aunitssystem> and positioned at the quantity <aquantity>.

        Parameters
        ----------
        aunitssystem: Units_UnitsSystem
        aquantity: char *

        Returns
        -------
        None
        Initializes the instance of the class with the unitsdictionary <aunitsdictionary> and positioned at the quantity <aquantity>.

        Parameters
        ----------
        aunitsdictionary: Units_UnitsDictionary
        aquantity: char *

        Returns
        -------
        None

        """
        return _Units.Units_Explorer_Init(self, *args)

    def IsActive(self, *args):
        r"""
        If the units system to explore is a user system, returns true if the current unit is active, false otherwise. //! if the units system to explore is the units dictionary, returns true if the current unit is the s.i. unit.

        Returns
        -------
        bool

        """
        return _Units.Units_Explorer_IsActive(self, *args)

    def MoreQuantity(self, *args):
        r"""
        Returns true if there is another quantity to explore, false otherwise.

        Returns
        -------
        bool

        """
        return _Units.Units_Explorer_MoreQuantity(self, *args)

    def MoreUnit(self, *args):
        r"""
        Returns true if there is another unit to explore, false otherwise.

        Returns
        -------
        bool

        """
        return _Units.Units_Explorer_MoreUnit(self, *args)

    def NextQuantity(self, *args):
        r"""
        Sets the next quantity current.

        Returns
        -------
        None

        """
        return _Units.Units_Explorer_NextQuantity(self, *args)

    def NextUnit(self, *args):
        r"""
        Sets the next unit current.

        Returns
        -------
        None

        """
        return _Units.Units_Explorer_NextUnit(self, *args)

    def Quantity(self, *args):
        r"""
        Returns the name of the current quantity.

        Returns
        -------
        TCollection_AsciiString

        """
        return _Units.Units_Explorer_Quantity(self, *args)

    def Unit(self, *args):
        r"""
        Returns the name of the current unit.

        Returns
        -------
        TCollection_AsciiString

        """
        return _Units.Units_Explorer_Unit(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_Explorer

# Register Units_Explorer in _Units:
_Units.Units_Explorer_swigregister(Units_Explorer)
class Units_Lexicon(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty instance of lexicon.

        Returns
        -------
        None

        """
        _Units.Units_Lexicon_swiginit(self, _Units.new_Units_Lexicon(*args))

    def AddToken(self, *args):
        r"""
        Adds to the lexicon a new token with <aword>, <amean>, <avalue> as arguments. if there is already a token with the field <theword> equal to <aword>, the existing token is updated.

        Parameters
        ----------
        aword: char *
        amean: char *
        avalue: float

        Returns
        -------
        None

        """
        return _Units.Units_Lexicon_AddToken(self, *args)

    def Creates(self, *args):
        r"""
        Reads the file <afilename> to create a sequence of tokens stored in <thesequenceoftokens>.

        Returns
        -------
        None

        """
        return _Units.Units_Lexicon_Creates(self, *args)

    def Dump(self, *args):
        r"""
        Useful for debugging.

        Returns
        -------
        None

        """
        return _Units.Units_Lexicon_Dump(self, *args)

    def Sequence(self, *args):
        r"""
        Returns the first item of the sequence of tokens.

        Returns
        -------
        opencascade::handle<Units_TokensSequence>

        """
        return _Units.Units_Lexicon_Sequence(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Units_Lexicon_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_Lexicon

# Register Units_Lexicon in _Units:
_Units.Units_Lexicon_swigregister(Units_Lexicon)
class Units_Measurement(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        It is the empty constructor of the class.

        Returns
        -------
        None
        Returns an instance of this class. <avalue> defines the measurement, and <atoken> the token which defines the unit used.

        Parameters
        ----------
        avalue: float
        atoken: Units_Token

        Returns
        -------
        None
        Returns an instance of this class. <avalue> defines the measurement, and <aunit> the unit used, described in natural language.

        Parameters
        ----------
        avalue: float
        aunit: char *

        Returns
        -------
        None

        """
        _Units.Units_Measurement_swiginit(self, _Units.new_Units_Measurement(*args))

    def Add(self, *args):
        r"""
        Returns (if it is possible) a measurement which is the addition of <self> and <ameasurement>. the chosen returned unit is the unit of <self>.

        Parameters
        ----------
        ameasurement: Units_Measurement

        Returns
        -------
        Units_Measurement

        """
        return _Units.Units_Measurement_Add(self, *args)

    def Convert(self, *args):
        r"""
        Converts (if possible) the measurement object into another unit. <aunit> must have the same dimensionality as the unit contained in the token <thetoken>.

        Parameters
        ----------
        aunit: char *

        Returns
        -------
        None

        """
        return _Units.Units_Measurement_Convert(self, *args)

    def Divide(self, *args):
        r"""
        Returns a measurement which is the division of <self> by <ameasurement>.

        Parameters
        ----------
        ameasurement: Units_Measurement

        Returns
        -------
        Units_Measurement
        Returns a measurement which is the division of <self> by the constant <avalue>.

        Parameters
        ----------
        avalue: float

        Returns
        -------
        Units_Measurement

        """
        return _Units.Units_Measurement_Divide(self, *args)

    def Dump(self, *args):
        r"""
        Useful for debugging.

        Returns
        -------
        None

        """
        return _Units.Units_Measurement_Dump(self, *args)

    def Fractional(self, *args):
        r"""
        Returns a measurement object with the fractional value of the measurement contained in <self>.

        Returns
        -------
        Units_Measurement

        """
        return _Units.Units_Measurement_Fractional(self, *args)

    def HasToken(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _Units.Units_Measurement_HasToken(self, *args)

    def Integer(self, *args):
        r"""
        Returns a measurement object with the integer value of the measurement contained in <self>.

        Returns
        -------
        Units_Measurement

        """
        return _Units.Units_Measurement_Integer(self, *args)

    def Measurement(self, *args):
        r"""
        Returns the value of the measurement.

        Returns
        -------
        float

        """
        return _Units.Units_Measurement_Measurement(self, *args)

    def Multiply(self, *args):
        r"""
        Returns a measurement which is the multiplication of <self> and <ameasurement>.

        Parameters
        ----------
        ameasurement: Units_Measurement

        Returns
        -------
        Units_Measurement
        Returns a measurement which is the multiplication of <self> with the value <avalue>.

        Parameters
        ----------
        avalue: float

        Returns
        -------
        Units_Measurement

        """
        return _Units.Units_Measurement_Multiply(self, *args)

    def Power(self, *args):
        r"""
        Returns a measurement which is <self> powered <anexponent>.

        Parameters
        ----------
        anexponent: float

        Returns
        -------
        Units_Measurement

        """
        return _Units.Units_Measurement_Power(self, *args)

    def Subtract(self, *args):
        r"""
        Returns (if it is possible) a measurement which is the subtraction of <self> and <ameasurement>. the chosen returned unit is the unit of <self>.

        Parameters
        ----------
        ameasurement: Units_Measurement

        Returns
        -------
        Units_Measurement

        """
        return _Units.Units_Measurement_Subtract(self, *args)

    def Token(self, *args):
        r"""
        Returns the token contained in <self>.

        Returns
        -------
        opencascade::handle<Units_Token>

        """
        return _Units.Units_Measurement_Token(self, *args)

    def __mul__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        ameasurement: Units_Measurement

        Returns
        -------
        Units_Measurement
        No available documentation.

        Parameters
        ----------
        avalue: float

        Returns
        -------
        Units_Measurement

        """
        return _Units.Units_Measurement___mul__(self, *args)

    def __add__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        ameasurement: Units_Measurement

        Returns
        -------
        Units_Measurement

        """
        return _Units.Units_Measurement___add__(self, *args)

    def __sub__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        ameasurement: Units_Measurement

        Returns
        -------
        Units_Measurement

        """
        return _Units.Units_Measurement___sub__(self, *args)

    def __truediv__(self, *args):
        return _Units.Units_Measurement___truediv__(self, *args)
    __div__ = __truediv__



    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_Measurement

# Register Units_Measurement in _Units:
_Units.Units_Measurement_swigregister(Units_Measurement)
class Units_Quantity(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a new quantity object with <aname> which is the name of the physical quantity, <adimensions> which is the physical dimensions, and <aunitssequence> which describes all the units known for this quantity.

        Parameters
        ----------
        aname: char *
        adimensions: Units_Dimensions
        aunitssequence: Units_UnitsSequence

        Returns
        -------
        None

        """
        _Units.Units_Quantity_swiginit(self, _Units.new_Units_Quantity(*args))

    def Dimensions(self, *args):
        r"""
        Returns the physical dimensions of the quantity.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _Units.Units_Quantity_Dimensions(self, *args)

    def Dump(self, *args):
        r"""
        Useful for debugging.

        Parameters
        ----------
        ashift: int
        alevel: int

        Returns
        -------
        None

        """
        return _Units.Units_Quantity_Dump(self, *args)

    def IsEqual(self, *args):
        r"""
        Returns true if the name of the quantity <self> is equal to <astring>, false otherwise.

        Parameters
        ----------
        astring: char *

        Returns
        -------
        bool

        """
        return _Units.Units_Quantity_IsEqual(self, *args)

    def Name(self, *args):
        r"""
        Returns in a asciistring from tcollection the name of the quantity.

        Returns
        -------
        TCollection_AsciiString

        """
        return _Units.Units_Quantity_Name(self, *args)

    def Sequence(self, *args):
        r"""
        Returns <theunitssequence>, which is the sequence of all the units stored for this physical quantity.

        Returns
        -------
        opencascade::handle<Units_UnitsSequence>

        """
        return _Units.Units_Quantity_Sequence(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Units_Quantity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_Quantity

# Register Units_Quantity in _Units:
_Units.Units_Quantity_swigregister(Units_Quantity)
class Units_Sentence(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates and returns a sentence, by analyzing the string <astring> with the lexicon <alexicon>.

        Parameters
        ----------
        alexicon: Units_Lexicon
        astring: char *

        Returns
        -------
        None

        """
        _Units.Units_Sentence_swiginit(self, _Units.new_Units_Sentence(*args))

    def Dump(self, *args):
        r"""
        Useful for debugging.

        Returns
        -------
        None

        """
        return _Units.Units_Sentence_Dump(self, *args)

    def Evaluate(self, *args):
        r"""
        Computes and returns in a token the result of the expression.

        Returns
        -------
        opencascade::handle<Units_Token>

        """
        return _Units.Units_Sentence_Evaluate(self, *args)

    def IsDone(self, *args):
        r"""
        Return true if number of created tokens > 0 (i.e creation of sentence is successful).

        Returns
        -------
        bool

        """
        return _Units.Units_Sentence_IsDone(self, *args)

    def Sequence(self, *args):
        r"""
        Returns <thesequenceoftokens>.

        Returns
        -------
        opencascade::handle<Units_TokensSequence>
        Sets the field <thesequenceoftokens> to <asequenceoftokens>.

        Parameters
        ----------
        asequenceoftokens: Units_TokensSequence

        Returns
        -------
        None

        """
        return _Units.Units_Sentence_Sequence(self, *args)

    def SetConstants(self, *args):
        r"""
        For each constant encountered, sets the value.

        Returns
        -------
        None

        """
        return _Units.Units_Sentence_SetConstants(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_Sentence

# Register Units_Sentence in _Units:
_Units.Units_Sentence_swigregister(Units_Sentence)
class Units_Token(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates and returns a empty token.

        Returns
        -------
        None
        Creates and returns a token. <aword> is a string containing the available word.

        Parameters
        ----------
        aword: char *

        Returns
        -------
        None
        Creates and returns a token. <atoken> is copied in the returned token.

        Parameters
        ----------
        atoken: Units_Token

        Returns
        -------
        None
        Creates and returns a token. <aword> is a string containing the available word and <amean> gives the signification of the token.

        Parameters
        ----------
        aword: char *
        amean: char *

        Returns
        -------
        None
        Creates and returns a token. <aword> is a string containing the available word, <amean> gives the signification of the token and <avalue> is the numeric value of the dimension.

        Parameters
        ----------
        aword: char *
        amean: char *
        avalue: float

        Returns
        -------
        None
        Creates and returns a token. <aword> is a string containing the available word, <amean> gives the signification of the token, <avalue> is the numeric value of the dimension, and <adimensions> is the dimension of the given word <aword>.

        Parameters
        ----------
        aword: char *
        amean: char *
        avalue: float
        adimension: Units_Dimensions

        Returns
        -------
        None

        """
        _Units.Units_Token_swiginit(self, _Units.new_Units_Token(*args))

    def Add(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        aninteger: int

        Returns
        -------
        opencascade::handle<Units_Token>
        Returns a token which is the addition of <self> and another token <atoken>. the addition is possible if and only if the dimensions are the same.

        Parameters
        ----------
        atoken: Units_Token

        Returns
        -------
        opencascade::handle<Units_Token>

        """
        return _Units.Units_Token_Add(self, *args)

    def Creates(self, *args):
        r"""
        Creates and returns a token, which is a shiftedtoken.

        Returns
        -------
        opencascade::handle<Units_Token>

        """
        return _Units.Units_Token_Creates(self, *args)

    def Dimensions(self, *args):
        r"""
        Returns the dimensions of the token <thedimensions>.

        Returns
        -------
        opencascade::handle<Units_Dimensions>
        Sets the field <thedimensions> to <adimensions>.

        Parameters
        ----------
        adimensions: Units_Dimensions

        Returns
        -------
        None

        """
        return _Units.Units_Token_Dimensions(self, *args)

    def Divide(self, *args):
        r"""
        Returns a token which is the division of <self> by another token <atoken>.

        Parameters
        ----------
        atoken: Units_Token

        Returns
        -------
        opencascade::handle<Units_Token>

        """
        return _Units.Units_Token_Divide(self, *args)

    def Divided(self, *args):
        r"""
        This virtual method is called by the measurement methods, to compute the measurement during a conversion.

        Parameters
        ----------
        avalue: float

        Returns
        -------
        float

        """
        return _Units.Units_Token_Divided(self, *args)

    def Dump(self, *args):
        r"""
        Useful for debugging.

        Parameters
        ----------
        ashift: int
        alevel: int

        Returns
        -------
        None

        """
        return _Units.Units_Token_Dump(self, *args)

    def IsEqual(self, *args):
        r"""
        Returns true if the field <theword> and the string <astring> are the same, false otherwise.

        Parameters
        ----------
        astring: char *

        Returns
        -------
        bool
        Returns true if the field <theword> and the string <theword> contained in the token <atoken> are the same, false otherwise.

        Parameters
        ----------
        atoken: Units_Token

        Returns
        -------
        bool

        """
        return _Units.Units_Token_IsEqual(self, *args)

    def IsGreater(self, *args):
        r"""
        Returns false if the field <theword> is strictly contained at the beginning of the string <astring>, true otherwise.

        Parameters
        ----------
        astring: char *

        Returns
        -------
        bool
        Returns false if the field <theword> is strictly contained at the beginning of the string <astring>, true otherwise.

        Parameters
        ----------
        atoken: Units_Token

        Returns
        -------
        bool

        """
        return _Units.Units_Token_IsGreater(self, *args)

    def IsGreaterOrEqual(self, *args):
        r"""
        Returns true if the string <astring> is strictly contained at the beginning of the field <theword> false otherwise.

        Parameters
        ----------
        atoken: Units_Token

        Returns
        -------
        bool

        """
        return _Units.Units_Token_IsGreaterOrEqual(self, *args)

    def IsLessOrEqual(self, *args):
        r"""
        Returns true if the field <theword> is strictly contained at the beginning of the string <astring>, false otherwise.

        Parameters
        ----------
        astring: char *

        Returns
        -------
        bool

        """
        return _Units.Units_Token_IsLessOrEqual(self, *args)

    def IsNotEqual(self, *args):
        r"""
        Returns false if the field <theword> and the string <astring> are the same, true otherwise.

        Parameters
        ----------
        astring: char *

        Returns
        -------
        bool
        Returns false if the field <theword> and the string <theword> contained in the token <atoken> are the same, true otherwise.

        Parameters
        ----------
        atoken: Units_Token

        Returns
        -------
        bool

        """
        return _Units.Units_Token_IsNotEqual(self, *args)

    def Length(self, *args):
        r"""
        Returns the length of the word.

        Returns
        -------
        int

        """
        return _Units.Units_Token_Length(self, *args)

    def Mean(self, *args):
        r"""
        Returns the significance of the word <theword>, which is in the field <themean>.

        Returns
        -------
        TCollection_AsciiString
        Sets the field <themean> to <amean>.

        Parameters
        ----------
        amean: char *

        Returns
        -------
        None

        """
        return _Units.Units_Token_Mean(self, *args)

    def Multiplied(self, *args):
        r"""
        This virtual method is called by the measurement methods, to compute the measurement during a conversion.

        Parameters
        ----------
        avalue: float

        Returns
        -------
        float

        """
        return _Units.Units_Token_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""
        Returns a token which is the product of <self> and another token <atoken>.

        Parameters
        ----------
        atoken: Units_Token

        Returns
        -------
        opencascade::handle<Units_Token>

        """
        return _Units.Units_Token_Multiply(self, *args)

    def Power(self, *args):
        r"""
        Returns a token which is <self> to the power of another token <atoken>. the computation is possible only if <atoken> is a dimensionless constant.

        Parameters
        ----------
        atoken: Units_Token

        Returns
        -------
        opencascade::handle<Units_Token>
        Returns a token which is <self> to the power of <anexponent>.

        Parameters
        ----------
        anexponent: float

        Returns
        -------
        opencascade::handle<Units_Token>

        """
        return _Units.Units_Token_Power(self, *args)

    def Subtract(self, *args):
        r"""
        Returns a token which is the subtraction of <self> and another token <atoken>. the subtraction is possible if and only if the dimensions are the same.

        Parameters
        ----------
        atoken: Units_Token

        Returns
        -------
        opencascade::handle<Units_Token>

        """
        return _Units.Units_Token_Subtract(self, *args)

    def Update(self, *args):
        r"""
        Updates the token <self> with the additional signification <amean> by concatenation of the two strings <themean> and <amean>. if the two significations are the same , an information message is written in the output device.

        Parameters
        ----------
        amean: char *

        Returns
        -------
        None

        """
        return _Units.Units_Token_Update(self, *args)

    def Value(self, *args):
        r"""
        Returns the value stored in the field <thevalue>.

        Returns
        -------
        float
        Sets the field <thevalue> to <avalue>.

        Parameters
        ----------
        avalue: float

        Returns
        -------
        None

        """
        return _Units.Units_Token_Value(self, *args)

    def Word(self, *args):
        r"""
        Returns the string <theword>.

        Returns
        -------
        TCollection_AsciiString
        Sets the field <theword> to <aword>.

        Parameters
        ----------
        aword: char *

        Returns
        -------
        None

        """
        return _Units.Units_Token_Word(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Units_Token_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_Token

# Register Units_Token in _Units:
_Units.Units_Token_swigregister(Units_Token)
class Units_Unit(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates and returns a unit. <aname> is the name of the unit, <asymbol> is the usual abbreviation of the unit, and <avalue> is the value in relation to the international system of units.

        Parameters
        ----------
        aname: char *
        asymbol: char *
        avalue: float
        aquantity: Units_Quantity

        Returns
        -------
        None
        Creates and returns a unit. <aname> is the name of the unit, <asymbol> is the usual abbreviation of the unit.

        Parameters
        ----------
        aname: char *
        asymbol: char *

        Returns
        -------
        None
        Creates and returns a unit. <aname> is the name of the unit.

        Parameters
        ----------
        aname: char *

        Returns
        -------
        None

        """
        _Units.Units_Unit_swiginit(self, _Units.new_Units_Unit(*args))

    def Dump(self, *args):
        r"""
        Useful for debugging.

        Parameters
        ----------
        ashift: int
        alevel: int

        Returns
        -------
        None

        """
        return _Units.Units_Unit_Dump(self, *args)

    def IsEqual(self, *args):
        r"""
        Compares all the symbols linked within <self> with the name of <atoken>, and returns true if there is one symbol equal to the name, false otherwise.

        Parameters
        ----------
        astring: char *

        Returns
        -------
        bool

        """
        return _Units.Units_Unit_IsEqual(self, *args)

    def Name(self, *args):
        r"""
        Returns the name of the unit <thename>.

        Returns
        -------
        TCollection_AsciiString

        """
        return _Units.Units_Unit_Name(self, *args)

    def Quantity(self, *args):
        r"""
        Returns <thequantity> contained in <self>.

        Returns
        -------
        opencascade::handle<Units_Quantity>
        Sets the physical quantity <aquantity> to <self>.

        Parameters
        ----------
        aquantity: Units_Quantity

        Returns
        -------
        None

        """
        return _Units.Units_Unit_Quantity(self, *args)

    def Symbol(self, *args):
        r"""
        Adds a new symbol <asymbol> attached to <self>.

        Parameters
        ----------
        asymbol: char *

        Returns
        -------
        None

        """
        return _Units.Units_Unit_Symbol(self, *args)

    def SymbolsSequence(self, *args):
        r"""
        Returns the sequence of symbols <thesymbolssequence>.

        Returns
        -------
        opencascade::handle<TColStd_HSequenceOfHAsciiString>

        """
        return _Units.Units_Unit_SymbolsSequence(self, *args)

    def Token(self, *args):
        r"""
        Starting with <self>, returns a new token object.

        Returns
        -------
        opencascade::handle<Units_Token>

        """
        return _Units.Units_Unit_Token(self, *args)

    def Value(self, *args):
        r"""
        Returns the value in relation with the international system of units.

        Returns
        -------
        float
        Sets the value <avalue> to <self>.

        Parameters
        ----------
        avalue: float

        Returns
        -------
        None

        """
        return _Units.Units_Unit_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Units_Unit_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_Unit

# Register Units_Unit in _Units:
_Units.Units_Unit_swigregister(Units_Unit)
class Units_UnitsDictionary(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns an empty instance of unitsdictionary.

        Returns
        -------
        None

        """
        _Units.Units_UnitsDictionary_swiginit(self, _Units.new_Units_UnitsDictionary(*args))

    def ActiveUnit(self, *args):
        r"""
        Returns for <aquantity> the active unit.

        Parameters
        ----------
        aquantity: char *

        Returns
        -------
        TCollection_AsciiString

        """
        return _Units.Units_UnitsDictionary_ActiveUnit(self, *args)

    def Creates(self, *args):
        r"""
        Returns a unitsdictionary object which contains the sequence of all the units you want to consider, physical quantity by physical quantity.

        Returns
        -------
        None

        """
        return _Units.Units_UnitsDictionary_Creates(self, *args)

    def Dump(self, *args):
        r"""
        Dumps only the sequence of quantities without the units if <alevel> is equal to zero, and for each quantity all the units stored if <alevel> is equal to one.

        Parameters
        ----------
        alevel: int

        Returns
        -------
        None
        Dumps for a designated physical dimensions <adimensions> all the previously stored units.

        Parameters
        ----------
        adimensions: Units_Dimensions

        Returns
        -------
        None

        """
        return _Units.Units_UnitsDictionary_Dump(self, *args)

    def Sequence(self, *args):
        r"""
        Returns the head of the sequence of physical quantities.

        Returns
        -------
        opencascade::handle<Units_QuantitiesSequence>

        """
        return _Units.Units_UnitsDictionary_Sequence(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Units_UnitsDictionary_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_UnitsDictionary

# Register Units_UnitsDictionary in _Units:
_Units.Units_UnitsDictionary_swigregister(Units_UnitsDictionary)
class Units_UnitsSystem(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns an instance of unitssystem initialized to the s.i. units system.

        Returns
        -------
        None
        Returns an instance of unitssystem initialized to the s.i. units system upgraded by the base system units description file. attempts to find the four following files: $csf_`aname`defaults/.aname $csf_`aname`sitedefaults/.aname $csf_`aname`groupdefaults/.aname $csf_`aname`userdefaults/.aname see : resource_manager for the description of this file.

        Parameters
        ----------
        aName: char *
        Verbose: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _Units.Units_UnitsSystem_swiginit(self, _Units.new_Units_UnitsSystem(*args))

    def Activate(self, *args):
        r"""
        Specifies for <aquantity> the unit <aunit> used.

        Parameters
        ----------
        aquantity: char *
        aunit: char *

        Returns
        -------
        None

        """
        return _Units.Units_UnitsSystem_Activate(self, *args)

    def Activates(self, *args):
        r"""
        Activates the first unit of all defined system quantities.

        Returns
        -------
        None

        """
        return _Units.Units_UnitsSystem_Activates(self, *args)

    def ActiveUnit(self, *args):
        r"""
        Returns for <aquantity> the active unit.

        Parameters
        ----------
        aquantity: char *

        Returns
        -------
        TCollection_AsciiString

        """
        return _Units.Units_UnitsSystem_ActiveUnit(self, *args)

    def ActiveUnitsSequence(self, *args):
        r"""
        Returns a sequence of integer in correspondence with the sequence of quantities, which indicates, for each redefined quantity, the index into the sequence of units, of the active unit.

        Returns
        -------
        opencascade::handle<TColStd_HSequenceOfInteger>

        """
        return _Units.Units_UnitsSystem_ActiveUnitsSequence(self, *args)

    def ConvertSIValueToUserSystem(self, *args):
        r"""
        Converts the real value <avalue> from the s.i. system of units to the user system of units. <aquantity> is the physical dimensions of the measurement.

        Parameters
        ----------
        aquantity: char *
        avalue: float

        Returns
        -------
        float

        """
        return _Units.Units_UnitsSystem_ConvertSIValueToUserSystem(self, *args)

    def ConvertUserSystemValueToSI(self, *args):
        r"""
        Converts the real value <avalue> from the user system of units to the s.i. system of units. <aquantity> is the physical dimensions of the measurement.

        Parameters
        ----------
        aquantity: char *
        avalue: float

        Returns
        -------
        float

        """
        return _Units.Units_UnitsSystem_ConvertUserSystemValueToSI(self, *args)

    def ConvertValueToUserSystem(self, *args):
        r"""
        Converts a real value <avalue> from the unit <aunit> belonging to the physical dimensions <aquantity> to the corresponding unit of the user system.

        Parameters
        ----------
        aquantity: char *
        avalue: float
        aunit: char *

        Returns
        -------
        float

        """
        return _Units.Units_UnitsSystem_ConvertValueToUserSystem(self, *args)

    def Dump(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _Units.Units_UnitsSystem_Dump(self, *args)

    def IsEmpty(self, *args):
        r"""
        Returns true if no units has been defined in the system.

        Returns
        -------
        bool

        """
        return _Units.Units_UnitsSystem_IsEmpty(self, *args)

    def QuantitiesSequence(self, *args):
        r"""
        Returns the sequence of refined quantities.

        Returns
        -------
        opencascade::handle<Units_QuantitiesSequence>

        """
        return _Units.Units_UnitsSystem_QuantitiesSequence(self, *args)

    def Remove(self, *args):
        r"""
        Removes for <aquantity> the unit <aunit> used.

        Parameters
        ----------
        aquantity: char *
        aunit: char *

        Returns
        -------
        None

        """
        return _Units.Units_UnitsSystem_Remove(self, *args)

    def Specify(self, *args):
        r"""
        Specifies for <aquantity> the unit <aunit> used.

        Parameters
        ----------
        aquantity: char *
        aunit: char *

        Returns
        -------
        None

        """
        return _Units.Units_UnitsSystem_Specify(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Units_UnitsSystem_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_UnitsSystem

# Register Units_UnitsSystem in _Units:
_Units.Units_UnitsSystem_swigregister(Units_UnitsSystem)
class Units_MathSentence(Units_Sentence):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates and returns a mathsentence object. the string <astring> describes an algebraic formula in natural language.

        Parameters
        ----------
        astring: char *

        Returns
        -------
        None

        """
        _Units.Units_MathSentence_swiginit(self, _Units.new_Units_MathSentence(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_MathSentence

# Register Units_MathSentence in _Units:
_Units.Units_MathSentence_swigregister(Units_MathSentence)
class Units_ShiftedToken(Units_Token):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates and returns a shifted token. <aword> is a string containing the available word, <amean> gives the signification of the token, <avalue> is the numeric value of the dimension, <amove> is the gap, and <adimensions> is the dimension of the given word <aword>.

        Parameters
        ----------
        aword: char *
        amean: char *
        avalue: float
        amove: float
        adimensions: Units_Dimensions

        Returns
        -------
        None

        """
        _Units.Units_ShiftedToken_swiginit(self, _Units.new_Units_ShiftedToken(*args))

    def Move(self, *args):
        r"""
        Returns the gap <themove>.

        Returns
        -------
        float

        """
        return _Units.Units_ShiftedToken_Move(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Units_ShiftedToken_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_ShiftedToken

# Register Units_ShiftedToken in _Units:
_Units.Units_ShiftedToken_swigregister(Units_ShiftedToken)
class Units_ShiftedUnit(Units_Unit):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates and returns a shifted unit. <aname> is the name of the unit, <asymbol> is the usual abbreviation of the unit, <avalue> is the value in relation to the international system of units, and <amove> is the gap in relation to another unit. //! for example celsius degree of temperature is an instance of shiftedunit with <avalue> equal to 1. and <amove> equal to 273.15.

        Parameters
        ----------
        aname: char *
        asymbol: char *
        avalue: float
        amove: float
        aquantity: Units_Quantity

        Returns
        -------
        None
        Creates and returns a unit. <aname> is the name of the unit, <asymbol> is the usual abbreviation of the unit.

        Parameters
        ----------
        aname: char *
        asymbol: char *

        Returns
        -------
        None
        Creates and returns a unit. <aname> is the name of the unit.

        Parameters
        ----------
        aname: char *

        Returns
        -------
        None

        """
        _Units.Units_ShiftedUnit_swiginit(self, _Units.new_Units_ShiftedUnit(*args))

    def Move(self, *args):
        r"""
        Sets the field <themove> to <amove>.

        Parameters
        ----------
        amove: float

        Returns
        -------
        None
        Returns the shifted value <themove>.

        Returns
        -------
        float

        """
        return _Units.Units_ShiftedUnit_Move(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Units_ShiftedUnit_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_ShiftedUnit

# Register Units_ShiftedUnit in _Units:
_Units.Units_ShiftedUnit_swigregister(Units_ShiftedUnit)
class Units_UnitSentence(Units_Sentence):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates and returns a unitsentence. the string <astring> describes in natural language the unit or the composed unit to be analysed.

        Parameters
        ----------
        astring: char *

        Returns
        -------
        None
        Creates and returns a unitsentence. the string <astring> describes in natural language the unit to be analysed. the sequence of physical quantities <asequenceofquantities> describes the available dictionary of units you want to use.

        Parameters
        ----------
        astring: char *
        aquantitiessequence: Units_QuantitiesSequence

        Returns
        -------
        None

        """
        _Units.Units_UnitSentence_swiginit(self, _Units.new_Units_UnitSentence(*args))

    def Analyse(self, *args):
        r"""
        Analyzes the sequence of tokens created by the constructor to find the true significance of each token.

        Returns
        -------
        None

        """
        return _Units.Units_UnitSentence_Analyse(self, *args)

    def SetUnits(self, *args):
        r"""
        For each token which represents a unit, finds in the sequence of physical quantities all the characteristics of the unit found.

        Parameters
        ----------
        aquantitiessequence: Units_QuantitiesSequence

        Returns
        -------
        None

        """
        return _Units.Units_UnitSentence_SetUnits(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_UnitSentence

# Register Units_UnitSentence in _Units:
_Units.Units_UnitSentence_swigregister(Units_UnitSentence)
class Units_UnitsLexicon(Units_Lexicon):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns an empty instance of unitslexicon.

        Returns
        -------
        None

        """
        _Units.Units_UnitsLexicon_swiginit(self, _Units.new_Units_UnitsLexicon(*args))

    def Creates(self, *args):
        r"""
        Reads the files <afilename1> and <afilename2> to create a sequence of tokens stored in <thesequenceoftokens>.

        Parameters
        ----------
        amode: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _Units.Units_UnitsLexicon_Creates(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Units_UnitsLexicon_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Units.delete_Units_UnitsLexicon

# Register Units_UnitsLexicon in _Units:
_Units.Units_UnitsLexicon_swigregister(Units_UnitsLexicon)
class Units_TokensSequence(Units_TksSequence, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Units.Units_TokensSequence_swiginit(self, _Units.new_Units_TokensSequence(*args))

    def Sequence(self):
        return _Units.Units_TokensSequence_Sequence(self)

    def Append(self, *args):
        return _Units.Units_TokensSequence_Append(self, *args)

    def ChangeSequence(self):
        return _Units.Units_TokensSequence_ChangeSequence(self)


    @staticmethod
    def DownCast(t):
      return Handle_Units_TokensSequence_DownCast(t)

    __swig_destroy__ = _Units.delete_Units_TokensSequence

# Register Units_TokensSequence in _Units:
_Units.Units_TokensSequence_swigregister(Units_TokensSequence)
class Units_QuantitiesSequence(Units_QtsSequence, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Units.Units_QuantitiesSequence_swiginit(self, _Units.new_Units_QuantitiesSequence(*args))

    def Sequence(self):
        return _Units.Units_QuantitiesSequence_Sequence(self)

    def Append(self, *args):
        return _Units.Units_QuantitiesSequence_Append(self, *args)

    def ChangeSequence(self):
        return _Units.Units_QuantitiesSequence_ChangeSequence(self)


    @staticmethod
    def DownCast(t):
      return Handle_Units_QuantitiesSequence_DownCast(t)

    __swig_destroy__ = _Units.delete_Units_QuantitiesSequence

# Register Units_QuantitiesSequence in _Units:
_Units.Units_QuantitiesSequence_swigregister(Units_QuantitiesSequence)
class Units_UnitsSequence(Units_UtsSequence, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Units.Units_UnitsSequence_swiginit(self, _Units.new_Units_UnitsSequence(*args))

    def Sequence(self):
        return _Units.Units_UnitsSequence_Sequence(self)

    def Append(self, *args):
        return _Units.Units_UnitsSequence_Append(self, *args)

    def ChangeSequence(self):
        return _Units.Units_UnitsSequence_ChangeSequence(self)


    @staticmethod
    def DownCast(t):
      return Handle_Units_UnitsSequence_DownCast(t)

    __swig_destroy__ = _Units.delete_Units_UnitsSequence

# Register Units_UnitsSequence in _Units:
_Units.Units_UnitsSequence_swigregister(Units_UnitsSequence)



