/*******************************************************************************
 * Copyright (c) 2016 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Michael Sturm (Intel Corporation) - initial implementation.
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.launching;

import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.dsf.iss.service.IssGdbDebugServicesFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;

@ThreadSafe
public class IssGdbLaunchDelegate extends GdbLaunchDelegate {

	private IssGdbLaunch fGdbLaunch;

	public IssGdbLaunchDelegate() {
		super();
	}

	public IssGdbLaunchDelegate(boolean requireCProject) {
		super(requireCProject);
	}

	@Override
	protected IDsfDebugServicesFactory newServiceFactory(ILaunchConfiguration config, String version) {
		return new IssGdbDebugServicesFactory(version, config);
	}

	@Override
	protected GdbLaunch createGdbLaunch(ILaunchConfiguration configuration, String mode, ISourceLocator locator)
			throws CoreException {
		return new IssGdbLaunch(configuration, mode, locator);
	}

	@Override
	public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
		// Need to configure the source locator before creating the launch
		// because once the launch is created and added to launch manager,
		// the adapters will be created for the whole session, including
		// the source lookup adapter.

		fGdbLaunch = (IssGdbLaunch) createGdbLaunch(configuration, mode, null);
		fGdbLaunch.initialize();
		fGdbLaunch.setSourceLocator(getSourceLocator(configuration, fGdbLaunch.getSession()));
		return fGdbLaunch;
	}
}
