/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.CreateIndexStep;
import org.jooq.CreateIndexWhereStep;
import org.jooq.Field;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.QueryPart;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.Tools;

final class CreateIndexImpl
extends AbstractQuery
implements CreateIndexStep,
CreateIndexWhereStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_INDEX};
    private final Index index;
    private final boolean unique;
    private final boolean ifNotExists;
    private Table<?> table;
    private Field<?>[] fields;
    private SortField<?>[] sortFields;
    private Condition where;

    CreateIndexImpl(Configuration configuration, Index index, boolean unique, boolean ifNotExists) {
        super(configuration);
        this.index = index;
        this.unique = unique;
        this.ifNotExists = ifNotExists;
        this.table = index.getTable();
        this.sortFields = index.getFields().toArray(Tools.EMPTY_SORTFIELD);
        this.where = index.getWhere();
    }

    @Override
    public final CreateIndexImpl on(Table<?> t, OrderField<?> ... f) {
        this.table = t;
        this.sortFields = Tools.sortFields(f);
        return this;
    }

    @Override
    public final CreateIndexImpl on(Name tableName, Name ... fieldNames) {
        return this.on((Table)DSL.table(tableName), Tools.fieldsByName(fieldNames));
    }

    @Override
    public final CreateIndexImpl on(String tableName, String ... fieldNames) {
        return this.on((Table)DSL.table(DSL.name(tableName)), Tools.fieldsByName(fieldNames));
    }

    @Override
    public final CreateIndexImpl where(Condition ... conditions) {
        this.where = DSL.and(conditions);
        return this;
    }

    @Override
    public final CreateIndexImpl where(Collection<? extends Condition> conditions) {
        this.where = DSL.and(conditions);
        return this;
    }

    @Override
    public final CreateIndexImpl where(Field<Boolean> field) {
        return this.where(DSL.condition(field));
    }

    @Override
    public final CreateIndexImpl where(SQL sql) {
        return this.where(DSL.condition(sql));
    }

    @Override
    public final CreateIndexImpl where(String sql) {
        return this.where(DSL.condition(sql));
    }

    @Override
    public final CreateIndexImpl where(String sql, Object ... bindings) {
        return this.where(DSL.condition(sql, bindings));
    }

    @Override
    public final CreateIndexImpl where(String sql, QueryPart ... parts) {
        return this.where(DSL.condition(sql, parts));
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !Arrays.asList(SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_INDEX);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_INDEX);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_CREATE);
        if (this.unique) {
            ctx.sql(' ').visit(Keywords.K_UNIQUE);
        }
        ctx.sql(' ').visit(Keywords.K_INDEX).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.index).sql(' ').visit(Keywords.K_ON).sql(' ').visit(this.table).sql('(').qualify(false).visit(this.fields != null ? new QueryPartList((QueryPart[])this.fields) : new QueryPartList((QueryPart[])this.sortFields)).qualify(true).sql(')');
        if (this.where != null) {
            ctx.sql(' ').visit(Keywords.K_WHERE).sql(' ').qualify(false).visit(this.where).qualify(true);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

