/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.opensearch.action.admin.indices.stats.IndexShardStats;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.NodeIndicesStats;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.collectors.NodeStatsAllShardsMetricsCollector;
import org.opensearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.collectors.StatExceptionCode;
import org.opensearch.performanceanalyzer.collectors.ValueCalculator;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.util.Utils;

public class NodeStatsFixedShardsMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(NodeStatsAllShardsMetricsCollector.class)).samplingInterval;
    private static final int KEYS_PATH_LENGTH = 2;
    private static final Logger LOG = LogManager.getLogger(NodeStatsFixedShardsMetricsCollector.class);
    private HashMap<ShardId, IndexShard> currentShards;
    private Iterator<Map.Entry<ShardId, IndexShard>> currentShardsIter;
    private final PerformanceAnalyzerController controller;
    private Map<String, ValueCalculator> valueCalculators = new HashMap<String, ValueCalculator>(){
        {
            this.put(AllMetrics.ShardStatsValue.INDEXING_THROTTLE_TIME.toString(), shardStats -> shardStats.getStats().getIndexing().getTotal().getThrottleTime().millis());
            this.put(AllMetrics.ShardStatsValue.REFRESH_EVENT.toString(), shardStats -> shardStats.getStats().getRefresh().getTotal());
            this.put(AllMetrics.ShardStatsValue.REFRESH_TIME.toString(), shardStats -> shardStats.getStats().getRefresh().getTotalTimeInMillis());
            this.put(AllMetrics.ShardStatsValue.FLUSH_EVENT.toString(), shardStats -> shardStats.getStats().getFlush().getTotal());
            this.put(AllMetrics.ShardStatsValue.FLUSH_TIME.toString(), shardStats -> shardStats.getStats().getFlush().getTotalTimeInMillis());
            this.put(AllMetrics.ShardStatsValue.MERGE_EVENT.toString(), shardStats -> shardStats.getStats().getMerge().getTotal());
            this.put(AllMetrics.ShardStatsValue.MERGE_TIME.toString(), shardStats -> shardStats.getStats().getMerge().getTotalTimeInMillis());
            this.put(AllMetrics.ShardStatsValue.MERGE_CURRENT_EVENT.toString(), shardStats -> shardStats.getStats().getMerge().getCurrent());
            this.put(AllMetrics.ShardStatsValue.SEGMENTS_TOTAL.toString(), shardStats -> shardStats.getStats().getSegments().getCount());
            this.put(AllMetrics.ShardStatsValue.INDEX_WRITER_MEMORY.toString(), shardStats -> shardStats.getStats().getSegments().getIndexWriterMemoryInBytes());
            this.put(AllMetrics.ShardStatsValue.VERSION_MAP_MEMORY.toString(), shardStats -> shardStats.getStats().getSegments().getVersionMapMemoryInBytes());
            this.put(AllMetrics.ShardStatsValue.BITSET_MEMORY.toString(), shardStats -> shardStats.getStats().getSegments().getBitsetMemoryInBytes());
            this.put(AllMetrics.ShardStatsValue.INDEXING_BUFFER.toString(), shardStats -> NodeStatsFixedShardsMetricsCollector.this.getIndexBufferBytes(shardStats));
            this.put(AllMetrics.ShardStatsValue.SHARD_SIZE_IN_BYTES.toString(), shardStats -> shardStats.getStats().getStore().getSizeInBytes());
        }
    };

    public NodeStatsFixedShardsMetricsCollector(PerformanceAnalyzerController controller) {
        super(SAMPLING_TIME_INTERVAL, "NodeStatsMetrics");
        this.currentShards = new HashMap();
        this.currentShardsIter = this.currentShards.entrySet().iterator();
        this.controller = controller;
    }

    private void populateCurrentShards() {
        this.currentShards.clear();
        this.currentShards = Utils.getShards();
        this.currentShardsIter = this.currentShards.entrySet().iterator();
    }

    private long getIndexBufferBytes(ShardStats shardStats) {
        IndexShard shard = this.currentShards.get(shardStats.getShardRouting().shardId());
        if (shard == null) {
            return 0L;
        }
        return Utils.CAN_WRITE_INDEX_BUFFER_STATES.contains(shard.state()) ? shard.getWritingBytes() + shard.getIndexBufferRAMBytesUsed() : 0L;
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 2) {
            throw new RuntimeException("keys length should be 2");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"indices", keysPath[0], keysPath[1]});
    }

    public void collectMetrics(long startTime) {
        IndicesService indicesService = OpenSearchResources.INSTANCE.getIndicesService();
        if (indicesService == null) {
            return;
        }
        try {
            if (!this.currentShardsIter.hasNext()) {
                this.populateCurrentShards();
            }
            for (int i = 0; i < this.controller.getNodeStatsShardsPerCollection() && this.currentShardsIter.hasNext(); ++i) {
                IndexShard currentIndexShard = this.currentShardsIter.next().getValue();
                IndexShardStats currentIndexShardStats = Utils.indexShardStats(indicesService, currentIndexShard, new CommonStatsFlags(new CommonStatsFlags.Flag[]{CommonStatsFlags.Flag.Segments, CommonStatsFlags.Flag.Store, CommonStatsFlags.Flag.Indexing, CommonStatsFlags.Flag.Merge, CommonStatsFlags.Flag.Flush, CommonStatsFlags.Flag.Refresh, CommonStatsFlags.Flag.Recovery}));
                for (ShardStats shardStats : currentIndexShardStats.getShards()) {
                    StringBuilder value = new StringBuilder();
                    value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds());
                    value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(new NodeStatsMetricsFixedShardsPerCollectionStatus(shardStats).serialize());
                    this.saveMetricValues(value.toString(), startTime, new String[]{currentIndexShardStats.getShardId().getIndexName(), String.valueOf(currentIndexShardStats.getShardId().id())});
                }
            }
        }
        catch (Exception ex) {
            LOG.debug("Exception in Collecting NodesStats Metrics: {} for startTime {} with ExceptionCode: {}", new Supplier[]{() -> ex.toString(), () -> startTime, () -> StatExceptionCode.NODESTATS_COLLECTION_ERROR.toString()});
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat((MeasurementSet)ExceptionsAndErrors.NODESTATS_COLLECTION_ERROR, "", (Number)1);
        }
    }

    Field getNodeIndicesStatsByShardField() throws Exception {
        Field field = NodeIndicesStats.class.getDeclaredField("statsByShard");
        field.setAccessible(true);
        return field;
    }

    public class NodeStatsMetricsFixedShardsPerCollectionStatus
    extends MetricStatus {
        @JsonIgnore
        private ShardStats shardStats;
        private final long indexingThrottleTime;
        private final long refreshCount;
        private final long refreshTime;
        private final long flushCount;
        private final long flushTime;
        private final long mergeCount;
        private final long mergeTime;
        private final long mergeCurrent;
        private final long indexBufferBytes;
        private final long segmentCount;
        private final long indexWriterMemory;
        private final long versionMapMemory;
        private final long bitsetMemory;
        private final long shardSizeInBytes;

        public NodeStatsMetricsFixedShardsPerCollectionStatus(ShardStats shardStats) {
            this.shardStats = shardStats;
            this.indexingThrottleTime = this.calculate(AllMetrics.ShardStatsValue.INDEXING_THROTTLE_TIME);
            this.refreshCount = this.calculate(AllMetrics.ShardStatsValue.REFRESH_EVENT);
            this.refreshTime = this.calculate(AllMetrics.ShardStatsValue.REFRESH_TIME);
            this.flushCount = this.calculate(AllMetrics.ShardStatsValue.FLUSH_EVENT);
            this.flushTime = this.calculate(AllMetrics.ShardStatsValue.FLUSH_TIME);
            this.mergeCount = this.calculate(AllMetrics.ShardStatsValue.MERGE_EVENT);
            this.mergeTime = this.calculate(AllMetrics.ShardStatsValue.MERGE_TIME);
            this.mergeCurrent = this.calculate(AllMetrics.ShardStatsValue.MERGE_CURRENT_EVENT);
            this.indexBufferBytes = this.calculate(AllMetrics.ShardStatsValue.INDEXING_BUFFER);
            this.segmentCount = this.calculate(AllMetrics.ShardStatsValue.SEGMENTS_TOTAL);
            this.indexWriterMemory = this.calculate(AllMetrics.ShardStatsValue.INDEX_WRITER_MEMORY);
            this.versionMapMemory = this.calculate(AllMetrics.ShardStatsValue.VERSION_MAP_MEMORY);
            this.bitsetMemory = this.calculate(AllMetrics.ShardStatsValue.BITSET_MEMORY);
            this.shardSizeInBytes = this.calculate(AllMetrics.ShardStatsValue.SHARD_SIZE_IN_BYTES);
        }

        private long calculate(AllMetrics.ShardStatsValue nodeMetric) {
            return NodeStatsFixedShardsMetricsCollector.this.valueCalculators.get(nodeMetric.toString()).calculateValue(this.shardStats);
        }

        @JsonProperty(value="Indexing_ThrottleTime")
        public long getIndexingThrottleTime() {
            return this.indexingThrottleTime;
        }

        @JsonProperty(value="Refresh_Event")
        public long getRefreshCount() {
            return this.refreshCount;
        }

        @JsonProperty(value="Refresh_Time")
        public long getRefreshTime() {
            return this.refreshTime;
        }

        @JsonProperty(value="Flush_Event")
        public long getFlushCount() {
            return this.flushCount;
        }

        @JsonProperty(value="Flush_Time")
        public long getFlushTime() {
            return this.flushTime;
        }

        @JsonProperty(value="Merge_Event")
        public long getMergeCount() {
            return this.mergeCount;
        }

        @JsonProperty(value="Merge_Time")
        public long getMergeTime() {
            return this.mergeTime;
        }

        @JsonProperty(value="Merge_CurrentEvent")
        public long getMergeCurrent() {
            return this.mergeCurrent;
        }

        @JsonIgnore
        public ShardStats getShardStats() {
            return this.shardStats;
        }

        @JsonProperty(value="Indexing_Buffer")
        public long getIndexBufferBytes() {
            return this.indexBufferBytes;
        }

        @JsonProperty(value="Segments_Total")
        public long getSegmentCount() {
            return this.segmentCount;
        }

        @JsonProperty(value="IndexWriter_Memory")
        public long getIndexWriterMemory() {
            return this.indexWriterMemory;
        }

        @JsonProperty(value="VersionMap_Memory")
        public long getVersionMapMemory() {
            return this.versionMapMemory;
        }

        @JsonProperty(value="Bitset_Memory")
        public long getBitsetMemory() {
            return this.bitsetMemory;
        }

        @JsonProperty(value="Shard_Size_In_Bytes")
        public long getShardSizeInBytes() {
            return this.shardSizeInBytes;
        }
    }
}

