/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.scheduler;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.rca.framework.core.Node;
import org.opensearch.performanceanalyzer.rca.framework.core.Queryable;
import org.opensearch.performanceanalyzer.rca.messages.DataMsg;
import org.opensearch.performanceanalyzer.rca.net.WireHopper;
import org.opensearch.performanceanalyzer.rca.persistence.NetPersistor;
import org.opensearch.performanceanalyzer.rca.persistence.Persistable;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public class Tasklet {
    private static final Logger LOG = LogManager.getLogger(Tasklet.class);
    protected List<Tasklet> predecessors;
    private Node<?> node;
    private Queryable db;
    private final Persistable persistable;
    private final Map<Node<?>, List<Node<?>>> remotelyDesirableNodeSet;
    private final WireHopper hopper;
    private final NetPersistor netPersistor;
    private int ticks;
    private Consumer<FlowUnitOperationArgWrapper> exec;
    private boolean isNet = false;

    Tasklet(Node<?> predecessorNode, Queryable db, Persistable persistable, Map<Node<?>, List<Node<?>>> remotelyDesirableNodeSet, WireHopper hopper, Consumer<FlowUnitOperationArgWrapper> exec) {
        this.node = predecessorNode;
        this.persistable = persistable;
        this.remotelyDesirableNodeSet = remotelyDesirableNodeSet;
        this.hopper = hopper;
        this.netPersistor = null;
        this.predecessors = new ArrayList<Tasklet>();
        this.db = db;
        this.exec = exec;
        this.ticks = 0;
        this.isNet = false;
    }

    void resetTicks() {
        this.ticks = 0;
    }

    Tasklet addPredecessor(Tasklet tasklet) {
        this.predecessors.add(tasklet);
        return this;
    }

    public CompletableFuture<Void> execute(ExecutorService executorPool, Map<Tasklet, CompletableFuture<Void>> taskletToFutureMap) {
        ++this.ticks;
        if ((long)this.ticks % this.node.getEvaluationIntervalSeconds() != 0L) {
            this.node.setEmptyFlowUnitList();
            this.node.setEmptyLocalFlowUnit();
            return CompletableFuture.supplyAsync(() -> null);
        }
        List<CompletableFuture> predecessorResultFutures = this.predecessors.stream().map(p -> (CompletableFuture)taskletToFutureMap.get(p)).collect(Collectors.toList());
        CompletableFuture<Void> completedPredecessorTasks = CompletableFuture.allOf(predecessorResultFutures.toArray(new CompletableFuture[0]));
        CompletionStage retCompletableFuture = completedPredecessorTasks.thenAcceptAsync(a -> {
            this.exec.accept(new FlowUnitOperationArgWrapper(this.node, this.db, this.persistable, this.hopper));
            this.sendToRemote();
        }, (Executor)executorPool);
        LOG.debug("RCA: Finished creating executable future for tasklet: {}", (Object)this.node.name());
        return retCompletableFuture;
    }

    private void sendToRemote() {
        if (this.remotelyDesirableNodeSet.containsKey(this.node)) {
            LOG.debug("Publishing to subscribers: {}", (Object)this.node.name());
            DataMsg dataMsg = new DataMsg(this.node.name(), this.remotelyDesirableNodeSet.get(this.node).stream().map(Node::name).collect(Collectors.toList()), this.node.getFlowUnits());
            this.hopper.sendData(dataMsg);
        }
    }

    public String toString() {
        return "Tasklet for node: " + this.node.name() + ", with executable Func: " + this.exec;
    }

    public Node<?> getNode() {
        return this.node;
    }

    @VisibleForTesting
    public void setDb(Queryable db) {
        this.db = db;
    }
}

