/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.collectors.StatExceptionCode;
import org.opensearch.performanceanalyzer.collectors.StatsCollector;

public class MemInfoParser {
    private static final Logger LOG = LogManager.getLogger(MemInfoParser.class);
    private static final String MEM_INFO_PATH = "/proc/meminfo";
    private static final String MEM_TOTAL_PREFIX = "MemTotal:";
    private static final long KB_TO_B = 1024L;

    public static long getTotalMemory() {
        try {
            List<String> lines = Files.readAllLines(Paths.get(MEM_INFO_PATH, new String[0]));
            for (String line : lines) {
                if (!line.startsWith(MEM_TOTAL_PREFIX)) continue;
                return MemInfoParser.extractTotalMemory(line);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to read total memory", (Throwable)e);
            StatsCollector.instance().logException(StatExceptionCode.TOTAL_MEM_READ_ERROR);
        }
        return -1L;
    }

    private static long extractTotalMemory(String memLine) {
        String[] parsedLine = memLine.trim().replaceAll("\\s+", " ").split(" ");
        if (parsedLine.length != 3) {
            return -1L;
        }
        try {
            return Long.parseLong(parsedLine[1]) * 1024L;
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("Unable to parse memInfoLine: " + memLine, (Throwable)numberFormatException);
            StatsCollector.instance().logException(StatExceptionCode.TOTAL_MEM_READ_ERROR);
            return -1L;
        }
    }
}

