/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import org.jooq.BatchBindStep;
import org.opensearch.performanceanalyzer.reader.AdmissionControlSnapshot;
import org.opensearch.performanceanalyzer.reader.EventProcessor;
import org.opensearch.performanceanalyzer.reader_writer_shared.Event;
import org.opensearch.performanceanalyzer.util.JsonConverter;

public class AdmissionControlProcessor
implements EventProcessor {
    private AdmissionControlSnapshot admissionControlSnapshot;
    private BatchBindStep handle;
    private long startTime;
    private long endTime;

    private AdmissionControlProcessor(AdmissionControlSnapshot admissionControlSnapshot) {
        this.admissionControlSnapshot = admissionControlSnapshot;
    }

    static AdmissionControlProcessor build(long currentWindowStartTime, Connection connection, NavigableMap<Long, AdmissionControlSnapshot> admissionControlSnapshotNavigableMap) {
        if (admissionControlSnapshotNavigableMap.get(currentWindowStartTime) == null) {
            AdmissionControlSnapshot admissionControlSnapshot = new AdmissionControlSnapshot(connection, currentWindowStartTime);
            admissionControlSnapshotNavigableMap.put(currentWindowStartTime, admissionControlSnapshot);
            return new AdmissionControlProcessor(admissionControlSnapshot);
        }
        return new AdmissionControlProcessor((AdmissionControlSnapshot)admissionControlSnapshotNavigableMap.get(currentWindowStartTime));
    }

    @Override
    public void initializeProcessing(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.handle = this.admissionControlSnapshot.startBatchPut();
    }

    @Override
    public void finalizeProcessing() {
        if (this.handle.size() > 0) {
            this.handle.execute();
        }
    }

    @Override
    public void processEvent(Event event) {
        this.processEvent(event.value);
        if (this.handle.size() == 500) {
            this.handle.execute();
            this.handle = this.admissionControlSnapshot.startBatchPut();
        }
    }

    private void processEvent(String eventValue) {
        String[] lines = eventValue.split(System.lineSeparator());
        Arrays.stream(lines).forEach(line -> {
            Map<String, Object> map = JsonConverter.createMapFrom(line);
            String controller = (String)map.get("ControllerName");
            long rejectionCount = this.getRejectionCount(map);
            this.handle.bind(new Object[]{controller, rejectionCount});
        });
    }

    private long getRejectionCount(Map<String, Object> map) {
        Object rejectionCountObject = map.get("AdmissionControl_RejectionCount");
        return rejectionCountObject instanceof String ? Long.parseLong((String)rejectionCountObject) : ((Number)rejectionCountObject).longValue();
    }

    @Override
    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("admission_control_metrics");
    }

    @Override
    public void commitBatchIfRequired() {
        if (this.handle.size() >= 500) {
            this.handle.execute();
            this.handle = this.admissionControlSnapshot.startBatchPut();
        }
    }
}

