/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.summaries;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.rca.framework.api.persist.JooqFieldValue;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericSummary;

public class HotClusterSummary
extends GenericSummary {
    public static final String HOT_CLUSTER_SUMMARY_TABLE = HotClusterSummary.class.getSimpleName();
    private static final Logger LOG = LogManager.getLogger(HotClusterSummary.class);
    private int numOfNodes;
    private int numOfUnhealthyNodes;
    private List<HotNodeSummary> hotNodeSummaryList;

    public HotClusterSummary(int numOfNodes, int numOfUnhealthyNodes) {
        this.numOfNodes = numOfNodes;
        this.numOfUnhealthyNodes = numOfUnhealthyNodes;
        this.hotNodeSummaryList = new ArrayList<HotNodeSummary>();
    }

    public GeneratedMessageV3 buildSummaryMessage() {
        return null;
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
    }

    public int getNumOfNodes() {
        return this.numOfNodes;
    }

    public int getNumOfUnhealthyNodes() {
        return this.numOfUnhealthyNodes;
    }

    public @NonNull List<HotNodeSummary> getHotNodeSummaryList() {
        return this.hotNodeSummaryList;
    }

    public void appendNestedSummary(HotNodeSummary summary) {
        this.hotNodeSummaryList.add(summary);
    }

    public String toString() {
        return this.numOfNodes + " " + this.numOfUnhealthyNodes + " " + this.getNestedSummaryList();
    }

    @Override
    public String getTableName() {
        return HOT_CLUSTER_SUMMARY_TABLE;
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        ArrayList schema = new ArrayList();
        schema.add(ClusterSummaryField.NUM_OF_NODES_FIELD.getField());
        schema.add(ClusterSummaryField.NUM_OF_UNHEALTHY_NODES_FIELD.getField());
        return schema;
    }

    @Override
    public List<Object> getSqlValue() {
        ArrayList<Object> value = new ArrayList<Object>();
        value.add(this.numOfNodes);
        value.add(this.numOfUnhealthyNodes);
        return value;
    }

    @Override
    public JsonElement toJson() {
        JsonObject summaryObj = new JsonObject();
        summaryObj.addProperty("number_of_nodes", (Number)this.numOfNodes);
        summaryObj.addProperty("number_of_unhealthy_nodes", (Number)this.numOfUnhealthyNodes);
        if (!this.getNestedSummaryList().isEmpty()) {
            String tableName = this.getNestedSummaryList().get(0).getTableName();
            summaryObj.add(tableName, (JsonElement)this.nestedSummaryListToJson());
        }
        return summaryObj;
    }

    @Override
    public List<GenericSummary> getNestedSummaryList() {
        return new ArrayList<GenericSummary>(this.hotNodeSummaryList);
    }

    @Override
    public GenericSummary buildNestedSummary(String summaryTable, Record record) throws IllegalArgumentException {
        if (summaryTable.equals(HotNodeSummary.HOT_NODE_SUMMARY_TABLE)) {
            HotNodeSummary hotNodeSummary = HotNodeSummary.buildSummary(record);
            if (hotNodeSummary != null) {
                this.hotNodeSummaryList.add(hotNodeSummary);
            }
            return hotNodeSummary;
        }
        throw new IllegalArgumentException(summaryTable + " does not belong to the nested summaries of " + this.getTableName());
    }

    @Override
    public List<String> getNestedSummaryTables() {
        return Collections.unmodifiableList(Collections.singletonList(HotNodeSummary.HOT_NODE_SUMMARY_TABLE));
    }

    @Nullable
    public static HotClusterSummary buildSummary(Record record) {
        if (record == null) {
            return null;
        }
        HotClusterSummary summary = null;
        try {
            Integer numOfNodes = (Integer)record.get(ClusterSummaryField.NUM_OF_NODES_FIELD.getField(), Integer.class);
            Integer numOfUnhealthyNodes = (Integer)record.get(ClusterSummaryField.NUM_OF_UNHEALTHY_NODES_FIELD.getField(), Integer.class);
            if (numOfNodes == null || numOfUnhealthyNodes == null) {
                LOG.warn("read null object from SQL, numOfNodes: {}, numOfUnhealthyNodes: {}", (Object)numOfNodes, (Object)numOfUnhealthyNodes);
                return null;
            }
            summary = new HotClusterSummary(numOfNodes, numOfUnhealthyNodes);
        }
        catch (IllegalArgumentException ie) {
            LOG.error("Some fields might not be found in record, cause : {}", (Object)ie.getMessage());
        }
        catch (DataTypeException de) {
            LOG.error("Fails to convert data type");
        }
        return summary;
    }

    public static enum ClusterSummaryField implements JooqFieldValue
    {
        NUM_OF_NODES_FIELD("number_of_nodes", Integer.class),
        NUM_OF_UNHEALTHY_NODES_FIELD("number_of_unhealthy_nodes", Integer.class);

        private String name;
        private Class<?> clazz;

        private ClusterSummaryField(String name, Class<?> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public Field<?> getField() {
            return DSL.field((Name)DSL.name((String)this.name), this.clazz);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class SQL_SCHEMA_CONSTANTS {
        public static final String NUM_OF_NODES_COL_NAME = "number_of_nodes";
        public static final String NUM_OF_UNHEALTHY_NODES_COL_NAME = "number_of_unhealthy_nodes";
    }
}

