/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.opensearch.action.bulk.BulkItemRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Strings;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.transport.TransportAddress;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.ClusterInfoHolder;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.privileges.DocumentAllowList;
import org.opensearch.security.privileges.PitPrivilegesEvaluator;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.privileges.PrivilegesInterceptor;
import org.opensearch.security.privileges.ProtectedIndexAccessEvaluator;
import org.opensearch.security.privileges.SecurityIndexAccessEvaluator;
import org.opensearch.security.privileges.SnapshotRestoreEvaluator;
import org.opensearch.security.privileges.TermsAggregationEvaluator;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.ConfigModel;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.securityconf.SecurityRoles;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;

public class PrivilegesEvaluator {
    private static final WildcardMatcher ACTION_MATCHER = WildcardMatcher.from("indices:data/read/*search*");
    private static final Pattern DNFOF_PATTERNS = Pattern.compile("indices:(data/read/.*|(admin/(mappings/fields/get.*|shards/search_shards|resolve/index)))");
    private static final IndicesOptions ALLOW_EMPTY = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false);
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver resolver;
    private final AuditLog auditLog;
    private ThreadContext threadContext;
    private PrivilegesInterceptor privilegesInterceptor;
    private final boolean checkSnapshotRestoreWritePrivileges;
    private final ClusterInfoHolder clusterInfoHolder;
    private ConfigModel configModel;
    private final IndexResolverReplacer irr;
    private final SnapshotRestoreEvaluator snapshotRestoreEvaluator;
    private final SecurityIndexAccessEvaluator securityIndexAccessEvaluator;
    private final ProtectedIndexAccessEvaluator protectedIndexAccessEvaluator;
    private final TermsAggregationEvaluator termsAggregationEvaluator;
    private final PitPrivilegesEvaluator pitPrivilegesEvaluator;
    private final boolean dlsFlsEnabled;
    private final boolean dfmEmptyOverwritesAll;
    private DynamicConfigModel dcm;
    private final NamedXContentRegistry namedXContentRegistry;

    public PrivilegesEvaluator(ClusterService clusterService, ThreadPool threadPool, ConfigurationRepository configurationRepository, IndexNameExpressionResolver resolver, AuditLog auditLog, Settings settings, PrivilegesInterceptor privilegesInterceptor, ClusterInfoHolder clusterInfoHolder, IndexResolverReplacer irr, boolean dlsFlsEnabled, NamedXContentRegistry namedXContentRegistry) {
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.privilegesInterceptor = privilegesInterceptor;
        this.checkSnapshotRestoreWritePrivileges = settings.getAsBoolean("plugins.security.check_snapshot_restore_write_privileges", Boolean.valueOf(true));
        this.clusterInfoHolder = clusterInfoHolder;
        this.irr = irr;
        this.snapshotRestoreEvaluator = new SnapshotRestoreEvaluator(settings, auditLog);
        this.securityIndexAccessEvaluator = new SecurityIndexAccessEvaluator(settings, auditLog, irr);
        this.protectedIndexAccessEvaluator = new ProtectedIndexAccessEvaluator(settings, auditLog);
        this.termsAggregationEvaluator = new TermsAggregationEvaluator();
        this.pitPrivilegesEvaluator = new PitPrivilegesEvaluator();
        this.namedXContentRegistry = namedXContentRegistry;
        this.dlsFlsEnabled = dlsFlsEnabled;
        this.dfmEmptyOverwritesAll = settings.getAsBoolean("plugins.security.dfm_empty_overrides_all", Boolean.valueOf(false));
    }

    @Subscribe
    public void onConfigModelChanged(ConfigModel configModel) {
        this.configModel = configModel;
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        this.dcm = dcm;
    }

    private SecurityRoles getSecurityRoles(Set<String> roles) {
        return this.configModel.getSecurityRoles().filter(roles);
    }

    public boolean isInitialized() {
        return this.configModel != null && this.configModel.getSecurityRoles() != null && this.dcm != null;
    }

    private void setUserInfoInThreadContext(User user, Set<String> mappedRoles) {
        if (this.threadContext.getTransient("_opendistro_security_user_info") == null) {
            StringJoiner joiner = new StringJoiner("|");
            joiner.add(user.getName());
            joiner.add(String.join((CharSequence)",", user.getRoles()));
            joiner.add(String.join((CharSequence)",", (Iterable<? extends CharSequence>)Sets.union(user.getSecurityRoles(), mappedRoles)));
            String requestedTenant = user.getRequestedTenant();
            if (!Strings.isNullOrEmpty((String)requestedTenant)) {
                joiner.add(requestedTenant);
            }
            this.threadContext.putTransient("_opendistro_security_user_info", (Object)joiner.toString());
        }
    }

    public PrivilegesEvaluatorResponse evaluate(User user, String action0, ActionRequest request, Task task, Set<String> injectedRoles) {
        IndexResolverReplacer.Resolved requestedResolved;
        if (!this.isInitialized()) {
            throw new OpenSearchSecurityException("OpenSearch Security is not initialized.", new Object[0]);
        }
        if (action0.startsWith("internal:indices/admin/upgrade")) {
            action0 = "indices:admin/upgrade";
        }
        if ("indices:admin/auto_create".equals(action0)) {
            action0 = "indices:admin/create";
        }
        if ("indices:admin/mapping/auto_put".equals(action0)) {
            action0 = "indices:admin/mapping/put";
        }
        PrivilegesEvaluatorResponse presponse = new PrivilegesEvaluatorResponse();
        TransportAddress caller = (TransportAddress)this.threadContext.getTransient("_opendistro_security_remote_address");
        ImmutableSet mappedRoles = injectedRoles == null ? this.mapRoles(user, caller) : injectedRoles;
        String injectedRolesValidationString = (String)this.threadContext.getTransient("opendistro_security_injected_roles_validation");
        if (injectedRolesValidationString != null) {
            HashSet<String> injectedRolesValidationSet = new HashSet<String>(Arrays.asList(injectedRolesValidationString.split(",")));
            if (!mappedRoles.containsAll(injectedRolesValidationSet)) {
                presponse.allowed = false;
                presponse.missingSecurityRoles.addAll(injectedRolesValidationSet);
                this.log.info("Roles {} are not mapped to the user {}", injectedRolesValidationSet, (Object)user);
                return presponse;
            }
            mappedRoles = ImmutableSet.copyOf(injectedRolesValidationSet);
        }
        presponse.resolvedSecurityRoles.addAll((Collection<String>)mappedRoles);
        SecurityRoles securityRoles = this.getSecurityRoles((Set<String>)mappedRoles);
        this.setUserInfoInThreadContext(user, (Set<String>)mappedRoles);
        user.addSecurityRoles((Collection<String>)mappedRoles);
        boolean isDebugEnabled = this.log.isDebugEnabled();
        if (isDebugEnabled) {
            this.log.debug("Evaluate permissions for {} on {}", (Object)user, (Object)this.clusterService.localNode().getName());
            this.log.debug("Action: {} ({})", (Object)action0, (Object)request.getClass().getSimpleName());
            this.log.debug("Mapped roles: {}", (Object)mappedRoles.toString());
        }
        if (request instanceof BulkRequest && Strings.isNullOrEmpty((String)user.getRequestedTenant())) {
            if (!securityRoles.impliesClusterPermissionPermission(action0)) {
                presponse.missingPrivileges.add(action0);
                presponse.allowed = false;
                this.log.info("No cluster-level perm match for {} [Action [{}]] [RolesChecked {}]. No permissions for {}", (Object)user, (Object)action0, securityRoles.getRoleNames(), presponse.missingPrivileges);
            } else {
                presponse.allowed = true;
            }
            return presponse;
        }
        presponse.resolved = requestedResolved = this.irr.resolveRequest(request);
        if (isDebugEnabled) {
            this.log.debug("RequestedResolved : {}", (Object)requestedResolved);
        }
        if (this.snapshotRestoreEvaluator.evaluate(request, task, action0, this.clusterInfoHolder, presponse).isComplete()) {
            return presponse;
        }
        if (this.securityIndexAccessEvaluator.evaluate(request, task, action0, requestedResolved, presponse).isComplete()) {
            return presponse;
        }
        if (this.protectedIndexAccessEvaluator.evaluate(request, task, action0, requestedResolved, presponse, securityRoles).isComplete()) {
            return presponse;
        }
        if (this.pitPrivilegesEvaluator.evaluate(request, this.clusterService, user, securityRoles, action0, this.resolver, presponse, this.irr).isComplete()) {
            return presponse;
        }
        boolean dnfofEnabled = this.dcm.isDnfofEnabled();
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (isTraceEnabled) {
            this.log.trace("dnfof enabled? {}", (Object)dnfofEnabled);
        }
        presponse.evaluatedDlsFlsConfig = this.getSecurityRoles((Set<String>)mappedRoles).getDlsFls(user, this.dfmEmptyOverwritesAll, this.resolver, this.clusterService, this.namedXContentRegistry);
        if (PrivilegesEvaluator.isClusterPerm(action0)) {
            if (!securityRoles.impliesClusterPermissionPermission(action0)) {
                presponse.missingPrivileges.add(action0);
                presponse.allowed = false;
                this.log.info("No cluster-level perm match for {} {} [Action [{}]] [RolesChecked {}]. No permissions for {}", (Object)user, (Object)requestedResolved, (Object)action0, securityRoles.getRoleNames(), presponse.missingPrivileges);
                return presponse;
            }
            if (request instanceof RestoreSnapshotRequest && this.checkSnapshotRestoreWritePrivileges) {
                if (isDebugEnabled) {
                    this.log.debug("Normally allowed but we need to apply some extra checks for a restore request.");
                }
            } else {
                if (this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class) {
                    PrivilegesInterceptor.ReplaceResult replaceResult = this.privilegesInterceptor.replaceDashboardsIndex(request, action0, user, this.dcm, requestedResolved, this.mapTenants(user, (Set<String>)mappedRoles));
                    if (isDebugEnabled) {
                        this.log.debug("Result from privileges interceptor for cluster perm: {}", (Object)replaceResult);
                    }
                    if (!replaceResult.continueEvaluation) {
                        if (replaceResult.accessDenied) {
                            this.auditLog.logMissingPrivileges(action0, (TransportRequest)request, task);
                        } else {
                            presponse.allowed = true;
                            presponse.createIndexRequestBuilder = replaceResult.createIndexRequestBuilder;
                        }
                        return presponse;
                    }
                }
                if (dnfofEnabled && action0.startsWith("indices:data/read/") && !requestedResolved.getAllIndices().isEmpty()) {
                    if (requestedResolved.getAllIndices().isEmpty()) {
                        presponse.missingPrivileges.clear();
                        presponse.allowed = true;
                        return presponse;
                    }
                    Set<String> reduced = securityRoles.reduce(requestedResolved, user, new String[]{action0}, this.resolver, this.clusterService);
                    if (reduced.isEmpty()) {
                        presponse.allowed = false;
                        return presponse;
                    }
                    if (this.irr.replace((TransportRequest)request, true, reduced.toArray(new String[0]))) {
                        presponse.missingPrivileges.clear();
                        presponse.allowed = true;
                        return presponse;
                    }
                }
                if (isDebugEnabled) {
                    this.log.debug("Allowed because we have cluster permissions for {}", (Object)action0);
                }
                presponse.allowed = true;
                return presponse;
            }
        }
        if (this.checkDocAllowListHeader(user, action0, request)) {
            presponse.allowed = true;
            return presponse;
        }
        if (this.termsAggregationEvaluator.evaluate(requestedResolved, request, this.clusterService, user, securityRoles, this.resolver, presponse).isComplete()) {
            return presponse;
        }
        Set<String> allIndexPermsRequired = this.evaluateAdditionalIndexPermissions(request, action0);
        String[] allIndexPermsRequiredA = allIndexPermsRequired.toArray(new String[0]);
        if (isDebugEnabled) {
            this.log.debug("Requested {} from {}", allIndexPermsRequired, (Object)caller);
        }
        presponse.missingPrivileges.clear();
        presponse.missingPrivileges.addAll(allIndexPermsRequired);
        if (isDebugEnabled) {
            this.log.debug("Requested resolved index types: {}", (Object)requestedResolved);
            this.log.debug("Security roles: {}", securityRoles.getRoleNames());
        }
        if (this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class) {
            PrivilegesInterceptor.ReplaceResult replaceResult = this.privilegesInterceptor.replaceDashboardsIndex(request, action0, user, this.dcm, requestedResolved, this.mapTenants(user, (Set<String>)mappedRoles));
            if (isDebugEnabled) {
                this.log.debug("Result from privileges interceptor: {}", (Object)replaceResult);
            }
            if (!replaceResult.continueEvaluation) {
                if (replaceResult.accessDenied) {
                    this.auditLog.logMissingPrivileges(action0, (TransportRequest)request, task);
                } else {
                    presponse.allowed = true;
                    presponse.createIndexRequestBuilder = replaceResult.createIndexRequestBuilder;
                }
                return presponse;
            }
        }
        if (dnfofEnabled && DNFOF_PATTERNS.matcher(action0).matches()) {
            if (requestedResolved.getAllIndices().isEmpty()) {
                presponse.missingPrivileges.clear();
                presponse.allowed = true;
                return presponse;
            }
            Set<String> reduced = securityRoles.reduce(requestedResolved, user, allIndexPermsRequiredA, this.resolver, this.clusterService);
            if (reduced.isEmpty()) {
                if (this.dcm.isDnfofForEmptyResultsEnabled() && request instanceof IndicesRequest.Replaceable) {
                    ((IndicesRequest.Replaceable)request).indices(new String[0]);
                    presponse.missingPrivileges.clear();
                    presponse.allowed = true;
                    if (request instanceof SearchRequest) {
                        ((SearchRequest)request).indicesOptions(ALLOW_EMPTY);
                    } else if (request instanceof ClusterSearchShardsRequest) {
                        ((ClusterSearchShardsRequest)request).indicesOptions(ALLOW_EMPTY);
                    } else if (request instanceof GetFieldMappingsRequest) {
                        ((GetFieldMappingsRequest)request).indicesOptions(ALLOW_EMPTY);
                    }
                    return presponse;
                }
                presponse.allowed = false;
                return presponse;
            }
            if (this.irr.replace((TransportRequest)request, true, reduced.toArray(new String[0]))) {
                presponse.missingPrivileges.clear();
                presponse.allowed = true;
                return presponse;
            }
        }
        boolean permGiven = false;
        if (isDebugEnabled) {
            this.log.debug("Security roles: {}", securityRoles.getRoleNames());
        }
        if (!(permGiven = this.dcm.isMultiRolespanEnabled() ? securityRoles.impliesTypePermGlobal(requestedResolved, user, allIndexPermsRequiredA, this.resolver, this.clusterService) : securityRoles.get(requestedResolved, user, allIndexPermsRequiredA, this.resolver, this.clusterService))) {
            this.log.info("No {}-level perm match for {} {} [Action [{}]] [RolesChecked {}]", (Object)"index", (Object)user, (Object)requestedResolved, (Object)action0, securityRoles.getRoleNames());
            this.log.info("No permissions for {}", presponse.missingPrivileges);
        } else {
            if (this.checkFilteredAliases(requestedResolved, action0, isDebugEnabled)) {
                presponse.allowed = false;
                return presponse;
            }
            if (isDebugEnabled) {
                this.log.debug("Allowed because we have all indices permissions for {}", (Object)action0);
            }
        }
        presponse.allowed = permGiven;
        return presponse;
    }

    public Set<String> mapRoles(User user, TransportAddress caller) {
        return this.configModel.mapSecurityRoles(user, caller);
    }

    public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
        return this.configModel.mapTenants(user, roles);
    }

    public Set<String> getAllConfiguredTenantNames() {
        return this.configModel.getAllConfiguredTenantNames();
    }

    public boolean multitenancyEnabled() {
        return this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class && this.dcm.isDashboardsMultitenancyEnabled();
    }

    public boolean notFailOnForbiddenEnabled() {
        return this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class && this.dcm.isDnfofEnabled();
    }

    public String dashboardsIndex() {
        return this.dcm.getDashboardsIndexname();
    }

    public String dashboardsServerUsername() {
        return this.dcm.getDashboardsServerUsername();
    }

    public String dashboardsOpenSearchRole() {
        return this.dcm.getDashboardsOpenSearchRole();
    }

    private Set<String> evaluateAdditionalIndexPermissions(ActionRequest request, String originalAction) {
        CreateIndexRequest cir;
        BulkShardRequest bsr;
        HashSet<String> additionalPermissionsRequired = new HashSet<String>();
        if (!PrivilegesEvaluator.isClusterPerm(originalAction)) {
            additionalPermissionsRequired.add(originalAction);
        }
        if (request instanceof ClusterSearchShardsRequest) {
            additionalPermissionsRequired.add("indices:data/read/search");
        }
        if (request instanceof BulkShardRequest) {
            bsr = (BulkShardRequest)request;
            block9: for (BulkItemRequest bir : bsr.items()) {
                switch (bir.request().opType()) {
                    case CREATE: {
                        additionalPermissionsRequired.add("indices:data/write/index");
                        continue block9;
                    }
                    case INDEX: {
                        additionalPermissionsRequired.add("indices:data/write/index");
                        continue block9;
                    }
                    case DELETE: {
                        additionalPermissionsRequired.add("indices:data/write/delete");
                        continue block9;
                    }
                    case UPDATE: {
                        additionalPermissionsRequired.add("indices:data/write/update");
                    }
                }
            }
        }
        if (request instanceof IndicesAliasesRequest) {
            bsr = (IndicesAliasesRequest)request;
            for (IndicesAliasesRequest.AliasActions bir : bsr.getAliasActions()) {
                switch (bir.actionType()) {
                    case REMOVE_INDEX: {
                        additionalPermissionsRequired.add("indices:admin/delete");
                        break;
                    }
                }
            }
        }
        if (request instanceof CreateIndexRequest && (cir = (CreateIndexRequest)request).aliases() != null && !cir.aliases().isEmpty()) {
            additionalPermissionsRequired.add("indices:admin/aliases");
        }
        if (request instanceof RestoreSnapshotRequest && this.checkSnapshotRestoreWritePrivileges) {
            additionalPermissionsRequired.addAll(ConfigConstants.SECURITY_SNAPSHOT_RESTORE_NEEDED_WRITE_PRIVILEGES);
        }
        if (additionalPermissionsRequired.size() > 1) {
            OpenSearchSecurityPlugin.traceAction("Additional permissions required: {}", additionalPermissionsRequired);
        }
        if (this.log.isDebugEnabled() && additionalPermissionsRequired.size() > 1) {
            this.log.debug("Additional permissions required: {}", additionalPermissionsRequired);
        }
        return Collections.unmodifiableSet(additionalPermissionsRequired);
    }

    public static boolean isClusterPerm(String action0) {
        return action0.startsWith("cluster:") || action0.startsWith("indices:admin/template/") || action0.startsWith("indices:admin/index_template/") || action0.startsWith("indices:data/read/scroll") || action0.equals("indices:data/write/bulk") || action0.equals("indices:data/read/mget") || action0.equals("indices:data/read/msearch") || action0.equals("indices:data/read/mtv") || action0.equals("indices:data/write/reindex");
    }

    private boolean checkFilteredAliases(IndexResolverReplacer.Resolved requestedResolved, String action, boolean isDebugEnabled) {
        Iterable<IndexMetadata> indexMetaDataCollection;
        String faMode = this.dcm.getFilteredAliasMode();
        if (!"disallow".equals(faMode)) {
            return false;
        }
        if (!ACTION_MATCHER.test(action)) {
            return false;
        }
        if (requestedResolved.isLocalAll()) {
            indexMetaDataCollection = new Iterable<IndexMetadata>(){

                @Override
                public Iterator<IndexMetadata> iterator() {
                    return PrivilegesEvaluator.this.clusterService.state().getMetadata().getIndices().valuesIt();
                }
            };
        } else {
            HashSet<IndexMetadata> indexMetaDataSet = new HashSet<IndexMetadata>(requestedResolved.getAllIndices().size());
            for (String requestAliasOrIndex : requestedResolved.getAllIndices()) {
                IndexMetadata indexMetaData = (IndexMetadata)this.clusterService.state().getMetadata().getIndices().get((Object)requestAliasOrIndex);
                if (indexMetaData == null) {
                    if (!isDebugEnabled) continue;
                    this.log.debug("{} does not exist in cluster metadata", (Object)requestAliasOrIndex);
                    continue;
                }
                indexMetaDataSet.add(indexMetaData);
            }
            indexMetaDataCollection = indexMetaDataSet;
        }
        for (IndexMetadata indexMetaData : indexMetaDataCollection) {
            ArrayList<AliasMetadata> filteredAliases = new ArrayList<AliasMetadata>();
            ImmutableOpenMap aliases = indexMetaData.getAliases();
            if (aliases != null && aliases.size() > 0) {
                if (isDebugEnabled) {
                    this.log.debug("Aliases for {}: {}", (Object)indexMetaData.getIndex().getName(), (Object)aliases);
                }
                Iterator it = aliases.keysIt();
                while (it.hasNext()) {
                    String alias = (String)it.next();
                    AliasMetadata aliasMetadata = (AliasMetadata)aliases.get((Object)alias);
                    if (aliasMetadata != null && aliasMetadata.filteringRequired()) {
                        filteredAliases.add(aliasMetadata);
                        if (!isDebugEnabled) continue;
                        this.log.debug("{} is a filtered alias {}", (Object)alias, (Object)aliasMetadata.getFilter());
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    this.log.debug("{} is not an alias or does not have a filter", (Object)alias);
                }
            }
            if (filteredAliases.size() <= 1 || !ACTION_MATCHER.test(action)) continue;
            this.log.error("More than one ({}) filtered alias found for same index ({}). This is currently not supported. Aliases: {}", (Object)filteredAliases.size(), (Object)indexMetaData.getIndex().getName(), this.toString(filteredAliases));
            return true;
        }
        return false;
    }

    private boolean checkDocAllowListHeader(User user, String action, ActionRequest request) {
        String docAllowListHeader = this.threadContext.getHeader("_opendistro_security_doc_allowlist");
        if (docAllowListHeader == null) {
            return false;
        }
        if (!(request instanceof GetRequest)) {
            return false;
        }
        try {
            DocumentAllowList documentAllowList = DocumentAllowList.parse(docAllowListHeader);
            GetRequest getRequest = (GetRequest)request;
            if (documentAllowList.isAllowed(getRequest.index(), getRequest.id())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Request " + request + " is allowed by " + documentAllowList);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.log.error("Error while handling document allow list: " + docAllowListHeader, (Throwable)e);
            return false;
        }
    }

    private List<String> toString(List<AliasMetadata> aliases) {
        if (aliases == null || aliases.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(aliases.size());
        for (AliasMetadata amd : aliases) {
            if (amd == null) continue;
            ret.add(amd.alias());
        }
        return Collections.unmodifiableList(ret);
    }
}

